/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Circle;
import com.mapbox.mapboxsdk.plugins.annotation.Options;

public class CircleOptions
extends Options<Circle> {
    private boolean isDraggable;
    private Point geometry;
    private Float circleRadius;
    private String circleColor;
    private Float circleBlur;
    private Float circleOpacity;
    private Float circleStrokeWidth;
    private String circleStrokeColor;
    private Float circleStrokeOpacity;
    static final String PROPERTY_circleRadius = "circle-radius";
    static final String PROPERTY_circleColor = "circle-color";
    static final String PROPERTY_circleBlur = "circle-blur";
    static final String PROPERTY_circleOpacity = "circle-opacity";
    static final String PROPERTY_circleStrokeWidth = "circle-stroke-width";
    static final String PROPERTY_circleStrokeColor = "circle-stroke-color";
    static final String PROPERTY_circleStrokeOpacity = "circle-stroke-opacity";
    private static final String PROPERTY_isDraggable = "is-draggable";

    public CircleOptions withCircleRadius(Float circleRadius) {
        this.circleRadius = circleRadius;
        return this;
    }

    public Float getCircleRadius() {
        return this.circleRadius;
    }

    public CircleOptions withCircleColor(String circleColor) {
        this.circleColor = circleColor;
        return this;
    }

    public String getCircleColor() {
        return this.circleColor;
    }

    public CircleOptions withCircleBlur(Float circleBlur) {
        this.circleBlur = circleBlur;
        return this;
    }

    public Float getCircleBlur() {
        return this.circleBlur;
    }

    public CircleOptions withCircleOpacity(Float circleOpacity) {
        this.circleOpacity = circleOpacity;
        return this;
    }

    public Float getCircleOpacity() {
        return this.circleOpacity;
    }

    public CircleOptions withCircleStrokeWidth(Float circleStrokeWidth) {
        this.circleStrokeWidth = circleStrokeWidth;
        return this;
    }

    public Float getCircleStrokeWidth() {
        return this.circleStrokeWidth;
    }

    public CircleOptions withCircleStrokeColor(String circleStrokeColor) {
        this.circleStrokeColor = circleStrokeColor;
        return this;
    }

    public String getCircleStrokeColor() {
        return this.circleStrokeColor;
    }

    public CircleOptions withCircleStrokeOpacity(Float circleStrokeOpacity) {
        this.circleStrokeOpacity = circleStrokeOpacity;
        return this;
    }

    public Float getCircleStrokeOpacity() {
        return this.circleStrokeOpacity;
    }

    public CircleOptions withLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        return this;
    }

    public CircleOptions withGeometry(Point geometry) {
        this.geometry = geometry;
        return this;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public CircleOptions withDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Circle build(long id, AnnotationManager<?, Circle, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROPERTY_circleRadius, (Number)this.circleRadius);
        jsonObject.addProperty(PROPERTY_circleColor, this.circleColor);
        jsonObject.addProperty(PROPERTY_circleBlur, (Number)this.circleBlur);
        jsonObject.addProperty(PROPERTY_circleOpacity, (Number)this.circleOpacity);
        jsonObject.addProperty(PROPERTY_circleStrokeWidth, (Number)this.circleStrokeWidth);
        jsonObject.addProperty(PROPERTY_circleStrokeColor, this.circleStrokeColor);
        jsonObject.addProperty(PROPERTY_circleStrokeOpacity, (Number)this.circleStrokeOpacity);
        Circle circle = new Circle(id, annotationManager, jsonObject, this.geometry);
        circle.setDraggable(this.isDraggable);
        return circle;
    }

    @Nullable
    static CircleOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof Point)) {
            return null;
        }
        CircleOptions options = new CircleOptions();
        options.geometry = (Point)feature.geometry();
        if (feature.hasProperty(PROPERTY_circleRadius)) {
            options.circleRadius = Float.valueOf(feature.getProperty(PROPERTY_circleRadius).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_circleColor)) {
            options.circleColor = feature.getProperty(PROPERTY_circleColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_circleBlur)) {
            options.circleBlur = Float.valueOf(feature.getProperty(PROPERTY_circleBlur).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_circleOpacity)) {
            options.circleOpacity = Float.valueOf(feature.getProperty(PROPERTY_circleOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_circleStrokeWidth)) {
            options.circleStrokeWidth = Float.valueOf(feature.getProperty(PROPERTY_circleStrokeWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_circleStrokeColor)) {
            options.circleStrokeColor = feature.getProperty(PROPERTY_circleStrokeColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_circleStrokeOpacity)) {
            options.circleStrokeOpacity = Float.valueOf(feature.getProperty(PROPERTY_circleStrokeOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_isDraggable)) {
            options.isDraggable = feature.getProperty(PROPERTY_isDraggable).getAsBoolean();
        }
        return options;
    }
}

