/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.annotation.SuppressLint;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import android.view.View;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.OnAnnotationDragListener;

final class DraggableAnnotationController<T extends Annotation, D extends OnAnnotationDragListener<T>> {
    private final MapboxMap mapboxMap;
    private AnnotationManager<?, T, ?, D, ?, ?> annotationManager;
    private final int touchAreaShiftX;
    private final int touchAreaShiftY;
    private final int touchAreaMaxX;
    private final int touchAreaMaxY;
    @Nullable
    private T draggedAnnotation;

    @SuppressLint(value={"ClickableViewAccessibility"})
    DraggableAnnotationController(MapView mapView, MapboxMap mapboxMap) {
        this(mapView, mapboxMap, new AndroidGesturesManager(mapView.getContext(), false), mapView.getScrollX(), mapView.getScrollY(), mapView.getMeasuredWidth(), mapView.getMeasuredHeight());
    }

    @VisibleForTesting
    public DraggableAnnotationController(MapView mapView, MapboxMap mapboxMap, final AndroidGesturesManager androidGesturesManager, int touchAreaShiftX, int touchAreaShiftY, int touchAreaMaxX, int touchAreaMaxY) {
        this.mapboxMap = mapboxMap;
        this.touchAreaShiftX = touchAreaShiftX;
        this.touchAreaShiftY = touchAreaShiftY;
        this.touchAreaMaxX = touchAreaMaxX;
        this.touchAreaMaxY = touchAreaMaxY;
        androidGesturesManager.setMoveGestureListener((MoveGestureDetector.OnMoveGestureListener)new AnnotationMoveGestureListener());
        mapView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                androidGesturesManager.onTouchEvent(event);
                return DraggableAnnotationController.this.draggedAnnotation != null;
            }
        });
    }

    void injectAnnotationManager(AnnotationManager<?, T, ?, D, ?, ?> annotationManager) {
        this.annotationManager = annotationManager;
    }

    void onSourceUpdated() {
        this.stopDragging(this.draggedAnnotation);
    }

    boolean onMoveBegin(MoveGestureDetector detector) {
        T annotation;
        if (detector.getPointersCount() == 1 && (annotation = this.annotationManager.queryMapForFeatures(detector.getFocalPoint())) != null) {
            return this.startDragging(annotation);
        }
        return false;
    }

    boolean onMove(MoveGestureDetector detector) {
        if (!(this.draggedAnnotation == null || detector.getPointersCount() <= 1 && ((Annotation)this.draggedAnnotation).isDraggable())) {
            this.stopDragging(this.draggedAnnotation);
            return true;
        }
        if (this.draggedAnnotation != null) {
            MoveDistancesObject moveObject = detector.getMoveObject(0);
            float x = moveObject.getCurrentX() - (float)this.touchAreaShiftX;
            float y = moveObject.getCurrentY() - (float)this.touchAreaShiftY;
            PointF pointF = new PointF(x, y);
            if (pointF.x < 0.0f || pointF.y < 0.0f || pointF.x > (float)this.touchAreaMaxX || pointF.y > (float)this.touchAreaMaxY) {
                this.stopDragging(this.draggedAnnotation);
                return true;
            }
            Geometry shiftedGeometry = ((Annotation)this.draggedAnnotation).getOffsetGeometry(this.mapboxMap.getProjection(), moveObject, this.touchAreaShiftX, this.touchAreaShiftY);
            if (shiftedGeometry != null) {
                this.draggedAnnotation.setGeometry((Geometry)shiftedGeometry);
                this.annotationManager.internalUpdateSource();
                if (!this.annotationManager.getDragListeners().isEmpty()) {
                    for (OnAnnotationDragListener d : this.annotationManager.getDragListeners()) {
                        d.onAnnotationDrag(this.draggedAnnotation);
                    }
                }
                return true;
            }
        }
        return false;
    }

    void onMoveEnd() {
        this.stopDragging(this.draggedAnnotation);
    }

    boolean startDragging(@NonNull T annotation) {
        if (((Annotation)annotation).isDraggable()) {
            if (!this.annotationManager.getDragListeners().isEmpty()) {
                for (OnAnnotationDragListener d : this.annotationManager.getDragListeners()) {
                    d.onAnnotationDragStarted(annotation);
                }
            }
            this.draggedAnnotation = annotation;
            return true;
        }
        return false;
    }

    void stopDragging(@Nullable T annotation) {
        if (annotation != null && !this.annotationManager.getDragListeners().isEmpty()) {
            for (OnAnnotationDragListener d : this.annotationManager.getDragListeners()) {
                d.onAnnotationDragFinished(annotation);
            }
        }
        this.draggedAnnotation = null;
    }

    private class AnnotationMoveGestureListener
    implements MoveGestureDetector.OnMoveGestureListener {
        private AnnotationMoveGestureListener() {
        }

        public boolean onMoveBegin(MoveGestureDetector detector) {
            return DraggableAnnotationController.this.onMoveBegin(detector);
        }

        public boolean onMove(MoveGestureDetector detector, float distanceX, float distanceY) {
            return DraggableAnnotationController.this.onMove(detector);
        }

        public void onMoveEnd(MoveGestureDetector detector, float velocityX, float velocityY) {
            DraggableAnnotationController.this.onMoveEnd();
        }
    }
}

