/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Fill;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import java.util.ArrayList;
import java.util.List;

public class FillOptions
extends Options<Fill> {
    private boolean isDraggable;
    private Polygon geometry;
    private Float fillOpacity;
    private String fillColor;
    private String fillOutlineColor;
    private String fillPattern;
    static final String PROPERTY_fillOpacity = "fill-opacity";
    static final String PROPERTY_fillColor = "fill-color";
    static final String PROPERTY_fillOutlineColor = "fill-outline-color";
    static final String PROPERTY_fillPattern = "fill-pattern";
    private static final String PROPERTY_isDraggable = "is-draggable";

    public FillOptions withFillOpacity(Float fillOpacity) {
        this.fillOpacity = fillOpacity;
        return this;
    }

    public Float getFillOpacity() {
        return this.fillOpacity;
    }

    public FillOptions withFillColor(String fillColor) {
        this.fillColor = fillColor;
        return this;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public FillOptions withFillOutlineColor(String fillOutlineColor) {
        this.fillOutlineColor = fillOutlineColor;
        return this;
    }

    public String getFillOutlineColor() {
        return this.fillOutlineColor;
    }

    public FillOptions withFillPattern(String fillPattern) {
        this.fillPattern = fillPattern;
        return this;
    }

    public String getFillPattern() {
        return this.fillPattern;
    }

    public FillOptions withLatLngs(List<List<LatLng>> latLngs) {
        ArrayList points = new ArrayList();
        for (List<LatLng> innerLatLngs : latLngs) {
            ArrayList<Point> innerList = new ArrayList<Point>();
            for (LatLng latLng : innerLatLngs) {
                innerList.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
            }
            points.add(innerList);
        }
        this.geometry = Polygon.fromLngLats(points);
        return this;
    }

    public FillOptions withGeometry(Polygon geometry) {
        this.geometry = geometry;
        return this;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public FillOptions withDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Fill build(long id, AnnotationManager<?, Fill, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROPERTY_fillOpacity, (Number)this.fillOpacity);
        jsonObject.addProperty(PROPERTY_fillColor, this.fillColor);
        jsonObject.addProperty(PROPERTY_fillOutlineColor, this.fillOutlineColor);
        jsonObject.addProperty(PROPERTY_fillPattern, this.fillPattern);
        Fill fill = new Fill(id, annotationManager, jsonObject, this.geometry);
        fill.setDraggable(this.isDraggable);
        return fill;
    }

    @Nullable
    static FillOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof Polygon)) {
            return null;
        }
        FillOptions options = new FillOptions();
        options.geometry = (Polygon)feature.geometry();
        if (feature.hasProperty(PROPERTY_fillOpacity)) {
            options.fillOpacity = Float.valueOf(feature.getProperty(PROPERTY_fillOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_fillColor)) {
            options.fillColor = feature.getProperty(PROPERTY_fillColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_fillOutlineColor)) {
            options.fillOutlineColor = feature.getProperty(PROPERTY_fillOutlineColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_fillPattern)) {
            options.fillPattern = feature.getProperty(PROPERTY_fillPattern).getAsString();
        }
        if (feature.hasProperty(PROPERTY_isDraggable)) {
            options.isDraggable = feature.getProperty(PROPERTY_isDraggable).getAsBoolean();
        }
        return options;
    }
}

