/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.util.ArrayList;
import java.util.List;

@UiThread
public class Line
extends Annotation<LineString> {
    private final AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager;

    Line(long id, AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, LineString geometry) {
        super(id, jsonObject, geometry);
        this.annotationManager = annotationManager;
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("line-join") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-join");
        }
        if (!(this.jsonObject.get("line-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-opacity");
        }
        if (!(this.jsonObject.get("line-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-color");
        }
        if (!(this.jsonObject.get("line-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-width");
        }
        if (!(this.jsonObject.get("line-gap-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-gap-width");
        }
        if (!(this.jsonObject.get("line-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-offset");
        }
        if (!(this.jsonObject.get("line-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-blur");
        }
        if (!(this.jsonObject.get("line-pattern") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("line-pattern");
        }
    }

    public void setLatLngs(List<LatLng> latLngs) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (LatLng latLng : latLngs) {
            points.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
        }
        this.geometry = LineString.fromLngLats(points);
    }

    @NonNull
    public List<LatLng> getLatLngs() {
        LineString lineString = (LineString)this.geometry;
        ArrayList<LatLng> latLngs = new ArrayList<LatLng>();
        for (Point point : lineString.coordinates()) {
            latLngs.add(new LatLng(point.latitude(), point.longitude()));
        }
        return latLngs;
    }

    public String getLineJoin() {
        return this.jsonObject.get("line-join").getAsString();
    }

    public void setLineJoin(String value) {
        this.jsonObject.addProperty("line-join", value);
    }

    public Float getLineOpacity() {
        return Float.valueOf(this.jsonObject.get("line-opacity").getAsFloat());
    }

    public void setLineOpacity(Float value) {
        this.jsonObject.addProperty("line-opacity", (Number)value);
    }

    @ColorInt
    public int getLineColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("line-color").getAsString());
    }

    public String getLineColor() {
        return this.jsonObject.get("line-color").getAsString();
    }

    public void setLineColor(@ColorInt int color) {
        this.jsonObject.addProperty("line-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setLineColor(@NonNull String color) {
        this.jsonObject.addProperty("line-color", color);
    }

    public Float getLineWidth() {
        return Float.valueOf(this.jsonObject.get("line-width").getAsFloat());
    }

    public void setLineWidth(Float value) {
        this.jsonObject.addProperty("line-width", (Number)value);
    }

    public Float getLineGapWidth() {
        return Float.valueOf(this.jsonObject.get("line-gap-width").getAsFloat());
    }

    public void setLineGapWidth(Float value) {
        this.jsonObject.addProperty("line-gap-width", (Number)value);
    }

    public Float getLineOffset() {
        return Float.valueOf(this.jsonObject.get("line-offset").getAsFloat());
    }

    public void setLineOffset(Float value) {
        this.jsonObject.addProperty("line-offset", (Number)value);
    }

    public Float getLineBlur() {
        return Float.valueOf(this.jsonObject.get("line-blur").getAsFloat());
    }

    public void setLineBlur(Float value) {
        this.jsonObject.addProperty("line-blur", (Number)value);
    }

    public String getLinePattern() {
        return this.jsonObject.get("line-pattern").getAsString();
    }

    public void setLinePattern(String value) {
        this.jsonObject.addProperty("line-pattern", value);
    }

    @Override
    @Nullable
    Geometry getOffsetGeometry(@NonNull Projection projection, @NonNull MoveDistancesObject moveDistancesObject, float touchAreaShiftX, float touchAreaShiftY) {
        List originalPoints = ((LineString)this.geometry).coordinates();
        ArrayList<Point> resultingPoints = new ArrayList<Point>(originalPoints.size());
        for (Point jsonPoint : originalPoints) {
            PointF pointF = projection.toScreenLocation(new LatLng(jsonPoint.latitude(), jsonPoint.longitude()));
            pointF.x -= moveDistancesObject.getDistanceXSinceLast();
            pointF.y -= moveDistancesObject.getDistanceYSinceLast();
            LatLng latLng = projection.fromScreenLocation(pointF);
            if (latLng.getLatitude() > 85.05112877980659 || latLng.getLatitude() < -85.05112877980659) {
                return null;
            }
            resultingPoints.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
        }
        return LineString.fromLngLats(resultingPoints);
    }

    @Override
    String getName() {
        return "Line";
    }
}

