/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.Line;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import java.util.ArrayList;
import java.util.List;

public class LineOptions
extends Options<Line> {
    private boolean isDraggable;
    private LineString geometry;
    private String lineJoin;
    private Float lineOpacity;
    private String lineColor;
    private Float lineWidth;
    private Float lineGapWidth;
    private Float lineOffset;
    private Float lineBlur;
    private String linePattern;
    static final String PROPERTY_lineJoin = "line-join";
    static final String PROPERTY_lineOpacity = "line-opacity";
    static final String PROPERTY_lineColor = "line-color";
    static final String PROPERTY_lineWidth = "line-width";
    static final String PROPERTY_lineGapWidth = "line-gap-width";
    static final String PROPERTY_lineOffset = "line-offset";
    static final String PROPERTY_lineBlur = "line-blur";
    static final String PROPERTY_linePattern = "line-pattern";
    private static final String PROPERTY_isDraggable = "is-draggable";

    public LineOptions withLineJoin(String lineJoin) {
        this.lineJoin = lineJoin;
        return this;
    }

    public String getLineJoin() {
        return this.lineJoin;
    }

    public LineOptions withLineOpacity(Float lineOpacity) {
        this.lineOpacity = lineOpacity;
        return this;
    }

    public Float getLineOpacity() {
        return this.lineOpacity;
    }

    public LineOptions withLineColor(String lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public LineOptions withLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public LineOptions withLineGapWidth(Float lineGapWidth) {
        this.lineGapWidth = lineGapWidth;
        return this;
    }

    public Float getLineGapWidth() {
        return this.lineGapWidth;
    }

    public LineOptions withLineOffset(Float lineOffset) {
        this.lineOffset = lineOffset;
        return this;
    }

    public Float getLineOffset() {
        return this.lineOffset;
    }

    public LineOptions withLineBlur(Float lineBlur) {
        this.lineBlur = lineBlur;
        return this;
    }

    public Float getLineBlur() {
        return this.lineBlur;
    }

    public LineOptions withLinePattern(String linePattern) {
        this.linePattern = linePattern;
        return this;
    }

    public String getLinePattern() {
        return this.linePattern;
    }

    public LineOptions withLatLngs(List<LatLng> latLngs) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (LatLng latLng : latLngs) {
            points.add(Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude()));
        }
        this.geometry = LineString.fromLngLats(points);
        return this;
    }

    public LineOptions withGeometry(LineString geometry) {
        this.geometry = geometry;
        return this;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public LineOptions withDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Line build(long id, AnnotationManager<?, Line, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROPERTY_lineJoin, this.lineJoin);
        jsonObject.addProperty(PROPERTY_lineOpacity, (Number)this.lineOpacity);
        jsonObject.addProperty(PROPERTY_lineColor, this.lineColor);
        jsonObject.addProperty(PROPERTY_lineWidth, (Number)this.lineWidth);
        jsonObject.addProperty(PROPERTY_lineGapWidth, (Number)this.lineGapWidth);
        jsonObject.addProperty(PROPERTY_lineOffset, (Number)this.lineOffset);
        jsonObject.addProperty(PROPERTY_lineBlur, (Number)this.lineBlur);
        jsonObject.addProperty(PROPERTY_linePattern, this.linePattern);
        Line line = new Line(id, annotationManager, jsonObject, this.geometry);
        line.setDraggable(this.isDraggable);
        return line;
    }

    @Nullable
    static LineOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof LineString)) {
            return null;
        }
        LineOptions options = new LineOptions();
        options.geometry = (LineString)feature.geometry();
        if (feature.hasProperty(PROPERTY_lineJoin)) {
            options.lineJoin = feature.getProperty(PROPERTY_lineJoin).getAsString();
        }
        if (feature.hasProperty(PROPERTY_lineOpacity)) {
            options.lineOpacity = Float.valueOf(feature.getProperty(PROPERTY_lineOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_lineColor)) {
            options.lineColor = feature.getProperty(PROPERTY_lineColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_lineWidth)) {
            options.lineWidth = Float.valueOf(feature.getProperty(PROPERTY_lineWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_lineGapWidth)) {
            options.lineGapWidth = Float.valueOf(feature.getProperty(PROPERTY_lineGapWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_lineOffset)) {
            options.lineOffset = Float.valueOf(feature.getProperty(PROPERTY_lineOffset).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_lineBlur)) {
            options.lineBlur = Float.valueOf(feature.getProperty(PROPERTY_lineBlur).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_linePattern)) {
            options.linePattern = feature.getProperty(PROPERTY_linePattern).getAsString();
        }
        if (feature.hasProperty(PROPERTY_isDraggable)) {
            options.isDraggable = feature.getProperty(PROPERTY_isDraggable).getAsBoolean();
        }
        return options;
    }
}

