/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.graphics.PointF;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mapbox.android.gestures.MoveDistancesObject;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.plugins.annotation.Annotation;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class Symbol
extends Annotation<Point> {
    private final AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager;

    Symbol(long id, AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager, JsonObject jsonObject, Point geometry) {
        super(id, jsonObject, geometry);
        this.annotationManager = annotationManager;
    }

    @Override
    void setUsedDataDrivenProperties() {
        if (!(this.jsonObject.get("icon-size") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-size");
        }
        if (!(this.jsonObject.get("icon-image") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-image");
        }
        if (!(this.jsonObject.get("icon-rotate") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-rotate");
        }
        if (!(this.jsonObject.get("icon-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-offset");
        }
        if (!(this.jsonObject.get("icon-anchor") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-anchor");
        }
        if (!(this.jsonObject.get("text-field") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-field");
        }
        if (!(this.jsonObject.get("text-font") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-font");
        }
        if (!(this.jsonObject.get("text-size") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-size");
        }
        if (!(this.jsonObject.get("text-max-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-max-width");
        }
        if (!(this.jsonObject.get("text-letter-spacing") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-letter-spacing");
        }
        if (!(this.jsonObject.get("text-justify") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-justify");
        }
        if (!(this.jsonObject.get("text-anchor") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-anchor");
        }
        if (!(this.jsonObject.get("text-rotate") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-rotate");
        }
        if (!(this.jsonObject.get("text-transform") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-transform");
        }
        if (!(this.jsonObject.get("text-offset") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-offset");
        }
        if (!(this.jsonObject.get("icon-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-opacity");
        }
        if (!(this.jsonObject.get("icon-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-color");
        }
        if (!(this.jsonObject.get("icon-halo-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-color");
        }
        if (!(this.jsonObject.get("icon-halo-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-width");
        }
        if (!(this.jsonObject.get("icon-halo-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("icon-halo-blur");
        }
        if (!(this.jsonObject.get("text-opacity") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-opacity");
        }
        if (!(this.jsonObject.get("text-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-color");
        }
        if (!(this.jsonObject.get("text-halo-color") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-color");
        }
        if (!(this.jsonObject.get("text-halo-width") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-width");
        }
        if (!(this.jsonObject.get("text-halo-blur") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("text-halo-blur");
        }
        if (!(this.jsonObject.get("z-index") instanceof JsonNull)) {
            this.annotationManager.enableDataDrivenProperty("z-index");
        }
    }

    public void setLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
    }

    @NonNull
    public LatLng getLatLng() {
        return new LatLng(((Point)this.geometry).latitude(), ((Point)this.geometry).longitude());
    }

    public void setZIndex(int index) {
        this.jsonObject.addProperty("z-index", (Number)index);
    }

    public int getZIndex() {
        return this.jsonObject.get("z-index").getAsInt();
    }

    public Float getIconSize() {
        return Float.valueOf(this.jsonObject.get("icon-size").getAsFloat());
    }

    public void setIconSize(Float value) {
        this.jsonObject.addProperty("icon-size", (Number)value);
    }

    public String getIconImage() {
        return this.jsonObject.get("icon-image").getAsString();
    }

    public void setIconImage(String value) {
        this.jsonObject.addProperty("icon-image", value);
    }

    public Float getIconRotate() {
        return Float.valueOf(this.jsonObject.get("icon-rotate").getAsFloat());
    }

    public void setIconRotate(Float value) {
        this.jsonObject.addProperty("icon-rotate", (Number)value);
    }

    public PointF getIconOffset() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("icon-offset");
        return new PointF(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat());
    }

    public void setIconOffset(PointF pointF) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Number)Float.valueOf(pointF.x));
        jsonArray.add((Number)Float.valueOf(pointF.y));
        this.jsonObject.add("icon-offset", (JsonElement)jsonArray);
    }

    public String getIconAnchor() {
        return this.jsonObject.get("icon-anchor").getAsString();
    }

    public void setIconAnchor(String value) {
        this.jsonObject.addProperty("icon-anchor", value);
    }

    public String getTextField() {
        return this.jsonObject.get("text-field").getAsString();
    }

    public void setTextField(String value) {
        this.jsonObject.addProperty("text-field", value);
    }

    public String[] getTextFont() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("text-font");
        String[] value = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            value[i] = jsonArray.get(i).getAsString();
        }
        return value;
    }

    public void setTextFont(String[] value) {
        JsonArray jsonArray = new JsonArray();
        for (String element : value) {
            jsonArray.add(element);
        }
        this.jsonObject.add("text-font", (JsonElement)jsonArray);
    }

    public Float getTextSize() {
        return Float.valueOf(this.jsonObject.get("text-size").getAsFloat());
    }

    public void setTextSize(Float value) {
        this.jsonObject.addProperty("text-size", (Number)value);
    }

    public Float getTextMaxWidth() {
        return Float.valueOf(this.jsonObject.get("text-max-width").getAsFloat());
    }

    public void setTextMaxWidth(Float value) {
        this.jsonObject.addProperty("text-max-width", (Number)value);
    }

    public Float getTextLetterSpacing() {
        return Float.valueOf(this.jsonObject.get("text-letter-spacing").getAsFloat());
    }

    public void setTextLetterSpacing(Float value) {
        this.jsonObject.addProperty("text-letter-spacing", (Number)value);
    }

    public String getTextJustify() {
        return this.jsonObject.get("text-justify").getAsString();
    }

    public void setTextJustify(String value) {
        this.jsonObject.addProperty("text-justify", value);
    }

    public String getTextAnchor() {
        return this.jsonObject.get("text-anchor").getAsString();
    }

    public void setTextAnchor(String value) {
        this.jsonObject.addProperty("text-anchor", value);
    }

    public Float getTextRotate() {
        return Float.valueOf(this.jsonObject.get("text-rotate").getAsFloat());
    }

    public void setTextRotate(Float value) {
        this.jsonObject.addProperty("text-rotate", (Number)value);
    }

    public String getTextTransform() {
        return this.jsonObject.get("text-transform").getAsString();
    }

    public void setTextTransform(String value) {
        this.jsonObject.addProperty("text-transform", value);
    }

    public PointF getTextOffset() {
        JsonArray jsonArray = this.jsonObject.getAsJsonArray("text-offset");
        return new PointF(jsonArray.get(0).getAsFloat(), jsonArray.get(1).getAsFloat());
    }

    public void setTextOffset(PointF pointF) {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Number)Float.valueOf(pointF.x));
        jsonArray.add((Number)Float.valueOf(pointF.y));
        this.jsonObject.add("text-offset", (JsonElement)jsonArray);
    }

    public Float getIconOpacity() {
        return Float.valueOf(this.jsonObject.get("icon-opacity").getAsFloat());
    }

    public void setIconOpacity(Float value) {
        this.jsonObject.addProperty("icon-opacity", (Number)value);
    }

    @ColorInt
    public int getIconColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("icon-color").getAsString());
    }

    public String getIconColor() {
        return this.jsonObject.get("icon-color").getAsString();
    }

    public void setIconColor(@ColorInt int color) {
        this.jsonObject.addProperty("icon-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setIconColor(@NonNull String color) {
        this.jsonObject.addProperty("icon-color", color);
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("icon-halo-color").getAsString());
    }

    public String getIconHaloColor() {
        return this.jsonObject.get("icon-halo-color").getAsString();
    }

    public void setIconHaloColor(@ColorInt int color) {
        this.jsonObject.addProperty("icon-halo-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setIconHaloColor(@NonNull String color) {
        this.jsonObject.addProperty("icon-halo-color", color);
    }

    public Float getIconHaloWidth() {
        return Float.valueOf(this.jsonObject.get("icon-halo-width").getAsFloat());
    }

    public void setIconHaloWidth(Float value) {
        this.jsonObject.addProperty("icon-halo-width", (Number)value);
    }

    public Float getIconHaloBlur() {
        return Float.valueOf(this.jsonObject.get("icon-halo-blur").getAsFloat());
    }

    public void setIconHaloBlur(Float value) {
        this.jsonObject.addProperty("icon-halo-blur", (Number)value);
    }

    public Float getTextOpacity() {
        return Float.valueOf(this.jsonObject.get("text-opacity").getAsFloat());
    }

    public void setTextOpacity(Float value) {
        this.jsonObject.addProperty("text-opacity", (Number)value);
    }

    @ColorInt
    public int getTextColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("text-color").getAsString());
    }

    public String getTextColor() {
        return this.jsonObject.get("text-color").getAsString();
    }

    public void setTextColor(@ColorInt int color) {
        this.jsonObject.addProperty("text-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setTextColor(@NonNull String color) {
        this.jsonObject.addProperty("text-color", color);
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        return ColorUtils.rgbaToColor((String)this.jsonObject.get("text-halo-color").getAsString());
    }

    public String getTextHaloColor() {
        return this.jsonObject.get("text-halo-color").getAsString();
    }

    public void setTextHaloColor(@ColorInt int color) {
        this.jsonObject.addProperty("text-halo-color", ColorUtils.colorToRgbaString((int)color));
    }

    public void setTextHaloColor(@NonNull String color) {
        this.jsonObject.addProperty("text-halo-color", color);
    }

    public Float getTextHaloWidth() {
        return Float.valueOf(this.jsonObject.get("text-halo-width").getAsFloat());
    }

    public void setTextHaloWidth(Float value) {
        this.jsonObject.addProperty("text-halo-width", (Number)value);
    }

    public Float getTextHaloBlur() {
        return Float.valueOf(this.jsonObject.get("text-halo-blur").getAsFloat());
    }

    public void setTextHaloBlur(Float value) {
        this.jsonObject.addProperty("text-halo-blur", (Number)value);
    }

    @Override
    @Nullable
    Geometry getOffsetGeometry(@NonNull Projection projection, @NonNull MoveDistancesObject moveDistancesObject, float touchAreaShiftX, float touchAreaShiftY) {
        PointF pointF = new PointF(moveDistancesObject.getCurrentX() - touchAreaShiftX, moveDistancesObject.getCurrentY() - touchAreaShiftY);
        LatLng latLng = projection.fromScreenLocation(pointF);
        if (latLng.getLatitude() > 85.05112877980659 || latLng.getLatitude() < -85.05112877980659) {
            return null;
        }
        return Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
    }

    @Override
    String getName() {
        return "Symbol";
    }
}

