/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.CoreElementProvider;
import com.mapbox.mapboxsdk.plugins.annotation.DraggableAnnotationController;
import com.mapbox.mapboxsdk.plugins.annotation.OnSymbolClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnSymbolDragListener;
import com.mapbox.mapboxsdk.plugins.annotation.OnSymbolLongClickListener;
import com.mapbox.mapboxsdk.plugins.annotation.Symbol;
import com.mapbox.mapboxsdk.plugins.annotation.SymbolComparator;
import com.mapbox.mapboxsdk.plugins.annotation.SymbolOptions;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import java.util.ArrayList;
import java.util.List;

public class SymbolManager
extends AnnotationManager<SymbolLayer, Symbol, SymbolOptions, OnSymbolDragListener, OnSymbolClickListener, OnSymbolLongClickListener> {
    public static final String ID_GEOJSON_SOURCE = "mapbox-android-symbol-source";
    public static final String ID_GEOJSON_LAYER = "mapbox-android-symbol-layer";
    private static final String PROPERTY_symbolPlacement = "symbol-placement";
    private static final String PROPERTY_symbolSpacing = "symbol-spacing";
    private static final String PROPERTY_symbolAvoidEdges = "symbol-avoid-edges";
    private static final String PROPERTY_iconAllowOverlap = "icon-allow-overlap";
    private static final String PROPERTY_iconIgnorePlacement = "icon-ignore-placement";
    private static final String PROPERTY_iconOptional = "icon-optional";
    private static final String PROPERTY_iconRotationAlignment = "icon-rotation-alignment";
    private static final String PROPERTY_iconTextFit = "icon-text-fit";
    private static final String PROPERTY_iconTextFitPadding = "icon-text-fit-padding";
    private static final String PROPERTY_iconPadding = "icon-padding";
    private static final String PROPERTY_iconKeepUpright = "icon-keep-upright";
    private static final String PROPERTY_iconPitchAlignment = "icon-pitch-alignment";
    private static final String PROPERTY_textPitchAlignment = "text-pitch-alignment";
    private static final String PROPERTY_textRotationAlignment = "text-rotation-alignment";
    private static final String PROPERTY_textLineHeight = "text-line-height";
    private static final String PROPERTY_textMaxAngle = "text-max-angle";
    private static final String PROPERTY_textPadding = "text-padding";
    private static final String PROPERTY_textKeepUpright = "text-keep-upright";
    private static final String PROPERTY_textAllowOverlap = "text-allow-overlap";
    private static final String PROPERTY_textIgnorePlacement = "text-ignore-placement";
    private static final String PROPERTY_textOptional = "text-optional";
    private static final String PROPERTY_iconTranslate = "icon-translate";
    private static final String PROPERTY_iconTranslateAnchor = "icon-translate-anchor";
    private static final String PROPERTY_textTranslate = "text-translate";
    private static final String PROPERTY_textTranslateAnchor = "text-translate-anchor";

    @UiThread
    public SymbolManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style) {
        this(mapView, mapboxMap, style, null, null);
    }

    @UiThread
    public SymbolManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId) {
        this(mapView, mapboxMap, style, belowLayerId, null);
    }

    @UiThread
    public SymbolManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @Nullable String belowLayerId, @Nullable GeoJsonOptions geoJsonOptions) {
        this(mapView, mapboxMap, style, new CoreElementProvider<SymbolLayer>(){

            @Override
            public SymbolLayer getLayer() {
                return new SymbolLayer(SymbolManager.ID_GEOJSON_LAYER, SymbolManager.ID_GEOJSON_SOURCE);
            }

            @Override
            public GeoJsonSource getSource(@Nullable GeoJsonOptions geoJsonOptions) {
                if (geoJsonOptions != null) {
                    return new GeoJsonSource(SymbolManager.ID_GEOJSON_SOURCE, geoJsonOptions);
                }
                return new GeoJsonSource(SymbolManager.ID_GEOJSON_SOURCE);
            }
        }, belowLayerId, geoJsonOptions, new DraggableAnnotationController<Symbol, OnSymbolDragListener>(mapView, mapboxMap));
    }

    @VisibleForTesting
    SymbolManager(@NonNull MapView mapView, @NonNull MapboxMap mapboxMap, @NonNull Style style, @NonNull CoreElementProvider<SymbolLayer> coreElementProvider, @Nullable String belowLayerId, @Nullable GeoJsonOptions geoJsonOptions, DraggableAnnotationController<Symbol, OnSymbolDragListener> draggableAnnotationController) {
        super(mapView, mapboxMap, style, coreElementProvider, new SymbolComparator(), draggableAnnotationController, belowLayerId, geoJsonOptions);
    }

    @Override
    void initializeDataDrivenPropertyMap() {
        this.dataDrivenPropertyUsageMap.put("icon-size", false);
        this.dataDrivenPropertyUsageMap.put("icon-image", false);
        this.dataDrivenPropertyUsageMap.put("icon-rotate", false);
        this.dataDrivenPropertyUsageMap.put("icon-offset", false);
        this.dataDrivenPropertyUsageMap.put("icon-anchor", false);
        this.dataDrivenPropertyUsageMap.put("text-field", false);
        this.dataDrivenPropertyUsageMap.put("text-font", false);
        this.dataDrivenPropertyUsageMap.put("text-size", false);
        this.dataDrivenPropertyUsageMap.put("text-max-width", false);
        this.dataDrivenPropertyUsageMap.put("text-letter-spacing", false);
        this.dataDrivenPropertyUsageMap.put("text-justify", false);
        this.dataDrivenPropertyUsageMap.put("text-anchor", false);
        this.dataDrivenPropertyUsageMap.put("text-rotate", false);
        this.dataDrivenPropertyUsageMap.put("text-transform", false);
        this.dataDrivenPropertyUsageMap.put("text-offset", false);
        this.dataDrivenPropertyUsageMap.put("icon-opacity", false);
        this.dataDrivenPropertyUsageMap.put("icon-color", false);
        this.dataDrivenPropertyUsageMap.put("icon-halo-color", false);
        this.dataDrivenPropertyUsageMap.put("icon-halo-width", false);
        this.dataDrivenPropertyUsageMap.put("icon-halo-blur", false);
        this.dataDrivenPropertyUsageMap.put("text-opacity", false);
        this.dataDrivenPropertyUsageMap.put("text-color", false);
        this.dataDrivenPropertyUsageMap.put("text-halo-color", false);
        this.dataDrivenPropertyUsageMap.put("text-halo-width", false);
        this.dataDrivenPropertyUsageMap.put("text-halo-blur", false);
        this.dataDrivenPropertyUsageMap.put("z-index", false);
    }

    @Override
    protected void setDataDrivenPropertyIsUsed(@NonNull String property) {
        switch (property) {
            case "icon-size": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconSize((Expression)Expression.get((String)"icon-size"))});
                break;
            }
            case "icon-image": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconImage((Expression)Expression.get((String)"icon-image"))});
                break;
            }
            case "icon-rotate": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconRotate((Expression)Expression.get((String)"icon-rotate"))});
                break;
            }
            case "icon-offset": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconOffset((Expression)Expression.get((String)"icon-offset"))});
                break;
            }
            case "icon-anchor": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconAnchor((Expression)Expression.get((String)"icon-anchor"))});
                break;
            }
            case "text-field": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textField((Expression)Expression.get((String)"text-field"))});
                break;
            }
            case "text-font": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textFont((Expression)Expression.get((String)"text-font"))});
                break;
            }
            case "text-size": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textSize((Expression)Expression.get((String)"text-size"))});
                break;
            }
            case "text-max-width": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textMaxWidth((Expression)Expression.get((String)"text-max-width"))});
                break;
            }
            case "text-letter-spacing": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textLetterSpacing((Expression)Expression.get((String)"text-letter-spacing"))});
                break;
            }
            case "text-justify": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textJustify((Expression)Expression.get((String)"text-justify"))});
                break;
            }
            case "text-anchor": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textAnchor((Expression)Expression.get((String)"text-anchor"))});
                break;
            }
            case "text-rotate": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textRotate((Expression)Expression.get((String)"text-rotate"))});
                break;
            }
            case "text-transform": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textTransform((Expression)Expression.get((String)"text-transform"))});
                break;
            }
            case "text-offset": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textOffset((Expression)Expression.get((String)"text-offset"))});
                break;
            }
            case "icon-opacity": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconOpacity((Expression)Expression.get((String)"icon-opacity"))});
                break;
            }
            case "icon-color": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconColor((Expression)Expression.get((String)"icon-color"))});
                break;
            }
            case "icon-halo-color": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconHaloColor((Expression)Expression.get((String)"icon-halo-color"))});
                break;
            }
            case "icon-halo-width": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconHaloWidth((Expression)Expression.get((String)"icon-halo-width"))});
                break;
            }
            case "icon-halo-blur": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.iconHaloBlur((Expression)Expression.get((String)"icon-halo-blur"))});
                break;
            }
            case "text-opacity": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textOpacity((Expression)Expression.get((String)"text-opacity"))});
                break;
            }
            case "text-color": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textColor((Expression)Expression.get((String)"text-color"))});
                break;
            }
            case "text-halo-color": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textHaloColor((Expression)Expression.get((String)"text-halo-color"))});
                break;
            }
            case "text-halo-width": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textHaloWidth((Expression)Expression.get((String)"text-halo-width"))});
                break;
            }
            case "text-halo-blur": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.textHaloBlur((Expression)Expression.get((String)"text-halo-blur"))});
                break;
            }
            case "z-index": {
                ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{PropertyFactory.symbolZOrder((String)"source")});
            }
        }
    }

    @Override
    @UiThread
    public List<Symbol> create(@NonNull String json) {
        return this.create(FeatureCollection.fromJson((String)json));
    }

    @Override
    @UiThread
    public List<Symbol> create(@NonNull FeatureCollection featureCollection) {
        List features = featureCollection.features();
        ArrayList<SymbolOptions> options = new ArrayList<SymbolOptions>();
        if (features != null) {
            for (Feature feature : features) {
                SymbolOptions option = SymbolOptions.fromFeature(feature);
                if (option == null) continue;
                options.add(option);
            }
        }
        return this.create(options);
    }

    @Override
    String getAnnotationLayerId() {
        return ID_GEOJSON_LAYER;
    }

    @Override
    String getAnnotationIdKey() {
        return "id";
    }

    public String getSymbolPlacement() {
        return (String)((SymbolLayer)this.layer).getSymbolPlacement().value;
    }

    public void setSymbolPlacement(String value) {
        PropertyValue propertyValue = PropertyFactory.symbolPlacement((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_symbolPlacement, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getSymbolSpacing() {
        return (Float)((SymbolLayer)this.layer).getSymbolSpacing().value;
    }

    public void setSymbolSpacing(Float value) {
        PropertyValue propertyValue = PropertyFactory.symbolSpacing((Float)value);
        this.constantPropertyUsageMap.put(PROPERTY_symbolSpacing, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getSymbolAvoidEdges() {
        return (Boolean)((SymbolLayer)this.layer).getSymbolAvoidEdges().value;
    }

    public void setSymbolAvoidEdges(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.symbolAvoidEdges((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_symbolAvoidEdges, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getIconAllowOverlap() {
        return (Boolean)((SymbolLayer)this.layer).getIconAllowOverlap().value;
    }

    public void setIconAllowOverlap(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.iconAllowOverlap((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconAllowOverlap, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getIconIgnorePlacement() {
        return (Boolean)((SymbolLayer)this.layer).getIconIgnorePlacement().value;
    }

    public void setIconIgnorePlacement(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.iconIgnorePlacement((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconIgnorePlacement, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getIconOptional() {
        return (Boolean)((SymbolLayer)this.layer).getIconOptional().value;
    }

    public void setIconOptional(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.iconOptional((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconOptional, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getIconRotationAlignment() {
        return (String)((SymbolLayer)this.layer).getIconRotationAlignment().value;
    }

    public void setIconRotationAlignment(String value) {
        PropertyValue propertyValue = PropertyFactory.iconRotationAlignment((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconRotationAlignment, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getIconTextFit() {
        return (String)((SymbolLayer)this.layer).getIconTextFit().value;
    }

    public void setIconTextFit(String value) {
        PropertyValue propertyValue = PropertyFactory.iconTextFit((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconTextFit, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getIconTextFitPadding() {
        return (Float[])((SymbolLayer)this.layer).getIconTextFitPadding().value;
    }

    public void setIconTextFitPadding(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.iconTextFitPadding((Float[])value);
        this.constantPropertyUsageMap.put(PROPERTY_iconTextFitPadding, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getIconPadding() {
        return (Float)((SymbolLayer)this.layer).getIconPadding().value;
    }

    public void setIconPadding(Float value) {
        PropertyValue propertyValue = PropertyFactory.iconPadding((Float)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconPadding, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getIconKeepUpright() {
        return (Boolean)((SymbolLayer)this.layer).getIconKeepUpright().value;
    }

    public void setIconKeepUpright(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.iconKeepUpright((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconKeepUpright, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getIconPitchAlignment() {
        return (String)((SymbolLayer)this.layer).getIconPitchAlignment().value;
    }

    public void setIconPitchAlignment(String value) {
        PropertyValue propertyValue = PropertyFactory.iconPitchAlignment((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconPitchAlignment, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getTextPitchAlignment() {
        return (String)((SymbolLayer)this.layer).getTextPitchAlignment().value;
    }

    public void setTextPitchAlignment(String value) {
        PropertyValue propertyValue = PropertyFactory.textPitchAlignment((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_textPitchAlignment, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getTextRotationAlignment() {
        return (String)((SymbolLayer)this.layer).getTextRotationAlignment().value;
    }

    public void setTextRotationAlignment(String value) {
        PropertyValue propertyValue = PropertyFactory.textRotationAlignment((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_textRotationAlignment, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getTextLineHeight() {
        return (Float)((SymbolLayer)this.layer).getTextLineHeight().value;
    }

    public void setTextLineHeight(Float value) {
        PropertyValue propertyValue = PropertyFactory.textLineHeight((Float)value);
        this.constantPropertyUsageMap.put(PROPERTY_textLineHeight, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getTextMaxAngle() {
        return (Float)((SymbolLayer)this.layer).getTextMaxAngle().value;
    }

    public void setTextMaxAngle(Float value) {
        PropertyValue propertyValue = PropertyFactory.textMaxAngle((Float)value);
        this.constantPropertyUsageMap.put(PROPERTY_textMaxAngle, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float getTextPadding() {
        return (Float)((SymbolLayer)this.layer).getTextPadding().value;
    }

    public void setTextPadding(Float value) {
        PropertyValue propertyValue = PropertyFactory.textPadding((Float)value);
        this.constantPropertyUsageMap.put(PROPERTY_textPadding, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getTextKeepUpright() {
        return (Boolean)((SymbolLayer)this.layer).getTextKeepUpright().value;
    }

    public void setTextKeepUpright(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.textKeepUpright((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_textKeepUpright, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getTextAllowOverlap() {
        return (Boolean)((SymbolLayer)this.layer).getTextAllowOverlap().value;
    }

    public void setTextAllowOverlap(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.textAllowOverlap((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_textAllowOverlap, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getTextIgnorePlacement() {
        return (Boolean)((SymbolLayer)this.layer).getTextIgnorePlacement().value;
    }

    public void setTextIgnorePlacement(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.textIgnorePlacement((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_textIgnorePlacement, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Boolean getTextOptional() {
        return (Boolean)((SymbolLayer)this.layer).getTextOptional().value;
    }

    public void setTextOptional(Boolean value) {
        PropertyValue propertyValue = PropertyFactory.textOptional((Boolean)value);
        this.constantPropertyUsageMap.put(PROPERTY_textOptional, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getIconTranslate() {
        return (Float[])((SymbolLayer)this.layer).getIconTranslate().value;
    }

    public void setIconTranslate(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.iconTranslate((Float[])value);
        this.constantPropertyUsageMap.put(PROPERTY_iconTranslate, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getIconTranslateAnchor() {
        return (String)((SymbolLayer)this.layer).getIconTranslateAnchor().value;
    }

    public void setIconTranslateAnchor(String value) {
        PropertyValue propertyValue = PropertyFactory.iconTranslateAnchor((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_iconTranslateAnchor, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public Float[] getTextTranslate() {
        return (Float[])((SymbolLayer)this.layer).getTextTranslate().value;
    }

    public void setTextTranslate(Float[] value) {
        PropertyValue propertyValue = PropertyFactory.textTranslate((Float[])value);
        this.constantPropertyUsageMap.put(PROPERTY_textTranslate, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    public String getTextTranslateAnchor() {
        return (String)((SymbolLayer)this.layer).getTextTranslateAnchor().value;
    }

    public void setTextTranslateAnchor(String value) {
        PropertyValue propertyValue = PropertyFactory.textTranslateAnchor((String)value);
        this.constantPropertyUsageMap.put(PROPERTY_textTranslateAnchor, propertyValue);
        ((SymbolLayer)this.layer).setProperties(new PropertyValue[]{propertyValue});
    }

    @Override
    public void setFilter(@NonNull Expression expression) {
        this.layerFilter = expression;
        ((SymbolLayer)this.layer).setFilter(this.layerFilter);
    }

    @Nullable
    public Expression getFilter() {
        return ((SymbolLayer)this.layer).getFilter();
    }
}

