/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.plugins.annotation;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.plugins.annotation.AnnotationManager;
import com.mapbox.mapboxsdk.plugins.annotation.ConvertUtils;
import com.mapbox.mapboxsdk.plugins.annotation.Options;
import com.mapbox.mapboxsdk.plugins.annotation.Symbol;

public class SymbolOptions
extends Options<Symbol> {
    private boolean isDraggable;
    private Point geometry;
    private Float iconSize;
    private String iconImage;
    private Float iconRotate;
    private Float[] iconOffset;
    private String iconAnchor;
    private String textField;
    private String[] textFont;
    private Float textSize;
    private Float textMaxWidth;
    private Float textLetterSpacing;
    private String textJustify;
    private String textAnchor;
    private Float textRotate;
    private String textTransform;
    private Float[] textOffset;
    private Float iconOpacity;
    private String iconColor;
    private String iconHaloColor;
    private Float iconHaloWidth;
    private Float iconHaloBlur;
    private Float textOpacity;
    private String textColor;
    private String textHaloColor;
    private Float textHaloWidth;
    private Float textHaloBlur;
    private int zIndex;
    static final String PROPERTY_iconSize = "icon-size";
    static final String PROPERTY_iconImage = "icon-image";
    static final String PROPERTY_iconRotate = "icon-rotate";
    static final String PROPERTY_iconOffset = "icon-offset";
    static final String PROPERTY_iconAnchor = "icon-anchor";
    static final String PROPERTY_textField = "text-field";
    static final String PROPERTY_textFont = "text-font";
    static final String PROPERTY_textSize = "text-size";
    static final String PROPERTY_textMaxWidth = "text-max-width";
    static final String PROPERTY_textLetterSpacing = "text-letter-spacing";
    static final String PROPERTY_textJustify = "text-justify";
    static final String PROPERTY_textAnchor = "text-anchor";
    static final String PROPERTY_textRotate = "text-rotate";
    static final String PROPERTY_textTransform = "text-transform";
    static final String PROPERTY_textOffset = "text-offset";
    static final String PROPERTY_iconOpacity = "icon-opacity";
    static final String PROPERTY_iconColor = "icon-color";
    static final String PROPERTY_iconHaloColor = "icon-halo-color";
    static final String PROPERTY_iconHaloWidth = "icon-halo-width";
    static final String PROPERTY_iconHaloBlur = "icon-halo-blur";
    static final String PROPERTY_textOpacity = "text-opacity";
    static final String PROPERTY_textColor = "text-color";
    static final String PROPERTY_textHaloColor = "text-halo-color";
    static final String PROPERTY_textHaloWidth = "text-halo-width";
    static final String PROPERTY_textHaloBlur = "text-halo-blur";
    static final String PROPERTY_zIndex = "z-index";
    private static final String PROPERTY_isDraggable = "is-draggable";

    public SymbolOptions withIconSize(Float iconSize) {
        this.iconSize = iconSize;
        return this;
    }

    public Float getIconSize() {
        return this.iconSize;
    }

    public SymbolOptions withIconImage(String iconImage) {
        this.iconImage = iconImage;
        return this;
    }

    public String getIconImage() {
        return this.iconImage;
    }

    public SymbolOptions withIconRotate(Float iconRotate) {
        this.iconRotate = iconRotate;
        return this;
    }

    public Float getIconRotate() {
        return this.iconRotate;
    }

    public SymbolOptions withIconOffset(Float[] iconOffset) {
        this.iconOffset = iconOffset;
        return this;
    }

    public Float[] getIconOffset() {
        return this.iconOffset;
    }

    public SymbolOptions withIconAnchor(String iconAnchor) {
        this.iconAnchor = iconAnchor;
        return this;
    }

    public String getIconAnchor() {
        return this.iconAnchor;
    }

    public SymbolOptions withTextField(String textField) {
        this.textField = textField;
        return this;
    }

    public String getTextField() {
        return this.textField;
    }

    public SymbolOptions withTextFont(String[] textFont) {
        this.textFont = textFont;
        return this;
    }

    public String[] getTextFont() {
        return this.textFont;
    }

    public SymbolOptions withTextSize(Float textSize) {
        this.textSize = textSize;
        return this;
    }

    public Float getTextSize() {
        return this.textSize;
    }

    public SymbolOptions withTextMaxWidth(Float textMaxWidth) {
        this.textMaxWidth = textMaxWidth;
        return this;
    }

    public Float getTextMaxWidth() {
        return this.textMaxWidth;
    }

    public SymbolOptions withTextLetterSpacing(Float textLetterSpacing) {
        this.textLetterSpacing = textLetterSpacing;
        return this;
    }

    public Float getTextLetterSpacing() {
        return this.textLetterSpacing;
    }

    public SymbolOptions withTextJustify(String textJustify) {
        this.textJustify = textJustify;
        return this;
    }

    public String getTextJustify() {
        return this.textJustify;
    }

    public SymbolOptions withTextAnchor(String textAnchor) {
        this.textAnchor = textAnchor;
        return this;
    }

    public String getTextAnchor() {
        return this.textAnchor;
    }

    public SymbolOptions withTextRotate(Float textRotate) {
        this.textRotate = textRotate;
        return this;
    }

    public Float getTextRotate() {
        return this.textRotate;
    }

    public SymbolOptions withTextTransform(String textTransform) {
        this.textTransform = textTransform;
        return this;
    }

    public String getTextTransform() {
        return this.textTransform;
    }

    public SymbolOptions withTextOffset(Float[] textOffset) {
        this.textOffset = textOffset;
        return this;
    }

    public Float[] getTextOffset() {
        return this.textOffset;
    }

    public SymbolOptions withIconOpacity(Float iconOpacity) {
        this.iconOpacity = iconOpacity;
        return this;
    }

    public Float getIconOpacity() {
        return this.iconOpacity;
    }

    public SymbolOptions withIconColor(String iconColor) {
        this.iconColor = iconColor;
        return this;
    }

    public String getIconColor() {
        return this.iconColor;
    }

    public SymbolOptions withIconHaloColor(String iconHaloColor) {
        this.iconHaloColor = iconHaloColor;
        return this;
    }

    public String getIconHaloColor() {
        return this.iconHaloColor;
    }

    public SymbolOptions withIconHaloWidth(Float iconHaloWidth) {
        this.iconHaloWidth = iconHaloWidth;
        return this;
    }

    public Float getIconHaloWidth() {
        return this.iconHaloWidth;
    }

    public SymbolOptions withIconHaloBlur(Float iconHaloBlur) {
        this.iconHaloBlur = iconHaloBlur;
        return this;
    }

    public Float getIconHaloBlur() {
        return this.iconHaloBlur;
    }

    public SymbolOptions withTextOpacity(Float textOpacity) {
        this.textOpacity = textOpacity;
        return this;
    }

    public Float getTextOpacity() {
        return this.textOpacity;
    }

    public SymbolOptions withTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public SymbolOptions withTextHaloColor(String textHaloColor) {
        this.textHaloColor = textHaloColor;
        return this;
    }

    public String getTextHaloColor() {
        return this.textHaloColor;
    }

    public SymbolOptions withTextHaloWidth(Float textHaloWidth) {
        this.textHaloWidth = textHaloWidth;
        return this;
    }

    public Float getTextHaloWidth() {
        return this.textHaloWidth;
    }

    public SymbolOptions withTextHaloBlur(Float textHaloBlur) {
        this.textHaloBlur = textHaloBlur;
        return this;
    }

    public Float getTextHaloBlur() {
        return this.textHaloBlur;
    }

    public SymbolOptions withLatLng(LatLng latLng) {
        this.geometry = Point.fromLngLat((double)latLng.getLongitude(), (double)latLng.getLatitude());
        return this;
    }

    public SymbolOptions withGeometry(Point geometry) {
        this.geometry = geometry;
        return this;
    }

    public SymbolOptions withZIndex(int zIndex) {
        this.zIndex = zIndex;
        return this;
    }

    public int getZIndex() {
        return this.zIndex;
    }

    public boolean getDraggable() {
        return this.isDraggable;
    }

    public SymbolOptions withDraggable(boolean draggable) {
        this.isDraggable = draggable;
        return this;
    }

    @Override
    Symbol build(long id, AnnotationManager<?, Symbol, ?, ?, ?, ?> annotationManager) {
        if (this.geometry == null) {
            throw new RuntimeException("geometry field is required");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(PROPERTY_iconSize, (Number)this.iconSize);
        jsonObject.addProperty(PROPERTY_iconImage, this.iconImage);
        jsonObject.addProperty(PROPERTY_iconRotate, (Number)this.iconRotate);
        jsonObject.add(PROPERTY_iconOffset, (JsonElement)ConvertUtils.convertArray(this.iconOffset));
        jsonObject.addProperty(PROPERTY_iconAnchor, this.iconAnchor);
        jsonObject.addProperty(PROPERTY_textField, this.textField);
        jsonObject.add(PROPERTY_textFont, (JsonElement)ConvertUtils.convertArray(this.textFont));
        jsonObject.addProperty(PROPERTY_textSize, (Number)this.textSize);
        jsonObject.addProperty(PROPERTY_textMaxWidth, (Number)this.textMaxWidth);
        jsonObject.addProperty(PROPERTY_textLetterSpacing, (Number)this.textLetterSpacing);
        jsonObject.addProperty(PROPERTY_textJustify, this.textJustify);
        jsonObject.addProperty(PROPERTY_textAnchor, this.textAnchor);
        jsonObject.addProperty(PROPERTY_textRotate, (Number)this.textRotate);
        jsonObject.addProperty(PROPERTY_textTransform, this.textTransform);
        jsonObject.add(PROPERTY_textOffset, (JsonElement)ConvertUtils.convertArray(this.textOffset));
        jsonObject.addProperty(PROPERTY_iconOpacity, (Number)this.iconOpacity);
        jsonObject.addProperty(PROPERTY_iconColor, this.iconColor);
        jsonObject.addProperty(PROPERTY_iconHaloColor, this.iconHaloColor);
        jsonObject.addProperty(PROPERTY_iconHaloWidth, (Number)this.iconHaloWidth);
        jsonObject.addProperty(PROPERTY_iconHaloBlur, (Number)this.iconHaloBlur);
        jsonObject.addProperty(PROPERTY_textOpacity, (Number)this.textOpacity);
        jsonObject.addProperty(PROPERTY_textColor, this.textColor);
        jsonObject.addProperty(PROPERTY_textHaloColor, this.textHaloColor);
        jsonObject.addProperty(PROPERTY_textHaloWidth, (Number)this.textHaloWidth);
        jsonObject.addProperty(PROPERTY_textHaloBlur, (Number)this.textHaloBlur);
        jsonObject.addProperty(PROPERTY_zIndex, (Number)this.zIndex);
        Symbol symbol = new Symbol(id, annotationManager, jsonObject, this.geometry);
        symbol.setDraggable(this.isDraggable);
        return symbol;
    }

    @Nullable
    static SymbolOptions fromFeature(@NonNull Feature feature) {
        if (feature.geometry() == null) {
            throw new RuntimeException("geometry field is required");
        }
        if (!(feature.geometry() instanceof Point)) {
            return null;
        }
        SymbolOptions options = new SymbolOptions();
        options.geometry = (Point)feature.geometry();
        if (feature.hasProperty(PROPERTY_iconSize)) {
            options.iconSize = Float.valueOf(feature.getProperty(PROPERTY_iconSize).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_iconImage)) {
            options.iconImage = feature.getProperty(PROPERTY_iconImage).getAsString();
        }
        if (feature.hasProperty(PROPERTY_iconRotate)) {
            options.iconRotate = Float.valueOf(feature.getProperty(PROPERTY_iconRotate).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_iconOffset)) {
            options.iconOffset = ConvertUtils.toFloatArray(feature.getProperty(PROPERTY_iconOffset).getAsJsonArray());
        }
        if (feature.hasProperty(PROPERTY_iconAnchor)) {
            options.iconAnchor = feature.getProperty(PROPERTY_iconAnchor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textField)) {
            options.textField = feature.getProperty(PROPERTY_textField).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textFont)) {
            options.textFont = ConvertUtils.toStringArray(feature.getProperty(PROPERTY_textFont).getAsJsonArray());
        }
        if (feature.hasProperty(PROPERTY_textSize)) {
            options.textSize = Float.valueOf(feature.getProperty(PROPERTY_textSize).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textMaxWidth)) {
            options.textMaxWidth = Float.valueOf(feature.getProperty(PROPERTY_textMaxWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textLetterSpacing)) {
            options.textLetterSpacing = Float.valueOf(feature.getProperty(PROPERTY_textLetterSpacing).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textJustify)) {
            options.textJustify = feature.getProperty(PROPERTY_textJustify).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textAnchor)) {
            options.textAnchor = feature.getProperty(PROPERTY_textAnchor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textRotate)) {
            options.textRotate = Float.valueOf(feature.getProperty(PROPERTY_textRotate).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textTransform)) {
            options.textTransform = feature.getProperty(PROPERTY_textTransform).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textOffset)) {
            options.textOffset = ConvertUtils.toFloatArray(feature.getProperty(PROPERTY_textOffset).getAsJsonArray());
        }
        if (feature.hasProperty(PROPERTY_iconOpacity)) {
            options.iconOpacity = Float.valueOf(feature.getProperty(PROPERTY_iconOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_iconColor)) {
            options.iconColor = feature.getProperty(PROPERTY_iconColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_iconHaloColor)) {
            options.iconHaloColor = feature.getProperty(PROPERTY_iconHaloColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_iconHaloWidth)) {
            options.iconHaloWidth = Float.valueOf(feature.getProperty(PROPERTY_iconHaloWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_iconHaloBlur)) {
            options.iconHaloBlur = Float.valueOf(feature.getProperty(PROPERTY_iconHaloBlur).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textOpacity)) {
            options.textOpacity = Float.valueOf(feature.getProperty(PROPERTY_textOpacity).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textColor)) {
            options.textColor = feature.getProperty(PROPERTY_textColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textHaloColor)) {
            options.textHaloColor = feature.getProperty(PROPERTY_textHaloColor).getAsString();
        }
        if (feature.hasProperty(PROPERTY_textHaloWidth)) {
            options.textHaloWidth = Float.valueOf(feature.getProperty(PROPERTY_textHaloWidth).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_textHaloBlur)) {
            options.textHaloBlur = Float.valueOf(feature.getProperty(PROPERTY_textHaloBlur).getAsFloat());
        }
        if (feature.hasProperty(PROPERTY_zIndex)) {
            options.zIndex = feature.getProperty(PROPERTY_zIndex).getAsInt();
        }
        if (feature.hasProperty(PROPERTY_isDraggable)) {
            options.isDraggable = feature.getProperty(PROPERTY_isDraggable).getAsBoolean();
        }
        return options;
    }
}

