/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import java.io.File;

public class OfflineManager {
    private static final String LOG_TAG = "OfflineManager";
    private static final String DATABASE_NAME = "mbgl-offline.db";
    private static final long DEFAULT_MAX_CACHE_SIZE = 0x3200000L;
    private long mDefaultFileSourcePtr = 0L;
    private Handler handler;
    private static OfflineManager instance;

    private OfflineManager(Context context) {
        String assetRoot = context.getFilesDir().getAbsolutePath();
        String cachePath = assetRoot + File.separator + DATABASE_NAME;
        this.mDefaultFileSourcePtr = this.createDefaultFileSource(cachePath, assetRoot, 0x3200000L);
        if (MapboxAccountManager.getInstance() != null) {
            this.setAccessToken(this.mDefaultFileSourcePtr, MapboxAccountManager.getInstance().getAccessToken());
        }
        this.deleteAmbientDatabase(context);
    }

    private void deleteAmbientDatabase(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String path = context.getCacheDir().getAbsolutePath() + File.separator + "mbgl-cache.db";
                    File file = new File(path);
                    if (file.exists()) {
                        file.delete();
                        Log.d((String)OfflineManager.LOG_TAG, (String)("Old ambient cache database deleted to save space: " + path));
                    }
                }
                catch (Exception e) {
                    Log.e((String)OfflineManager.LOG_TAG, (String)("Failed to delete old ambient cache database: " + e.getMessage()));
                }
            }
        }).start();
    }

    public static synchronized OfflineManager getInstance(Context context) {
        if (instance == null) {
            instance = new OfflineManager(context);
        }
        return instance;
    }

    @Deprecated
    public void setAccessToken(String accessToken) {
        this.setAccessToken(this.mDefaultFileSourcePtr, accessToken);
    }

    @Deprecated
    public String getAccessToken() {
        return this.getAccessToken(this.mDefaultFileSourcePtr);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void listOfflineRegions(final @NonNull ListOfflineRegionsCallback callback) {
        this.listOfflineRegions(this.mDefaultFileSourcePtr, new ListOfflineRegionsCallback(){

            @Override
            public void onList(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onList(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void createOfflineRegion(@NonNull OfflineRegionDefinition definition, @NonNull byte[] metadata, final @NonNull CreateOfflineRegionCallback callback) {
        this.createOfflineRegion(this.mDefaultFileSourcePtr, definition, metadata, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void setOfflineMapboxTileCountLimit(long limit) {
        this.setOfflineMapboxTileCountLimit(this.mDefaultFileSourcePtr, limit);
    }

    private native long createDefaultFileSource(String var1, String var2, long var3);

    private native void setAccessToken(long var1, String var3);

    private native String getAccessToken(long var1);

    private native void listOfflineRegions(long var1, ListOfflineRegionsCallback var3);

    private native void createOfflineRegion(long var1, OfflineRegionDefinition var3, byte[] var4, CreateOfflineRegionCallback var5);

    private native void setOfflineMapboxTileCountLimit(long var1, long var3);

    static {
        System.loadLibrary("mapbox-gl");
    }

    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    public static interface ListOfflineRegionsCallback {
        public void onList(OfflineRegion[] var1);

        public void onError(String var1);
    }
}

