/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import android.content.Context;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import com.mapbox.mapboxsdk.exceptions.InvalidAccessTokenException;
import com.mapbox.mapboxsdk.telemetry.MapboxEventManager;

public class MapboxAccountManager {
    private static MapboxAccountManager mapboxAccountManager = null;
    private final String accessToken;
    private final Context applicationContext;

    private MapboxAccountManager(Context applicationContext, String accessToken) {
        this.applicationContext = applicationContext.getApplicationContext();
        this.accessToken = accessToken;
    }

    public static MapboxAccountManager start(Context context, String accessToken) {
        if (mapboxAccountManager == null) {
            mapboxAccountManager = new MapboxAccountManager(context, accessToken);
        }
        MapboxEventManager eventManager = MapboxEventManager.getMapboxEventManager();
        eventManager.initialize(MapboxAccountManager.mapboxAccountManager.applicationContext, MapboxAccountManager.mapboxAccountManager.accessToken);
        return mapboxAccountManager;
    }

    public static MapboxAccountManager getInstance() {
        return mapboxAccountManager;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static void validateAccessToken(String accessToken) throws InvalidAccessTokenException {
        if (TextUtils.isEmpty((CharSequence)accessToken) || !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("pk.") && !accessToken.toLowerCase(MapboxConstants.MAPBOX_LOCALE).startsWith("sk.")) {
            throw new InvalidAccessTokenException();
        }
    }
}

