/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapbox.mapboxsdk.location.LocationServices;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import java.lang.ref.WeakReference;

public class MyLocationView
extends View {
    private MyLocationBehavior myLocationBehavior;
    private MapboxMap mapboxMap;
    private Projection projection;
    private int[] contentPadding = new int[4];
    private Location location;
    private LatLng latLng;
    private LatLng interpolatedLocation;
    private LatLng previousLocation;
    private long locationUpdateTimestamp;
    private float gpsDirection;
    private float previousDirection;
    private float accuracy;
    private Paint accuracyPaint;
    private ValueAnimator locationChangeAnimator;
    private ValueAnimator accuracyAnimator;
    private ValueAnimator directionAnimator;
    private ValueAnimator.AnimatorUpdateListener invalidateSelfOnUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            MyLocationView.this.invalidate();
        }
    };
    private Drawable foregroundDrawable;
    private Drawable foregroundBearingDrawable;
    private Drawable backgroundDrawable;
    private int foregroundTintColor;
    private int backgroundTintColor;
    private Rect foregroundBounds;
    private Rect backgroundBounds;
    private int backgroundOffsetLeft;
    private int backgroundOffsetTop;
    private int backgroundOffsetRight;
    private int backgroundOffsetBottom;
    private Matrix matrix;
    private Camera camera;
    private PointF screenLocation;
    private float tilt;
    private int myLocationTrackingMode;
    private int myBearingTrackingMode;
    private GpsLocationListener userLocationListener;
    private CompassListener compassListener;

    public MyLocationView(Context context) {
        super(context);
        this.init(context);
    }

    public MyLocationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MyLocationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setEnabled(false);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        this.matrix = new Matrix();
        this.camera = new Camera();
        this.camera.setLocation(0.0f, 0.0f, -1000.0f);
        this.accuracyPaint = new Paint();
        this.myLocationBehavior = new MyLocationBehaviorFactory().getBehavioralModel(0);
        this.compassListener = new CompassListener(context);
    }

    public final void setForegroundDrawables(Drawable defaultDrawable, Drawable bearingDrawable) {
        if (defaultDrawable == null) {
            return;
        }
        if (bearingDrawable == null) {
            bearingDrawable = defaultDrawable.getConstantState().newDrawable();
        }
        if (this.backgroundDrawable == null) {
            this.backgroundDrawable = defaultDrawable.getConstantState().newDrawable();
        }
        if (defaultDrawable.getIntrinsicWidth() != bearingDrawable.getIntrinsicWidth() || defaultDrawable.getIntrinsicHeight() != bearingDrawable.getIntrinsicHeight()) {
            throw new RuntimeException("The dimensions from location and bearing drawables should be match");
        }
        this.foregroundDrawable = defaultDrawable;
        this.foregroundBearingDrawable = bearingDrawable;
        this.setForegroundDrawableTint(this.foregroundTintColor);
        this.invalidateBounds();
    }

    public final void setForegroundDrawableTint(@ColorInt int color2) {
        if (color2 != 0) {
            this.foregroundTintColor = color2;
            if (this.foregroundDrawable != null) {
                this.foregroundDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            }
            if (this.foregroundBearingDrawable != null) {
                this.foregroundBearingDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            }
        }
        this.invalidate();
    }

    public final void setShadowDrawable(Drawable drawable2) {
        this.setShadowDrawable(drawable2, 0, 0, 0, 0);
    }

    public final void setShadowDrawable(Drawable drawable2, int left, int top, int right, int bottom) {
        if (drawable2 != null) {
            this.backgroundDrawable = drawable2;
        }
        this.backgroundOffsetLeft = left;
        this.backgroundOffsetTop = top;
        this.backgroundOffsetRight = right;
        this.backgroundOffsetBottom = bottom;
        this.setShadowDrawableTint(this.backgroundTintColor);
        this.invalidateBounds();
    }

    public final void setShadowDrawableTint(@ColorInt int color2) {
        if (color2 != 0) {
            this.backgroundTintColor = color2;
            if (this.backgroundDrawable == null) {
                return;
            }
            this.backgroundDrawable.mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
        this.invalidate();
    }

    public final void setAccuracyTint(@ColorInt int color2) {
        int alpha = this.accuracyPaint.getAlpha();
        this.accuracyPaint.setColor(color2);
        this.accuracyPaint.setAlpha(alpha);
        this.invalidate();
    }

    public final void setAccuracyAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.accuracyPaint.setAlpha(alpha);
        this.invalidate();
    }

    private void invalidateBounds() {
        if (this.backgroundDrawable == null || this.foregroundDrawable == null || this.foregroundBearingDrawable == null) {
            return;
        }
        int backgroundWidth = this.backgroundDrawable.getIntrinsicWidth();
        int backgroundHeight = this.backgroundDrawable.getIntrinsicHeight();
        int horizontalOffset = this.backgroundOffsetLeft - this.backgroundOffsetRight;
        int verticalOffset = this.backgroundOffsetTop - this.backgroundOffsetBottom;
        this.backgroundBounds = new Rect(-backgroundWidth / 2 + horizontalOffset, -backgroundHeight / 2 + verticalOffset, backgroundWidth / 2 + horizontalOffset, backgroundHeight / 2 + verticalOffset);
        this.backgroundDrawable.setBounds(this.backgroundBounds);
        int foregroundWidth = this.foregroundDrawable.getIntrinsicWidth();
        int foregroundHeight = this.foregroundDrawable.getIntrinsicHeight();
        this.foregroundBounds = new Rect(-foregroundWidth / 2, -foregroundHeight / 2, foregroundWidth / 2, foregroundHeight / 2);
        this.foregroundDrawable.setBounds(this.foregroundBounds);
        this.foregroundBearingDrawable.setBounds(this.foregroundBounds);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        float maxRadius;
        super.onDraw(canvas);
        if (this.location == null || this.foregroundBounds == null || this.backgroundBounds == null || this.accuracyAnimator == null || this.screenLocation == null) {
            return;
        }
        PointF pointF = this.screenLocation;
        float metersPerPixel = (float)this.projection.getMetersPerPixelAtLatitude(this.location.getLatitude());
        float accuracyPixels = ((Float)this.accuracyAnimator.getAnimatedValue()).floatValue() / metersPerPixel / 2.0f;
        accuracyPixels = accuracyPixels <= (maxRadius = (float)(this.getWidth() / 2)) ? accuracyPixels : maxRadius;
        this.matrix.reset();
        this.camera.save();
        this.camera.rotate(this.tilt, 0.0f, 0.0f);
        this.camera.getMatrix(this.matrix);
        if (this.myBearingTrackingMode != 0 && this.directionAnimator != null) {
            this.matrix.preRotate(((Float)this.directionAnimator.getAnimatedValue()).floatValue());
        }
        this.matrix.postTranslate(pointF.x, pointF.y);
        canvas.concat(this.matrix);
        this.camera.restore();
        canvas.drawCircle(0.0f, 0.0f, accuracyPixels, this.accuracyPaint);
        if (this.backgroundDrawable != null) {
            this.backgroundDrawable.draw(canvas);
        }
        if (this.myBearingTrackingMode == 0) {
            if (this.foregroundDrawable != null) {
                this.foregroundDrawable.draw(canvas);
            }
        } else if (this.foregroundBearingDrawable != null && this.foregroundBounds != null) {
            this.foregroundBearingDrawable.draw(canvas);
        }
    }

    public void setTilt(@FloatRange(from=0.0, to=60.0) double tilt) {
        this.tilt = (float)tilt;
    }

    public void onPause() {
        this.compassListener.onPause();
        this.toggleGps(false);
    }

    public void onResume() {
        if (this.myBearingTrackingMode == 4) {
            this.compassListener.onResume();
        }
        if (this.isEnabled()) {
            this.toggleGps(true);
        }
    }

    public void update() {
        if (this.isEnabled()) {
            this.myLocationBehavior.invalidate();
        } else {
            this.setVisibility(4);
        }
    }

    public void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        this.projection = mapboxMap.getProjection();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setVisibility(enabled ? 0 : 4);
        this.toggleGps(enabled);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putFloat("tilt", this.tilt);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.tilt = bundle.getFloat("tilt");
            state = bundle.getParcelable("superState");
        }
        super.onRestoreInstanceState(state);
    }

    private void toggleGps(boolean enableGps) {
        LocationServices locationServices = LocationServices.getLocationServices(this.getContext());
        if (enableGps) {
            Location lastLocation = locationServices.getLastLocation();
            if (lastLocation != null) {
                this.setLocation(lastLocation);
            }
            if (this.userLocationListener == null) {
                this.userLocationListener = new GpsLocationListener(this);
            }
            locationServices.addLocationListener(this.userLocationListener);
        } else {
            this.location = null;
            locationServices.removeLocationListener(this.userLocationListener);
        }
        locationServices.toggleGPS(enableGps);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        if (location == null) {
            this.location = null;
            return;
        }
        this.location = location;
        this.myLocationBehavior.updateLatLng(location);
    }

    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.myBearingTrackingMode = myBearingTrackingMode;
        if (myBearingTrackingMode == 4) {
            this.compassListener.onResume();
        } else {
            this.compassListener.onPause();
            if (this.myLocationTrackingMode == 4) {
                this.gpsDirection = 0.0f;
                this.setCompass(this.gpsDirection);
            }
        }
        this.invalidate();
        this.update();
    }

    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.myLocationTrackingMode = myLocationTrackingMode;
        MyLocationBehaviorFactory factory = new MyLocationBehaviorFactory();
        this.myLocationBehavior = factory.getBehavioralModel(myLocationTrackingMode);
        if (myLocationTrackingMode != 0 && this.location != null) {
            this.myLocationBehavior.updateLatLng(this.location);
            this.mapboxMap.moveCamera(CameraUpdateFactory.newLatLng(new LatLng(this.location)));
        }
        this.invalidate();
        this.update();
    }

    private void setCompass(float bearing) {
        float newDir;
        float diff;
        float oldDir = this.previousDirection;
        if (this.directionAnimator != null) {
            oldDir = ((Float)this.directionAnimator.getAnimatedValue()).floatValue();
            this.directionAnimator.end();
            this.directionAnimator = null;
        }
        if ((diff = oldDir - (newDir = bearing)) > 180.0f) {
            newDir += 360.0f;
        } else if (diff < -180.0f) {
            newDir -= 360.0f;
        }
        this.previousDirection = newDir;
        this.directionAnimator = ValueAnimator.ofFloat((float[])new float[]{oldDir, newDir});
        this.directionAnimator.setDuration(375L);
        this.directionAnimator.addUpdateListener(this.invalidateSelfOnUpdateListener);
        this.directionAnimator.start();
    }

    public float getCenterX() {
        return this.getX() + (float)(this.getMeasuredWidth() / 2);
    }

    public float getCenterY() {
        return this.getY() + (float)(this.getMeasuredHeight() / 2);
    }

    public void setContentPadding(int[] padding) {
        this.contentPadding = padding;
    }

    private class MyLocationShowBehavior
    extends MyLocationBehavior {
        private MyLocationShowBehavior() {
        }

        @Override
        void updateLatLng(@NonNull Location location) {
            if (MyLocationView.this.latLng == null) {
                MyLocationView.this.latLng = new LatLng(location);
                MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            }
            MyLocationView.this.previousLocation = MyLocationView.this.latLng;
            MyLocationView.this.latLng = new LatLng(location);
            if (location.hasBearing()) {
                MyLocationView.this.gpsDirection = this.clamp(location.getBearing() - (float)((MyLocationView)MyLocationView.this).mapboxMap.getCameraPosition().bearing);
                MyLocationView.this.setCompass(MyLocationView.this.gpsDirection);
            }
            this.updateAccuracy(location);
            long previousUpdateTimeStamp = MyLocationView.this.locationUpdateTimestamp;
            MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            long locationUpdateDuration = (long)((double)(MyLocationView.this.locationUpdateTimestamp - previousUpdateTimeStamp) * 1.3);
            MyLocationView.this.interpolatedLocation = new LatLng((MyLocationView.this.latLng.getLatitude() + MyLocationView.this.previousLocation.getLatitude()) / 2.0, (MyLocationView.this.latLng.getLongitude() + MyLocationView.this.previousLocation.getLongitude()) / 2.0);
            if (MyLocationView.this.locationChangeAnimator != null) {
                MyLocationView.this.locationChangeAnimator.end();
                MyLocationView.this.locationChangeAnimator = null;
            }
            MyLocationView.this.locationChangeAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            MyLocationView.this.locationChangeAnimator.setDuration((long)((double)locationUpdateDuration * 1.2));
            MyLocationView.this.locationChangeAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new MarkerCoordinateAnimatorListener(this, MyLocationView.this.previousLocation, MyLocationView.this.interpolatedLocation));
            MyLocationView.this.locationChangeAnimator.start();
            MyLocationView.this.latLng = MyLocationView.this.interpolatedLocation;
        }

        private float clamp(float direction) {
            float diff = MyLocationView.this.previousDirection - direction;
            if (diff > 180.0f) {
                direction += 360.0f;
            } else if (diff < -180.0f) {
                direction -= 360.0f;
            }
            MyLocationView.this.previousDirection = direction;
            return direction;
        }

        @Override
        void invalidate() {
            MyLocationView.this.screenLocation = MyLocationView.this.projection.toScreenLocation(MyLocationView.this.latLng);
            MyLocationView.this.invalidate();
        }
    }

    private class MyLocationTrackingBehavior
    extends MyLocationBehavior {
        private MyLocationTrackingBehavior() {
        }

        @Override
        void updateLatLng(@NonNull Location location) {
            if (MyLocationView.this.latLng == null) {
                MyLocationView.this.latLng = new LatLng(location);
                MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            }
            long previousUpdateTimeStamp = MyLocationView.this.locationUpdateTimestamp;
            MyLocationView.this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            long locationUpdateDuration = previousUpdateTimeStamp == 0L ? 0L : MyLocationView.this.locationUpdateTimestamp - previousUpdateTimeStamp;
            MyLocationView.this.previousLocation = MyLocationView.this.latLng;
            MyLocationView.this.latLng = new LatLng(location);
            MyLocationView.this.interpolatedLocation = new LatLng((MyLocationView.this.latLng.getLatitude() + MyLocationView.this.previousLocation.getLatitude()) / 2.0, (MyLocationView.this.latLng.getLongitude() + MyLocationView.this.previousLocation.getLongitude()) / 2.0);
            CameraPosition.Builder builder = new CameraPosition.Builder().target(MyLocationView.this.interpolatedLocation);
            if (MyLocationView.this.myBearingTrackingMode == 8) {
                if (location.hasBearing()) {
                    builder.bearing(location.getBearing());
                }
                MyLocationView.this.gpsDirection = 0.0f;
                MyLocationView.this.setCompass(MyLocationView.this.gpsDirection);
            } else if (MyLocationView.this.myBearingTrackingMode == 4 && !MyLocationView.this.compassListener.isPaused()) {
                builder.bearing(MyLocationView.this.compassListener.getCurrentDegree());
                MyLocationView.this.setCompass(0.0f);
            }
            this.updateAccuracy(location);
            MyLocationView.this.mapboxMap.easeCamera(CameraUpdateFactory.newCameraPosition(builder.build()), (int)locationUpdateDuration, false);
        }

        @Override
        void invalidate() {
            int[] mapPadding = MyLocationView.this.mapboxMap.getPadding();
            float x = (MyLocationView.this.getWidth() + mapPadding[0] - mapPadding[2]) / 2 + (MyLocationView.this.contentPadding[0] - MyLocationView.this.contentPadding[2]) / 2;
            float y = (MyLocationView.this.getHeight() - mapPadding[3] + mapPadding[1]) / 2 + (MyLocationView.this.contentPadding[1] - MyLocationView.this.contentPadding[3]) / 2;
            MyLocationView.this.screenLocation = new PointF(x, y);
            MyLocationView.this.invalidate();
        }
    }

    private abstract class MyLocationBehavior {
        private MyLocationBehavior() {
        }

        abstract void updateLatLng(@NonNull Location var1);

        public void updateLatLng(double lat, double lon) {
            if (MyLocationView.this.latLng != null) {
                MyLocationView.this.latLng.setLatitude(lat);
                MyLocationView.this.latLng.setLongitude(lon);
            }
        }

        protected void updateAccuracy(@NonNull Location location) {
            if (MyLocationView.this.accuracyAnimator != null && MyLocationView.this.accuracyAnimator.isRunning()) {
                MyLocationView.this.accuracy = ((Float)MyLocationView.this.accuracyAnimator.getAnimatedValue()).floatValue();
                MyLocationView.this.accuracyAnimator.end();
            }
            MyLocationView.this.accuracyAnimator = ValueAnimator.ofFloat((float[])new float[]{MyLocationView.this.accuracy * 10.0f, location.getAccuracy() * 10.0f});
            MyLocationView.this.accuracyAnimator.setDuration(750L);
            MyLocationView.this.accuracyAnimator.start();
            MyLocationView.this.accuracy = location.getAccuracy();
        }

        abstract void invalidate();
    }

    private class MyLocationBehaviorFactory {
        private MyLocationBehaviorFactory() {
        }

        public MyLocationBehavior getBehavioralModel(int mode) {
            if (mode == 0) {
                return new MyLocationShowBehavior();
            }
            return new MyLocationTrackingBehavior();
        }
    }

    private class MarkerCoordinateAnimatorListener
    implements ValueAnimator.AnimatorUpdateListener {
        private MyLocationBehavior behavior;
        private double fromLat;
        private double fromLng;
        private double toLat;
        private double toLng;

        private MarkerCoordinateAnimatorListener(MyLocationBehavior myLocationBehavior, LatLng from, LatLng to) {
            this.behavior = myLocationBehavior;
            this.fromLat = from.getLatitude();
            this.fromLng = from.getLongitude();
            this.toLat = to.getLatitude();
            this.toLng = to.getLongitude();
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float frac = animation.getAnimatedFraction();
            double latitude = this.fromLat + (this.toLat - this.fromLat) * (double)frac;
            double longitude = this.fromLng + (this.toLng - this.fromLng) * (double)frac;
            this.behavior.updateLatLng(latitude, longitude);
            MyLocationView.this.update();
        }
    }

    private class CompassListener
    implements SensorEventListener {
        private SensorManager mSensorManager;
        private Sensor mAccelerometer;
        private Sensor mMagnetometer;
        private boolean paused;
        private float mCurrentDegree = 0.0f;
        private float[] mOrientation = new float[3];
        private float[] mGData = new float[3];
        private float[] mMData = new float[3];
        private float[] mR = new float[16];
        private float[] mI = new float[16];
        private static final int UPDATE_RATE_MS = 500;
        private long mCompassUpdateNextTimestamp = 0L;

        public CompassListener(Context context) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
            this.mAccelerometer = this.mSensorManager.getDefaultSensor(1);
            this.mMagnetometer = this.mSensorManager.getDefaultSensor(2);
        }

        public void onResume() {
            this.paused = false;
            this.mSensorManager.registerListener((SensorEventListener)this, this.mAccelerometer, 1);
            this.mSensorManager.registerListener((SensorEventListener)this, this.mMagnetometer, 1);
        }

        public void onPause() {
            this.paused = true;
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mAccelerometer);
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mMagnetometer);
        }

        public void onSensorChanged(SensorEvent event) {
            if (this.paused) {
                return;
            }
            int type = event.sensor.getType();
            if (type == 1) {
                System.arraycopy(event.values, 0, this.mGData, 0, 3);
            } else if (type == 2) {
                System.arraycopy(event.values, 0, this.mMData, 0, 3);
            } else {
                return;
            }
            long currentTime = SystemClock.elapsedRealtime();
            if (currentTime < this.mCompassUpdateNextTimestamp) {
                return;
            }
            SensorManager.getRotationMatrix((float[])this.mR, (float[])this.mI, (float[])this.mGData, (float[])this.mMData);
            SensorManager.getOrientation((float[])this.mR, (float[])this.mOrientation);
            MyLocationView.this.setCompass((int)((double)(this.mOrientation[0] * 180.0f) / Math.PI));
            this.mCompassUpdateNextTimestamp = currentTime + 500L;
        }

        public float getCurrentDegree() {
            return this.mCurrentDegree;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static class GpsLocationListener
    implements LocationListener {
        private WeakReference<MyLocationView> mUserLocationView;

        public GpsLocationListener(MyLocationView myLocationView) {
            this.mUserLocationView = new WeakReference<MyLocationView>(myLocationView);
        }

        @Override
        public void onLocationChanged(Location location) {
            MyLocationView locationView = (MyLocationView)((Object)this.mUserLocationView.get());
            if (locationView != null) {
                locationView.setLocation(location);
            }
        }
    }
}

