/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.Property;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public class SymbolLayer
extends Layer {
    public SymbolLayer(long nativePtr) {
        super(nativePtr);
    }

    public SymbolLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkValidity();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public SymbolLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public void setFilter(Filter.Statement filter) {
        this.checkValidity();
        this.setFilter(filter.toArray());
    }

    public void setFilter(Object[] filter) {
        this.checkValidity();
        this.nativeSetFilter(filter);
    }

    public SymbolLayer withFilter(Object[] filter) {
        this.setFilter(filter);
        return this;
    }

    public SymbolLayer withFilter(Filter.Statement filter) {
        this.setFilter(filter);
        return this;
    }

    public SymbolLayer withProperties(Property<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getSymbolPlacement() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetSymbolPlacement());
    }

    public PropertyValue<Float> getSymbolSpacing() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetSymbolSpacing());
    }

    public PropertyValue<Boolean> getSymbolAvoidEdges() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetSymbolAvoidEdges());
    }

    public PropertyValue<Boolean> getIconAllowOverlap() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetIconAllowOverlap());
    }

    public PropertyValue<Boolean> getIconIgnorePlacement() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetIconIgnorePlacement());
    }

    public PropertyValue<Boolean> getIconOptional() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetIconOptional());
    }

    public PropertyValue<String> getIconRotationAlignment() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconRotationAlignment());
    }

    public PropertyValue<Float> getIconSize() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconSize());
    }

    public PropertyValue<String> getIconTextFit() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconTextFit());
    }

    public PropertyValue<Float[]> getIconTextFitPadding() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetIconTextFitPadding());
    }

    public PropertyValue<String> getIconImage() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconImage());
    }

    public PropertyValue<Float> getIconRotate() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconRotate());
    }

    public PropertyValue<Float> getIconPadding() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconPadding());
    }

    public PropertyValue<Boolean> getIconKeepUpright() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetIconKeepUpright());
    }

    public PropertyValue<Float[]> getIconOffset() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetIconOffset());
    }

    public PropertyValue<String> getTextPitchAlignment() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextPitchAlignment());
    }

    public PropertyValue<String> getTextRotationAlignment() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextRotationAlignment());
    }

    public PropertyValue<String> getTextField() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextField());
    }

    public PropertyValue<String[]> getTextFont() {
        this.checkValidity();
        return new PropertyValue<String[]>(this.nativeGetTextFont());
    }

    public PropertyValue<Float> getTextSize() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextSize());
    }

    public PropertyValue<Float> getTextMaxWidth() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextMaxWidth());
    }

    public PropertyValue<Float> getTextLineHeight() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextLineHeight());
    }

    public PropertyValue<Float> getTextLetterSpacing() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextLetterSpacing());
    }

    public PropertyValue<String> getTextJustify() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextJustify());
    }

    public PropertyValue<String> getTextAnchor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextAnchor());
    }

    public PropertyValue<Float> getTextMaxAngle() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextMaxAngle());
    }

    public PropertyValue<Float> getTextRotate() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextRotate());
    }

    public PropertyValue<Float> getTextPadding() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextPadding());
    }

    public PropertyValue<Boolean> getTextKeepUpright() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetTextKeepUpright());
    }

    public PropertyValue<String> getTextTransform() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextTransform());
    }

    public PropertyValue<Float[]> getTextOffset() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetTextOffset());
    }

    public PropertyValue<Boolean> getTextAllowOverlap() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetTextAllowOverlap());
    }

    public PropertyValue<Boolean> getTextIgnorePlacement() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetTextIgnorePlacement());
    }

    public PropertyValue<Boolean> getTextOptional() {
        this.checkValidity();
        return new PropertyValue<Boolean>(this.nativeGetTextOptional());
    }

    public PropertyValue<Float> getIconOpacity() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconOpacity());
    }

    public PropertyValue<String> getIconColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconColor());
    }

    @ColorInt
    public int getIconColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getIconColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-color was set as a Function");
    }

    public PropertyValue<String> getIconHaloColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconHaloColor());
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getIconHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-halo-color was set as a Function");
    }

    public PropertyValue<Float> getIconHaloWidth() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconHaloWidth());
    }

    public PropertyValue<Float> getIconHaloBlur() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetIconHaloBlur());
    }

    public PropertyValue<Float[]> getIconTranslate() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetIconTranslate());
    }

    public PropertyValue<String> getIconTranslateAnchor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetIconTranslateAnchor());
    }

    public PropertyValue<Float> getTextOpacity() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextOpacity());
    }

    public PropertyValue<String> getTextColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextColor());
    }

    @ColorInt
    public int getTextColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getTextColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-color was set as a Function");
    }

    public PropertyValue<String> getTextHaloColor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextHaloColor());
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        this.checkValidity();
        PropertyValue<String> value = this.getTextHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-halo-color was set as a Function");
    }

    public PropertyValue<Float> getTextHaloWidth() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextHaloWidth());
    }

    public PropertyValue<Float> getTextHaloBlur() {
        this.checkValidity();
        return new PropertyValue<Float>(this.nativeGetTextHaloBlur());
    }

    public PropertyValue<Float[]> getTextTranslate() {
        this.checkValidity();
        return new PropertyValue<Float[]>(this.nativeGetTextTranslate());
    }

    public PropertyValue<String> getTextTranslateAnchor() {
        this.checkValidity();
        return new PropertyValue<String>(this.nativeGetTextTranslateAnchor());
    }

    private native Object nativeGetSymbolPlacement();

    private native Object nativeGetSymbolSpacing();

    private native Object nativeGetSymbolAvoidEdges();

    private native Object nativeGetIconAllowOverlap();

    private native Object nativeGetIconIgnorePlacement();

    private native Object nativeGetIconOptional();

    private native Object nativeGetIconRotationAlignment();

    private native Object nativeGetIconSize();

    private native Object nativeGetIconTextFit();

    private native Object nativeGetIconTextFitPadding();

    private native Object nativeGetIconImage();

    private native Object nativeGetIconRotate();

    private native Object nativeGetIconPadding();

    private native Object nativeGetIconKeepUpright();

    private native Object nativeGetIconOffset();

    private native Object nativeGetTextPitchAlignment();

    private native Object nativeGetTextRotationAlignment();

    private native Object nativeGetTextField();

    private native Object nativeGetTextFont();

    private native Object nativeGetTextSize();

    private native Object nativeGetTextMaxWidth();

    private native Object nativeGetTextLineHeight();

    private native Object nativeGetTextLetterSpacing();

    private native Object nativeGetTextJustify();

    private native Object nativeGetTextAnchor();

    private native Object nativeGetTextMaxAngle();

    private native Object nativeGetTextRotate();

    private native Object nativeGetTextPadding();

    private native Object nativeGetTextKeepUpright();

    private native Object nativeGetTextTransform();

    private native Object nativeGetTextOffset();

    private native Object nativeGetTextAllowOverlap();

    private native Object nativeGetTextIgnorePlacement();

    private native Object nativeGetTextOptional();

    private native Object nativeGetIconOpacity();

    private native Object nativeGetIconColor();

    private native Object nativeGetIconHaloColor();

    private native Object nativeGetIconHaloWidth();

    private native Object nativeGetIconHaloBlur();

    private native Object nativeGetIconTranslate();

    private native Object nativeGetIconTranslateAnchor();

    private native Object nativeGetTextOpacity();

    private native Object nativeGetTextColor();

    private native Object nativeGetTextHaloColor();

    private native Object nativeGetTextHaloWidth();

    private native Object nativeGetTextHaloBlur();

    private native Object nativeGetTextTranslate();

    private native Object nativeGetTextTranslateAnchor();

    @Override
    protected native void finalize() throws Throwable;
}

