/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ZoomButtonsController;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.ShoveGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.mapboxsdk.MapboxAccountManager;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.IconFactory;
import com.mapbox.mapboxsdk.annotations.InfoWindow;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.exceptions.IconBitmapChangedException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationListener;
import com.mapbox.mapboxsdk.location.LocationServices;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.telemetry.MapboxEventManager;
import com.mapbox.mapboxsdk.utils.ColorUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapView
extends FrameLayout {
    private MapboxMap mapboxMap;
    private boolean initialLoad;
    private boolean destroyed;
    private List<Icon> icons;
    private int averageIconHeight;
    private int averageIconWidth;
    private NativeMapView nativeMapView;
    private boolean hasSurface = false;
    private ViewGroup markerViewContainer;
    private CompassView compassView;
    private ImageView logoView;
    private ImageView attributionsView;
    private MyLocationView myLocationView;
    private LocationListener myLocationListener;
    private CopyOnWriteArrayList<OnMapChangedListener> onMapChangedListener;
    private ZoomButtonsController zoomButtonsController;
    private ConnectivityReceiver connectivityReceiver;
    private float screenDensity = 1.0f;
    private TrackballLongPressTimeOut currentTrackballLongPressTimeOut;
    private GestureDetectorCompat gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private RotateGestureDetector rotateGestureDetector;
    private ShoveGestureDetector shoveGestureDetector;
    private boolean twoTap = false;
    private boolean zoomStarted = false;
    private boolean dragStarted = false;
    private boolean quickZoom = false;
    private boolean scrollInProgress = false;
    private int contentPaddingLeft;
    private int contentPaddingTop;
    private int contentPaddingRight;
    private int contentPaddingBottom;
    private PointF focalPoint;
    private String styleUrl;
    private String initalStyle;
    private List<OnMapReadyCallback> onMapReadyCallbackList;
    private SnapshotRequest snapshotRequest;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;
    public static final int DID_FINISH_LOADING_STYLE = 14;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialize(context, options);
    }

    private void initialize(@NonNull Context context, @NonNull MapboxMapOptions options) {
        if (this.isInEditMode()) {
            LayoutInflater.from((Context)context).inflate(R.layout.mapview_preview, (ViewGroup)this);
            return;
        }
        this.initialLoad = true;
        this.onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
        this.onMapChangedListener = new CopyOnWriteArrayList();
        this.mapboxMap = new MapboxMap(this);
        this.icons = new ArrayList<Icon>();
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapview_internal, (ViewGroup)this);
        this.setWillNotDraw(false);
        SurfaceView surfaceView = (SurfaceView)view.findViewById(R.id.surfaceView);
        this.nativeMapView = new NativeMapView(this);
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestFocus();
        surfaceView.getHolder().addCallback((SurfaceHolder.Callback)new SurfaceCallback());
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.gestureDetector.setIsLongpressEnabled(true);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.scaleGestureDetector, (boolean)true);
        this.rotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
        this.shoveGestureDetector = new ShoveGestureDetector(context, new ShoveGestureListener());
        this.zoomButtonsController = new ZoomButtonsController((View)this);
        this.zoomButtonsController.setZoomSpeed(300L);
        this.zoomButtonsController.setOnZoomListener((ZoomButtonsController.OnZoomListener)new OnZoomListener());
        this.onConnectivityChanged(this.isConnected());
        this.markerViewContainer = (ViewGroup)view.findViewById(R.id.markerViewContainer);
        this.myLocationView = (MyLocationView)view.findViewById(R.id.userLocationView);
        this.myLocationView.setMapboxMap(this.mapboxMap);
        this.compassView = (CompassView)view.findViewById(R.id.compassView);
        this.compassView.setMapboxMap(this.mapboxMap);
        this.logoView = (ImageView)view.findViewById(R.id.logoView);
        this.attributionsView = (ImageView)view.findViewById(R.id.attributionView);
        this.attributionsView.setOnClickListener((View.OnClickListener)new AttributionOnClickListener(this));
        this.screenDensity = context.getResources().getDisplayMetrics().density;
        this.setInitialState(options);
        if (!context.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch")) {
            this.mapboxMap.getUiSettings().setZoomControlsEnabled(true);
        }
    }

    private void setInitialState(MapboxMapOptions options) {
        String style2;
        String accessToken;
        String apiBaseUrl;
        this.mapboxMap.setDebugActive(options.getDebugActive());
        CameraPosition position = options.getCamera();
        if (position != null) {
            this.mapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition(position));
            this.myLocationView.setTilt(position.tilt);
        }
        if (!TextUtils.isEmpty((CharSequence)(apiBaseUrl = options.getApiBaseUrl()))) {
            this.setApiBaseUrl(apiBaseUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)(accessToken = options.getAccessToken()))) {
            this.mapboxMap.setAccessToken(accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)(style2 = options.getStyle()))) {
            this.initalStyle = style2;
        }
        MyLocationViewSettings myLocationViewSettings = this.mapboxMap.getMyLocationViewSettings();
        myLocationViewSettings.setForegroundDrawable(options.getMyLocationForegroundDrawable(), options.getMyLocationForegroundBearingDrawable());
        myLocationViewSettings.setForegroundTintColor(options.getMyLocationForegroundTintColor());
        myLocationViewSettings.setBackgroundDrawable(options.getMyLocationBackgroundDrawable(), options.getMyLocationBackgroundPadding());
        myLocationViewSettings.setBackgroundTintColor(options.getMyLocationBackgroundTintColor());
        myLocationViewSettings.setAccuracyAlpha(options.getMyLocationAccuracyAlpha());
        myLocationViewSettings.setAccuracyTintColor(options.getMyLocationAccuracyTintColor());
        this.mapboxMap.setMyLocationEnabled(options.getLocationEnabled());
        UiSettings uiSettings = this.mapboxMap.getUiSettings();
        uiSettings.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        uiSettings.setZoomGestureChangeAllowed(options.getZoomGesturesEnabled());
        uiSettings.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        uiSettings.setScrollGestureChangeAllowed(options.getScrollGesturesEnabled());
        uiSettings.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        uiSettings.setRotateGestureChangeAllowed(options.getRotateGesturesEnabled());
        uiSettings.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        uiSettings.setTiltGestureChangeAllowed(options.getTiltGesturesEnabled());
        uiSettings.setZoomControlsEnabled(options.getZoomControlsEnabled());
        this.mapboxMap.setMaxZoom(options.getMaxZoom());
        this.mapboxMap.setMinZoom(options.getMinZoom());
        uiSettings.setCompassEnabled(options.getCompassEnabled());
        uiSettings.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            uiSettings.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)this.getResources().getDimension(R.dimen.ten_dp);
            uiSettings.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        uiSettings.setLogoEnabled(options.getLogoEnabled());
        uiSettings.setLogoGravity(options.getLogoGravity());
        int[] logoMargins = options.getLogoMargins();
        if (logoMargins != null) {
            uiSettings.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int sixteenDp = (int)this.getResources().getDimension(R.dimen.sixteen_dp);
            uiSettings.setLogoMargins(sixteenDp, sixteenDp, sixteenDp, sixteenDp);
        }
        uiSettings.setAttributionEnabled(options.getAttributionEnabled());
        uiSettings.setAttributionGravity(options.getAttributionGravity());
        int[] attributionMargins = options.getAttributionMargins();
        if (attributionMargins != null) {
            uiSettings.setAttributionMargins(attributionMargins[0], attributionMargins[1], attributionMargins[2], attributionMargins[3]);
        } else {
            Resources resources = this.getResources();
            int sevenDp = (int)resources.getDimension(R.dimen.seven_dp);
            int seventySixDp = (int)resources.getDimension(R.dimen.seventy_six_dp);
            uiSettings.setAttributionMargins(seventySixDp, sevenDp, sevenDp, sevenDp);
        }
        int attributionTintColor = options.getAttributionTintColor();
        uiSettings.setAttributionTintColor(attributionTintColor != -1 ? attributionTintColor : ColorUtils.getPrimaryColor(this.getContext()));
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        String accessToken = this.mapboxMap.getAccessToken();
        if (TextUtils.isEmpty((CharSequence)accessToken)) {
            accessToken = MapboxAccountManager.getInstance().getAccessToken();
            this.mapboxMap.setAccessToken(accessToken);
        } else {
            MapboxAccountManager.start(this.getContext(), accessToken);
        }
        MapboxAccountManager.validateAccessToken(accessToken);
        if (savedInstanceState != null && savedInstanceState.getBoolean("savedState")) {
            CameraPosition cameraPosition = (CameraPosition)savedInstanceState.getParcelable("cameraPosition");
            if (cameraPosition != null) {
                this.mapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
            }
            UiSettings uiSettings = this.mapboxMap.getUiSettings();
            uiSettings.setZoomGesturesEnabled(savedInstanceState.getBoolean("zoomEnabled"));
            uiSettings.setZoomGestureChangeAllowed(savedInstanceState.getBoolean("zoomEnabledChange"));
            uiSettings.setScrollGesturesEnabled(savedInstanceState.getBoolean("scrollEnabled"));
            uiSettings.setScrollGestureChangeAllowed(savedInstanceState.getBoolean("scrollEnabledChange"));
            uiSettings.setRotateGesturesEnabled(savedInstanceState.getBoolean("rotateEnabled"));
            uiSettings.setRotateGestureChangeAllowed(savedInstanceState.getBoolean("rotateEnabledChange"));
            uiSettings.setTiltGesturesEnabled(savedInstanceState.getBoolean("tiltEnabled"));
            uiSettings.setTiltGestureChangeAllowed(savedInstanceState.getBoolean("tiltEnabledChange"));
            uiSettings.setZoomControlsEnabled(savedInstanceState.getBoolean("zoomControlsEnabled"));
            uiSettings.setCompassEnabled(savedInstanceState.getBoolean("compassEnabled"));
            uiSettings.setCompassGravity(savedInstanceState.getInt("compassGravity"));
            uiSettings.setCompassMargins(savedInstanceState.getInt("compassMarginLeft"), savedInstanceState.getInt("compassMarginTop"), savedInstanceState.getInt("compassMarginRight"), savedInstanceState.getInt("compassMarginBottom"));
            uiSettings.setLogoEnabled(savedInstanceState.getBoolean("logoEnabled"));
            uiSettings.setLogoGravity(savedInstanceState.getInt("logoGravity"));
            uiSettings.setLogoMargins(savedInstanceState.getInt("logoMarginLeft"), savedInstanceState.getInt("logoMarginTop"), savedInstanceState.getInt("logoMarginRight"), savedInstanceState.getInt("logoMarginBottom"));
            uiSettings.setAttributionEnabled(savedInstanceState.getBoolean("atrrEnabled"));
            uiSettings.setAttributionGravity(savedInstanceState.getInt("attrGravity"));
            uiSettings.setAttributionMargins(savedInstanceState.getInt("attrMarginLeft"), savedInstanceState.getInt("attrMarginTop"), savedInstanceState.getInt("attrMarginRight"), savedInstanceState.getInt("atrrMarginBottom"));
            this.mapboxMap.setDebugActive(savedInstanceState.getBoolean("debugActive"));
            this.mapboxMap.setStyleUrl(savedInstanceState.getString("styleUrl"));
            try {
                this.mapboxMap.setMyLocationEnabled(savedInstanceState.getBoolean("myLocationEnabled"));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            TrackingSettings trackingSettings = this.mapboxMap.getTrackingSettings();
            trackingSettings.setMyLocationTrackingMode(savedInstanceState.getInt("myLocationTracking", 0));
            trackingSettings.setMyBearingTrackingMode(savedInstanceState.getInt("myBearingTracking", 0));
        } else if (savedInstanceState == null) {
            Log.i((String)MapView.class.getCanonicalName(), (String)"MapView start Telemetry...");
            MapboxEventManager eventManager = MapboxEventManager.getMapboxEventManager();
            eventManager.initialize(this.getContext(), this.getAccessToken());
        }
        this.nativeMapView.initializeDisplay();
        this.nativeMapView.initializeContext();
        this.addOnMapChangedListener(new OnMapChangedListener(){

            @Override
            public void onMapChanged(int change) {
                if (change == 14 && MapView.this.initialLoad) {
                    MapView.this.initialLoad = false;
                    MapView.this.reloadIcons();
                    MapView.this.reloadMarkers();
                    MapView.this.adjustTopOffsetPixels();
                    if (MapView.this.onMapReadyCallbackList.size() > 0) {
                        Iterator iterator = MapView.this.onMapReadyCallbackList.iterator();
                        while (iterator.hasNext()) {
                            OnMapReadyCallback callback = (OnMapReadyCallback)iterator.next();
                            callback.onMapReady(MapView.this.mapboxMap);
                            iterator.remove();
                        }
                        MapView.this.mapboxMap.getMarkerViewManager().scheduleViewMarkerInvalidation();
                    }
                } else if (change == 2 || change == 3 || change == 6) {
                    MapView.this.mapboxMap.getMarkerViewManager().scheduleViewMarkerInvalidation();
                    MapView.this.compassView.update(MapView.this.getDirection());
                    MapView.this.myLocationView.update();
                    MapView.this.mapboxMap.getMarkerViewManager().update();
                    for (InfoWindow infoWindow : MapView.this.mapboxMap.getInfoWindows()) {
                        infoWindow.update();
                    }
                }
            }
        });
        if (savedInstanceState == null) {
            Hashtable<String, Object> evt = new Hashtable<String, Object>();
            evt.put("event", "map.load");
            evt.put("created", MapboxEventManager.generateCreateDate());
            MapboxEventManager.getMapboxEventManager().pushEvent(evt);
        }
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putBoolean("savedState", true);
        outState.putParcelable("cameraPosition", (Parcelable)this.mapboxMap.getCameraPosition());
        outState.putBoolean("debugActive", this.mapboxMap.isDebugActive());
        outState.putString("styleUrl", this.styleUrl);
        outState.putBoolean("myLocationEnabled", this.mapboxMap.isMyLocationEnabled());
        TrackingSettings trackingSettings = this.mapboxMap.getTrackingSettings();
        outState.putInt("myLocationTracking", trackingSettings.getMyLocationTrackingMode());
        outState.putInt("myBearingTracking", trackingSettings.getMyBearingTrackingMode());
        UiSettings uiSettings = this.mapboxMap.getUiSettings();
        outState.putBoolean("zoomEnabled", uiSettings.isZoomGesturesEnabled());
        outState.putBoolean("zoomEnabledChange", uiSettings.isZoomGestureChangeAllowed());
        outState.putBoolean("scrollEnabled", uiSettings.isScrollGesturesEnabled());
        outState.putBoolean("scrollEnabledChange", uiSettings.isScrollGestureChangeAllowed());
        outState.putBoolean("rotateEnabled", uiSettings.isRotateGesturesEnabled());
        outState.putBoolean("rotateEnabledChange", uiSettings.isRotateGestureChangeAllowed());
        outState.putBoolean("tiltEnabled", uiSettings.isTiltGesturesEnabled());
        outState.putBoolean("tiltEnabledChange", uiSettings.isTiltGestureChangeAllowed());
        outState.putBoolean("zoomControlsEnabled", uiSettings.isZoomControlsEnabled());
        outState.putBoolean("compassEnabled", uiSettings.isCompassEnabled());
        outState.putInt("compassGravity", uiSettings.getCompassGravity());
        outState.putInt("compassMarginLeft", uiSettings.getCompassMarginLeft());
        outState.putInt("compassMarginTop", uiSettings.getCompassMarginTop());
        outState.putInt("compassMarginBottom", uiSettings.getCompassMarginBottom());
        outState.putInt("compassMarginRight", uiSettings.getCompassMarginRight());
        outState.putInt("logoGravity", uiSettings.getLogoGravity());
        outState.putInt("logoMarginLeft", uiSettings.getLogoMarginLeft());
        outState.putInt("logoMarginTop", uiSettings.getLogoMarginTop());
        outState.putInt("logoMarginRight", uiSettings.getLogoMarginRight());
        outState.putInt("logoMarginBottom", uiSettings.getLogoMarginBottom());
        outState.putBoolean("logoEnabled", uiSettings.isLogoEnabled());
        outState.putInt("attrGravity", uiSettings.getAttributionGravity());
        outState.putInt("attrMarginLeft", uiSettings.getAttributionMarginLeft());
        outState.putInt("attrMarginTop", uiSettings.getAttributionMarginTop());
        outState.putInt("attrMarginRight", uiSettings.getAttributionMarginRight());
        outState.putInt("atrrMarginBottom", uiSettings.getAttributionMarginBottom());
        outState.putBoolean("atrrEnabled", uiSettings.isAttributionEnabled());
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.nativeMapView.terminateContext();
        this.nativeMapView.terminateDisplay();
        this.nativeMapView.destroySurface();
        this.nativeMapView.destroy();
        this.nativeMapView = null;
    }

    @UiThread
    public void onPause() {
        if (this.connectivityReceiver != null) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.connectivityReceiver);
            this.connectivityReceiver = null;
        }
        this.myLocationView.onPause();
    }

    @UiThread
    public void onResume() {
        this.connectivityReceiver = new ConnectivityReceiver();
        this.getContext().registerReceiver((BroadcastReceiver)this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        this.nativeMapView.update();
        this.myLocationView.onResume();
        if (this.styleUrl == null) {
            this.setStyleUrl(this.initalStyle == null ? "mapbox://styles/mapbox/streets-v9" : this.initalStyle);
        }
    }

    void setFocalPoint(PointF focalPoint) {
        UiSettings uiSettings;
        if (focalPoint == null && (uiSettings = this.mapboxMap.getUiSettings()).getFocalPoint() != null) {
            focalPoint = uiSettings.getFocalPoint();
        }
        this.focalPoint = focalPoint;
    }

    @UiThread
    public void onLowMemory() {
        this.nativeMapView.onLowMemory();
    }

    protected void onFpsChanged(final double fps) {
        this.post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.OnFpsChangedListener listener = MapView.this.mapboxMap.getOnFpsChangedListener();
                if (listener != null) {
                    listener.onFpsChanged(fps);
                }
            }
        });
    }

    LatLng getLatLng() {
        return this.nativeMapView.getLatLng();
    }

    double getTilt() {
        return this.nativeMapView.getPitch();
    }

    void setTilt(Double pitch) {
        this.myLocationView.setTilt(pitch);
        this.nativeMapView.setPitch(pitch, 0L);
    }

    double getDirection() {
        double direction;
        if (this.destroyed) {
            return 0.0;
        }
        for (direction = -this.nativeMapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    void setDirection(@FloatRange(from=0.0, to=360.0) double direction) {
        if (this.destroyed) {
            return;
        }
        this.setDirection(direction, false);
    }

    void setDirection(@FloatRange(from=0.0, to=360.0) double direction, boolean animated) {
        if (this.destroyed) {
            return;
        }
        long duration = animated ? 300L : 0L;
        this.nativeMapView.cancelTransitions();
        this.nativeMapView.setBearing(-direction, duration);
    }

    void resetNorth() {
        if (this.destroyed) {
            return;
        }
        this.myLocationView.setBearing(0.0);
        this.nativeMapView.cancelTransitions();
        this.nativeMapView.resetNorth();
    }

    int getContentPaddingLeft() {
        return this.contentPaddingLeft;
    }

    int getContentPaddingTop() {
        return this.contentPaddingTop;
    }

    int getContentPaddingRight() {
        return this.contentPaddingRight;
    }

    int getContentPaddingBottom() {
        return this.contentPaddingBottom;
    }

    int getContentWidth() {
        return this.getWidth() - this.contentPaddingLeft - this.contentPaddingRight;
    }

    int getContentHeight() {
        return this.getHeight() - this.contentPaddingBottom - this.contentPaddingTop;
    }

    double getZoom() {
        if (this.destroyed) {
            return 0.0;
        }
        return this.nativeMapView.getZoom();
    }

    void setMinZoom(@FloatRange(from=0.0, to=21.0) double minZoom) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.setMinZoom(minZoom);
    }

    double getMinZoom() {
        if (this.destroyed) {
            return 0.0;
        }
        return this.nativeMapView.getMinZoom();
    }

    void setMaxZoom(@FloatRange(from=0.0, to=21.0) double maxZoom) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.setMaxZoom(maxZoom);
    }

    double getMaxZoom() {
        if (this.destroyed) {
            return 0.0;
        }
        return this.nativeMapView.getMaxZoom();
    }

    private void zoom(boolean zoomIn) {
        this.zoom(zoomIn, -1.0f, -1.0f);
    }

    private void zoom(boolean zoomIn, float x, float y) {
        this.nativeMapView.cancelTransitions();
        if (zoomIn) {
            this.nativeMapView.scaleBy(2.0, x / this.screenDensity, y / this.screenDensity, 300L);
        } else {
            this.nativeMapView.scaleBy(0.5, x / this.screenDensity, y / this.screenDensity, 300L);
        }
        this.postDelayed(new ZoomInvalidator(this.mapboxMap), 300L);
    }

    boolean isDebugActive() {
        if (this.destroyed) {
            return false;
        }
        return this.nativeMapView.getDebug();
    }

    void setDebugActive(boolean debugActive) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.setDebug(debugActive);
    }

    void cycleDebugOptions() {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.cycleDebugOptions();
    }

    public void setStyleUrl(@NonNull String url) {
        if (this.destroyed) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.nativeMapView.getAccessToken())) {
            this.setAccessToken(MapboxAccountManager.getInstance().getAccessToken());
        }
        this.styleUrl = url;
        this.nativeMapView.setStyleUrl(url);
    }

    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    @NonNull
    public String getStyleUrl() {
        return this.styleUrl;
    }

    @UiThread
    void setApiBaseUrl(@NonNull String baseUrl) {
        this.nativeMapView.setApiBaseUrl(baseUrl);
    }

    @Deprecated
    @UiThread
    public void setAccessToken(@NonNull String accessToken) {
        if (this.destroyed) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            accessToken = accessToken.trim();
        }
        MapboxAccountManager.validateAccessToken(accessToken);
        this.nativeMapView.setAccessToken(accessToken);
    }

    @Deprecated
    @UiThread
    @Nullable
    public String getAccessToken() {
        if (this.destroyed) {
            return "";
        }
        return this.nativeMapView.getAccessToken();
    }

    LatLng fromScreenLocation(@NonNull PointF point) {
        if (this.destroyed) {
            return new LatLng();
        }
        point.set(point.x / this.screenDensity, point.y / this.screenDensity);
        return this.nativeMapView.latLngForPixel(point);
    }

    PointF toScreenLocation(@NonNull LatLng location) {
        if (this.destroyed || location == null) {
            return new PointF();
        }
        PointF pointF = this.nativeMapView.pixelForLatLng(location);
        pointF.set(pointF.x * this.screenDensity, pointF.y * this.screenDensity);
        return pointF;
    }

    Icon loadIconForMarker(Marker marker) {
        Bitmap bitmap;
        Icon icon = marker.getIcon();
        int iconSize = this.icons.size() + 1;
        if (icon == null) {
            icon = IconFactory.getInstance(this.getContext()).defaultMarker();
            bitmap = icon.getBitmap();
            this.averageIconHeight += (bitmap.getHeight() / 2 - this.averageIconHeight) / iconSize;
            this.averageIconWidth = this.averageIconHeight + (bitmap.getWidth() - this.averageIconHeight) / iconSize;
            marker.setIcon(icon);
        } else {
            bitmap = icon.getBitmap();
            this.averageIconHeight += (bitmap.getHeight() - this.averageIconHeight) / iconSize;
            this.averageIconWidth = this.averageIconHeight + (bitmap.getWidth() - this.averageIconHeight) / iconSize;
        }
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        return icon;
    }

    void loadIcon(Icon icon) {
        if (this.destroyed) {
            return;
        }
        Bitmap bitmap = icon.getBitmap();
        String id2 = icon.getId();
        if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
            bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        }
        ByteBuffer buffer = ByteBuffer.allocate(bitmap.getRowBytes() * bitmap.getHeight());
        bitmap.copyPixelsToBuffer((Buffer)buffer);
        float density = bitmap.getDensity();
        if (density == 0.0f) {
            density = 160.0f;
        }
        float scale = density / 160.0f;
        this.nativeMapView.addAnnotationIcon(id2, bitmap.getWidth(), bitmap.getHeight(), scale, buffer.array());
    }

    void reloadIcons() {
        int count = this.icons.size();
        for (int i = 0; i < count; ++i) {
            Icon icon = this.icons.get(i);
            this.loadIcon(icon);
        }
    }

    void updateMarker(@NonNull Marker updatedMarker) {
        if (this.destroyed) {
            return;
        }
        if (updatedMarker == null) {
            Log.w((String)"MapboxMap", (String)"marker was null, doing nothing");
            return;
        }
        if (updatedMarker.getId() == -1L) {
            Log.w((String)"MapboxMap", (String)"marker has an id of -1, possibly was not added yet, doing nothing");
            return;
        }
        if (!(updatedMarker instanceof MarkerView)) {
            this.ensureIconLoaded(updatedMarker);
        }
        this.nativeMapView.updateMarker(updatedMarker);
    }

    void updatePolygon(Polygon polygon) {
        if (this.destroyed) {
            return;
        }
        if (polygon == null) {
            Log.w((String)"MapboxMap", (String)"polygon was null, doing nothing");
            return;
        }
        if (polygon.getId() == -1L) {
            Log.w((String)"MapboxMap", (String)"polygon has an id of -1, indicating the polygon was not added to the map yet.");
            return;
        }
        this.nativeMapView.updatePolygon(polygon);
    }

    void updatePolyline(Polyline polyline) {
        if (this.destroyed) {
            return;
        }
        if (polyline == null) {
            Log.w((String)"MapboxMap", (String)"polygon was null, doing nothing");
            return;
        }
        if (polyline.getId() == -1L) {
            Log.w((String)"MapboxMap", (String)"polygon has an id of -1, indicating the polygon was not added to the map yet.");
            return;
        }
        this.nativeMapView.updatePolyline(polyline);
    }

    private void ensureIconLoaded(Marker marker) {
        Marker previousMarker;
        Icon icon = marker.getIcon();
        if (icon == null) {
            icon = IconFactory.getInstance(this.getContext()).defaultMarker();
            marker.setIcon(icon);
        }
        if (!this.icons.contains(icon)) {
            this.icons.add(icon);
            this.loadIcon(icon);
        } else {
            Icon oldIcon = this.icons.get(this.icons.indexOf(icon));
            if (!oldIcon.getBitmap().sameAs(icon.getBitmap())) {
                throw new IconBitmapChangedException();
            }
        }
        Marker marker2 = previousMarker = marker.getId() != -1L ? (Marker)this.mapboxMap.getAnnotation(marker.getId()) : null;
        if (previousMarker == null || previousMarker.getIcon() == null || previousMarker.getIcon() != marker.getIcon()) {
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(icon));
        }
    }

    long addMarker(@NonNull Marker marker) {
        if (this.destroyed) {
            return 0L;
        }
        return this.nativeMapView.addMarker(marker);
    }

    long[] addMarkers(@NonNull List<Marker> markerList) {
        if (this.destroyed) {
            return new long[0];
        }
        return this.nativeMapView.addMarkers(markerList);
    }

    long addPolyline(@NonNull Polyline polyline) {
        if (this.destroyed) {
            return 0L;
        }
        return this.nativeMapView.addPolyline(polyline);
    }

    long[] addPolylines(@NonNull List<Polyline> polylines) {
        if (this.destroyed) {
            return new long[0];
        }
        return this.nativeMapView.addPolylines(polylines);
    }

    long addPolygon(@NonNull Polygon polygon) {
        if (this.destroyed) {
            return 0L;
        }
        return this.nativeMapView.addPolygon(polygon);
    }

    long[] addPolygons(@NonNull List<Polygon> polygons) {
        if (this.destroyed) {
            return new long[0];
        }
        return this.nativeMapView.addPolygons(polygons);
    }

    void removeAnnotation(long id2) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.removeAnnotation(id2);
    }

    void removeAnnotations(@NonNull long[] ids) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.removeAnnotations(ids);
    }

    List<Marker> getMarkersInRect(@NonNull RectF rect) {
        if (this.destroyed || rect == null) {
            return new ArrayList<Marker>();
        }
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idsList.add(ids[i]);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.mapboxMap.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    public List<MarkerView> getMarkerViewsInRect(@NonNull RectF rect) {
        if (this.destroyed || rect == null) {
            return new ArrayList<MarkerView>();
        }
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idsList.add(ids[i]);
        }
        ArrayList<MarkerView> annotations = new ArrayList<MarkerView>(ids.length);
        List<Annotation> annotationList = this.mapboxMap.getAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof MarkerView)) continue;
            annotations.add((MarkerView)annotation);
        }
        return new ArrayList<MarkerView>(annotations);
    }

    public ViewGroup getMarkerViewContainer() {
        return this.markerViewContainer;
    }

    int getTopOffsetPixelsForIcon(Icon icon) {
        if (this.destroyed) {
            return 0;
        }
        return (int)(this.nativeMapView.getTopOffsetPixelsForAnnotationSymbol(icon.getId()) * (double)this.screenDensity);
    }

    void setContentPadding(int left, int top, int right, int bottom) {
        if (this.destroyed) {
            return;
        }
        this.contentPaddingLeft = left;
        this.contentPaddingTop = top;
        this.contentPaddingRight = right;
        this.contentPaddingBottom = bottom;
        int[] userLocationViewPadding = this.mapboxMap.getMyLocationViewSettings().getPadding();
        this.nativeMapView.setContentPadding((float)(top += userLocationViewPadding[1]) / this.screenDensity, (float)(left += userLocationViewPadding[0]) / this.screenDensity, (float)(bottom += userLocationViewPadding[3]) / this.screenDensity, (float)(right += userLocationViewPadding[2]) / this.screenDensity);
    }

    public void invalidateContentPadding() {
        this.setContentPadding(this.contentPaddingLeft, this.contentPaddingTop, this.contentPaddingRight, this.contentPaddingBottom);
    }

    double getMetersPerPixelAtLatitude(@FloatRange(from=-180.0, to=180.0) double latitude) {
        if (this.destroyed) {
            return 0.0;
        }
        return this.nativeMapView.getMetersPerPixelAtLatitude(latitude, this.getZoom()) / (double)this.screenDensity;
    }

    void jumpTo(double bearing, LatLng center, double pitch, double zoom) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.cancelTransitions();
        this.nativeMapView.jumpTo(bearing, center, pitch, zoom);
    }

    void easeTo(double bearing, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator, final @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.cancelTransitions();
        if (cancelableCallback != null) {
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        cancelableCallback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.nativeMapView.easeTo(bearing, center, duration, pitch, zoom, easingInterpolator);
    }

    void flyTo(double bearing, LatLng center, long duration, double pitch, double zoom, final @Nullable MapboxMap.CancelableCallback cancelableCallback) {
        if (this.destroyed) {
            return;
        }
        this.nativeMapView.cancelTransitions();
        if (cancelableCallback != null) {
            this.addOnMapChangedListener(new OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 4) {
                        cancelableCallback.onFinish();
                        MapView.this.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.nativeMapView.flyTo(bearing, center, duration, pitch, zoom);
    }

    private void adjustTopOffsetPixels() {
        List<Annotation> annotations = this.mapboxMap.getAnnotations();
        int count = annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.mapboxMap.getSelectedMarkers()) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(this.mapboxMap, this);
        }
    }

    private void reloadMarkers() {
        if (this.destroyed) {
            return;
        }
        List<Annotation> annotations = this.mapboxMap.getAnnotations();
        int count = annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotations.get(i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            long newId = this.nativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    protected void onInvalidate() {
        this.postInvalidate();
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            return;
        }
        if (this.destroyed) {
            return;
        }
        if (!this.hasSurface) {
            return;
        }
        this.nativeMapView.render();
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (this.destroyed) {
            return;
        }
        if (!this.isInEditMode()) {
            this.nativeMapView.resizeView((int)((float)width / this.screenDensity), (int)((float)height / this.screenDensity));
        }
    }

    double getScale() {
        if (this.destroyed) {
            return 0.0;
        }
        return this.nativeMapView.getScale();
    }

    CameraPosition invalidateCameraPosition() {
        if (this.destroyed) {
            return new CameraPosition.Builder().build();
        }
        CameraPosition position = new CameraPosition.Builder(this.nativeMapView.getCameraValues()).build();
        this.myLocationView.setCameraPosition(position);
        return position;
    }

    double getBearing() {
        double direction;
        if (this.destroyed) {
            return 0.0;
        }
        for (direction = -this.nativeMapView.getBearing(); direction > 360.0; direction -= 360.0) {
        }
        while (direction < 0.0) {
            direction += 360.0;
        }
        return direction;
    }

    void setBearing(float bearing) {
        if (this.destroyed) {
            return;
        }
        this.myLocationView.setBearing(bearing);
        this.nativeMapView.setBearing(bearing);
    }

    void setBearing(float bearing, long duration) {
        if (this.destroyed) {
            return;
        }
        this.myLocationView.setBearing(bearing);
        this.nativeMapView.setBearing(bearing, duration);
    }

    void setBearing(double bearing, float focalX, float focalY) {
        if (this.destroyed) {
            return;
        }
        this.myLocationView.setBearing(bearing);
        this.nativeMapView.setBearing(bearing, focalX, focalY);
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mapboxMap.getUiSettings().isZoomControlsEnabled()) {
            this.zoomButtonsController.setVisible(false);
        }
        if (this.myLocationListener != null) {
            LocationServices services = LocationServices.getLocationServices(this.getContext());
            services.removeLocationListener(this.myLocationListener);
            this.myLocationListener = null;
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.isInEditMode()) {
            return;
        }
        if (visibility == 0) {
            if (this.mapboxMap != null && this.mapboxMap.getUiSettings().isZoomControlsEnabled()) {
                this.zoomButtonsController.setVisible(true);
            }
        } else if (this.mapboxMap != null && this.mapboxMap.getUiSettings().isZoomControlsEnabled()) {
            this.zoomButtonsController.setVisible(false);
        }
    }

    private void trackGestureEvent(@NonNull String gestureId, @NonNull float xCoordinate, @NonNull float yCoordinate) {
        LatLng tapLatLng = this.fromScreenLocation(new PointF(xCoordinate, yCoordinate));
        if (Double.isNaN(tapLatLng.getLatitude()) || Double.isNaN(tapLatLng.getLongitude())) {
            Log.d((String)MapView.class.getSimpleName(), (String)"trackGestureEvent() has a NaN lat or lon.  Returning.");
            return;
        }
        if (Double.isInfinite(tapLatLng.getLatitude()) || Double.isInfinite(tapLatLng.getLongitude())) {
            Log.d((String)MapView.class.getSimpleName(), (String)"trackGestureEvent() has an Infinite lat or lon.  Returning.");
            return;
        }
        Hashtable<String, Object> evt = new Hashtable<String, Object>();
        evt.put("event", "map.click");
        evt.put("created", MapboxEventManager.generateCreateDate());
        evt.put("gesture", gestureId);
        evt.put("lat", tapLatLng.getLatitude());
        evt.put("lng", tapLatLng.getLongitude());
        evt.put("zoom", this.mapboxMap.getCameraPosition().zoom);
        MapboxEventManager.getMapboxEventManager().pushEvent(evt);
    }

    private void trackGestureDragEndEvent(@NonNull float xCoordinate, @NonNull float yCoordinate) {
        LatLng tapLatLng = this.fromScreenLocation(new PointF(xCoordinate, yCoordinate));
        if (Double.isNaN(tapLatLng.getLatitude()) || Double.isNaN(tapLatLng.getLongitude())) {
            Log.d((String)MapView.class.getSimpleName(), (String)"trackGestureDragEndEvent() has a NaN lat or lon.  Returning.");
            return;
        }
        if (Double.isInfinite(tapLatLng.getLatitude()) || Double.isInfinite(tapLatLng.getLongitude())) {
            Log.d((String)MapView.class.getSimpleName(), (String)"trackGestureDragEndEvent() has an Infinite lat or lon.  Returning.");
            return;
        }
        Hashtable<String, Object> evt = new Hashtable<String, Object>();
        evt.put("event", "map.dragend");
        evt.put("created", MapboxEventManager.generateCreateDate());
        evt.put("lat", tapLatLng.getLatitude());
        evt.put("lng", tapLatLng.getLongitude());
        evt.put("zoom", this.mapboxMap.getCameraPosition().zoom);
        MapboxEventManager.getMapboxEventManager().pushEvent(evt);
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.destroyed) {
            return super.onTouchEvent(event);
        }
        if (event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.rotateGestureDetector.onTouchEvent(event);
        this.scaleGestureDetector.onTouchEvent(event);
        this.shoveGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.nativeMapView.setGestureInProgress(true);
                break;
            }
            case 5: {
                boolean bl = this.twoTap = event.getPointerCount() == 2 && this.mapboxMap.getUiSettings().isZoomGesturesEnabled();
                if (!this.twoTap) break;
                this.trackGestureEvent("TwoFingerTap", event.getX(), event.getY());
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                boolean inProgress;
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean bl = inProgress = this.rotateGestureDetector.isInProgress() || this.scaleGestureDetector.isInProgress() || this.shoveGestureDetector.isInProgress();
                if (this.twoTap && isTap && !inProgress) {
                    if (this.focalPoint != null) {
                        this.zoom(false, this.focalPoint.x / this.screenDensity, this.focalPoint.y / this.screenDensity);
                    } else {
                        PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                        this.zoom(false, focalPoint.x, focalPoint.y);
                    }
                    this.twoTap = false;
                    return true;
                }
                if (this.scrollInProgress) {
                    this.trackGestureDragEndEvent(event.getX(), event.getY());
                    this.scrollInProgress = false;
                }
                this.twoTap = false;
                this.nativeMapView.setGestureInProgress(false);
                break;
            }
            case 3: {
                this.twoTap = false;
                this.nativeMapView.setGestureInProgress(false);
            }
        }
        boolean retVal = this.gestureDetector.onTouchEvent(event);
        return retVal || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (this.destroyed) {
            return super.onKeyDown(keyCode, event);
        }
        double scrollDist = event.getRepeatCount() >= 5 ? 50.0 : 10.0;
        switch (keyCode) {
            case 23: 
            case 66: {
                event.startTracking();
                return true;
            }
            case 21: {
                if (!this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.nativeMapView.cancelTransitions();
                this.nativeMapView.moveBy(scrollDist / (double)this.screenDensity, 0.0 / (double)this.screenDensity);
                return true;
            }
            case 22: {
                if (!this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.nativeMapView.cancelTransitions();
                this.nativeMapView.moveBy(-scrollDist / (double)this.screenDensity, 0.0 / (double)this.screenDensity);
                return true;
            }
            case 19: {
                if (!this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.nativeMapView.cancelTransitions();
                this.nativeMapView.moveBy(0.0 / (double)this.screenDensity, scrollDist / (double)this.screenDensity);
                return true;
            }
            case 20: {
                if (!this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.nativeMapView.cancelTransitions();
                this.nativeMapView.moveBy(0.0 / (double)this.screenDensity, -scrollDist / (double)this.screenDensity);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                this.zoom(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.isCanceled()) {
            return super.onKeyUp(keyCode, event);
        }
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                this.zoom(true);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.destroyed) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 2: {
                if (!this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                    return false;
                }
                this.nativeMapView.cancelTransitions();
                this.nativeMapView.moveBy(-10.0 * (double)event.getX() / (double)this.screenDensity, -10.0 * (double)event.getY() / (double)this.screenDensity);
                return true;
            }
            case 0: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                this.currentTrackballLongPressTimeOut = new TrackballLongPressTimeOut();
                this.postDelayed(this.currentTrackballLongPressTimeOut, ViewConfiguration.getLongPressTimeout());
                return true;
            }
            case 1: {
                if (!this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                    return false;
                }
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.zoom(true);
                }
                return true;
            }
            case 3: {
                if (this.currentTrackballLongPressTimeOut != null) {
                    this.currentTrackballLongPressTimeOut.cancel();
                    this.currentTrackballLongPressTimeOut = null;
                }
                return true;
            }
        }
        return super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (this.destroyed) {
            return false;
        }
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.nativeMapView.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.nativeMapView.scaleBy(Math.pow(2.0, scrollDist), event.getX() / this.screenDensity, event.getY() / this.screenDensity);
                    return true;
                }
            }
            return super.onGenericMotionEvent(event);
        }
        return super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(@NonNull MotionEvent event) {
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                if (this.mapboxMap.getUiSettings().isZoomControlsEnabled()) {
                    this.zoomButtonsController.setVisible(true);
                }
                return true;
            }
            case 10: {
                if (!this.mapboxMap.getUiSettings().isZoomControlsEnabled()) break;
                this.zoomButtonsController.setVisible(false);
            }
        }
        return super.onHoverEvent(event);
    }

    private boolean isConnected() {
        Context appContext = this.getContext().getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)appContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    private void onConnectivityChanged(boolean isConnected) {
        this.nativeMapView.setReachability(isConnected);
    }

    public void addOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.onMapChangedListener.add(listener);
        }
    }

    public void removeOnMapChangedListener(@Nullable OnMapChangedListener listener) {
        if (listener != null) {
            this.onMapChangedListener.remove(listener);
        }
    }

    protected void onMapChanged(int mapChange) {
        if (this.onMapChangedListener != null) {
            for (OnMapChangedListener listener : this.onMapChangedListener) {
                listener.onMapChanged(mapChange);
            }
        }
    }

    void setMyLocationEnabled(boolean enabled) {
        this.myLocationView.setEnabled(enabled);
    }

    Location getMyLocation() {
        return this.myLocationView.getLocation();
    }

    void setOnMyLocationChangeListener(final @Nullable MapboxMap.OnMyLocationChangeListener listener) {
        if (listener != null) {
            this.myLocationListener = new LocationListener(){

                @Override
                public void onLocationChanged(Location location) {
                    if (listener != null) {
                        listener.onMyLocationChange(location);
                    }
                }
            };
            LocationServices.getLocationServices(this.getContext()).addLocationListener(this.myLocationListener);
        } else {
            LocationServices.getLocationServices(this.getContext()).removeLocationListener(this.myLocationListener);
            this.myLocationListener = null;
        }
    }

    void setMyLocationTrackingMode(int myLocationTrackingMode) {
        if (myLocationTrackingMode != 0 && !this.mapboxMap.isMyLocationEnabled()) {
            this.mapboxMap.setMyLocationEnabled(true);
        }
        this.myLocationView.setMyLocationTrackingMode(myLocationTrackingMode);
        if (myLocationTrackingMode == 4) {
            this.setFocalPoint(new PointF(this.myLocationView.getCenterX(), this.myLocationView.getCenterY()));
        } else {
            this.setFocalPoint(null);
        }
        MapboxMap.OnMyLocationTrackingModeChangeListener listener = this.mapboxMap.getOnMyLocationTrackingModeChangeListener();
        if (listener != null) {
            listener.onMyLocationTrackingModeChange(myLocationTrackingMode);
        }
    }

    void setMyBearingTrackingMode(int myBearingTrackingMode) {
        if (myBearingTrackingMode != 0 && !this.mapboxMap.isMyLocationEnabled()) {
            this.mapboxMap.setMyLocationEnabled(true);
        }
        this.myLocationView.setMyBearingTrackingMode(myBearingTrackingMode);
        MapboxMap.OnMyBearingTrackingModeChangeListener listener = this.mapboxMap.getOnMyBearingTrackingModeChangeListener();
        if (listener != null) {
            listener.onMyBearingTrackingModeChange(myBearingTrackingMode);
        }
    }

    boolean isPermissionsAccepted() {
        return ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    private void resetTrackingModesIfRequired() {
        TrackingSettings trackingSettings = this.mapboxMap.getTrackingSettings();
        if (trackingSettings.isDismissLocationTrackingOnGesture()) {
            this.resetLocationTrackingMode();
        }
        if (trackingSettings.isDismissBearingTrackingOnGesture()) {
            this.resetBearingTrackingMode();
        }
    }

    private void resetLocationTrackingMode() {
        try {
            TrackingSettings trackingSettings = this.mapboxMap.getTrackingSettings();
            trackingSettings.setMyLocationTrackingMode(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void resetBearingTrackingMode() {
        try {
            this.setMyBearingTrackingMode(0);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    void setCompassEnabled(boolean compassEnabled) {
        this.compassView.setEnabled(compassEnabled);
    }

    void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.compassView, gravity);
    }

    void setCompassMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.compassView, left, top, right, bottom);
    }

    void setLogoGravity(int gravity) {
        this.setWidgetGravity((View)this.logoView, gravity);
    }

    void setLogoMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.logoView, left, top, right, bottom);
    }

    void setLogoEnabled(boolean visible) {
        this.logoView.setVisibility(visible ? 0 : 8);
    }

    void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.attributionsView, gravity);
    }

    void setAttributionMargins(int left, int top, int right, int bottom) {
        this.setWidgetMargins((View)this.attributionsView, left, top, right, bottom);
    }

    void setAttributionEnabled(int visibility) {
        this.attributionsView.setVisibility(visibility);
    }

    void setAtttibutionTintColor(int tintColor) {
        ColorUtils.setTintList(this.attributionsView, tintColor);
    }

    int getAttributionTintColor() {
        return this.mapboxMap.getUiSettings().getAttributionTintColor();
    }

    @UiThread
    public void getMapAsync(OnMapReadyCallback callback) {
        if (!this.initialLoad && callback != null) {
            callback.onMapReady(this.mapboxMap);
        } else if (callback != null) {
            this.onMapReadyCallbackList.add(callback);
        }
    }

    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    MyLocationView getUserLocationView() {
        return this.myLocationView;
    }

    NativeMapView getNativeMapView() {
        return this.nativeMapView;
    }

    @UiThread
    void snapshot(@NonNull MapboxMap.SnapshotReadyCallback callback, @Nullable Bitmap bitmap) {
        this.snapshotRequest = new SnapshotRequest(bitmap, callback);
        this.nativeMapView.scheduleTakeSnapshot();
        this.nativeMapView.render();
    }

    protected void onSnapshotReady(byte[] bytes) {
        if (this.snapshotRequest != null && bytes != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inBitmap = this.snapshotRequest.getBitmap();
            options.inMutable = true;
            options.inSampleSize = 1;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            MapboxMap.SnapshotReadyCallback callback = this.snapshotRequest.getCallback();
            if (callback != null) {
                callback.onSnapshotReady(bitmap);
            }
        }
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int left, int top, int right, int bottom) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left += this.contentPaddingLeft, top += this.contentPaddingTop, right += this.contentPaddingRight, bottom += this.contentPaddingBottom);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }

    private static class ZoomInvalidator
    implements Runnable {
        private MapboxMap mapboxMap;

        public ZoomInvalidator(MapboxMap mapboxMap) {
            this.mapboxMap = mapboxMap;
        }

        @Override
        public void run() {
            this.mapboxMap.getCameraPosition();
        }
    }

    private static class AttributionOnClickListener
    implements View.OnClickListener,
    DialogInterface.OnClickListener {
        private static final int ATTRIBUTION_INDEX_IMPROVE_THIS_MAP = 2;
        private static final int ATTRIBUTION_INDEX_TELEMETRY_SETTINGS = 3;
        private MapView mapView;

        public AttributionOnClickListener(MapView mapView) {
            this.mapView = mapView;
        }

        public void onClick(View v) {
            Context context = v.getContext();
            Object[] items = context.getResources().getStringArray(R.array.attribution_names);
            AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
            builder.setTitle(R.string.attributionsDialogTitle);
            builder.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items), (DialogInterface.OnClickListener)this);
            AlertDialog dialog = builder.show();
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(this.mapView.getAttributionTintColor()));
        }

        public void onClick(DialogInterface dialog, int which) {
            final Context context = ((Dialog)dialog).getContext();
            if (which == 3) {
                int array2 = R.array.attribution_telemetry_options;
                if (MapboxEventManager.getMapboxEventManager().isTelemetryEnabled()) {
                    array2 = R.array.attribution_telemetry_options_already_participating;
                }
                Object[] items = context.getResources().getStringArray(array2);
                AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.AttributionAlertDialogStyle);
                builder.setTitle(R.string.attributionTelemetryTitle);
                LayoutInflater factory = LayoutInflater.from((Context)context);
                View content = factory.inflate(R.layout.attribution_telemetry_view, null);
                ListView lv = (ListView)content.findViewById(R.id.telemetryOptionsList);
                lv.setAdapter((ListAdapter)new ArrayAdapter(context, R.layout.attribution_list_item, items));
                lv.setChoiceMode(1);
                builder.setView(content);
                final AlertDialog telemDialog = builder.show();
                lv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        switch (position) {
                            case 0: {
                                String url = context.getResources().getStringArray(R.array.attribution_links)[3];
                                Intent intent = new Intent("android.intent.action.VIEW");
                                intent.setData(Uri.parse((String)url));
                                context.startActivity(intent);
                                telemDialog.cancel();
                                return;
                            }
                            case 1: {
                                MapboxEventManager.getMapboxEventManager().setTelemetryEnabled(false);
                                telemDialog.cancel();
                                return;
                            }
                            case 2: {
                                MapboxEventManager.getMapboxEventManager().setTelemetryEnabled(true);
                                telemDialog.cancel();
                                return;
                            }
                        }
                    }
                });
                return;
            }
            String url = context.getResources().getStringArray(R.array.attribution_links)[which];
            if (which == 2) {
                LatLng latLng = this.mapView.getMapboxMap().getCameraPosition().target;
                url = String.format(url, latLng.getLongitude(), latLng.getLatitude(), (int)this.mapView.getZoom());
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            context.startActivity(intent);
        }
    }

    private class SnapshotRequest {
        private Bitmap bitmap;
        private MapboxMap.SnapshotReadyCallback callback;

        public SnapshotRequest(Bitmap bitmap, MapboxMap.SnapshotReadyCallback callback) {
            this.bitmap = bitmap;
            this.callback = callback;
        }

        public Bitmap getBitmap() {
            return this.bitmap;
        }

        public MapboxMap.SnapshotReadyCallback getCallback() {
            return this.callback;
        }
    }

    private class ConnectivityReceiver
    extends BroadcastReceiver {
        private ConnectivityReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean noConnectivity = intent.getBooleanExtra("noConnectivity", false);
                MapView.this.onConnectivityChanged(!noConnectivity);
            }
        }
    }

    private class TrackballLongPressTimeOut
    implements Runnable {
        private boolean cancelled = false;

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            if (!this.cancelled) {
                MapView.this.zoom(false);
                MapView.this.currentTrackballLongPressTimeOut = null;
            }
        }
    }

    private class OnZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private OnZoomListener() {
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (!MapView.this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return;
            }
            MapView.this.zoom(zoomIn);
        }
    }

    private class ShoveGestureListener
    implements ShoveGestureDetector.OnShoveGestureListener {
        long beginTime = 0L;
        float totalDelta = 0.0f;
        boolean started = false;

        private ShoveGestureListener() {
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            if (!MapView.this.mapboxMap.getUiSettings().isTiltGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.beginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Pitch", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
            this.beginTime = 0L;
            this.totalDelta = 0.0f;
            this.started = false;
            MapView.this.dragStarted = false;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isTiltGesturesEnabled()) {
                return false;
            }
            this.totalDelta += detector.getShovePixelsDelta();
            if (!MapView.this.zoomStarted && (this.totalDelta > 10.0f || this.totalDelta < -10.0f)) {
                this.started = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!this.started && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.started) {
                return false;
            }
            MapView.this.nativeMapView.cancelTransitions();
            double pitch = MapView.this.getTilt();
            pitch -= 0.1 * (double)detector.getShovePixelsDelta();
            pitch = Math.max(0.0, Math.min(60.0, pitch));
            MapView.this.mapboxMap.setTilt(pitch);
            MapView.this.dragStarted = true;
            return true;
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        long beginTime = 0L;
        float totalAngle = 0.0f;
        boolean started = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isRotateGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.beginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Rotation", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            this.beginTime = 0L;
            this.totalAngle = 0.0f;
            this.started = false;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isRotateGesturesEnabled()) {
                return false;
            }
            if (MapView.this.dragStarted) {
                return false;
            }
            this.totalAngle += detector.getRotationDegreesDelta();
            if (!MapView.this.zoomStarted && (this.totalAngle > 20.0f || this.totalAngle < -20.0f)) {
                this.started = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!this.started && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.started) {
                return false;
            }
            MapView.this.nativeMapView.cancelTransitions();
            double bearing = MapView.this.nativeMapView.getBearing();
            bearing += (double)detector.getRotationDegreesDelta();
            if (MapView.this.focalPoint != null) {
                MapView.this.setBearing(bearing, ((MapView)MapView.this).focalPoint.x / MapView.this.screenDensity, ((MapView)MapView.this).focalPoint.y / MapView.this.screenDensity);
            } else {
                MapView.this.setBearing(bearing, detector.getFocusX() / MapView.this.screenDensity, detector.getFocusY() / MapView.this.screenDensity);
            }
            return true;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        long beginTime = 0L;
        float scaleFactor = 1.0f;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            this.beginTime = detector.getEventTime();
            MapView.this.trackGestureEvent("Pinch", detector.getFocusX(), detector.getFocusY());
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.beginTime = 0L;
            this.scaleFactor = 1.0f;
            MapView.this.zoomStarted = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            UiSettings uiSettings = MapView.this.mapboxMap.getUiSettings();
            if (MapView.this.destroyed || !uiSettings.isZoomGesturesEnabled()) {
                return super.onScale(detector);
            }
            this.scaleFactor *= detector.getScaleFactor();
            if (this.scaleFactor > 1.05f || this.scaleFactor < 0.95f) {
                MapView.this.zoomStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!MapView.this.zoomStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!MapView.this.zoomStarted) {
                return false;
            }
            if (MapView.this.dragStarted) {
                return false;
            }
            MapView.this.nativeMapView.cancelTransitions();
            MapView.this.quickZoom = !MapView.this.twoTap;
            if (MapView.this.focalPoint != null) {
                MapView.this.nativeMapView.scaleBy(detector.getScaleFactor(), ((MapView)MapView.this).focalPoint.x / MapView.this.screenDensity, ((MapView)MapView.this).focalPoint.y / MapView.this.screenDensity);
            } else if (MapView.this.quickZoom) {
                MapView.this.nativeMapView.scaleBy(detector.getScaleFactor(), (float)(MapView.this.getWidth() / 2) / MapView.this.screenDensity, (float)(MapView.this.getHeight() / 2) / MapView.this.screenDensity);
            } else {
                MapView.this.nativeMapView.scaleBy(detector.getScaleFactor(), detector.getFocusX() / MapView.this.screenDensity, detector.getFocusY() / MapView.this.screenDensity);
            }
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        @SuppressLint(value={"ResourceType"})
        public boolean onDown(MotionEvent event) {
            if (MapView.this.mapboxMap.getUiSettings().isZoomControlsEnabled()) {
                MapView.this.zoomButtonsController.setVisible(true);
            }
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isZoomGesturesEnabled()) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (MapView.this.quickZoom) {
                        MapView.this.quickZoom = false;
                        break;
                    }
                    if (MapView.this.focalPoint != null) {
                        MapView.this.zoom(true, ((MapView)MapView.this).focalPoint.x, ((MapView)MapView.this).focalPoint.y);
                        break;
                    }
                    MapView.this.zoom(true, e.getX(), e.getY());
                }
            }
            MapView.this.trackGestureEvent("DoubleTap", e.getX(), e.getY());
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            if (MapView.this.destroyed) {
                return false;
            }
            MapView.this.nativeMapView.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            List<Marker> selectedMarkers = MapView.this.mapboxMap.getSelectedMarkers();
            PointF tapPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            float toleranceSides = 4.0f * MapView.this.screenDensity;
            float toleranceTopBottom = 10.0f * MapView.this.screenDensity;
            RectF tapRect = new RectF((tapPoint.x - (float)(MapView.this.averageIconWidth / 2) - toleranceSides) / MapView.this.screenDensity, (tapPoint.y - (float)(MapView.this.averageIconHeight / 2) - toleranceTopBottom) / MapView.this.screenDensity, (tapPoint.x + (float)(MapView.this.averageIconWidth / 2) + toleranceSides) / MapView.this.screenDensity, (tapPoint.y + (float)(MapView.this.averageIconHeight / 2) + toleranceTopBottom) / MapView.this.screenDensity);
            List<Marker> nearbyMarkers = MapView.this.getMarkersInRect(tapRect);
            long newSelectedMarkerId = -1L;
            if (nearbyMarkers != null && nearbyMarkers.size() > 0) {
                Collections.sort(nearbyMarkers);
                for (Marker nearbyMarker : nearbyMarkers) {
                    boolean found = false;
                    for (Marker selectedMarker : selectedMarkers) {
                        if (!selectedMarker.equals(nearbyMarker)) continue;
                        found = true;
                    }
                    if (found) continue;
                    newSelectedMarkerId = nearbyMarker.getId();
                    break;
                }
            }
            if (newSelectedMarkerId >= 0L) {
                List<Annotation> annotations = MapView.this.mapboxMap.getAnnotations();
                int count = annotations.size();
                for (int i = 0; i < count; ++i) {
                    Annotation annotation = annotations.get(i);
                    if (!(annotation instanceof Marker) || annotation.getId() != newSelectedMarkerId) continue;
                    if (!(!selectedMarkers.isEmpty() && selectedMarkers.contains(annotation) || annotation instanceof MarkerView)) {
                        MapView.this.mapboxMap.selectMarker((Marker)annotation);
                    }
                    break;
                }
            } else {
                MapboxMap.OnMapClickListener listener;
                if (MapView.this.mapboxMap.getUiSettings().isDeselectMarkersOnTap()) {
                    MapView.this.mapboxMap.deselectMarkers();
                }
                if ((listener = MapView.this.mapboxMap.getOnMapClickListener()) != null) {
                    LatLng point = MapView.this.fromScreenLocation(tapPoint);
                    listener.onMapClick(point);
                }
            }
            MapView.this.trackGestureEvent("SingleTap", motionEvent.getX(), motionEvent.getY());
            return true;
        }

        public void onLongPress(MotionEvent motionEvent) {
            MapboxMap.OnMapLongClickListener listener = MapView.this.mapboxMap.getOnMapLongClickListener();
            if (listener != null && !MapView.this.quickZoom) {
                LatLng point = MapView.this.fromScreenLocation(new PointF(motionEvent.getX(), motionEvent.getY()));
                listener.onMapLongClick(point);
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                return false;
            }
            MapView.this.resetTrackingModesIfRequired();
            float ease = 0.25f;
            double speed = Math.sqrt((velocityX *= ease) * velocityX + (velocityY *= ease) * velocityY);
            double deceleration = 2500.0;
            double duration = speed / (deceleration * (double)ease);
            MapView.this.nativeMapView.cancelTransitions();
            MapView.this.nativeMapView.moveBy((double)velocityX * duration / 2.0 / (double)MapView.this.screenDensity, (double)velocityY * duration / 2.0 / (double)MapView.this.screenDensity, (long)(duration * 1000.0));
            MapboxMap.OnFlingListener listener = MapView.this.mapboxMap.getOnFlingListener();
            if (listener != null) {
                listener.onFling();
            }
            MapView.this.trackGestureEvent("Pan", e1.getX(), e1.getY());
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapView.this.scrollInProgress) {
                MapView.this.scrollInProgress = true;
            }
            if (MapView.this.destroyed || !MapView.this.mapboxMap.getUiSettings().isScrollGesturesEnabled()) {
                return false;
            }
            if (MapView.this.dragStarted) {
                return false;
            }
            MapView.this.requestDisallowInterceptTouchEvent(true);
            MapView.this.resetTrackingModesIfRequired();
            MapView.this.nativeMapView.cancelTransitions();
            MapView.this.nativeMapView.moveBy(-distanceX / MapView.this.screenDensity, -distanceY / MapView.this.screenDensity);
            MapboxMap.OnScrollListener listener = MapView.this.mapboxMap.getOnScrollListener();
            if (listener != null) {
                listener.onScroll();
            }
            return true;
        }
    }

    private class SurfaceCallback
    implements SurfaceHolder.Callback {
        private Surface surface;

        private SurfaceCallback() {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            this.surface = holder.getSurface();
            MapView.this.nativeMapView.createSurface(this.surface);
            MapView.this.hasSurface = true;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (MapView.this.destroyed) {
                return;
            }
            MapView.this.nativeMapView.resizeFramebuffer(width, height);
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            MapView.this.hasSurface = false;
            if (MapView.this.nativeMapView != null) {
                MapView.this.nativeMapView.destroySurface();
            }
            this.surface.release();
        }
    }
}

