/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.VisibleRegion;
import com.mapbox.mapboxsdk.maps.MapView;

public class Projection {
    private MapView mapView;

    Projection(@NonNull MapView mapView) {
        this.mapView = mapView;
    }

    public double getMetersPerPixelAtLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        return this.mapView.getMetersPerPixelAtLatitude(latitude);
    }

    public LatLng fromScreenLocation(PointF point) {
        return this.mapView.fromScreenLocation(point);
    }

    public VisibleRegion getVisibleRegion() {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        float left = this.mapView.getContentPaddingLeft();
        float right = this.mapView.getWidth() - this.mapView.getContentPaddingRight();
        float top = this.mapView.getContentPaddingTop();
        float bottom = this.mapView.getHeight() - this.mapView.getContentPaddingBottom();
        LatLng topLeft = this.fromScreenLocation(new PointF(left, top));
        LatLng topRight = this.fromScreenLocation(new PointF(right, top));
        LatLng bottomRight = this.fromScreenLocation(new PointF(right, bottom));
        LatLng bottomLeft = this.fromScreenLocation(new PointF(left, bottom));
        builder.include(topLeft).include(topRight).include(bottomRight).include(bottomLeft);
        return new VisibleRegion(topLeft, topRight, bottomLeft, bottomRight, builder.build());
    }

    public PointF toScreenLocation(LatLng location) {
        return this.mapView.toScreenLocation(location);
    }

    public double calculateZoom(float minScale) {
        return Math.log(this.mapView.getScale() * (double)minScale) / Math.log(2.0);
    }
}

