/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;

public final class CompassView
extends ImageView {
    private Timer northTimer;
    private double direction = 0.0;
    private ViewPropertyAnimatorCompat fadeAnimator;

    public CompassView(Context context) {
        super(context);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setImageDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.compass));
        this.setContentDescription(this.getResources().getString(R.string.compassContentDescription));
        this.setEnabled(false);
        float screenDensity = context.getResources().getDisplayMetrics().density;
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams((int)(48.0f * screenDensity), (int)(48.0f * screenDensity));
        this.setLayoutParams(lp);
    }

    public void setMapboxMap(@NonNull MapboxMap mapboxMap) {
        this.setOnClickListener(new CompassClickListener(mapboxMap));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            if (this.direction != 0.0) {
                if (this.northTimer != null) {
                    this.northTimer.cancel();
                    this.northTimer = null;
                }
                if (this.fadeAnimator != null) {
                    this.fadeAnimator.cancel();
                }
                this.fadeAnimator = null;
                this.setAlpha(1.0f);
                this.setVisibility(0);
            }
        } else {
            if (this.northTimer != null) {
                this.northTimer.cancel();
                this.northTimer = null;
            }
            if (this.fadeAnimator != null) {
                this.fadeAnimator.cancel();
            }
            this.fadeAnimator = null;
            this.setVisibility(4);
        }
    }

    public void update(double direction) {
        this.direction = direction;
        this.setRotation((float)direction);
        if (!this.isEnabled()) {
            return;
        }
        if (direction == 0.0) {
            if (this.getVisibility() == 4) {
                return;
            }
            if (this.northTimer == null) {
                if (this.fadeAnimator != null) {
                    this.fadeAnimator.cancel();
                }
                this.fadeAnimator = null;
                this.northTimer = new Timer("CompassView North timer");
                this.northTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        CompassView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                CompassView.this.setAlpha(1.0f);
                                CompassView.this.fadeAnimator = ViewCompat.animate((View)CompassView.this).alpha(0.0f).setDuration(1000L).withLayer();
                                CompassView.this.fadeAnimator.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                                    public void onAnimationEnd(View view) {
                                        CompassView.this.setVisibility(4);
                                        CompassView.this.northTimer = null;
                                    }
                                });
                            }
                        });
                    }
                }, 1000L);
            }
        } else {
            if (this.northTimer != null) {
                this.northTimer.cancel();
                this.northTimer = null;
            }
            if (this.fadeAnimator != null) {
                this.fadeAnimator.cancel();
            }
            this.setAlpha(1.0f);
            this.setVisibility(0);
        }
    }

    static class CompassClickListener
    implements View.OnClickListener {
        private WeakReference<MapboxMap> mapboxMap;

        public CompassClickListener(MapboxMap mapboxMap) {
            this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
        }

        public void onClick(View view) {
            MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
            if (mapboxMap != null) {
                mapboxMap.resetNorth();
            }
        }
    }
}

