/*
 * Decompiled with CFR 0.152.
 */
package com.almeros.android.multitouch.gesturedetectors;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.almeros.android.multitouch.gesturedetectors.BaseGestureDetector;

public class MoveGestureDetector
extends BaseGestureDetector {
    private static final PointF FOCUS_DELTA_ZERO = new PointF();
    private final OnMoveGestureListener mListener;
    private PointF mFocusExternal = new PointF();
    private PointF mFocusDeltaExternal = new PointF();

    public MoveGestureDetector(Context context, OnMoveGestureListener listener) {
        super(context);
        this.mListener = listener;
    }

    @Override
    protected void handleStartProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 0: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(event);
                break;
            }
            case 2: {
                this.mGestureInProgress = this.mListener.onMoveBegin(this);
            }
        }
    }

    @Override
    protected void handleInProgressEvent(int actionCode, MotionEvent event) {
        switch (actionCode) {
            case 1: 
            case 3: {
                this.mListener.onMoveEnd(this);
                this.resetState();
                break;
            }
            case 2: {
                boolean updatePrevious;
                this.updateStateByEvent(event);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onMove(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)event);
            }
        }
    }

    @Override
    protected void updateStateByEvent(MotionEvent curr) {
        super.updateStateByEvent(curr);
        MotionEvent prev = this.mPrevEvent;
        PointF mCurrFocusInternal = this.determineFocalPoint(curr);
        PointF mPrevFocusInternal = this.determineFocalPoint(prev);
        boolean mSkipNextMoveEvent = prev.getPointerCount() != curr.getPointerCount();
        this.mFocusDeltaExternal = mSkipNextMoveEvent ? FOCUS_DELTA_ZERO : new PointF(mCurrFocusInternal.x - mPrevFocusInternal.x, mCurrFocusInternal.y - mPrevFocusInternal.y);
        this.mFocusExternal.x += this.mFocusDeltaExternal.x;
        this.mFocusExternal.y += this.mFocusDeltaExternal.y;
    }

    private PointF determineFocalPoint(MotionEvent e) {
        int pCount = e.getPointerCount();
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < pCount; ++i) {
            x += e.getX(i);
            y += e.getY(i);
        }
        return new PointF(x / (float)pCount, y / (float)pCount);
    }

    public float getFocusX() {
        return this.mFocusExternal.x;
    }

    public float getFocusY() {
        return this.mFocusExternal.y;
    }

    public PointF getFocusDelta() {
        return this.mFocusDeltaExternal;
    }

    public static class SimpleOnMoveGestureListener
    implements OnMoveGestureListener {
        @Override
        public boolean onMove(MoveGestureDetector detector) {
            return false;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector detector) {
        }
    }

    public static interface OnMoveGestureListener {
        public boolean onMove(MoveGestureDetector var1);

        public boolean onMoveBegin(MoveGestureDetector var1);

        public void onMoveEnd(MoveGestureDetector var1);
    }
}

