/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.location.LocationSource;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationView;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapbox.services.android.telemetry.permissions.PermissionsManager;
import timber.log.Timber;

public final class TrackingSettings {
    private final MyLocationView myLocationView;
    private final UiSettings uiSettings;
    private final FocalPointChangeListener focalPointChangedListener;
    private final CameraZoomInvalidator zoomInvalidator;
    private LocationEngineListener myLocationListener;
    private boolean myLocationEnabled;
    private boolean dismissLocationTrackingOnGesture = true;
    private boolean dismissBearingTrackingOnGesture = true;
    private boolean isResetTrackingWithCameraPositionChange = true;
    private MapboxMap.OnMyLocationTrackingModeChangeListener onMyLocationTrackingModeChangeListener;
    private MapboxMap.OnMyBearingTrackingModeChangeListener onMyBearingTrackingModeChangeListener;

    TrackingSettings(@NonNull MyLocationView myLocationView, UiSettings uiSettings, FocalPointChangeListener focalPointChangedListener, CameraZoomInvalidator zoomInvalidator) {
        this.myLocationView = myLocationView;
        this.focalPointChangedListener = focalPointChangedListener;
        this.uiSettings = uiSettings;
        this.zoomInvalidator = zoomInvalidator;
    }

    void initialise(MapboxMapOptions options) {
        this.setMyLocationEnabled(options.getLocationEnabled());
    }

    void onSaveInstanceState(Bundle outState) {
        outState.putInt("myLocationTracking", this.getMyLocationTrackingMode());
        outState.putInt("myBearingTracking", this.getMyBearingTrackingMode());
        outState.putBoolean("myLocationTrackingDismiss", this.isDismissLocationTrackingOnGesture());
        outState.putBoolean("myBearingTrackingDismiss", this.isDismissBearingTrackingOnGesture());
        outState.putBoolean("myLocationEnabled", this.isMyLocationEnabled());
        outState.putBoolean("myBearingTrackingDismiss", this.isDismissTrackingModesForCameraPositionChange());
    }

    void onRestoreInstanceState(Bundle savedInstanceState) {
        try {
            this.setMyLocationEnabled(savedInstanceState.getBoolean("myLocationEnabled"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.setMyLocationTrackingMode(savedInstanceState.getInt("myLocationTracking", 0));
        this.setMyBearingTrackingMode(savedInstanceState.getInt("myBearingTracking", 0));
        this.setDismissLocationTrackingOnGesture(savedInstanceState.getBoolean("myLocationTrackingDismiss", true));
        this.setDismissBearingTrackingOnGesture(savedInstanceState.getBoolean("myBearingTrackingDismiss", true));
        this.setDismissTrackingModeForCameraPositionChange(savedInstanceState.getBoolean("myBearingTrackingDismiss", true));
    }

    @UiThread
    public void setMyLocationTrackingMode(int myLocationTrackingMode) {
        this.myLocationView.setMyLocationTrackingMode(myLocationTrackingMode);
        if (myLocationTrackingMode == 4) {
            this.zoomInvalidator.zoomTo(2.0);
            this.focalPointChangedListener.onFocalPointChanged(this.myLocationView.getCenter());
        } else {
            this.focalPointChangedListener.onFocalPointChanged(null);
        }
        if (this.onMyLocationTrackingModeChangeListener != null) {
            this.onMyLocationTrackingModeChangeListener.onMyLocationTrackingModeChange(myLocationTrackingMode);
        }
    }

    @UiThread
    public int getMyLocationTrackingMode() {
        return this.myLocationView.getMyLocationTrackingMode();
    }

    @UiThread
    public void setMyBearingTrackingMode(int myBearingTrackingMode) {
        this.myLocationView.setMyBearingTrackingMode(myBearingTrackingMode);
        if (this.onMyBearingTrackingModeChangeListener != null) {
            this.onMyBearingTrackingModeChangeListener.onMyBearingTrackingModeChange(myBearingTrackingMode);
        }
    }

    @UiThread
    public int getMyBearingTrackingMode() {
        return this.myLocationView.getMyBearingTrackingMode();
    }

    public boolean isAllDismissTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture && this.dismissBearingTrackingOnGesture;
    }

    public void setDismissAllTrackingOnGesture(boolean dismissTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissTrackingOnGesture;
        this.dismissBearingTrackingOnGesture = dismissTrackingOnGesture;
    }

    public void setDismissLocationTrackingOnGesture(boolean dismissLocationTrackingOnGesture) {
        this.dismissLocationTrackingOnGesture = dismissLocationTrackingOnGesture;
    }

    public boolean isDismissLocationTrackingOnGesture() {
        return this.dismissLocationTrackingOnGesture;
    }

    public void setDismissBearingTrackingOnGesture(boolean dismissBearingTrackingOnGesture) {
        this.dismissBearingTrackingOnGesture = dismissBearingTrackingOnGesture;
    }

    public boolean isDismissBearingTrackingOnGesture() {
        return this.dismissBearingTrackingOnGesture;
    }

    public boolean isLocationTrackingDisabled() {
        return this.myLocationView.getMyLocationTrackingMode() == 0;
    }

    public boolean isBearingTrackingDisabled() {
        return this.myLocationView.getMyBearingTrackingMode() == 0;
    }

    public boolean isRotateGestureCurrentlyEnabled() {
        return this.uiSettings.isRotateGesturesEnabled() && (this.dismissBearingTrackingOnGesture || this.myLocationView.getMyBearingTrackingMode() == 0 || this.myLocationView.getMyLocationTrackingMode() == 0);
    }

    public boolean isScrollGestureCurrentlyEnabled() {
        return this.uiSettings.isScrollGesturesEnabled() && (this.dismissLocationTrackingOnGesture || this.myLocationView.getMyLocationTrackingMode() == 0);
    }

    void resetTrackingModesIfRequired(boolean translate, boolean rotate) {
        if (translate && !this.isLocationTrackingDisabled() && this.isDismissLocationTrackingOnGesture()) {
            this.setMyLocationTrackingMode(0);
        }
        if (rotate && !this.isBearingTrackingDisabled() && this.isDismissBearingTrackingOnGesture()) {
            this.setMyBearingTrackingMode(0);
        }
    }

    void resetTrackingModesIfRequired(CameraPosition cameraPosition) {
        if (this.isDismissTrackingModesForCameraPositionChange()) {
            this.resetTrackingModesIfRequired(cameraPosition.target != null, cameraPosition.bearing != -1.0);
        }
    }

    public boolean isDismissTrackingModesForCameraPositionChange() {
        return this.isResetTrackingWithCameraPositionChange;
    }

    public void setDismissTrackingModeForCameraPositionChange(boolean willAllowToDismiss) {
        this.isResetTrackingWithCameraPositionChange = willAllowToDismiss;
    }

    Location getMyLocation() {
        return this.myLocationView.getLocation();
    }

    void setOnMyLocationChangeListener(final @Nullable MapboxMap.OnMyLocationChangeListener listener) {
        if (listener != null) {
            this.myLocationListener = new LocationEngineListener(){

                public void onConnected() {
                }

                public void onLocationChanged(Location location) {
                    if (listener != null) {
                        listener.onMyLocationChange(location);
                    }
                }
            };
            LocationSource.getLocationEngine(this.myLocationView.getContext()).addLocationEngineListener(this.myLocationListener);
        } else {
            LocationSource.getLocationEngine(this.myLocationView.getContext()).removeLocationEngineListener(this.myLocationListener);
            this.myLocationListener = null;
        }
    }

    void setOnMyLocationTrackingModeChangeListener(MapboxMap.OnMyLocationTrackingModeChangeListener listener) {
        this.onMyLocationTrackingModeChangeListener = listener;
    }

    void setOnMyBearingTrackingModeChangeListener(MapboxMap.OnMyBearingTrackingModeChangeListener listener) {
        this.onMyBearingTrackingModeChangeListener = listener;
    }

    MyLocationView getMyLocationView() {
        return this.myLocationView;
    }

    boolean isMyLocationEnabled() {
        return this.myLocationEnabled;
    }

    void setMyLocationEnabled(boolean locationEnabled) {
        if (!PermissionsManager.areLocationPermissionsGranted((Context)this.myLocationView.getContext())) {
            Timber.e((String)"Could not activate user location tracking: user did not accept the permission or permissions were not requested.", (Object[])new Object[0]);
            return;
        }
        this.myLocationEnabled = locationEnabled;
        this.myLocationView.setEnabled(locationEnabled);
    }

    void update() {
        if (!this.myLocationView.isEnabled()) {
            return;
        }
        this.myLocationView.update();
    }

    void onStart() {
        this.myLocationView.onStart();
    }

    void onStop() {
        this.myLocationView.onStop();
    }

    static interface CameraZoomInvalidator {
        public void zoomTo(double var1);
    }
}

