/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ZoomButtonsController;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;

final class MapZoomButtonController
extends ZoomButtonsController {
    private UiSettings uiSettings;

    MapZoomButtonController(@NonNull View ownerView, @NonNull UiSettings uiSettings, @NonNull Transform transform) {
        super(ownerView);
        this.uiSettings = uiSettings;
        this.setZoomSpeed(300L);
        this.setOnZoomListener(new OnZoomListener(uiSettings, transform));
    }

    public void setVisible(boolean visible) {
        if (this.uiSettings.isZoomControlsEnabled()) {
            super.setVisible(visible);
        }
    }

    private static class OnZoomListener
    implements ZoomButtonsController.OnZoomListener {
        private final UiSettings uiSettings;
        private final Transform transform;

        OnZoomListener(UiSettings uiSettings, Transform transform) {
            this.uiSettings = uiSettings;
            this.transform = transform;
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            if (!this.uiSettings.isZoomGesturesEnabled()) {
                return;
            }
            this.transform.zoom(zoomIn);
        }
    }
}

