/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.storage;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.Mapbox;
import timber.log.Timber;

public class FileSource {
    private static FileSource INSTANCE;
    private long nativePtr;

    public static synchronized FileSource getInstance(Context context) {
        if (INSTANCE == null) {
            String cachePath = FileSource.getCachePath(context);
            String apkPath = context.getPackageCodePath();
            INSTANCE = new FileSource(cachePath, apkPath);
        }
        return INSTANCE;
    }

    public static String getCachePath(Context context) {
        boolean setStorageExternal = false;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            setStorageExternal = appInfo.metaData.getBoolean("com.mapbox.SetStorageExternal", false);
        }
        catch (PackageManager.NameNotFoundException exception) {
            Timber.e((String)"Failed to read the package metadata: ", (Object[])new Object[]{exception});
        }
        catch (Exception exception) {
            Timber.e((String)"Failed to read the storage key: ", (Object[])new Object[]{exception});
        }
        String cachePath = null;
        if (setStorageExternal && FileSource.isExternalStorageReadable()) {
            try {
                cachePath = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException exception) {
                Timber.e((String)"Failed to obtain the external storage path: ", (Object[])new Object[]{exception});
            }
        }
        if (cachePath == null) {
            cachePath = context.getFilesDir().getAbsolutePath();
        }
        return cachePath;
    }

    public static boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state) || "mounted_ro".equals(state)) {
            return true;
        }
        Timber.w((String)"External storage was requested but it isn't readable. For API level < 18 make sure you've requested READ_EXTERNAL_STORAGE or WRITE_EXTERNAL_STORAGE permissions in your app Manifest (defaulting to internal storage).", (Object[])new Object[0]);
        return false;
    }

    private FileSource(String cachePath, String apkPath) {
        this.initialize(Mapbox.getAccessToken(), cachePath, apkPath);
    }

    public native void setAccessToken(@NonNull String var1);

    public native String getAccessToken();

    public native void setApiBaseUrl(String var1);

    public native void setResourceTransform(@NonNull ResourceTransformCallback var1);

    private native void initialize(String var1, String var2, String var3);

    protected native void finalize() throws Throwable;

    public static interface ResourceTransformCallback {
        public String onURL(int var1, String var2);
    }
}

