/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.sources.GeoJsonOptions;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@UiThread
public class GeoJsonSource
extends Source {
    public GeoJsonSource(long nativePtr) {
        super(nativePtr);
    }

    public GeoJsonSource(String id2) {
        this.initialize(id2, null);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(FeatureCollection.fromFeatures(new ArrayList()));
    }

    public GeoJsonSource(String id2, String geoJson) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, null);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id2, String geoJson, GeoJsonOptions options) {
        if (geoJson == null || geoJson.startsWith("http")) {
            throw new IllegalArgumentException("Expected a raw json body");
        }
        this.initialize(id2, options);
        this.setGeoJson(geoJson);
    }

    public GeoJsonSource(String id2, URL url) {
        this.initialize(id2, null);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id2, URL url, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.nativeSetUrl(url.toExternalForm());
    }

    public GeoJsonSource(String id2, FeatureCollection features) {
        this.initialize(id2, null);
        this.setGeoJson(features);
    }

    public GeoJsonSource(String id2, FeatureCollection features, GeoJsonOptions options) {
        this.initialize(id2, options);
        this.setGeoJson(features);
    }

    public void setGeoJson(FeatureCollection features) {
        this.checkValidity();
        this.setGeoJson(features.toJson());
    }

    public void setGeoJson(String json) {
        this.checkValidity();
        this.setRawJson(json);
    }

    public void setUrl(URL url) {
        this.checkValidity();
        this.setUrl(url.toExternalForm());
    }

    public void setUrl(String url) {
        this.checkValidity();
        this.nativeSetUrl(url);
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Filter.Statement filter) {
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    protected void setRawJson(String geoJson) {
        HashMap<String, String> wrapper = new HashMap<String, String>();
        wrapper.put("data", geoJson);
        this.nativeSetGeoJson(wrapper);
    }

    protected native void initialize(String var1, Object var2);

    protected native void nativeSetUrl(String var1);

    private native void nativeSetGeoJson(Object var1);

    private native Feature[] querySourceFeatures(Object[] var1);

    protected native void finalize() throws Throwable;
}

