/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.PointF;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ViewConfiguration;
import com.almeros.android.multitouch.gesturedetectors.RotateGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.ShoveGestureDetector;
import com.almeros.android.multitouch.gesturedetectors.TwoFingerGestureDetector;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.services.android.telemetry.MapboxEvent;
import com.mapbox.services.android.telemetry.MapboxTelemetry;
import com.mapbox.services.android.telemetry.utils.MathUtils;
import com.mapbox.services.android.telemetry.utils.TelemetryUtils;

final class MapGestureDetector {
    private final Transform transform;
    private final Projection projection;
    private final UiSettings uiSettings;
    private final TrackingSettings trackingSettings;
    private final AnnotationManager annotationManager;
    private final GestureDetectorCompat gestureDetector;
    private final ScaleGestureDetector scaleGestureDetector;
    private final RotateGestureDetector rotateGestureDetector;
    private final ShoveGestureDetector shoveGestureDetector;
    private MapboxMap.OnMapClickListener onMapClickListener;
    private MapboxMap.OnMapLongClickListener onMapLongClickListener;
    private MapboxMap.OnFlingListener onFlingListener;
    private MapboxMap.OnScrollListener onScrollListener;
    private PointF focalPoint;
    private boolean twoTap = false;
    private boolean zoomStarted = false;
    private boolean dragStarted = false;
    private boolean quickZoom = false;
    private boolean scrollInProgress = false;
    private boolean scaleGestureOccurred = false;

    MapGestureDetector(Context context, Transform transform, Projection projection, UiSettings uiSettings, TrackingSettings trackingSettings, AnnotationManager annotationManager) {
        this.annotationManager = annotationManager;
        this.transform = transform;
        this.projection = projection;
        this.uiSettings = uiSettings;
        this.trackingSettings = trackingSettings;
        this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.gestureDetector.setIsLongpressEnabled(true);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        ScaleGestureDetectorCompat.setQuickScaleEnabled((Object)this.scaleGestureDetector, (boolean)true);
        this.rotateGestureDetector = new RotateGestureDetector(context, new RotateGestureListener());
        this.shoveGestureDetector = new ShoveGestureDetector(context, new ShoveGestureListener());
    }

    void setFocalPoint(PointF focalPoint) {
        if (focalPoint == null && this.uiSettings.getFocalPoint() != null) {
            focalPoint = this.uiSettings.getFocalPoint();
        }
        this.focalPoint = focalPoint;
    }

    @Nullable
    PointF getFocalPoint() {
        return this.focalPoint;
    }

    private Location getLocationFromGesture(float x, float y) {
        LatLng latLng = this.projection.fromScreenLocation(new PointF(x, y));
        return TelemetryUtils.buildLocation((double)latLng.getLongitude(), (double)latLng.getLatitude());
    }

    boolean onTouchEvent(@NonNull MotionEvent event) {
        if (event.getButtonState() != 0 && event.getButtonState() != 1) {
            return false;
        }
        this.rotateGestureDetector.onTouchEvent(event);
        this.scaleGestureDetector.onTouchEvent(event);
        this.shoveGestureDetector.onTouchEvent(event);
        switch (event.getActionMasked()) {
            case 0: {
                this.scaleGestureOccurred = false;
                this.transform.setGestureInProgress(true);
                break;
            }
            case 5: {
                boolean bl = this.twoTap = event.getPointerCount() == 2 && this.uiSettings.isZoomGesturesEnabled();
                if (!this.twoTap) break;
                MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)this.getLocationFromGesture(event.getX(), event.getY()), (String)"TwoFingerTap", (double)this.transform.getZoom()));
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                boolean inProgress;
                long tapInterval = event.getEventTime() - event.getDownTime();
                boolean isTap = tapInterval <= (long)ViewConfiguration.getTapTimeout();
                boolean bl = inProgress = this.rotateGestureDetector.isInProgress() || this.scaleGestureDetector.isInProgress() || this.shoveGestureDetector.isInProgress();
                if (this.twoTap && isTap && !inProgress) {
                    if (this.focalPoint != null) {
                        this.transform.zoom(false, this.focalPoint);
                    } else {
                        PointF focalPoint = TwoFingerGestureDetector.determineFocalPoint(event);
                        this.transform.zoom(false, focalPoint);
                    }
                    this.twoTap = false;
                    return true;
                }
                if (this.scrollInProgress) {
                    MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapDragEndEvent((Location)this.getLocationFromGesture(event.getX(), event.getY()), (double)this.transform.getZoom()));
                    this.scrollInProgress = false;
                }
                this.twoTap = false;
                this.transform.setGestureInProgress(false);
                break;
            }
            case 3: {
                this.twoTap = false;
                this.transform.setGestureInProgress(false);
            }
        }
        return this.gestureDetector.onTouchEvent(event);
    }

    boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) == 2) {
            switch (event.getActionMasked()) {
                case 8: {
                    if (!this.uiSettings.isZoomGesturesEnabled()) {
                        return false;
                    }
                    this.transform.cancelTransitions();
                    float scrollDist = event.getAxisValue(9);
                    this.transform.zoomBy(Math.pow(2.0, scrollDist), event.getX(), event.getY());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    void setOnMapClickListener(MapboxMap.OnMapClickListener onMapClickListener) {
        this.onMapClickListener = onMapClickListener;
    }

    void setOnMapLongClickListener(MapboxMap.OnMapLongClickListener onMapLongClickListener) {
        this.onMapLongClickListener = onMapLongClickListener;
    }

    void setOnFlingListener(MapboxMap.OnFlingListener onFlingListener) {
        this.onFlingListener = onFlingListener;
    }

    void setOnScrollListener(MapboxMap.OnScrollListener onScrollListener) {
        this.onScrollListener = onScrollListener;
    }

    private class ShoveGestureListener
    implements ShoveGestureDetector.OnShoveGestureListener {
        long beginTime = 0L;
        float totalDelta = 0.0f;
        boolean started = false;

        private ShoveGestureListener() {
        }

        @Override
        public boolean onShoveBegin(ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            this.beginTime = detector.getEventTime();
            MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(detector.getFocusX(), detector.getFocusY()), (String)"Pitch", (double)MapGestureDetector.this.transform.getZoom()));
            return true;
        }

        @Override
        public void onShoveEnd(ShoveGestureDetector detector) {
            this.beginTime = 0L;
            this.totalDelta = 0.0f;
            this.started = false;
            MapGestureDetector.this.dragStarted = false;
        }

        @Override
        public boolean onShove(ShoveGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isTiltGesturesEnabled()) {
                return false;
            }
            this.totalDelta += detector.getShovePixelsDelta();
            if (!MapGestureDetector.this.zoomStarted && (this.totalDelta > 10.0f || this.totalDelta < -10.0f)) {
                this.started = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!this.started && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.started) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            double pitch = MapGestureDetector.this.transform.getTilt();
            pitch -= 0.1 * (double)detector.getShovePixelsDelta();
            pitch = Math.max(0.0, Math.min(60.0, pitch));
            MapGestureDetector.this.transform.setTilt(pitch);
            MapGestureDetector.this.dragStarted = true;
            return true;
        }
    }

    private class RotateGestureListener
    extends RotateGestureDetector.SimpleOnRotateGestureListener {
        long beginTime = 0L;
        float totalAngle = 0.0f;
        boolean started = false;

        private RotateGestureListener() {
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            if (!MapGestureDetector.this.trackingSettings.isRotateGestureCurrentlyEnabled()) {
                return false;
            }
            this.beginTime = detector.getEventTime();
            MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(detector.getFocusX(), detector.getFocusY()), (String)"Rotation", (double)MapGestureDetector.this.transform.getZoom()));
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            this.beginTime = 0L;
            this.totalAngle = 0.0f;
            this.started = false;
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            if (!MapGestureDetector.this.trackingSettings.isRotateGestureCurrentlyEnabled() || MapGestureDetector.this.dragStarted) {
                return false;
            }
            this.totalAngle += detector.getRotationDegreesDelta();
            if (!MapGestureDetector.this.zoomStarted && (this.totalAngle > 20.0f || this.totalAngle < -20.0f)) {
                this.started = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!this.started && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!this.started) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, true);
            double bearing = MapGestureDetector.this.transform.getRawBearing();
            bearing += (double)detector.getRotationDegreesDelta();
            if (MapGestureDetector.this.focalPoint != null) {
                MapGestureDetector.this.transform.setBearing(bearing, ((MapGestureDetector)MapGestureDetector.this).focalPoint.x, ((MapGestureDetector)MapGestureDetector.this).focalPoint.y);
            } else {
                MapGestureDetector.this.transform.setBearing(bearing, detector.getFocusX(), detector.getFocusY());
            }
            return true;
        }
    }

    private class ScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        long beginTime = 0L;
        float scaleFactor = 1.0f;

        private ScaleGestureListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return false;
            }
            MapGestureDetector.this.scaleGestureOccurred = true;
            this.beginTime = detector.getEventTime();
            MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(detector.getFocusX(), detector.getFocusY()), (String)"Pinch", (double)MapGestureDetector.this.transform.getZoom()));
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            this.beginTime = 0L;
            this.scaleFactor = 1.0f;
            MapGestureDetector.this.zoomStarted = false;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled()) {
                return super.onScale(detector);
            }
            this.scaleFactor *= detector.getScaleFactor();
            if (this.scaleFactor > 1.05f || this.scaleFactor < 0.95f) {
                MapGestureDetector.this.zoomStarted = true;
            }
            long time = detector.getEventTime();
            long interval = time - this.beginTime;
            if (!MapGestureDetector.this.zoomStarted && interval <= (long)ViewConfiguration.getTapTimeout()) {
                return false;
            }
            if (!MapGestureDetector.this.zoomStarted) {
                return false;
            }
            if (MapGestureDetector.this.dragStarted) {
                return false;
            }
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.quickZoom = !MapGestureDetector.this.twoTap;
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(!MapGestureDetector.this.quickZoom, false);
            if (MapGestureDetector.this.focalPoint != null) {
                MapGestureDetector.this.transform.zoomBy(detector.getScaleFactor(), ((MapGestureDetector)MapGestureDetector.this).focalPoint.x, ((MapGestureDetector)MapGestureDetector.this).focalPoint.y);
            } else if (MapGestureDetector.this.quickZoom) {
                float scaleFactor = MathUtils.clamp((float)detector.getScaleFactor(), (float)0.65f, (float)1.35f);
                MapGestureDetector.this.transform.zoomBy(scaleFactor, MapGestureDetector.this.uiSettings.getWidth() / 2.0f, MapGestureDetector.this.uiSettings.getHeight() / 2.0f);
            } else {
                MapGestureDetector.this.transform.zoomBy(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY());
            }
            return true;
        }
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private GestureListener() {
        }

        public boolean onDown(MotionEvent event) {
            return true;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            if (!MapGestureDetector.this.uiSettings.isZoomGesturesEnabled() || !MapGestureDetector.this.uiSettings.isDoubleTapGesturesEnabled()) {
                return false;
            }
            switch (e.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (MapGestureDetector.this.quickZoom) {
                        MapGestureDetector.this.quickZoom = false;
                        break;
                    }
                    if (MapGestureDetector.this.focalPoint != null) {
                        MapGestureDetector.this.transform.zoom(true, MapGestureDetector.this.focalPoint);
                        break;
                    }
                    MapGestureDetector.this.transform.zoom(true, new PointF(e.getX(), e.getY()));
                }
            }
            MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(e.getX(), e.getY()), (String)"DoubleTap", (double)MapGestureDetector.this.transform.getZoom()));
            return true;
        }

        public boolean onSingleTapUp(MotionEvent motionEvent) {
            MapGestureDetector.this.transform.cancelTransitions();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            PointF tapPoint = new PointF(motionEvent.getX(), motionEvent.getY());
            boolean tapHandled = MapGestureDetector.this.annotationManager.onTap(tapPoint, MapGestureDetector.this.uiSettings.getPixelRatio());
            if (!tapHandled) {
                if (MapGestureDetector.this.uiSettings.isDeselectMarkersOnTap()) {
                    MapGestureDetector.this.annotationManager.deselectMarkers();
                }
                if (MapGestureDetector.this.onMapClickListener != null) {
                    MapGestureDetector.this.onMapClickListener.onMapClick(MapGestureDetector.this.projection.fromScreenLocation(tapPoint));
                }
            }
            MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(motionEvent.getX(), motionEvent.getY()), (String)"SingleTap", (double)MapGestureDetector.this.transform.getZoom()));
            return true;
        }

        public void onLongPress(MotionEvent motionEvent) {
            if (MapGestureDetector.this.onMapLongClickListener != null && !MapGestureDetector.this.quickZoom) {
                MapGestureDetector.this.onMapLongClickListener.onMapLongClick(MapGestureDetector.this.projection.fromScreenLocation(new PointF(motionEvent.getX(), motionEvent.getY())));
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!MapGestureDetector.this.trackingSettings.isScrollGestureCurrentlyEnabled() || MapGestureDetector.this.scaleGestureOccurred) {
                return false;
            }
            float screenDensity = MapGestureDetector.this.uiSettings.getPixelRatio();
            double velocityXY = Math.hypot(velocityX / screenDensity, velocityY / screenDensity);
            if (velocityXY < 1000.0) {
                return false;
            }
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, false);
            MapGestureDetector.this.transform.cancelTransitions();
            double tilt = MapGestureDetector.this.transform.getTilt();
            double tiltFactor = 1.0 + (tilt != 0.0 ? tilt / 10.0 : 0.0);
            double offsetX = (double)velocityX / tiltFactor / (double)screenDensity;
            double offsetY = (double)velocityY / tiltFactor / (double)screenDensity;
            long animationTime = (long)(velocityXY / 7.0 / tiltFactor + 150.0);
            MapGestureDetector.this.transform.setGestureInProgress(true);
            MapGestureDetector.this.transform.moveBy(offsetX, offsetY, animationTime);
            MapGestureDetector.this.transform.setGestureInProgress(false);
            if (MapGestureDetector.this.onFlingListener != null) {
                MapGestureDetector.this.onFlingListener.onFling();
            }
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!MapGestureDetector.this.scrollInProgress) {
                MapGestureDetector.this.scrollInProgress = true;
                MapboxTelemetry.getInstance().pushEvent(MapboxEvent.buildMapClickEvent((Location)MapGestureDetector.this.getLocationFromGesture(e1.getX(), e1.getY()), (String)"Pan", (double)MapGestureDetector.this.transform.getZoom()));
            }
            if (!MapGestureDetector.this.trackingSettings.isScrollGestureCurrentlyEnabled()) {
                return false;
            }
            if (MapGestureDetector.this.dragStarted) {
                return false;
            }
            MapGestureDetector.this.trackingSettings.resetTrackingModesIfRequired(true, false);
            MapGestureDetector.this.transform.cancelTransitions();
            MapGestureDetector.this.transform.moveBy(-distanceX, -distanceY, 0L);
            if (MapGestureDetector.this.onScrollListener != null) {
                MapGestureDetector.this.onScrollListener.onScroll();
            }
            return true;
        }
    }
}

