/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.offline;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineRegion;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import java.io.File;
import timber.log.Timber;

public class OfflineManager {
    private long nativePtr;
    private final FileSource fileSource;
    private Handler handler;
    private static OfflineManager instance;
    private Context context;

    private OfflineManager(Context context) {
        this.context = context.getApplicationContext();
        this.fileSource = FileSource.getInstance(context);
        this.initialize(this.fileSource);
        this.deleteAmbientDatabase(context);
    }

    private void deleteAmbientDatabase(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String path = context.getCacheDir().getAbsolutePath() + File.separator + "mbgl-cache.db";
                    File file = new File(path);
                    if (file.exists()) {
                        file.delete();
                        Timber.d((String)("Old ambient cache database deleted to save space: " + path), (Object[])new Object[0]);
                    }
                }
                catch (Exception exception) {
                    Timber.e((String)"Failed to delete old ambient cache database: ", (Object[])new Object[]{exception});
                }
            }
        }).start();
    }

    public static synchronized OfflineManager getInstance(Context context) {
        if (instance == null) {
            instance = new OfflineManager(context);
        }
        return instance;
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler(Looper.getMainLooper());
        }
        return this.handler;
    }

    public void listOfflineRegions(final @NonNull ListOfflineRegionsCallback callback) {
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(){

            @Override
            public void onList(final OfflineRegion[] offlineRegions) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onList(offlineRegions);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public void createOfflineRegion(@NonNull OfflineRegionDefinition definition, @NonNull byte[] metadata, final @NonNull CreateOfflineRegionCallback callback) {
        ConnectivityReceiver.instance(this.context).activate();
        this.createOfflineRegion(this.fileSource, definition, metadata, new CreateOfflineRegionCallback(){

            @Override
            public void onCreate(final OfflineRegion offlineRegion) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        callback.onCreate(offlineRegion);
                    }
                });
            }

            @Override
            public void onError(final String error) {
                OfflineManager.this.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectivityReceiver.instance(OfflineManager.this.context).deactivate();
                        callback.onError(error);
                    }
                });
            }
        });
    }

    public native void setOfflineMapboxTileCountLimit(long var1);

    private native void initialize(FileSource var1);

    protected native void finalize() throws Throwable;

    private native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    private native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    static {
        System.loadLibrary("mapbox-gl");
    }

    public static interface CreateOfflineRegionCallback {
        public void onCreate(OfflineRegion var1);

        public void onError(String var1);
    }

    public static interface ListOfflineRegionsCallback {
        public void onList(OfflineRegion[] var1);

        public void onError(String var1);
    }
}

