/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.Pools;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.TrackingSettings;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.widgets.MyLocationViewSettings;
import com.mapbox.mapboxsdk.style.layers.Filter;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.commons.geojson.Feature;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import timber.log.Timber;

public final class MapboxMap {
    private final NativeMapView nativeMapView;
    private final UiSettings uiSettings;
    private final TrackingSettings trackingSettings;
    private final Projection projection;
    private final Transform transform;
    private final AnnotationManager annotationManager;
    private final MyLocationViewSettings myLocationViewSettings;
    private final OnRegisterTouchListener onRegisterTouchListener;
    private OnFpsChangedListener onFpsChangedListener;

    MapboxMap(NativeMapView map, Transform transform, UiSettings ui, TrackingSettings tracking, MyLocationViewSettings myLocationView, Projection projection, OnRegisterTouchListener listener, AnnotationManager annotations) {
        this.nativeMapView = map;
        this.uiSettings = ui;
        this.trackingSettings = tracking;
        this.projection = projection;
        this.myLocationViewSettings = myLocationView;
        this.annotationManager = annotations.bind(this);
        this.transform = transform;
        this.onRegisterTouchListener = listener;
    }

    void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        this.transform.initialise(this, options);
        this.uiSettings.initialise(context, options);
        this.myLocationViewSettings.initialise(options);
        this.trackingSettings.initialise(options);
        this.setDebugActive(options.getDebugActive());
        this.setApiBaseUrl(options);
        this.setStyleUrl(options);
    }

    void onStart() {
        this.nativeMapView.update();
        this.trackingSettings.onStart();
        if (TextUtils.isEmpty((CharSequence)this.nativeMapView.getStyleUrl())) {
            this.nativeMapView.setStyleUrl("mapbox://styles/mapbox/streets-v9");
        }
    }

    void onStop() {
        this.trackingSettings.onStop();
    }

    void onSaveInstanceState(Bundle outState) {
        outState.putParcelable("mapbox_cameraPosition", (Parcelable)this.transform.getCameraPosition());
        outState.putBoolean("mapbox_debugActive", this.nativeMapView.getDebug());
        outState.putString("mapbox_styleUrl", this.nativeMapView.getStyleUrl());
        this.trackingSettings.onSaveInstanceState(outState);
        this.uiSettings.onSaveInstanceState(outState);
    }

    void onRestoreInstanceState(Bundle savedInstanceState) {
        CameraPosition cameraPosition = (CameraPosition)savedInstanceState.getParcelable("mapbox_cameraPosition");
        if (cameraPosition != null) {
            this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder(cameraPosition).build()));
        }
        this.uiSettings.onRestoreInstanceState(savedInstanceState);
        this.trackingSettings.onRestoreInstanceState(savedInstanceState);
        this.nativeMapView.setDebug(savedInstanceState.getBoolean("mapbox_debugActive"));
        String styleUrl = savedInstanceState.getString("mapbox_styleUrl");
        if (!TextUtils.isEmpty((CharSequence)styleUrl)) {
            this.nativeMapView.setStyleUrl(savedInstanceState.getString("mapbox_styleUrl"));
        }
    }

    void onPreMapReady() {
        this.annotationManager.reloadMarkers();
        this.annotationManager.adjustTopOffsetPixels(this);
    }

    void onPostMapReady() {
        this.invalidateCameraPosition();
    }

    void onUpdateRegionChange() {
        this.trackingSettings.update();
        this.annotationManager.update();
    }

    void onUpdateFullyRendered() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.uiSettings.update(cameraPosition);
        }
    }

    @UiThread
    public long getTransitionDuration() {
        return this.nativeMapView.getTransitionDuration();
    }

    @UiThread
    public void setTransitionDuration(long durationMs) {
        this.nativeMapView.setTransitionDuration(durationMs);
    }

    @UiThread
    public long getTransitionDelay() {
        return this.nativeMapView.getTransitionDelay();
    }

    @UiThread
    public void setTransitionDelay(long delayMs) {
        this.nativeMapView.setTransitionDelay(delayMs);
    }

    @UiThread
    public List<Layer> getLayers() {
        return this.nativeMapView.getLayers();
    }

    @Nullable
    @UiThread
    public Layer getLayer(@NonNull String layerId) {
        return this.nativeMapView.getLayer(layerId);
    }

    @Nullable
    @UiThread
    public <T extends Layer> T getLayerAs(@NonNull String layerId) {
        try {
            return (T)this.nativeMapView.getLayer(layerId);
        }
        catch (ClassCastException exception) {
            Timber.e((String)String.format("Layer: %s is a different type: %s", layerId, exception), (Object[])new Object[0]);
            return null;
        }
    }

    @UiThread
    public void addLayer(@NonNull Layer layer) {
        this.nativeMapView.addLayer(layer);
    }

    @UiThread
    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        this.nativeMapView.addLayerBelow(layer, below);
    }

    @UiThread
    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        this.nativeMapView.addLayerAbove(layer, above);
    }

    @UiThread
    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        this.nativeMapView.addLayerAt(layer, index);
    }

    @UiThread
    @Nullable
    public Layer removeLayer(@NonNull String layerId) {
        return this.nativeMapView.removeLayer(layerId);
    }

    @UiThread
    @Nullable
    public Layer removeLayer(@NonNull Layer layer) {
        return this.nativeMapView.removeLayer(layer);
    }

    @UiThread
    @Nullable
    public Layer removeLayerAt(@IntRange(from=0L) int index) {
        return this.nativeMapView.removeLayerAt(index);
    }

    @UiThread
    public List<Source> getSources() {
        return this.nativeMapView.getSources();
    }

    @Nullable
    @UiThread
    public Source getSource(@NonNull String sourceId) {
        return this.nativeMapView.getSource(sourceId);
    }

    @Nullable
    @UiThread
    public <T extends Source> T getSourceAs(@NonNull String sourceId) {
        try {
            return (T)this.nativeMapView.getSource(sourceId);
        }
        catch (ClassCastException exception) {
            Timber.e((String)String.format("Source: %s is a different type: %s", sourceId, exception), (Object[])new Object[0]);
            return null;
        }
    }

    @UiThread
    public void addSource(@NonNull Source source) {
        this.nativeMapView.addSource(source);
    }

    @UiThread
    @Nullable
    public Source removeSource(@NonNull String sourceId) {
        return this.nativeMapView.removeSource(sourceId);
    }

    @UiThread
    @Nullable
    public Source removeSource(@NonNull Source source) {
        return this.nativeMapView.removeSource(source);
    }

    @UiThread
    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        this.nativeMapView.addImage(name, image);
    }

    @UiThread
    public void removeImage(String name) {
        this.nativeMapView.removeImage(name);
    }

    @UiThread
    public void setMinZoomPreference(@FloatRange(from=0.0, to=20.0) double minZoom) {
        this.transform.setMinZoom(minZoom);
    }

    @UiThread
    public double getMinZoomLevel() {
        return this.transform.getMinZoom();
    }

    @UiThread
    public void setMaxZoomPreference(@FloatRange(from=0.0, to=20.0) double maxZoom) {
        this.transform.setMaxZoom(maxZoom);
    }

    @UiThread
    public double getMaxZoomLevel() {
        return this.transform.getMaxZoom();
    }

    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    public TrackingSettings getTrackingSettings() {
        return this.trackingSettings;
    }

    public MyLocationViewSettings getMyLocationViewSettings() {
        return this.myLocationViewSettings;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public void cancelTransitions() {
        this.transform.cancelTransitions();
    }

    public final CameraPosition getCameraPosition() {
        return this.transform.getCameraPosition();
    }

    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), null);
    }

    @UiThread
    public final void moveCamera(CameraUpdate update) {
        this.moveCamera(update, null);
    }

    @UiThread
    public final void moveCamera(final CameraUpdate update, final CancelableCallback callback) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.transform.moveCamera(MapboxMap.this, update, callback);
                MapboxMap.this.invalidateCameraPosition();
            }
        });
    }

    @UiThread
    public final void easeCamera(CameraUpdate update) {
        this.easeCamera(update, 300);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs) {
        this.easeCamera(update, durationMs, null);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, CancelableCallback callback) {
        this.easeCamera(update, durationMs, true, callback);
    }

    @UiThread
    public final void easeCamera(CameraUpdate update, int durationMs, boolean easingInterpolator) {
        this.easeCamera(update, durationMs, easingInterpolator, null);
    }

    @UiThread
    public final void easeCamera(final CameraUpdate update, final int durationMs, final boolean easingInterpolator, final CancelableCallback callback) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.transform.easeCamera(MapboxMap.this, update, durationMs, easingInterpolator, callback);
            }
        });
    }

    @UiThread
    public final void animateCamera(CameraUpdate update) {
        this.animateCamera(update, 300, null);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        this.animateCamera(update, 300, callback);
    }

    @UiThread
    public final void animateCamera(CameraUpdate update, int durationMs) {
        this.animateCamera(update, durationMs, null);
    }

    @UiThread
    public final void animateCamera(final CameraUpdate update, final int durationMs, final CancelableCallback callback) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                MapboxMap.this.transform.animateCamera(MapboxMap.this, update, durationMs, callback);
            }
        });
    }

    void invalidateCameraPosition() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.transform.updateCameraPosition(cameraPosition);
        }
    }

    public void resetNorth() {
        this.transform.resetNorth();
    }

    public void setFocalBearing(double bearing, float focalX, float focalY, long duration) {
        this.transform.setBearing(bearing, focalX, focalY, duration);
    }

    public float getHeight() {
        return this.nativeMapView.getHeight();
    }

    public float getWidth() {
        return this.nativeMapView.getWidth();
    }

    @UiThread
    public boolean isDebugActive() {
        return this.nativeMapView.getDebug();
    }

    @UiThread
    public void setDebugActive(boolean debugActive) {
        this.nativeMapView.setDebug(debugActive);
    }

    @UiThread
    public void cycleDebugOptions() {
        this.nativeMapView.cycleDebugOptions();
    }

    private void setApiBaseUrl(@NonNull MapboxMapOptions options) {
        String apiBaseUrl = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            this.nativeMapView.setApiBaseUrl(apiBaseUrl);
        }
    }

    @UiThread
    public void setStyleUrl(@NonNull String url) {
        this.setStyleUrl(url, null);
    }

    @UiThread
    public void setStyleUrl(final @NonNull String url, final @Nullable OnStyleLoadedListener callback) {
        if (callback != null) {
            this.nativeMapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 14) {
                        callback.onStyleLoaded(url);
                        MapboxMap.this.nativeMapView.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.nativeMapView.setStyleUrl(url);
    }

    @UiThread
    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    @UiThread
    public void setStyle(String style2, @Nullable OnStyleLoadedListener callback) {
        this.setStyleUrl(style2, callback);
    }

    private void setStyleUrl(@NonNull MapboxMapOptions options) {
        String style2 = options.getStyle();
        if (!TextUtils.isEmpty((CharSequence)style2)) {
            this.setStyleUrl(style2, null);
        }
    }

    @UiThread
    @Nullable
    public String getStyleUrl() {
        return this.nativeMapView.getStyleUrl();
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @UiThread
    @NonNull
    public Marker addMarker(@NonNull BaseMarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @UiThread
    @NonNull
    public MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this, null);
    }

    @UiThread
    @NonNull
    public MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        return this.annotationManager.addMarker(markerOptions, this, onMarkerViewAddedListener);
    }

    @UiThread
    @NonNull
    public List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions) {
        return this.annotationManager.addMarkerViews(markerViewOptions, this);
    }

    @UiThread
    @NonNull
    public List<MarkerView> getMarkerViewsInRect(@NonNull RectF rect) {
        return this.annotationManager.getMarkerViewsInRect(rect);
    }

    @UiThread
    @NonNull
    public List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList) {
        return this.annotationManager.addMarkers(markerOptionsList, this);
    }

    @UiThread
    public void updateMarker(@NonNull Marker updatedMarker) {
        this.annotationManager.updateMarker(updatedMarker);
    }

    @UiThread
    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        return this.annotationManager.addPolyline(polylineOptions, this);
    }

    @UiThread
    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        return this.annotationManager.addPolylines(polylineOptionsList, this);
    }

    @UiThread
    public void updatePolyline(Polyline polyline) {
        this.annotationManager.updatePolyline(polyline);
    }

    @UiThread
    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        return this.annotationManager.addPolygon(polygonOptions, this);
    }

    @UiThread
    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        return this.annotationManager.addPolygons(polygonOptionsList, this);
    }

    @UiThread
    public void updatePolygon(Polygon polygon) {
        this.annotationManager.updatePolygon(polygon);
    }

    @UiThread
    public void removeMarker(@NonNull Marker marker) {
        this.annotationManager.removeAnnotation(marker);
    }

    @UiThread
    public void removePolyline(@NonNull Polyline polyline) {
        this.annotationManager.removeAnnotation(polyline);
    }

    @UiThread
    public void removePolygon(@NonNull Polygon polygon) {
        this.annotationManager.removeAnnotation(polygon);
    }

    @UiThread
    public void removeAnnotation(@NonNull Annotation annotation) {
        this.annotationManager.removeAnnotation(annotation);
    }

    @UiThread
    public void removeAnnotation(long id2) {
        this.annotationManager.removeAnnotation(id2);
    }

    @UiThread
    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        this.annotationManager.removeAnnotations(annotationList);
    }

    @UiThread
    public void removeAnnotations() {
        this.annotationManager.removeAnnotations();
    }

    @UiThread
    public void clear() {
        this.annotationManager.removeAnnotations();
    }

    @Nullable
    public Annotation getAnnotation(long id2) {
        return this.annotationManager.getAnnotation(id2);
    }

    @NonNull
    public List<Annotation> getAnnotations() {
        return this.annotationManager.getAnnotations();
    }

    @NonNull
    public List<Marker> getMarkers() {
        return this.annotationManager.getMarkers();
    }

    @NonNull
    public List<Polygon> getPolygons() {
        return this.annotationManager.getPolygons();
    }

    @NonNull
    public List<Polyline> getPolylines() {
        return this.annotationManager.getPolylines();
    }

    @UiThread
    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.annotationManager.setOnMarkerClickListener(listener);
    }

    @UiThread
    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Timber.w((String)"marker was null, so just returning", (Object[])new Object[0]);
            return;
        }
        this.annotationManager.selectMarker(marker);
    }

    @UiThread
    public void deselectMarkers() {
        this.annotationManager.deselectMarkers();
    }

    @UiThread
    public void deselectMarker(@NonNull Marker marker) {
        this.annotationManager.deselectMarker(marker);
    }

    @UiThread
    public List<Marker> getSelectedMarkers() {
        return this.annotationManager.getSelectedMarkers();
    }

    public MarkerViewManager getMarkerViewManager() {
        return this.annotationManager.getMarkerViewManager();
    }

    @UiThread
    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.annotationManager.getInfoWindowManager().setInfoWindowAdapter(infoWindowAdapter);
    }

    @UiThread
    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.annotationManager.getInfoWindowManager().getInfoWindowAdapter();
    }

    @UiThread
    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.annotationManager.getInfoWindowManager().setAllowConcurrentMultipleOpenInfoWindows(allow);
    }

    @UiThread
    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.annotationManager.getInfoWindowManager().isAllowConcurrentMultipleOpenInfoWindows();
    }

    public void setLatLngBoundsForCameraTarget(@Nullable LatLngBounds latLngBounds) {
        this.nativeMapView.setLatLngBounds(latLngBounds);
    }

    public CameraPosition getCameraForLatLngBounds(@Nullable LatLngBounds latLngBounds, int[] padding) {
        int[] mapPadding = this.getPadding();
        for (int i = 0; i < padding.length; ++i) {
            padding[i] = mapPadding[i] + padding[i];
        }
        this.projection.setContentPadding(padding, this.myLocationViewSettings.getPadding());
        CameraPosition cameraPosition = this.nativeMapView.getCameraForLatLngBounds(latLngBounds);
        this.setPadding(mapPadding);
        return cameraPosition;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.setPadding(new int[]{left, top, right, bottom});
    }

    private void setPadding(int[] padding) {
        this.projection.setContentPadding(padding, this.myLocationViewSettings.getPadding());
        this.uiSettings.invalidate();
    }

    public int[] getPadding() {
        return this.projection.getContentPadding();
    }

    @UiThread
    public void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        this.transform.setOnCameraChangeListener(listener);
    }

    @UiThread
    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
    }

    OnFpsChangedListener getOnFpsChangedListener() {
        return this.onFpsChangedListener;
    }

    @UiThread
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.onRegisterTouchListener.onRegisterScrollListener(listener);
    }

    @UiThread
    public void setOnFlingListener(@Nullable OnFlingListener listener) {
        this.onRegisterTouchListener.onRegisterFlingListener(listener);
    }

    @UiThread
    public void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        this.onRegisterTouchListener.onRegisterMapClickListener(listener);
    }

    @UiThread
    public void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        this.onRegisterTouchListener.onRegisterMapLongClickListener(listener);
    }

    @UiThread
    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowClickListener(listener);
    }

    @UiThread
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowClickListener();
    }

    @UiThread
    public void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowLongClickListener(listener);
    }

    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowLongClickListener();
    }

    public void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowCloseListener(listener);
    }

    @UiThread
    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowCloseListener();
    }

    @UiThread
    public boolean isMyLocationEnabled() {
        return this.trackingSettings.isMyLocationEnabled();
    }

    @UiThread
    public void setMyLocationEnabled(boolean enabled) {
        this.trackingSettings.setMyLocationEnabled(enabled);
    }

    @UiThread
    @Nullable
    public Location getMyLocation() {
        return this.trackingSettings.getMyLocation();
    }

    @UiThread
    public void setOnMyLocationChangeListener(@Nullable OnMyLocationChangeListener listener) {
        this.trackingSettings.setOnMyLocationChangeListener(listener);
    }

    @UiThread
    public void setLocationSource(@Nullable LocationEngine locationSource) {
        this.trackingSettings.setLocationSource(locationSource);
    }

    @UiThread
    public void setOnMyLocationTrackingModeChangeListener(@Nullable OnMyLocationTrackingModeChangeListener listener) {
        this.trackingSettings.setOnMyLocationTrackingModeChangeListener(listener);
    }

    @UiThread
    public void setOnMyBearingTrackingModeChangeListener(@Nullable OnMyBearingTrackingModeChangeListener listener) {
        this.trackingSettings.setOnMyBearingTrackingModeChangeListener(listener);
    }

    @UiThread
    public void snapshot(@NonNull SnapshotReadyCallback callback) {
        this.nativeMapView.addSnapshotCallback(callback);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable Filter.Statement filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @UiThread
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable Filter.Statement filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    Transform getTransform() {
        return this.transform;
    }

    public static interface OnStyleLoadedListener {
        public void onStyleLoaded(String var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnMyBearingTrackingModeChangeListener {
        public void onMyBearingTrackingModeChange(int var1);
    }

    public static interface OnMyLocationTrackingModeChangeListener {
        public void onMyLocationTrackingModeChange(int var1);
    }

    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(@Nullable Location var1);
    }

    public static interface OnMarkerViewClickListener {
        public boolean onMarkerClick(@NonNull Marker var1, @NonNull View var2, @NonNull MarkerViewAdapter var3);
    }

    public static abstract class MarkerViewAdapter<U extends MarkerView> {
        private Context context;
        private final Class<U> persistentClass;
        private final Pools.SimplePool<View> viewReusePool;

        public MarkerViewAdapter(Context context) {
            this.context = context;
            this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            this.viewReusePool = new Pools.SimplePool(10000);
        }

        @Nullable
        public abstract View getView(@NonNull U var1, @Nullable View var2, @NonNull ViewGroup var3);

        public boolean prepareViewForReuse(@NonNull MarkerView marker, @NonNull View convertView) {
            return true;
        }

        public boolean onSelect(@NonNull U marker, @NonNull View convertView, boolean reselectionFromRecycling) {
            return true;
        }

        public void onDeselect(@NonNull U marker, @NonNull View convertView) {
        }

        public final Class<U> getMarkerClass() {
            return this.persistentClass;
        }

        public final Pools.SimplePool<View> getViewReusePool() {
            return this.viewReusePool;
        }

        public final Context getContext() {
            return this.context;
        }

        public final void releaseView(View view) {
            view.setVisibility(8);
            this.viewReusePool.release((Object)view);
        }
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(@NonNull Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    static interface OnRegisterTouchListener {
        public void onRegisterMapClickListener(OnMapClickListener var1);

        public void onRegisterMapLongClickListener(OnMapLongClickListener var1);

        public void onRegisterScrollListener(OnScrollListener var1);

        public void onRegisterFlingListener(OnFlingListener var1);
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }
}

