/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.widgets;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.lang.ref.WeakReference;

public final class CompassView
extends AppCompatImageView
implements Runnable,
FocalPointChangeListener {
    private static final long TIME_WAIT_IDLE = 500L;
    private static final long TIME_FADE_ANIMATION = 500L;
    private static final long TIME_MAP_NORTH_ANIMATION = 150L;
    private float rotation = 0.0f;
    private boolean fadeCompassViewFacingNorth = true;
    private ViewPropertyAnimatorCompat fadeAnimator;
    private PointF focalPoint;

    public CompassView(Context context) {
        super(context);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context);
    }

    public CompassView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    private void initialize(Context context) {
        this.setEnabled(false);
        float screenDensity = context.getResources().getDisplayMetrics().density;
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams((int)(48.0f * screenDensity), (int)(48.0f * screenDensity));
        this.setLayoutParams(lp);
    }

    public void setMapboxMap(@NonNull MapboxMap mapboxMap) {
        this.setOnClickListener(new CompassClickListener(mapboxMap, this));
    }

    private void resetAnimation() {
        if (this.fadeAnimator != null) {
            this.fadeAnimator.cancel();
        }
        this.fadeAnimator = null;
    }

    public boolean isHidden() {
        return this.fadeCompassViewFacingNorth && this.isFacingNorth();
    }

    public boolean isFacingNorth() {
        return (double)Math.abs(this.rotation) >= 359.0 || (double)Math.abs(this.rotation) <= 1.0;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled && !this.isHidden()) {
            this.resetAnimation();
            this.setAlpha(1.0f);
            this.setVisibility(0);
        } else {
            this.resetAnimation();
            this.setAlpha(0.0f);
            this.setVisibility(4);
        }
    }

    @Nullable
    PointF getFocalPoint() {
        return this.focalPoint;
    }

    public void update(double bearing) {
        this.rotation = (float)bearing;
        if (!this.isEnabled()) {
            return;
        }
        if (this.isHidden()) {
            if (this.getVisibility() == 4 || this.fadeAnimator != null) {
                return;
            }
            this.postDelayed(this, 500L);
            return;
        }
        this.resetAnimation();
        this.setAlpha(1.0f);
        this.setVisibility(0);
        this.setRotation(this.rotation);
    }

    public void fadeCompassViewFacingNorth(boolean compassFadeFacingNorth) {
        this.fadeCompassViewFacingNorth = compassFadeFacingNorth;
    }

    public boolean isFadeCompassViewFacingNorth() {
        return this.fadeCompassViewFacingNorth;
    }

    public void setCompassImage(Drawable compass) {
        this.setImageDrawable(compass);
    }

    public Drawable getCompassImage() {
        return this.getDrawable();
    }

    @Override
    public void run() {
        if (this.isFacingNorth() && this.fadeCompassViewFacingNorth) {
            this.resetAnimation();
            this.setLayerType(2, null);
            this.fadeAnimator = ViewCompat.animate((View)this).alpha(0.0f).setDuration(500L);
            this.fadeAnimator.setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    CompassView.this.setLayerType(0, null);
                    CompassView.this.setVisibility(4);
                    CompassView.this.resetAnimation();
                }
            });
        }
    }

    @Override
    public void onFocalPointChanged(PointF pointF) {
        this.focalPoint = pointF;
    }

    static class CompassClickListener
    implements View.OnClickListener {
        private WeakReference<MapboxMap> mapboxMap;
        private WeakReference<CompassView> compassView;

        CompassClickListener(MapboxMap mapboxMap, CompassView compassView) {
            this.mapboxMap = new WeakReference<MapboxMap>(mapboxMap);
            this.compassView = new WeakReference<CompassView>(compassView);
        }

        public void onClick(View view) {
            MapboxMap mapboxMap = (MapboxMap)this.mapboxMap.get();
            CompassView compassView = (CompassView)this.compassView.get();
            if (mapboxMap != null && compassView != null) {
                PointF focalPoint = compassView.getFocalPoint();
                if (focalPoint != null) {
                    mapboxMap.setFocalBearing(0.0, focalPoint.x, focalPoint.y, 150L);
                } else {
                    mapboxMap.setFocalBearing(0.0, mapboxMap.getWidth() / 2.0f, mapboxMap.getHeight() / 2.0f, 150L);
                }
                compassView.postDelayed(compassView, 650L);
            }
        }
    }
}

