/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.http;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.text.TextUtils;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.constants.MapboxConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import timber.log.Timber;

class HTTPRequest
implements Callback {
    private static OkHttpClient mClient = new OkHttpClient();
    private String USER_AGENT_STRING = null;
    private static final int CONNECTION_ERROR = 0;
    private static final int TEMPORARY_ERROR = 1;
    private static final int PERMANENT_ERROR = 2;
    private ReentrantLock mLock = new ReentrantLock();
    private long mNativePtr = 0L;
    private Call mCall;
    private Request mRequest;

    private native void nativeOnFailure(int var1, String var2);

    private native void nativeOnResponse(int var1, String var2, String var3, String var4, String var5, String var6, String var7, byte[] var8);

    private HTTPRequest(long nativePtr, String resourceUrl, String etag, String modified) {
        this.mNativePtr = nativePtr;
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)resourceUrl);
            String host = httpUrl.host().toLowerCase(MapboxConstants.MAPBOX_LOCALE);
            if (!(Mapbox.isConnected().booleanValue() || host.equals("127.0.0.1") || host.equals("localhost"))) {
                throw new NoRouteToHostException("No Internet connection available.");
            }
            if (host.equals("mapbox.com") || host.endsWith(".mapbox.com") || host.equals("mapbox.cn") || host.endsWith(".mapbox.cn")) {
                resourceUrl = httpUrl.querySize() == 0 ? resourceUrl + "?" : resourceUrl + "&";
                resourceUrl = resourceUrl + "events=true";
            }
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapboxConstants.MAPBOX_LOCALE)).addHeader("User-Agent", this.getUserAgent());
            if (etag.length() > 0) {
                builder = builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder = builder.addHeader("If-Modified-Since", modified);
            }
            this.mRequest = builder.build();
            this.mCall = mClient.newCall(this.mRequest);
            if (Build.VERSION.SDK_INT <= 25) {
                this.mCall.enqueue((Callback)this);
            } else {
                this.onResponse(this.mCall, this.mCall.execute());
            }
        }
        catch (Exception exception) {
            this.onFailure(exception);
        }
    }

    public void cancel() {
        if (this.mCall != null) {
            this.mCall.cancel();
        }
        this.mLock.lock();
        this.mNativePtr = 0L;
        this.mLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) throws IOException {
        byte[] body;
        if (response.isSuccessful()) {
            Timber.v((String)"[HTTP] Request was successful (code = %s).", (Object[])new Object[]{response.code()});
        } else {
            String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
            Timber.d((String)"[HTTP] Request with response code = %s: %s", (Object[])new Object[]{response.code(), message});
        }
        try {
            body = response.body().bytes();
        }
        catch (IOException ioException) {
            this.onFailure(ioException);
            return;
        }
        finally {
            response.body().close();
        }
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), body);
        }
        this.mLock.unlock();
    }

    public void onFailure(Call call, IOException e) {
        this.onFailure(e);
    }

    private void onFailure(Exception e) {
        String errorMessage;
        int type = 2;
        if (e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
            type = 0;
        } else if (e instanceof InterruptedIOException) {
            type = 1;
        }
        String string2 = errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
        if (type == 1) {
            Timber.d((String)"Request failed due to a temporary error: %s", (Object[])new Object[]{errorMessage});
        } else if (type == 0) {
            Timber.i((String)"Request failed due to a connection error: %s", (Object[])new Object[]{errorMessage});
        } else {
            Timber.w((String)"Request failed due to a permanent error: %s", (Object[])new Object[]{errorMessage});
        }
        this.mLock.lock();
        if (this.mNativePtr != 0L) {
            this.nativeOnFailure(type, errorMessage);
        }
        this.mLock.unlock();
    }

    private String getUserAgent() {
        if (this.USER_AGENT_STRING == null) {
            this.USER_AGENT_STRING = Util.toHumanReadableAscii((String)String.format("%s %s (%s) Android/%s (%s)", this.getApplicationIdentifier(), "Mapbox/5.2.0-beta.4", "55c6ed0", Build.VERSION.SDK_INT, Build.CPU_ABI));
            return this.USER_AGENT_STRING;
        }
        return this.USER_AGENT_STRING;
    }

    private String getApplicationIdentifier() {
        try {
            Context context = Mapbox.getApplicationContext();
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return String.format("%s/%s (%s)", context.getPackageName(), packageInfo.versionName, packageInfo.versionCode);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

