/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.UiThread;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class BackgroundLayer
extends Layer {
    public BackgroundLayer(long nativePtr) {
        super(nativePtr);
    }

    public BackgroundLayer(String layerId) {
        this.initialize(layerId);
    }

    protected native void initialize(String var1);

    public BackgroundLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getBackgroundColor() {
        return new PropertyValue<Object>("background-color", this.nativeGetBackgroundColor());
    }

    @ColorInt
    public int getBackgroundColorAsInt() {
        PropertyValue<String> value = this.getBackgroundColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("background-color was set as a Function");
    }

    public TransitionOptions getBackgroundColorTransition() {
        return this.nativeGetBackgroundColorTransition();
    }

    public void setBackgroundColorTransition(TransitionOptions options) {
        this.nativeSetBackgroundColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getBackgroundPattern() {
        return new PropertyValue<Object>("background-pattern", this.nativeGetBackgroundPattern());
    }

    public TransitionOptions getBackgroundPatternTransition() {
        return this.nativeGetBackgroundPatternTransition();
    }

    public void setBackgroundPatternTransition(TransitionOptions options) {
        this.nativeSetBackgroundPatternTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getBackgroundOpacity() {
        return new PropertyValue<Object>("background-opacity", this.nativeGetBackgroundOpacity());
    }

    public TransitionOptions getBackgroundOpacityTransition() {
        return this.nativeGetBackgroundOpacityTransition();
    }

    public void setBackgroundOpacityTransition(TransitionOptions options) {
        this.nativeSetBackgroundOpacityTransition(options.getDuration(), options.getDelay());
    }

    private native Object nativeGetBackgroundColor();

    private native TransitionOptions nativeGetBackgroundColorTransition();

    private native void nativeSetBackgroundColorTransition(long var1, long var3);

    private native Object nativeGetBackgroundPattern();

    private native TransitionOptions nativeGetBackgroundPatternTransition();

    private native void nativeSetBackgroundPatternTransition(long var1, long var3);

    private native Object nativeGetBackgroundOpacity();

    private native TransitionOptions nativeGetBackgroundOpacityTransition();

    private native void nativeSetBackgroundOpacityTransition(long var1, long var3);

    @Override
    protected native void finalize() throws Throwable;
}

