/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.google.gson.JsonArray;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class SymbolLayer
extends Layer {
    public SymbolLayer(long nativePtr) {
        super(nativePtr);
    }

    public SymbolLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    public SymbolLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    public SymbolLayer withFilter(Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        Expression expression = null;
        JsonArray array = (JsonArray)this.nativeGetFilter();
        if (array != null) {
            expression = Expression.Converter.convert(array);
        }
        return expression;
    }

    public SymbolLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    public PropertyValue<String> getSymbolPlacement() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-placement", this.nativeGetSymbolPlacement());
    }

    public PropertyValue<Float> getSymbolSpacing() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-spacing", this.nativeGetSymbolSpacing());
    }

    public PropertyValue<Boolean> getSymbolAvoidEdges() {
        this.checkThread();
        return new PropertyValue<Object>("symbol-avoid-edges", this.nativeGetSymbolAvoidEdges());
    }

    public PropertyValue<Boolean> getIconAllowOverlap() {
        this.checkThread();
        return new PropertyValue<Object>("icon-allow-overlap", this.nativeGetIconAllowOverlap());
    }

    public PropertyValue<Boolean> getIconIgnorePlacement() {
        this.checkThread();
        return new PropertyValue<Object>("icon-ignore-placement", this.nativeGetIconIgnorePlacement());
    }

    public PropertyValue<Boolean> getIconOptional() {
        this.checkThread();
        return new PropertyValue<Object>("icon-optional", this.nativeGetIconOptional());
    }

    public PropertyValue<String> getIconRotationAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("icon-rotation-alignment", this.nativeGetIconRotationAlignment());
    }

    public PropertyValue<Float> getIconSize() {
        this.checkThread();
        return new PropertyValue<Object>("icon-size", this.nativeGetIconSize());
    }

    public PropertyValue<String> getIconTextFit() {
        this.checkThread();
        return new PropertyValue<Object>("icon-text-fit", this.nativeGetIconTextFit());
    }

    public PropertyValue<Float[]> getIconTextFitPadding() {
        this.checkThread();
        return new PropertyValue<Object>("icon-text-fit-padding", this.nativeGetIconTextFitPadding());
    }

    public PropertyValue<String> getIconImage() {
        this.checkThread();
        return new PropertyValue<Object>("icon-image", this.nativeGetIconImage());
    }

    public PropertyValue<Float> getIconRotate() {
        this.checkThread();
        return new PropertyValue<Object>("icon-rotate", this.nativeGetIconRotate());
    }

    public PropertyValue<Float> getIconPadding() {
        this.checkThread();
        return new PropertyValue<Object>("icon-padding", this.nativeGetIconPadding());
    }

    public PropertyValue<Boolean> getIconKeepUpright() {
        this.checkThread();
        return new PropertyValue<Object>("icon-keep-upright", this.nativeGetIconKeepUpright());
    }

    public PropertyValue<Float[]> getIconOffset() {
        this.checkThread();
        return new PropertyValue<Object>("icon-offset", this.nativeGetIconOffset());
    }

    public PropertyValue<String> getIconAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-anchor", this.nativeGetIconAnchor());
    }

    public PropertyValue<String> getIconPitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("icon-pitch-alignment", this.nativeGetIconPitchAlignment());
    }

    public PropertyValue<String> getTextPitchAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("text-pitch-alignment", this.nativeGetTextPitchAlignment());
    }

    public PropertyValue<String> getTextRotationAlignment() {
        this.checkThread();
        return new PropertyValue<Object>("text-rotation-alignment", this.nativeGetTextRotationAlignment());
    }

    public PropertyValue<String> getTextField() {
        this.checkThread();
        return new PropertyValue<Object>("text-field", this.nativeGetTextField());
    }

    public PropertyValue<String[]> getTextFont() {
        this.checkThread();
        return new PropertyValue<Object>("text-font", this.nativeGetTextFont());
    }

    public PropertyValue<Float> getTextSize() {
        this.checkThread();
        return new PropertyValue<Object>("text-size", this.nativeGetTextSize());
    }

    public PropertyValue<Float> getTextMaxWidth() {
        this.checkThread();
        return new PropertyValue<Object>("text-max-width", this.nativeGetTextMaxWidth());
    }

    public PropertyValue<Float> getTextLineHeight() {
        this.checkThread();
        return new PropertyValue<Object>("text-line-height", this.nativeGetTextLineHeight());
    }

    public PropertyValue<Float> getTextLetterSpacing() {
        this.checkThread();
        return new PropertyValue<Object>("text-letter-spacing", this.nativeGetTextLetterSpacing());
    }

    public PropertyValue<String> getTextJustify() {
        this.checkThread();
        return new PropertyValue<Object>("text-justify", this.nativeGetTextJustify());
    }

    public PropertyValue<String> getTextAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("text-anchor", this.nativeGetTextAnchor());
    }

    public PropertyValue<Float> getTextMaxAngle() {
        this.checkThread();
        return new PropertyValue<Object>("text-max-angle", this.nativeGetTextMaxAngle());
    }

    public PropertyValue<Float> getTextRotate() {
        this.checkThread();
        return new PropertyValue<Object>("text-rotate", this.nativeGetTextRotate());
    }

    public PropertyValue<Float> getTextPadding() {
        this.checkThread();
        return new PropertyValue<Object>("text-padding", this.nativeGetTextPadding());
    }

    public PropertyValue<Boolean> getTextKeepUpright() {
        this.checkThread();
        return new PropertyValue<Object>("text-keep-upright", this.nativeGetTextKeepUpright());
    }

    public PropertyValue<String> getTextTransform() {
        this.checkThread();
        return new PropertyValue<Object>("text-transform", this.nativeGetTextTransform());
    }

    public PropertyValue<Float[]> getTextOffset() {
        this.checkThread();
        return new PropertyValue<Object>("text-offset", this.nativeGetTextOffset());
    }

    public PropertyValue<Boolean> getTextAllowOverlap() {
        this.checkThread();
        return new PropertyValue<Object>("text-allow-overlap", this.nativeGetTextAllowOverlap());
    }

    public PropertyValue<Boolean> getTextIgnorePlacement() {
        this.checkThread();
        return new PropertyValue<Object>("text-ignore-placement", this.nativeGetTextIgnorePlacement());
    }

    public PropertyValue<Boolean> getTextOptional() {
        this.checkThread();
        return new PropertyValue<Object>("text-optional", this.nativeGetTextOptional());
    }

    public PropertyValue<Float> getIconOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("icon-opacity", this.nativeGetIconOpacity());
    }

    public TransitionOptions getIconOpacityTransition() {
        this.checkThread();
        return this.nativeGetIconOpacityTransition();
    }

    public void setIconOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconColor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-color", this.nativeGetIconColor());
    }

    @ColorInt
    public int getIconColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getIconColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-color was set as a Function");
    }

    public TransitionOptions getIconColorTransition() {
        this.checkThread();
        return this.nativeGetIconColorTransition();
    }

    public void setIconColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconHaloColor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-color", this.nativeGetIconHaloColor());
    }

    @ColorInt
    public int getIconHaloColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getIconHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("icon-halo-color was set as a Function");
    }

    public TransitionOptions getIconHaloColorTransition() {
        this.checkThread();
        return this.nativeGetIconHaloColorTransition();
    }

    public void setIconHaloColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getIconHaloWidth() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-width", this.nativeGetIconHaloWidth());
    }

    public TransitionOptions getIconHaloWidthTransition() {
        this.checkThread();
        return this.nativeGetIconHaloWidthTransition();
    }

    public void setIconHaloWidthTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getIconHaloBlur() {
        this.checkThread();
        return new PropertyValue<Object>("icon-halo-blur", this.nativeGetIconHaloBlur());
    }

    public TransitionOptions getIconHaloBlurTransition() {
        this.checkThread();
        return this.nativeGetIconHaloBlurTransition();
    }

    public void setIconHaloBlurTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getIconTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("icon-translate", this.nativeGetIconTranslate());
    }

    public TransitionOptions getIconTranslateTransition() {
        this.checkThread();
        return this.nativeGetIconTranslateTransition();
    }

    public void setIconTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetIconTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getIconTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("icon-translate-anchor", this.nativeGetIconTranslateAnchor());
    }

    public PropertyValue<Float> getTextOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("text-opacity", this.nativeGetTextOpacity());
    }

    public TransitionOptions getTextOpacityTransition() {
        this.checkThread();
        return this.nativeGetTextOpacityTransition();
    }

    public void setTextOpacityTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextOpacityTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextColor() {
        this.checkThread();
        return new PropertyValue<Object>("text-color", this.nativeGetTextColor());
    }

    @ColorInt
    public int getTextColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getTextColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-color was set as a Function");
    }

    public TransitionOptions getTextColorTransition() {
        this.checkThread();
        return this.nativeGetTextColorTransition();
    }

    public void setTextColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextHaloColor() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-color", this.nativeGetTextHaloColor());
    }

    @ColorInt
    public int getTextHaloColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getTextHaloColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("text-halo-color was set as a Function");
    }

    public TransitionOptions getTextHaloColorTransition() {
        this.checkThread();
        return this.nativeGetTextHaloColorTransition();
    }

    public void setTextHaloColorTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloColorTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getTextHaloWidth() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-width", this.nativeGetTextHaloWidth());
    }

    public TransitionOptions getTextHaloWidthTransition() {
        this.checkThread();
        return this.nativeGetTextHaloWidthTransition();
    }

    public void setTextHaloWidthTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloWidthTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float> getTextHaloBlur() {
        this.checkThread();
        return new PropertyValue<Object>("text-halo-blur", this.nativeGetTextHaloBlur());
    }

    public TransitionOptions getTextHaloBlurTransition() {
        this.checkThread();
        return this.nativeGetTextHaloBlurTransition();
    }

    public void setTextHaloBlurTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextHaloBlurTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<Float[]> getTextTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("text-translate", this.nativeGetTextTranslate());
    }

    public TransitionOptions getTextTranslateTransition() {
        this.checkThread();
        return this.nativeGetTextTranslateTransition();
    }

    public void setTextTranslateTransition(TransitionOptions options) {
        this.checkThread();
        this.nativeSetTextTranslateTransition(options.getDuration(), options.getDelay());
    }

    public PropertyValue<String> getTextTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("text-translate-anchor", this.nativeGetTextTranslateAnchor());
    }

    private native Object nativeGetSymbolPlacement();

    private native Object nativeGetSymbolSpacing();

    private native Object nativeGetSymbolAvoidEdges();

    private native Object nativeGetIconAllowOverlap();

    private native Object nativeGetIconIgnorePlacement();

    private native Object nativeGetIconOptional();

    private native Object nativeGetIconRotationAlignment();

    private native Object nativeGetIconSize();

    private native Object nativeGetIconTextFit();

    private native Object nativeGetIconTextFitPadding();

    private native Object nativeGetIconImage();

    private native Object nativeGetIconRotate();

    private native Object nativeGetIconPadding();

    private native Object nativeGetIconKeepUpright();

    private native Object nativeGetIconOffset();

    private native Object nativeGetIconAnchor();

    private native Object nativeGetIconPitchAlignment();

    private native Object nativeGetTextPitchAlignment();

    private native Object nativeGetTextRotationAlignment();

    private native Object nativeGetTextField();

    private native Object nativeGetTextFont();

    private native Object nativeGetTextSize();

    private native Object nativeGetTextMaxWidth();

    private native Object nativeGetTextLineHeight();

    private native Object nativeGetTextLetterSpacing();

    private native Object nativeGetTextJustify();

    private native Object nativeGetTextAnchor();

    private native Object nativeGetTextMaxAngle();

    private native Object nativeGetTextRotate();

    private native Object nativeGetTextPadding();

    private native Object nativeGetTextKeepUpright();

    private native Object nativeGetTextTransform();

    private native Object nativeGetTextOffset();

    private native Object nativeGetTextAllowOverlap();

    private native Object nativeGetTextIgnorePlacement();

    private native Object nativeGetTextOptional();

    private native Object nativeGetIconOpacity();

    private native TransitionOptions nativeGetIconOpacityTransition();

    private native void nativeSetIconOpacityTransition(long var1, long var3);

    private native Object nativeGetIconColor();

    private native TransitionOptions nativeGetIconColorTransition();

    private native void nativeSetIconColorTransition(long var1, long var3);

    private native Object nativeGetIconHaloColor();

    private native TransitionOptions nativeGetIconHaloColorTransition();

    private native void nativeSetIconHaloColorTransition(long var1, long var3);

    private native Object nativeGetIconHaloWidth();

    private native TransitionOptions nativeGetIconHaloWidthTransition();

    private native void nativeSetIconHaloWidthTransition(long var1, long var3);

    private native Object nativeGetIconHaloBlur();

    private native TransitionOptions nativeGetIconHaloBlurTransition();

    private native void nativeSetIconHaloBlurTransition(long var1, long var3);

    private native Object nativeGetIconTranslate();

    private native TransitionOptions nativeGetIconTranslateTransition();

    private native void nativeSetIconTranslateTransition(long var1, long var3);

    private native Object nativeGetIconTranslateAnchor();

    private native Object nativeGetTextOpacity();

    private native TransitionOptions nativeGetTextOpacityTransition();

    private native void nativeSetTextOpacityTransition(long var1, long var3);

    private native Object nativeGetTextColor();

    private native TransitionOptions nativeGetTextColorTransition();

    private native void nativeSetTextColorTransition(long var1, long var3);

    private native Object nativeGetTextHaloColor();

    private native TransitionOptions nativeGetTextHaloColorTransition();

    private native void nativeSetTextHaloColorTransition(long var1, long var3);

    private native Object nativeGetTextHaloWidth();

    private native TransitionOptions nativeGetTextHaloWidthTransition();

    private native void nativeSetTextHaloWidthTransition(long var1, long var3);

    private native Object nativeGetTextHaloBlur();

    private native TransitionOptions nativeGetTextHaloBlurTransition();

    private native void nativeSetTextHaloBlurTransition(long var1, long var3);

    private native Object nativeGetTextTranslate();

    private native TransitionOptions nativeGetTextTranslateTransition();

    private native void nativeSetTextTranslateTransition(long var1, long var3);

    private native Object nativeGetTextTranslateAnchor();

    @Override
    protected native void finalize() throws Throwable;
}

