/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.AsyncTask;
import android.os.Handler;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.exceptions.CalledFromWorkerThreadException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CannotAddLayerException;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.CannotAddSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import timber.log.Timber;

final class NativeMapView {
    private final FileSource fileSource;
    private final MapRenderer mapRenderer;
    private final Thread thread;
    private ViewCallback viewCallback;
    private final float pixelRatio;
    private boolean destroyed = false;
    private long nativePtr = 0L;
    private MapboxMap.SnapshotReadyCallback snapshotReadyCallback;
    private final CopyOnWriteArrayList<MapView.OnMapChangedListener> onMapChangedListeners = new CopyOnWriteArrayList();

    public NativeMapView(Context context, ViewCallback viewCallback, MapRenderer mapRenderer) {
        this(context, context.getResources().getDisplayMetrics().density, viewCallback, mapRenderer);
    }

    public NativeMapView(Context context, float pixelRatio, ViewCallback viewCallback, MapRenderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        this.viewCallback = viewCallback;
        this.fileSource = FileSource.getInstance(context);
        this.pixelRatio = pixelRatio;
        this.thread = Thread.currentThread();
        this.nativeInitialize(this, this.fileSource, mapRenderer, pixelRatio);
    }

    private boolean checkState(String callingMethod) {
        if (this.thread != Thread.currentThread()) {
            throw new CalledFromWorkerThreadException(String.format("Map interactions should happen on the UI thread. Method invoked from wrong thread is %s.", callingMethod));
        }
        if (this.destroyed && !TextUtils.isEmpty((CharSequence)callingMethod)) {
            Timber.e((String)"You're calling `%s` after the `MapView` was destroyed, were you invoking it after `onDestroy()`?", (Object[])new Object[]{callingMethod});
        }
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
        this.onMapChangedListeners.clear();
        this.viewCallback = null;
        this.nativeDestroy();
    }

    public void update() {
        if (this.checkState("update")) {
            return;
        }
        this.mapRenderer.requestRender();
    }

    public void resizeView(int width, int height) {
        if (this.checkState("resizeView")) {
            return;
        }
        width = (int)Math.ceil((float)width / this.pixelRatio);
        height = (int)Math.ceil((float)height / this.pixelRatio);
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            Timber.e((String)"Device returned an out of range width size, capping value at 65535 instead of %s", (Object[])new Object[]{width});
            width = 65535;
        }
        if (height > 65535) {
            Timber.e((String)"Device returned an out of range height size, capping value at 65535 instead of %s", (Object[])new Object[]{height});
            height = 65535;
        }
        this.nativeResizeView(width, height);
    }

    public void setStyleUrl(String url) {
        if (this.checkState("setStyleUrl")) {
            return;
        }
        this.nativeSetStyleUrl(url);
    }

    public String getStyleUrl() {
        if (this.checkState("getStyleUrl")) {
            return null;
        }
        return this.nativeGetStyleUrl();
    }

    public void setStyleJson(String newStyleJson) {
        if (this.checkState("setStyleJson")) {
            return;
        }
        this.nativeSetStyleJson(newStyleJson);
    }

    public String getStyleJson() {
        if (this.checkState("getStyleJson")) {
            return null;
        }
        return this.nativeGetStyleJson();
    }

    public void setLatLngBounds(LatLngBounds latLngBounds) {
        if (this.checkState("setLatLngBounds")) {
            return;
        }
        this.nativeSetLatLngBounds(latLngBounds);
    }

    public void cancelTransitions() {
        if (this.checkState("cancelTransitions")) {
            return;
        }
        this.nativeCancelTransitions();
    }

    public void setGestureInProgress(boolean inProgress) {
        if (this.checkState("setGestureInProgress")) {
            return;
        }
        this.nativeSetGestureInProgress(inProgress);
    }

    public void moveBy(double dx, double dy) {
        if (this.checkState("moveBy")) {
            return;
        }
        this.moveBy(dx, dy, 0L);
    }

    public void moveBy(double dx, double dy, long duration) {
        if (this.checkState("moveBy")) {
            return;
        }
        this.nativeMoveBy(dx / (double)this.pixelRatio, dy / (double)this.pixelRatio, duration);
    }

    public void setLatLng(LatLng latLng) {
        if (this.checkState("setLatLng")) {
            return;
        }
        this.setLatLng(latLng, 0L);
    }

    public void setLatLng(LatLng latLng, long duration) {
        if (this.checkState("setLatLng")) {
            return;
        }
        this.nativeSetLatLng(latLng.getLatitude(), latLng.getLongitude(), duration);
    }

    public LatLng getLatLng() {
        if (this.checkState("")) {
            return new LatLng();
        }
        return this.nativeGetLatLng().wrap();
    }

    public CameraPosition getCameraForLatLngBounds(LatLngBounds bounds, int[] padding, double bearing, double tilt) {
        if (this.checkState("getCameraForLatLngBounds")) {
            return null;
        }
        return this.nativeGetCameraForLatLngBounds(bounds, (float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio, bearing, tilt);
    }

    public CameraPosition getCameraForGeometry(Geometry geometry, int[] padding, double bearing, double tilt) {
        if (this.checkState("getCameraForGeometry")) {
            return null;
        }
        return this.nativeGetCameraForGeometry(geometry, (float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio, bearing, tilt);
    }

    public void resetPosition() {
        if (this.checkState("resetPosition")) {
            return;
        }
        this.nativeResetPosition();
    }

    public double getPitch() {
        if (this.checkState("getPitch")) {
            return 0.0;
        }
        return this.nativeGetPitch();
    }

    public void setPitch(double pitch, long duration) {
        if (this.checkState("setPitch")) {
            return;
        }
        this.nativeSetPitch(pitch, duration);
    }

    public void setZoom(double zoom, PointF focalPoint, long duration) {
        if (this.checkState("setZoom")) {
            return;
        }
        this.nativeSetZoom(zoom, focalPoint.x / this.pixelRatio, focalPoint.y / this.pixelRatio, duration);
    }

    public double getZoom() {
        if (this.checkState("getZoom")) {
            return 0.0;
        }
        return this.nativeGetZoom();
    }

    public void resetZoom() {
        if (this.checkState("resetZoom")) {
            return;
        }
        this.nativeResetZoom();
    }

    public void setMinZoom(double zoom) {
        if (this.checkState("setMinZoom")) {
            return;
        }
        this.nativeSetMinZoom(zoom);
    }

    public double getMinZoom() {
        if (this.checkState("getMinZoom")) {
            return 0.0;
        }
        return this.nativeGetMinZoom();
    }

    public void setMaxZoom(double zoom) {
        if (this.checkState("setMaxZoom")) {
            return;
        }
        this.nativeSetMaxZoom(zoom);
    }

    public double getMaxZoom() {
        if (this.checkState("getMaxZoom")) {
            return 0.0;
        }
        return this.nativeGetMaxZoom();
    }

    public void rotateBy(double sx, double sy, double ex, double ey) {
        if (this.checkState("rotateBy")) {
            return;
        }
        this.rotateBy(sx, sy, ex, ey, 0L);
    }

    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        if (this.checkState("rotateBy")) {
            return;
        }
        this.nativeRotateBy(sx / (double)this.pixelRatio, sy / (double)this.pixelRatio, ex, ey, duration);
    }

    public void setContentPadding(int[] padding) {
        if (this.checkState("setContentPadding")) {
            return;
        }
        this.nativeSetContentPadding((float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio);
    }

    public void setBearing(double degrees) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.setBearing(degrees, 0L);
    }

    public void setBearing(double degrees, long duration) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.nativeSetBearing(degrees, duration);
    }

    public void setBearing(double degrees, double cx, double cy) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.setBearing(degrees, cx, cy, 0L);
    }

    public void setBearing(double degrees, double fx, double fy, long duration) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.nativeSetBearingXY(degrees, fx / (double)this.pixelRatio, fy / (double)this.pixelRatio, duration);
    }

    public double getBearing() {
        if (this.checkState("getBearing")) {
            return 0.0;
        }
        return this.nativeGetBearing();
    }

    public void resetNorth() {
        if (this.checkState("resetNorth")) {
            return;
        }
        this.nativeResetNorth();
    }

    public long addMarker(Marker marker) {
        if (this.checkState("addMarker")) {
            return 0L;
        }
        Marker[] markers = new Marker[]{marker};
        return this.nativeAddMarkers(markers)[0];
    }

    public long[] addMarkers(List<Marker> markers) {
        if (this.checkState("addMarkers")) {
            return new long[0];
        }
        return this.nativeAddMarkers(markers.toArray(new Marker[markers.size()]));
    }

    public long addPolyline(Polyline polyline) {
        if (this.checkState("addPolyline")) {
            return 0L;
        }
        Polyline[] polylines = new Polyline[]{polyline};
        return this.nativeAddPolylines(polylines)[0];
    }

    public long[] addPolylines(List<Polyline> polylines) {
        if (this.checkState("addPolylines")) {
            return new long[0];
        }
        return this.nativeAddPolylines(polylines.toArray(new Polyline[polylines.size()]));
    }

    public long addPolygon(Polygon polygon) {
        if (this.checkState("addPolygon")) {
            return 0L;
        }
        Polygon[] polygons = new Polygon[]{polygon};
        return this.nativeAddPolygons(polygons)[0];
    }

    public long[] addPolygons(List<Polygon> polygons) {
        if (this.checkState("addPolygons")) {
            return new long[0];
        }
        return this.nativeAddPolygons(polygons.toArray(new Polygon[polygons.size()]));
    }

    public void updateMarker(Marker marker) {
        if (this.checkState("updateMarker")) {
            return;
        }
        LatLng position = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(marker.getId(), position.getLatitude(), position.getLongitude(), icon.getId());
    }

    public void updatePolygon(Polygon polygon) {
        if (this.checkState("updatePolygon")) {
            return;
        }
        this.nativeUpdatePolygon(polygon.getId(), polygon);
    }

    public void updatePolyline(Polyline polyline) {
        if (this.checkState("updatePolyline")) {
            return;
        }
        this.nativeUpdatePolyline(polyline.getId(), polyline);
    }

    public void removeAnnotation(long id2) {
        if (this.checkState("removeAnnotation")) {
            return;
        }
        long[] ids = new long[]{id2};
        this.removeAnnotations(ids);
    }

    public void removeAnnotations(long[] ids) {
        if (this.checkState("removeAnnotations")) {
            return;
        }
        this.nativeRemoveAnnotations(ids);
    }

    public long[] queryPointAnnotations(RectF rect) {
        if (this.checkState("queryPointAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryPointAnnotations(rect);
    }

    public long[] queryShapeAnnotations(RectF rectF) {
        if (this.checkState("queryShapeAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryShapeAnnotations(rectF);
    }

    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        if (this.checkState("addAnnotationIcon")) {
            return;
        }
        this.nativeAddAnnotationIcon(symbol, width, height, scale, pixels);
    }

    public void removeAnnotationIcon(String symbol) {
        if (this.checkState("removeAnnotationIcon")) {
            return;
        }
        this.nativeRemoveAnnotationIcon(symbol);
    }

    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        if (this.checkState("setVisibleCoordinateBounds")) {
            return;
        }
        this.nativeSetVisibleCoordinateBounds(coordinates, padding, direction, duration);
    }

    public void onLowMemory() {
        if (this.checkState("onLowMemory")) {
            return;
        }
        this.nativeOnLowMemory();
    }

    public void setDebug(boolean debug) {
        if (this.checkState("setDebug")) {
            return;
        }
        this.nativeSetDebug(debug);
    }

    public void cycleDebugOptions() {
        if (this.checkState("cycleDebugOptions")) {
            return;
        }
        this.nativeCycleDebugOptions();
    }

    public boolean getDebug() {
        if (this.checkState("getDebug")) {
            return false;
        }
        return this.nativeGetDebug();
    }

    public boolean isFullyLoaded() {
        if (this.checkState("isFullyLoaded")) {
            return false;
        }
        return this.nativeIsFullyLoaded();
    }

    public void setReachability(boolean status) {
        if (this.checkState("setReachability")) {
            return;
        }
        this.nativeSetReachability(status);
    }

    public double getMetersPerPixelAtLatitude(double lat) {
        if (this.checkState("getMetersPerPixelAtLatitude")) {
            return 0.0;
        }
        return this.nativeGetMetersPerPixelAtLatitude(lat, this.getZoom()) / (double)this.pixelRatio;
    }

    public ProjectedMeters projectedMetersForLatLng(LatLng latLng) {
        if (this.checkState("projectedMetersForLatLng")) {
            return null;
        }
        return this.nativeProjectedMetersForLatLng(latLng.getLatitude(), latLng.getLongitude());
    }

    public LatLng latLngForProjectedMeters(ProjectedMeters projectedMeters) {
        if (this.checkState("latLngForProjectedMeters")) {
            return new LatLng();
        }
        return this.nativeLatLngForProjectedMeters(projectedMeters.getNorthing(), projectedMeters.getEasting()).wrap();
    }

    public PointF pixelForLatLng(LatLng latLng) {
        if (this.checkState("pixelForLatLng")) {
            return new PointF();
        }
        PointF pointF = this.nativePixelForLatLng(latLng.getLatitude(), latLng.getLongitude());
        pointF.set(pointF.x * this.pixelRatio, pointF.y * this.pixelRatio);
        return pointF;
    }

    public LatLng latLngForPixel(PointF pixel) {
        if (this.checkState("latLngForPixel")) {
            return new LatLng();
        }
        return this.nativeLatLngForPixel(pixel.x / this.pixelRatio, pixel.y / this.pixelRatio).wrap();
    }

    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        if (this.checkState("getTopOffsetPixelsForAnnotationSymbol")) {
            return 0.0;
        }
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(symbolName);
    }

    public void jumpTo(double angle, LatLng center, double pitch, double zoom) {
        if (this.checkState("jumpTo")) {
            return;
        }
        this.nativeJumpTo(angle, center.getLatitude(), center.getLongitude(), pitch, zoom);
    }

    public void easeTo(double angle, LatLng center, long duration, double pitch, double zoom, boolean easingInterpolator) {
        if (this.checkState("easeTo")) {
            return;
        }
        this.nativeEaseTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, easingInterpolator);
    }

    public void flyTo(double angle, LatLng center, long duration, double pitch, double zoom) {
        if (this.checkState("flyTo")) {
            return;
        }
        this.nativeFlyTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom);
    }

    public CameraPosition getCameraPosition() {
        if (this.checkState("getCameraValues")) {
            return new CameraPosition.Builder().build();
        }
        return this.nativeGetCameraPosition();
    }

    public void setPrefetchesTiles(boolean enable) {
        if (this.checkState("setPrefetchesTiles")) {
            return;
        }
        this.nativeSetPrefetchesTiles(enable);
    }

    public boolean getPrefetchesTiles() {
        if (this.checkState("getPrefetchesTiles")) {
            return false;
        }
        return this.nativeGetPrefetchesTiles();
    }

    public long getTransitionDuration() {
        return this.nativeGetTransitionDuration();
    }

    public void setTransitionDuration(long duration) {
        this.nativeSetTransitionDuration(duration);
    }

    public long getTransitionDelay() {
        return this.nativeGetTransitionDelay();
    }

    public void setTransitionDelay(long delay) {
        this.nativeSetTransitionDelay(delay);
    }

    public List<Layer> getLayers() {
        if (this.checkState("getLayers")) {
            return null;
        }
        return Arrays.asList(this.nativeGetLayers());
    }

    public Layer getLayer(String layerId) {
        if (this.checkState("getLayer")) {
            return null;
        }
        return this.nativeGetLayer(layerId);
    }

    public void addLayer(@NonNull Layer layer) {
        if (this.checkState("addLayer")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), null);
    }

    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        if (this.checkState("addLayerBelow")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), below);
    }

    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        if (this.checkState("addLayerAbove")) {
            return;
        }
        this.nativeAddLayerAbove(layer.getNativePtr(), above);
    }

    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        if (this.checkState("addLayerAt")) {
            return;
        }
        this.nativeAddLayerAt(layer.getNativePtr(), index);
    }

    @Nullable
    public Layer removeLayer(@NonNull String layerId) {
        if (this.checkState("removeLayer")) {
            return null;
        }
        return this.nativeRemoveLayerById(layerId);
    }

    @Nullable
    public Layer removeLayer(@NonNull Layer layer) {
        if (this.checkState("removeLayer")) {
            return null;
        }
        this.nativeRemoveLayer(layer.getNativePtr());
        return layer;
    }

    @Nullable
    public Layer removeLayerAt(@IntRange(from=0L) int index) {
        if (this.checkState("removeLayerAt")) {
            return null;
        }
        return this.nativeRemoveLayerAt(index);
    }

    public List<Source> getSources() {
        if (this.checkState("getSources")) {
            return null;
        }
        return Arrays.asList(this.nativeGetSources());
    }

    public Source getSource(@NonNull String sourceId) {
        if (this.checkState("getSource")) {
            return null;
        }
        return this.nativeGetSource(sourceId);
    }

    public void addSource(@NonNull Source source) {
        if (this.checkState("addSource")) {
            return;
        }
        this.nativeAddSource(source, source.getNativePtr());
    }

    @Nullable
    public Source removeSource(@NonNull String sourceId) {
        if (this.checkState("removeSource")) {
            return null;
        }
        Source source = this.getSource(sourceId);
        if (source != null) {
            return this.removeSource(source);
        }
        return null;
    }

    @Nullable
    public Source removeSource(@NonNull Source source) {
        if (this.checkState("removeSource")) {
            return null;
        }
        this.nativeRemoveSource(source, source.getNativePtr());
        return source;
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image, boolean sdf) {
        if (this.checkState("addImage")) {
            return;
        }
        float pixelRatio = (float)image.getDensity() / 160.0f;
        this.nativeAddImage(name, image, pixelRatio, sdf);
    }

    public void addImages(@NonNull HashMap<String, Bitmap> bitmapHashMap) {
        if (this.checkState("addImages")) {
            return;
        }
        this.addImages(bitmapHashMap, false);
    }

    public void addImages(@NonNull HashMap<String, Bitmap> bitmapHashMap, boolean sdf) {
        if (this.checkState("addImages")) {
            return;
        }
        new BitmapImageConversionTask(this, sdf).execute(new HashMap[]{bitmapHashMap});
    }

    public void removeImage(String name) {
        if (this.checkState("removeImage")) {
            return;
        }
        this.nativeRemoveImage(name);
    }

    public Bitmap getImage(String name) {
        if (this.checkState("getImage")) {
            return null;
        }
        return this.nativeGetImage(name);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable String[] layerIds, @Nullable Expression filter) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForPoint(coordinates.x / this.pixelRatio, coordinates.y / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable String[] layerIds, @Nullable Expression filter) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForBox(coordinates.left / this.pixelRatio, coordinates.top / this.pixelRatio, coordinates.right / this.pixelRatio, coordinates.bottom / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    public void setApiBaseUrl(String baseUrl) {
        if (this.checkState("setApiBaseUrl")) {
            return;
        }
        this.fileSource.setApiBaseUrl(baseUrl);
    }

    public Light getLight() {
        if (this.checkState("getLight")) {
            return null;
        }
        return this.nativeGetLight();
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    RectF getDensityDependantRectangle(RectF rectangle) {
        return new RectF(rectangle.left / this.pixelRatio, rectangle.top / this.pixelRatio, rectangle.right / this.pixelRatio, rectangle.bottom / this.pixelRatio);
    }

    protected void onMapChanged(int rawChange) {
        for (MapView.OnMapChangedListener onMapChangedListener : this.onMapChangedListeners) {
            try {
                onMapChangedListener.onMapChanged(rawChange);
            }
            catch (RuntimeException err) {
                Timber.e((Throwable)err, (String)"Exception in MapView.OnMapChangedListener", (Object[])new Object[0]);
            }
        }
    }

    protected void onSnapshotReady(Bitmap mapContent) {
        if (this.checkState("OnSnapshotReady")) {
            return;
        }
        Bitmap viewContent = this.viewCallback.getViewContent();
        if (this.snapshotReadyCallback != null && mapContent != null && viewContent != null) {
            this.snapshotReadyCallback.onSnapshotReady(BitmapUtils.mergeBitmap(mapContent, viewContent));
        }
    }

    private native void nativeInitialize(NativeMapView var1, FileSource var2, MapRenderer var3, float var4);

    private native void nativeDestroy();

    private native void nativeResizeView(int var1, int var2);

    private native void nativeSetStyleUrl(String var1);

    private native String nativeGetStyleUrl();

    private native void nativeSetStyleJson(String var1);

    private native String nativeGetStyleJson();

    private native void nativeSetLatLngBounds(LatLngBounds var1);

    private native void nativeCancelTransitions();

    private native void nativeSetGestureInProgress(boolean var1);

    private native void nativeMoveBy(double var1, double var3, long var5);

    private native void nativeSetLatLng(double var1, double var3, long var5);

    private native LatLng nativeGetLatLng();

    private native CameraPosition nativeGetCameraForLatLngBounds(LatLngBounds var1, double var2, double var4, double var6, double var8, double var10, double var12);

    private native CameraPosition nativeGetCameraForGeometry(Geometry var1, double var2, double var4, double var6, double var8, double var10, double var12);

    private native void nativeResetPosition();

    private native double nativeGetPitch();

    private native void nativeSetPitch(double var1, long var3);

    private native void nativeSetZoom(double var1, double var3, double var5, long var7);

    private native double nativeGetZoom();

    private native void nativeResetZoom();

    private native void nativeSetMinZoom(double var1);

    private native double nativeGetMinZoom();

    private native void nativeSetMaxZoom(double var1);

    private native double nativeGetMaxZoom();

    private native void nativeRotateBy(double var1, double var3, double var5, double var7, long var9);

    private native void nativeSetContentPadding(double var1, double var3, double var5, double var7);

    private native void nativeSetBearing(double var1, long var3);

    private native void nativeSetBearingXY(double var1, double var3, double var5, long var7);

    private native double nativeGetBearing();

    private native void nativeResetNorth();

    private native void nativeUpdateMarker(long var1, double var3, double var5, String var7);

    private native long[] nativeAddMarkers(Marker[] var1);

    private native long[] nativeAddPolylines(Polyline[] var1);

    private native long[] nativeAddPolygons(Polygon[] var1);

    private native void nativeRemoveAnnotations(long[] var1);

    private native long[] nativeQueryPointAnnotations(RectF var1);

    private native long[] nativeQueryShapeAnnotations(RectF var1);

    private native void nativeAddAnnotationIcon(String var1, int var2, int var3, float var4, byte[] var5);

    private native void nativeRemoveAnnotationIcon(String var1);

    private native void nativeSetVisibleCoordinateBounds(LatLng[] var1, RectF var2, double var3, long var5);

    private native void nativeOnLowMemory();

    private native void nativeSetDebug(boolean var1);

    private native void nativeCycleDebugOptions();

    private native boolean nativeGetDebug();

    private native boolean nativeIsFullyLoaded();

    private native void nativeSetReachability(boolean var1);

    private native double nativeGetMetersPerPixelAtLatitude(double var1, double var3);

    private native ProjectedMeters nativeProjectedMetersForLatLng(double var1, double var3);

    private native LatLng nativeLatLngForProjectedMeters(double var1, double var3);

    private native PointF nativePixelForLatLng(double var1, double var3);

    private native LatLng nativeLatLngForPixel(float var1, float var2);

    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(String var1);

    private native void nativeJumpTo(double var1, double var3, double var5, double var7, double var9);

    private native void nativeEaseTo(double var1, double var3, double var5, long var7, double var9, double var11, boolean var13);

    private native void nativeFlyTo(double var1, double var3, double var5, long var7, double var9, double var11);

    private native CameraPosition nativeGetCameraPosition();

    private native long nativeGetTransitionDuration();

    private native void nativeSetTransitionDuration(long var1);

    private native long nativeGetTransitionDelay();

    private native void nativeSetTransitionDelay(long var1);

    private native Layer[] nativeGetLayers();

    private native Layer nativeGetLayer(String var1);

    private native void nativeAddLayer(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAbove(long var1, String var3) throws CannotAddLayerException;

    private native void nativeAddLayerAt(long var1, int var3) throws CannotAddLayerException;

    private native Layer nativeRemoveLayerById(String var1);

    private native void nativeRemoveLayer(long var1);

    private native Layer nativeRemoveLayerAt(int var1);

    private native Source[] nativeGetSources();

    private native Source nativeGetSource(String var1);

    private native void nativeAddSource(Source var1, long var2) throws CannotAddSourceException;

    private native void nativeRemoveSource(Source var1, long var2);

    private native void nativeAddImage(String var1, Bitmap var2, float var3, boolean var4);

    private native void nativeAddImages(Image[] var1);

    private native void nativeRemoveImage(String var1);

    private native Bitmap nativeGetImage(String var1);

    private native void nativeUpdatePolygon(long var1, Polygon var3);

    private native void nativeUpdatePolyline(long var1, Polyline var3);

    private native void nativeTakeSnapshot();

    private native Feature[] nativeQueryRenderedFeaturesForPoint(float var1, float var2, String[] var3, Object[] var4);

    private native Feature[] nativeQueryRenderedFeaturesForBox(float var1, float var2, float var3, float var4, String[] var5, Object[] var6);

    private native Light nativeGetLight();

    private native void nativeSetPrefetchesTiles(boolean var1);

    private native boolean nativeGetPrefetchesTiles();

    int getWidth() {
        if (this.checkState("")) {
            return 0;
        }
        return this.viewCallback.getWidth();
    }

    int getHeight() {
        if (this.checkState("")) {
            return 0;
        }
        return this.viewCallback.getHeight();
    }

    void addOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        this.onMapChangedListeners.add(listener);
    }

    void removeOnMapChangedListener(@NonNull MapView.OnMapChangedListener listener) {
        if (this.onMapChangedListeners.contains(listener)) {
            this.onMapChangedListeners.remove(listener);
        }
    }

    void addSnapshotCallback(@NonNull MapboxMap.SnapshotReadyCallback callback) {
        if (this.checkState("addSnapshotCallback")) {
            return;
        }
        this.snapshotReadyCallback = callback;
        this.nativeTakeSnapshot();
    }

    public void setOnFpsChangedListener(final MapboxMap.OnFpsChangedListener listener) {
        final Handler handler = new Handler();
        this.mapRenderer.queueEvent(new Runnable(){

            @Override
            public void run() {
                NativeMapView.this.mapRenderer.setOnFpsChangedListener(new MapboxMap.OnFpsChangedListener(){

                    @Override
                    public void onFpsChanged(final double fps) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onFpsChanged(fps);
                            }
                        });
                    }
                });
            }
        });
    }

    static {
        LibraryLoader.load();
    }

    public static interface ViewCallback {
        public int getWidth();

        public int getHeight();

        public Bitmap getViewContent();
    }

    private static class BitmapImageConversionTask
    extends AsyncTask<HashMap<String, Bitmap>, Void, List<Image>> {
        private NativeMapView nativeMapView;
        private boolean sdf;

        BitmapImageConversionTask(NativeMapView nativeMapView, boolean sdf) {
            this.nativeMapView = nativeMapView;
            this.sdf = sdf;
        }

        protected List<Image> doInBackground(HashMap<String, Bitmap> ... params) {
            HashMap<String, Bitmap> bitmapHashMap = params[0];
            ArrayList<Image> images = new ArrayList<Image>();
            for (Map.Entry<String, Bitmap> stringBitmapEntry : bitmapHashMap.entrySet()) {
                String name = stringBitmapEntry.getKey();
                Bitmap bitmap = stringBitmapEntry.getValue();
                if (bitmap.getConfig() != Bitmap.Config.ARGB_8888) {
                    bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, false);
                }
                ByteBuffer buffer = ByteBuffer.allocate(bitmap.getByteCount());
                bitmap.copyPixelsToBuffer((Buffer)buffer);
                float pixelRatio = (float)bitmap.getDensity() / 160.0f;
                images.add(new Image(buffer.array(), pixelRatio, name, bitmap.getWidth(), bitmap.getHeight(), this.sdf));
            }
            return images;
        }

        protected void onPostExecute(List<Image> images) {
            super.onPostExecute(images);
            if (this.nativeMapView != null && !this.nativeMapView.checkState("nativeAddImages")) {
                this.nativeMapView.nativeAddImages(images.toArray(new Image[images.size()]));
            }
        }
    }
}

