/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps.renderer;

import android.content.Context;
import android.support.annotation.CallSuper;
import android.support.annotation.Keep;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererRunnable;
import com.mapbox.mapboxsdk.maps.renderer.MapRendererScheduler;
import com.mapbox.mapboxsdk.storage.FileSource;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@Keep
public abstract class MapRenderer
implements MapRendererScheduler {
    private long nativePtr = 0L;
    private MapboxMap.OnFpsChangedListener onFpsChangedListener;
    private long frames;
    private long timeElapsed;

    public MapRenderer(Context context, String localIdeographFontFamily) {
        FileSource fileSource = FileSource.getInstance(context);
        float pixelRatio = context.getResources().getDisplayMetrics().density;
        String programCacheDir = context.getCacheDir().getAbsolutePath();
        this.nativeInitialize(this, fileSource, pixelRatio, programCacheDir, localIdeographFontFamily);
    }

    public void onStart() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }

    public void setOnFpsChangedListener(MapboxMap.OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
    }

    @CallSuper
    protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.nativeOnSurfaceCreated();
    }

    @CallSuper
    protected void onSurfaceChanged(GL10 gl, int width, int height) {
        gl.glViewport(0, 0, width, height);
        this.nativeOnSurfaceChanged(width, height);
    }

    @CallSuper
    protected void onDrawFrame(GL10 gl) {
        this.nativeRender();
        if (this.onFpsChangedListener != null) {
            this.updateFps();
        }
    }

    @CallSuper
    void queueEvent(MapRendererRunnable runnable) {
        this.queueEvent((Runnable)runnable);
    }

    private native void nativeInitialize(MapRenderer var1, FileSource var2, float var3, String var4, String var5);

    @CallSuper
    protected native void finalize() throws Throwable;

    private native void nativeOnSurfaceCreated();

    private native void nativeOnSurfaceChanged(int var1, int var2);

    private native void nativeRender();

    private void updateFps() {
        ++this.frames;
        long currentTime = System.nanoTime();
        double fps = 0.0;
        if (currentTime - this.timeElapsed >= 1L) {
            fps = (double)this.frames / ((double)(currentTime - this.timeElapsed) / 1.0E9);
            this.onFpsChangedListener.onFpsChanged(fps);
            this.timeElapsed = currentTime;
            this.frames = 0L;
        }
    }
}

