/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.expressions;

import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Expression {
    private final String operator;
    private final Expression[] arguments;

    Expression() {
        this.operator = null;
        this.arguments = null;
    }

    public Expression(@NonNull String operator, Expression ... arguments) {
        this.operator = operator;
        this.arguments = arguments;
    }

    public static Expression literal(@NonNull Number number) {
        return new ExpressionLiteral(number);
    }

    public static Expression literal(@NonNull String string2) {
        return new ExpressionLiteral(string2);
    }

    public static Expression literal(boolean bool) {
        return new ExpressionLiteral(bool);
    }

    public static Expression literal(@NonNull Object object) {
        if (object.getClass().isArray()) {
            return Expression.literal(ExpressionArray.toObjectArray(object));
        }
        if (object instanceof Expression) {
            throw new RuntimeException("Can't convert an expression to a literal");
        }
        return new ExpressionLiteral(object);
    }

    public static Expression literal(@NonNull Object[] array) {
        return new ExpressionArray(array);
    }

    public static Expression color(@ColorInt int color2) {
        float[] rgba = PropertyFactory.colorToRgbaArray(color2);
        return Expression.rgba(Float.valueOf(rgba[0]), Float.valueOf(rgba[1]), Float.valueOf(rgba[2]), Float.valueOf(rgba[3]));
    }

    public static Expression rgb(@NonNull Expression red, @NonNull Expression green, @NonNull Expression blue) {
        return new Expression("rgb", red, green, blue);
    }

    public static Expression rgb(@NonNull Number red, @NonNull Number green, @NonNull Number blue) {
        return Expression.rgb(Expression.literal(red), Expression.literal(green), Expression.literal(blue));
    }

    public static Expression rgba(@NonNull Expression red, @NonNull Expression green, @NonNull Expression blue, @NonNull Expression alpha) {
        return new Expression("rgba", red, green, blue, alpha);
    }

    public static Expression rgba(@NonNull Number red, @NonNull Number green, @NonNull Number blue, @NonNull Number alpha) {
        return Expression.rgba(Expression.literal(red), Expression.literal(green), Expression.literal(blue), Expression.literal(alpha));
    }

    public static Expression toRgba(@NonNull Expression expression) {
        return new Expression("to-rgba", expression);
    }

    public static Expression eq(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression("==", compareOne, compareTwo);
    }

    public static Expression eq(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression("==", compareOne, compareTwo, collator);
    }

    public static Expression eq(Expression compareOne, boolean compareTwo) {
        return Expression.eq(compareOne, Expression.literal(compareTwo));
    }

    public static Expression eq(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return Expression.eq(compareOne, Expression.literal(compareTwo));
    }

    public static Expression eq(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return Expression.eq(compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression eq(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return Expression.eq(compareOne, Expression.literal(compareTwo));
    }

    public static Expression neq(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression("!=", compareOne, compareTwo);
    }

    public static Expression neq(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression("!=", compareOne, compareTwo, collator);
    }

    public static Expression neq(Expression compareOne, boolean compareTwo) {
        return new Expression("!=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression neq(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return new Expression("!=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression neq(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return new Expression("!=", compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression neq(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return new Expression("!=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression gt(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression(">", compareOne, compareTwo);
    }

    public static Expression gt(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression(">", compareOne, compareTwo, collator);
    }

    public static Expression gt(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return new Expression(">", compareOne, Expression.literal(compareTwo));
    }

    public static Expression gt(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return new Expression(">", compareOne, Expression.literal(compareTwo));
    }

    public static Expression gt(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return new Expression(">", compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression lt(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression("<", compareOne, compareTwo);
    }

    public static Expression lt(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression("<", compareOne, compareTwo, collator);
    }

    public static Expression lt(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return new Expression("<", compareOne, Expression.literal(compareTwo));
    }

    public static Expression lt(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return new Expression("<", compareOne, Expression.literal(compareTwo));
    }

    public static Expression lt(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return new Expression("<", compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression gte(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression(">=", compareOne, compareTwo);
    }

    public static Expression gte(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression(">=", compareOne, compareTwo, collator);
    }

    public static Expression gte(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return new Expression(">=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression gte(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return new Expression(">=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression gte(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return new Expression(">=", compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression lte(@NonNull Expression compareOne, @NonNull Expression compareTwo) {
        return new Expression("<=", compareOne, compareTwo);
    }

    public static Expression lte(@NonNull Expression compareOne, @NonNull Expression compareTwo, @NonNull Expression collator) {
        return new Expression("<=", compareOne, compareTwo, collator);
    }

    public static Expression lte(@NonNull Expression compareOne, @NonNull Number compareTwo) {
        return new Expression("<=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression lte(@NonNull Expression compareOne, @NonNull String compareTwo) {
        return new Expression("<=", compareOne, Expression.literal(compareTwo));
    }

    public static Expression lte(@NonNull Expression compareOne, @NonNull String compareTwo, @NonNull Expression collator) {
        return new Expression("<=", compareOne, Expression.literal(compareTwo), collator);
    }

    public static Expression all(Expression ... input) {
        return new Expression("all", input);
    }

    public static Expression any(Expression ... input) {
        return new Expression("any", input);
    }

    public static Expression not(@NonNull Expression input) {
        return new Expression("!", input);
    }

    public static Expression not(boolean input) {
        return Expression.not(Expression.literal(input));
    }

    public static Expression switchCase(Expression ... input) {
        return new Expression("case", input);
    }

    public static Expression match(Expression ... input) {
        return new Expression("match", input);
    }

    public static Expression match(@NonNull Expression input, @NonNull Expression defaultOutput, Stop ... stops) {
        return Expression.match(Expression.join(Expression.join(new Expression[]{input}, Stop.toExpressionArray(stops)), new Expression[]{defaultOutput}));
    }

    public static Expression coalesce(Expression ... input) {
        return new Expression("coalesce", input);
    }

    public static Expression properties() {
        return new Expression("properties", new Expression[0]);
    }

    public static Expression geometryType() {
        return new Expression("geometry-type", new Expression[0]);
    }

    public static Expression id() {
        return new Expression("id", new Expression[0]);
    }

    public static Expression heatmapDensity() {
        return new Expression("heatmap-density", new Expression[0]);
    }

    public static Expression lineProgress() {
        return new Expression("line-progress", new Expression[0]);
    }

    public static Expression at(@NonNull Expression number, @NonNull Expression expression) {
        return new Expression("at", number, expression);
    }

    public static Expression at(@NonNull Number number, @NonNull Expression expression) {
        return Expression.at(Expression.literal(number), expression);
    }

    public static Expression get(@NonNull Expression input) {
        return new Expression("get", input);
    }

    public static Expression get(@NonNull String input) {
        return Expression.get(Expression.literal(input));
    }

    public static Expression get(@NonNull Expression key, @NonNull Expression object) {
        return new Expression("get", key, object);
    }

    public static Expression get(@NonNull String key, @NonNull Expression object) {
        return Expression.get(Expression.literal(key), object);
    }

    public static Expression has(@NonNull Expression key) {
        return new Expression("has", key);
    }

    public static Expression has(@NonNull String key) {
        return Expression.has(Expression.literal(key));
    }

    public static Expression has(@NonNull Expression key, @NonNull Expression object) {
        return new Expression("has", key, object);
    }

    public static Expression has(@NonNull String key, @NonNull Expression object) {
        return Expression.has(Expression.literal(key), object);
    }

    public static Expression length(@NonNull Expression expression) {
        return new Expression("length", expression);
    }

    public static Expression length(@NonNull String input) {
        return Expression.length(Expression.literal(input));
    }

    public static Expression ln2() {
        return new Expression("ln2", new Expression[0]);
    }

    public static Expression pi() {
        return new Expression("pi", new Expression[0]);
    }

    public static Expression e() {
        return new Expression("e", new Expression[0]);
    }

    public static Expression sum(Expression ... numbers) {
        return new Expression("+", numbers);
    }

    public static Expression sum(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.sum(numberExpression);
    }

    public static Expression product(Expression ... numbers) {
        return new Expression("*", numbers);
    }

    public static Expression product(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.product(numberExpression);
    }

    public static Expression subtract(@NonNull Expression number) {
        return new Expression("-", number);
    }

    public static Expression subtract(@NonNull Number number) {
        return Expression.subtract(Expression.literal(number));
    }

    public static Expression subtract(@NonNull Expression first, @NonNull Expression second) {
        return new Expression("-", first, second);
    }

    public static Expression subtract(@NonNull Number first, @NonNull Number second) {
        return Expression.subtract(Expression.literal(first), Expression.literal(second));
    }

    public static Expression division(@NonNull Expression first, @NonNull Expression second) {
        return new Expression("/", first, second);
    }

    public static Expression division(@NonNull Number first, @NonNull Number second) {
        return Expression.division(Expression.literal(first), Expression.literal(second));
    }

    public static Expression mod(@NonNull Expression first, @NonNull Expression second) {
        return new Expression("%", first, second);
    }

    public static Expression mod(@NonNull Number first, @NonNull Number second) {
        return Expression.mod(Expression.literal(first), Expression.literal(second));
    }

    public static Expression pow(@NonNull Expression first, @NonNull Expression second) {
        return new Expression("^", first, second);
    }

    public static Expression pow(@NonNull Number first, @NonNull Number second) {
        return Expression.pow(Expression.literal(first), Expression.literal(second));
    }

    public static Expression sqrt(@NonNull Expression number) {
        return new Expression("sqrt", number);
    }

    public static Expression sqrt(@NonNull Number number) {
        return Expression.sqrt(Expression.literal(number));
    }

    public static Expression log10(@NonNull Expression number) {
        return new Expression("log10", number);
    }

    public static Expression log10(@NonNull Number number) {
        return Expression.log10(Expression.literal(number));
    }

    public static Expression ln(Expression number) {
        return new Expression("ln", number);
    }

    public static Expression ln(Number number) {
        return Expression.ln(Expression.literal(number));
    }

    public static Expression log2(@NonNull Expression number) {
        return new Expression("log2", number);
    }

    public static Expression log2(@NonNull Number number) {
        return Expression.log2(Expression.literal(number));
    }

    public static Expression sin(@NonNull Expression number) {
        return new Expression("sin", number);
    }

    public static Expression sin(@NonNull Number number) {
        return Expression.sin(Expression.literal(number));
    }

    public static Expression cos(@NonNull Expression number) {
        return new Expression("cos", number);
    }

    public static Expression cos(@NonNull Number number) {
        return new Expression("cos", Expression.literal(number));
    }

    public static Expression tan(@NonNull Expression number) {
        return new Expression("tan", number);
    }

    public static Expression tan(@NonNull Number number) {
        return new Expression("tan", Expression.literal(number));
    }

    public static Expression asin(@NonNull Expression number) {
        return new Expression("asin", number);
    }

    public static Expression asin(@NonNull Number number) {
        return Expression.asin(Expression.literal(number));
    }

    public static Expression acos(@NonNull Expression number) {
        return new Expression("acos", number);
    }

    public static Expression acos(@NonNull Number number) {
        return Expression.acos(Expression.literal(number));
    }

    public static Expression atan(@NonNull Expression number) {
        return new Expression("atan", number);
    }

    public static Expression atan(@NonNull Number number) {
        return Expression.atan(Expression.literal(number));
    }

    public static Expression min(Expression ... numbers) {
        return new Expression("min", numbers);
    }

    public static Expression min(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.min(numberExpression);
    }

    public static Expression max(Expression ... numbers) {
        return new Expression("max", numbers);
    }

    public static Expression max(Number ... numbers) {
        Expression[] numberExpression = new Expression[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            numberExpression[i] = Expression.literal(numbers[i]);
        }
        return Expression.max(numberExpression);
    }

    public static Expression round(Expression expression) {
        return new Expression("round", expression);
    }

    public static Expression round(Number number) {
        return Expression.round(Expression.literal(number));
    }

    public static Expression abs(Expression expression) {
        return new Expression("abs", expression);
    }

    public static Expression abs(Number number) {
        return Expression.abs(Expression.literal(number));
    }

    public static Expression ceil(Expression expression) {
        return new Expression("ceil", expression);
    }

    public static Expression ceil(Number number) {
        return Expression.ceil(Expression.literal(number));
    }

    public static Expression floor(Expression expression) {
        return new Expression("floor", expression);
    }

    public static Expression floor(Number number) {
        return Expression.floor(Expression.literal(number));
    }

    public static Expression resolvedLocale(Expression collator) {
        return new Expression("resolved-locale", collator);
    }

    public static Expression upcase(@NonNull Expression string2) {
        return new Expression("upcase", string2);
    }

    public static Expression upcase(@NonNull String string2) {
        return Expression.upcase(Expression.literal(string2));
    }

    public static Expression downcase(@NonNull Expression input) {
        return new Expression("downcase", input);
    }

    public static Expression downcase(@NonNull String input) {
        return Expression.downcase(Expression.literal(input));
    }

    public static Expression concat(Expression ... input) {
        return new Expression("concat", input);
    }

    public static Expression concat(String ... input) {
        Expression[] stringExpression = new Expression[input.length];
        for (int i = 0; i < input.length; ++i) {
            stringExpression[i] = Expression.literal(input[i]);
        }
        return Expression.concat(stringExpression);
    }

    public static Expression array(@NonNull Expression input) {
        return new Expression("array", input);
    }

    public static Expression typeOf(@NonNull Expression input) {
        return new Expression("typeof", input);
    }

    public static Expression string(Expression ... input) {
        return new Expression("string", input);
    }

    public static Expression number(Expression ... input) {
        return new Expression("number", input);
    }

    public static Expression bool(Expression ... input) {
        return new Expression("boolean", input);
    }

    public static Expression collator(boolean caseSensitive, boolean diacriticSensitive, Locale locale) {
        String country;
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        map.put("case-sensitive", Expression.literal(caseSensitive));
        map.put("diacritic-sensitive", Expression.literal(diacriticSensitive));
        StringBuilder localeStringBuilder = new StringBuilder();
        String language = locale.getLanguage();
        if (language != null && !language.isEmpty()) {
            localeStringBuilder.append(language);
        }
        if ((country = locale.getCountry()) != null && !country.isEmpty()) {
            localeStringBuilder.append("-");
            localeStringBuilder.append(country);
        }
        map.put("locale", Expression.literal(localeStringBuilder.toString()));
        return new Expression("collator", new ExpressionMap(map));
    }

    public static Expression collator(boolean caseSensitive, boolean diacriticSensitive) {
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        map.put("case-sensitive", Expression.literal(caseSensitive));
        map.put("diacritic-sensitive", Expression.literal(diacriticSensitive));
        return new Expression("collator", new ExpressionMap(map));
    }

    public static Expression collator(Expression caseSensitive, Expression diacriticSensitive, Expression locale) {
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        map.put("case-sensitive", caseSensitive);
        map.put("diacritic-sensitive", diacriticSensitive);
        map.put("locale", locale);
        return new Expression("collator", new ExpressionMap(map));
    }

    public static Expression collator(Expression caseSensitive, Expression diacriticSensitive) {
        HashMap<String, Expression> map = new HashMap<String, Expression>();
        map.put("case-sensitive", caseSensitive);
        map.put("diacritic-sensitive", diacriticSensitive);
        return new Expression("collator", new ExpressionMap(map));
    }

    public static Expression object(@NonNull Expression input) {
        return new Expression("object", input);
    }

    public static Expression toString(@NonNull Expression input) {
        return new Expression("to-string", input);
    }

    public static Expression toNumber(@NonNull Expression input) {
        return new Expression("to-number", input);
    }

    public static Expression toBool(@NonNull Expression input) {
        return new Expression("to-boolean", input);
    }

    public static Expression toColor(@NonNull Expression input) {
        return new Expression("to-color", input);
    }

    public static Expression let(Expression ... input) {
        return new Expression("let", input);
    }

    public static Expression var(@NonNull Expression expression) {
        return new Expression("var", expression);
    }

    public static Expression var(@NonNull String variableName) {
        return Expression.var(Expression.literal(variableName));
    }

    public static Expression zoom() {
        return new Expression("zoom", new Expression[0]);
    }

    public static Stop stop(@NonNull Object stop, @NonNull Object value) {
        return new Stop(stop, value);
    }

    public static Expression step(@NonNull Number input, @NonNull Expression defaultOutput, Expression ... stops) {
        return Expression.step(Expression.literal(input), defaultOutput, stops);
    }

    public static Expression step(@NonNull Expression input, @NonNull Expression defaultOutput, Expression ... stops) {
        return new Expression("step", Expression.join(new Expression[]{input, defaultOutput}, stops));
    }

    public static Expression step(@NonNull Number input, @NonNull Expression defaultOutput, Stop ... stops) {
        return Expression.step(Expression.literal(input), defaultOutput, Stop.toExpressionArray(stops));
    }

    public static Expression step(@NonNull Expression input, @NonNull Expression defaultOutput, Stop ... stops) {
        return Expression.step(input, defaultOutput, Stop.toExpressionArray(stops));
    }

    public static Expression step(@NonNull Number input, @NonNull Number defaultOutput, Expression ... stops) {
        return Expression.step(Expression.literal(input), defaultOutput, stops);
    }

    public static Expression step(@NonNull Expression input, @NonNull Number defaultOutput, Expression ... stops) {
        return Expression.step(input, Expression.literal(defaultOutput), stops);
    }

    public static Expression step(@NonNull Number input, @NonNull Number defaultOutput, Stop ... stops) {
        return Expression.step(Expression.literal(input), defaultOutput, Stop.toExpressionArray(stops));
    }

    public static Expression step(@NonNull Expression input, @NonNull Number defaultOutput, Stop ... stops) {
        return Expression.step(input, defaultOutput, Stop.toExpressionArray(stops));
    }

    public static Expression interpolate(@NonNull Interpolator interpolation, @NonNull Expression number, Expression ... stops) {
        return new Expression("interpolate", Expression.join(new Expression[]{interpolation, number}, stops));
    }

    public static Expression interpolate(@NonNull Interpolator interpolation, @NonNull Expression number, Stop ... stops) {
        return Expression.interpolate(interpolation, number, Stop.toExpressionArray(stops));
    }

    public static Interpolator linear() {
        return new Interpolator("linear", new Expression[0]);
    }

    public static Interpolator exponential(@NonNull Number base) {
        return Expression.exponential(Expression.literal(base));
    }

    public static Interpolator exponential(@NonNull Expression expression) {
        return new Interpolator("exponential", expression);
    }

    public static Interpolator cubicBezier(@NonNull Expression x1, @NonNull Expression y1, @NonNull Expression x2, @NonNull Expression y2) {
        return new Interpolator("cubic-bezier", x1, y1, x2, y2);
    }

    public static Interpolator cubicBezier(@NonNull Number x1, @NonNull Number y1, @NonNull Number x2, @NonNull Number y2) {
        return Expression.cubicBezier(Expression.literal(x1), Expression.literal(y1), Expression.literal(x2), Expression.literal(y2));
    }

    private static Expression[] join(Expression[] left, Expression[] right) {
        Expression[] output = new Expression[left.length + right.length];
        System.arraycopy(left, 0, output, 0, left.length);
        System.arraycopy(right, 0, output, left.length, right.length);
        return output;
    }

    @NonNull
    public Object[] toArray() {
        ArrayList<Object> array = new ArrayList<Object>();
        array.add(this.operator);
        if (this.arguments != null) {
            for (Expression argument : this.arguments) {
                if (argument instanceof ValueExpression) {
                    array.add(((ValueExpression)((Object)argument)).toValue());
                    continue;
                }
                array.add(argument.toArray());
            }
        }
        return array.toArray();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[\"").append(this.operator).append("\"");
        if (this.arguments != null) {
            for (Expression argument : this.arguments) {
                builder.append(", ");
                if (argument instanceof ExpressionLiteral) {
                    Object literalValue = ((ExpressionLiteral)argument).toValue();
                    if (literalValue instanceof String && ((String)literalValue).contains(",")) {
                        builder.append("\"").append(literalValue).append("\"");
                        continue;
                    }
                    builder.append(literalValue);
                    continue;
                }
                builder.append(((Object)argument).toString());
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static Expression raw(@NonNull String rawExpression) {
        return Converter.convert(rawExpression);
    }

    public boolean equals(Object o) {
        super.equals(o);
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Expression)) {
            return false;
        }
        Expression that = (Expression)o;
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        return Arrays.deepEquals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.arguments);
        return result;
    }

    static Object[] toObjectArray(Object object) {
        int len = java.lang.reflect.Array.getLength(object);
        Object[] objects = new Object[len];
        for (int i = 0; i < len; ++i) {
            objects[i] = java.lang.reflect.Array.get(object, i);
        }
        return objects;
    }

    private static interface ValueExpression {
        public Object toValue();
    }

    private static class ExpressionMap
    extends Expression
    implements ValueExpression {
        private Map<String, Expression> map;

        ExpressionMap(Map<String, Expression> map) {
            this.map = map;
        }

        @Override
        public Object toValue() {
            HashMap<String, Object> unwrappedMap = new HashMap<String, Object>();
            for (String key : this.map.keySet()) {
                Expression expression = this.map.get(key);
                if (expression instanceof ExpressionLiteral) {
                    unwrappedMap.put(key, ((ExpressionLiteral)expression).toValue());
                    continue;
                }
                unwrappedMap.put(key, expression.toArray());
            }
            return unwrappedMap;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            for (String key : this.map.keySet()) {
                builder.append("\"").append(key).append("\": ");
                builder.append(this.map.get(key));
                builder.append(", ");
            }
            if (this.map.size() > 0) {
                builder.delete(builder.length() - 2, builder.length());
            }
            builder.append("}");
            return builder.toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExpressionMap that = (ExpressionMap)o;
            return this.map.equals(that.map);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            return result;
        }
    }

    private static class ExpressionArray
    extends Expression {
        private Object[] array;

        ExpressionArray(Object[] array) {
            this.array = array;
        }

        @Override
        @NonNull
        public Object[] toArray() {
            return new Object[]{"literal", this.array};
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("[\"literal\"], [");
            for (int i = 0; i < this.array.length; ++i) {
                Object argument = this.array[i];
                if (argument instanceof String) {
                    builder.append("\"").append(argument).append("\"");
                } else {
                    builder.append(argument);
                }
                if (i == this.array.length - 1) continue;
                builder.append(", ");
            }
            builder.append("]]");
            return builder.toString();
        }
    }

    public static final class Converter {
        private static final Gson gson = new Gson();

        public static Expression convert(@NonNull JsonArray jsonArray) {
            if (jsonArray.size() == 0) {
                throw new IllegalArgumentException("Can't convert empty jsonArray expressions");
            }
            String operator = jsonArray.get(0).getAsString();
            ArrayList<Expression> arguments = new ArrayList<Expression>();
            for (int i = 1; i < jsonArray.size(); ++i) {
                JsonElement jsonElement = jsonArray.get(i);
                arguments.add(Converter.convert(jsonElement));
            }
            return new Expression(operator, arguments.toArray(new Expression[arguments.size()]));
        }

        private static Expression convert(@NonNull JsonElement jsonElement) {
            if (jsonElement instanceof JsonArray) {
                return Converter.convert((JsonArray)jsonElement);
            }
            if (jsonElement instanceof JsonPrimitive) {
                return Converter.convert((JsonPrimitive)jsonElement);
            }
            if (jsonElement instanceof JsonNull) {
                return new ExpressionLiteral("");
            }
            if (jsonElement instanceof JsonObject) {
                HashMap<String, Expression> map = new HashMap<String, Expression>();
                for (String key : ((JsonObject)jsonElement).keySet()) {
                    map.put(key, Converter.convert(((JsonObject)jsonElement).get(key)));
                }
                return new ExpressionMap(map);
            }
            throw new RuntimeException("Unsupported expression conversion for " + jsonElement.getClass());
        }

        private static Expression convert(@NonNull JsonPrimitive jsonPrimitive) {
            if (jsonPrimitive.isBoolean()) {
                return new ExpressionLiteral(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isNumber()) {
                return new ExpressionLiteral(Float.valueOf(jsonPrimitive.getAsFloat()));
            }
            if (jsonPrimitive.isString()) {
                return new ExpressionLiteral(jsonPrimitive.getAsString());
            }
            throw new RuntimeException("Unsupported literal expression conversion for " + jsonPrimitive.getClass());
        }

        public static Expression convert(@NonNull String rawExpression) {
            return Converter.convert((JsonArray)gson.fromJson(rawExpression, JsonArray.class));
        }
    }

    public static class Stop {
        private Object value;
        private Object output;

        Stop(Object value, Object output) {
            this.value = value;
            this.output = output;
        }

        static Expression[] toExpressionArray(Stop ... stops) {
            Expression[] expressions = new Expression[stops.length * 2];
            for (int i = 0; i < stops.length; ++i) {
                Stop stop = stops[i];
                Object inputValue = stop.value;
                Object outputValue = stop.output;
                if (!(inputValue instanceof Expression)) {
                    inputValue = Expression.literal(inputValue);
                }
                if (!(outputValue instanceof Expression)) {
                    outputValue = Expression.literal(outputValue);
                }
                expressions[i * 2] = (Expression)inputValue;
                expressions[i * 2 + 1] = (Expression)outputValue;
            }
            return expressions;
        }
    }

    public static class Array {
    }

    public static class Interpolator
    extends Expression {
        Interpolator(@NonNull String operator, Expression ... arguments) {
            super(operator, arguments);
        }
    }

    public static class ExpressionLiteral
    extends Expression
    implements ValueExpression {
        protected Object literal;

        public ExpressionLiteral(@NonNull Object object) {
            if (object instanceof String) {
                object = ExpressionLiteral.unwrapStringLiteral((String)object);
            } else if (object instanceof Number) {
                object = Float.valueOf(((Number)object).floatValue());
            }
            this.literal = object;
        }

        @Override
        public Object toValue() {
            if (this.literal instanceof PropertyValue) {
                throw new IllegalArgumentException("PropertyValue are not allowed as an expression literal, use value instead.");
            }
            if (this.literal instanceof ExpressionLiteral) {
                return ((ExpressionLiteral)this.literal).toValue();
            }
            return this.literal;
        }

        @Override
        @NonNull
        public Object[] toArray() {
            return new Object[]{"literal", this.literal};
        }

        @Override
        public String toString() {
            String string2 = this.literal instanceof String ? "\"" + this.literal + "\"" : this.literal.toString();
            return string2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExpressionLiteral that = (ExpressionLiteral)o;
            return this.literal != null ? this.literal.equals(that.literal) : that.literal == null;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.literal != null ? this.literal.hashCode() : 0);
            return result;
        }

        private static String unwrapStringLiteral(String value) {
            if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }
    }
}

