/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk;

import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.log.Logger;

public abstract class LibraryLoader {
    private static final String TAG = "Mbgl-LibraryLoader";
    private static final LibraryLoader DEFAULT;
    private static volatile LibraryLoader loader;

    public static void setLibraryLoader(LibraryLoader libraryLoader) {
        loader = libraryLoader;
    }

    public static void load() {
        try {
            loader.load("mapbox-gl");
        }
        catch (UnsatisfiedLinkError error) {
            String message = "Failed to load native shared library.";
            Logger.e(TAG, message, error);
            MapStrictMode.strictModeViolation(message, error);
        }
    }

    public abstract void load(String var1);

    static {
        loader = DEFAULT = new LibraryLoader(){

            @Override
            public void load(String name) {
                System.loadLibrary(name);
            }
        };
    }
}

