/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.UiThread;
import android.support.v4.util.Pools;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.android.gestures.MoveGestureDetector;
import com.mapbox.android.gestures.RotateGestureDetector;
import com.mapbox.android.gestures.ShoveGestureDetector;
import com.mapbox.android.gestures.StandardScaleGestureDetector;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerOptions;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdate;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.util.HashMap;
import java.util.List;

@UiThread
public final class MapboxMap {
    private static final String TAG = "Mbgl-MapboxMap";
    private final NativeMapView nativeMapView;
    private final UiSettings uiSettings;
    private final Projection projection;
    private final Transform transform;
    private final AnnotationManager annotationManager;
    private final CameraChangeDispatcher cameraChangeDispatcher;
    private final OnGesturesManagerInteractionListener onGesturesManagerInteractionListener;
    private LocationComponent locationComponent;
    private OnFpsChangedListener onFpsChangedListener;

    MapboxMap(NativeMapView map, Transform transform, UiSettings ui, Projection projection, OnGesturesManagerInteractionListener listener, AnnotationManager annotations, CameraChangeDispatcher cameraChangeDispatcher) {
        this.nativeMapView = map;
        this.uiSettings = ui;
        this.projection = projection;
        this.annotationManager = annotations.bind(this);
        this.transform = transform;
        this.onGesturesManagerInteractionListener = listener;
        this.cameraChangeDispatcher = cameraChangeDispatcher;
    }

    void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        this.transform.initialise(this, options);
        this.uiSettings.initialise(context, options);
        this.setDebugActive(options.getDebugActive());
        this.setApiBaseUrl(options);
        this.setStyleUrl(options);
        this.setStyleJson(options);
        this.setPrefetchesTiles(options);
    }

    void onStart() {
        this.nativeMapView.update();
        if (TextUtils.isEmpty((CharSequence)this.nativeMapView.getStyleUrl()) && TextUtils.isEmpty((CharSequence)this.nativeMapView.getStyleJson())) {
            this.nativeMapView.setStyleUrl("mapbox://styles/mapbox/streets-v10");
        }
        this.locationComponent.onStart();
    }

    void onStop() {
        this.locationComponent.onStop();
    }

    void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putParcelable("mapbox_cameraPosition", (Parcelable)this.transform.getCameraPosition());
        outState.putBoolean("mapbox_debugActive", this.nativeMapView.getDebug());
        outState.putString("mapbox_styleUrl", this.nativeMapView.getStyleUrl());
        this.uiSettings.onSaveInstanceState(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        CameraPosition cameraPosition = (CameraPosition)savedInstanceState.getParcelable("mapbox_cameraPosition");
        this.uiSettings.onRestoreInstanceState(savedInstanceState);
        if (cameraPosition != null) {
            this.moveCamera(CameraUpdateFactory.newCameraPosition(new CameraPosition.Builder(cameraPosition).build()));
        }
        this.nativeMapView.setDebug(savedInstanceState.getBoolean("mapbox_debugActive"));
        String styleUrl = savedInstanceState.getString("mapbox_styleUrl");
        if (!TextUtils.isEmpty((CharSequence)styleUrl)) {
            this.nativeMapView.setStyleUrl(savedInstanceState.getString("mapbox_styleUrl"));
        }
    }

    void onDestroy() {
        this.locationComponent.onDestroy();
    }

    void onPreMapReady() {
        this.invalidateCameraPosition();
        this.annotationManager.reloadMarkers();
        this.annotationManager.adjustTopOffsetPixels(this);
    }

    void onPostMapReady() {
        this.invalidateCameraPosition();
    }

    void onStartLoadingMap() {
        this.locationComponent.onStartLoadingMap();
    }

    void onFinishLoadingStyle() {
        this.locationComponent.onFinishLoadingStyle();
    }

    void onUpdateRegionChange() {
        this.annotationManager.update();
    }

    void onUpdateFullyRendered() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.uiSettings.update(cameraPosition);
        }
    }

    public long getTransitionDuration() {
        return this.nativeMapView.getTransitionDuration();
    }

    public void setTransitionDuration(long durationMs) {
        this.nativeMapView.setTransitionDuration(durationMs);
    }

    public long getTransitionDelay() {
        return this.nativeMapView.getTransitionDelay();
    }

    public void setTransitionDelay(long delayMs) {
        this.nativeMapView.setTransitionDelay(delayMs);
    }

    private void setPrefetchesTiles(@NonNull MapboxMapOptions options) {
        this.setPrefetchesTiles(options.getPrefetchesTiles());
    }

    public void setPrefetchesTiles(boolean enable) {
        this.nativeMapView.setPrefetchesTiles(enable);
    }

    public boolean getPrefetchesTiles() {
        return this.nativeMapView.getPrefetchesTiles();
    }

    @NonNull
    public List<Layer> getLayers() {
        return this.nativeMapView.getLayers();
    }

    @Nullable
    public Layer getLayer(@NonNull String layerId) {
        return this.nativeMapView.getLayer(layerId);
    }

    @Nullable
    public <T extends Layer> T getLayerAs(@NonNull String layerId) {
        try {
            return (T)this.nativeMapView.getLayer(layerId);
        }
        catch (ClassCastException exception) {
            String message = String.format("Layer: %s is a different type: ", layerId);
            Logger.e(TAG, message, exception);
            MapStrictMode.strictModeViolation(message, exception);
            return null;
        }
    }

    public void addLayer(@NonNull Layer layer) {
        this.nativeMapView.addLayer(layer);
    }

    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        this.nativeMapView.addLayerBelow(layer, below);
    }

    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        this.nativeMapView.addLayerAbove(layer, above);
    }

    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        this.nativeMapView.addLayerAt(layer, index);
    }

    @Nullable
    public Layer removeLayer(@NonNull String layerId) {
        return this.nativeMapView.removeLayer(layerId);
    }

    @Nullable
    public Layer removeLayer(@NonNull Layer layer) {
        return this.nativeMapView.removeLayer(layer);
    }

    @Nullable
    public Layer removeLayerAt(@IntRange(from=0L) int index) {
        return this.nativeMapView.removeLayerAt(index);
    }

    @NonNull
    public List<Source> getSources() {
        return this.nativeMapView.getSources();
    }

    @Nullable
    public Source getSource(@NonNull String sourceId) {
        return this.nativeMapView.getSource(sourceId);
    }

    @Nullable
    public <T extends Source> T getSourceAs(@NonNull String sourceId) {
        try {
            return (T)this.nativeMapView.getSource(sourceId);
        }
        catch (ClassCastException exception) {
            String message = String.format("Source: %s is a different type: ", sourceId);
            Logger.e(TAG, message, exception);
            MapStrictMode.strictModeViolation(message, exception);
            return null;
        }
    }

    public void addSource(@NonNull Source source) {
        this.nativeMapView.addSource(source);
    }

    @Nullable
    public Source removeSource(@NonNull String sourceId) {
        return this.nativeMapView.removeSource(sourceId);
    }

    @Nullable
    public Source removeSource(@NonNull Source source) {
        return this.nativeMapView.removeSource(source);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image) {
        this.addImage(name, image, false);
    }

    public void addImage(@NonNull String name, @NonNull Bitmap image, boolean sdf) {
        this.nativeMapView.addImage(name, image, sdf);
    }

    public void addImages(@NonNull HashMap<String, Bitmap> images) {
        this.nativeMapView.addImages(images);
    }

    public void removeImage(@NonNull String name) {
        this.nativeMapView.removeImage(name);
    }

    @Nullable
    public Bitmap getImage(@NonNull String name) {
        return this.nativeMapView.getImage(name);
    }

    public void setMinZoomPreference(@FloatRange(from=0.0, to=25.5) double minZoom) {
        this.transform.setMinZoom(minZoom);
    }

    public double getMinZoomLevel() {
        return this.transform.getMinZoom();
    }

    public void setMaxZoomPreference(@FloatRange(from=0.0, to=25.5) double maxZoom) {
        this.transform.setMaxZoom(maxZoom);
    }

    public double getMaxZoomLevel() {
        return this.transform.getMaxZoom();
    }

    @NonNull
    public UiSettings getUiSettings() {
        return this.uiSettings;
    }

    @NonNull
    public Projection getProjection() {
        return this.projection;
    }

    @NonNull
    public Light getLight() {
        return this.nativeMapView.getLight();
    }

    public void cancelTransitions() {
        this.transform.cancelTransitions();
    }

    @NonNull
    public final CameraPosition getCameraPosition() {
        return this.transform.getCameraPosition();
    }

    public void setCameraPosition(@NonNull CameraPosition cameraPosition) {
        this.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition), null);
    }

    public final void moveCamera(@NonNull CameraUpdate update) {
        this.moveCamera(update, null);
    }

    public final void moveCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        this.transform.moveCamera(this, update, callback);
    }

    public final void easeCamera(CameraUpdate update) {
        this.easeCamera(update, 300);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs) {
        this.easeCamera(update, durationMs, null);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        this.easeCamera(update, durationMs, true, callback);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, boolean easingInterpolator) {
        this.easeCamera(update, durationMs, easingInterpolator, null);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, boolean easingInterpolator, @Nullable CancelableCallback callback) {
        this.easeCamera(update, durationMs, easingInterpolator, callback, false);
    }

    public final void easeCamera(@NonNull CameraUpdate update, int durationMs, boolean easingInterpolator, @Nullable CancelableCallback callback, boolean isDismissable) {
        if (durationMs <= 0) {
            throw new IllegalArgumentException("Null duration passed into easeCamera");
        }
        this.transform.easeCamera(this, update, durationMs, easingInterpolator, callback, isDismissable);
    }

    public final void animateCamera(@NonNull CameraUpdate update) {
        this.animateCamera(update, 300, null);
    }

    public final void animateCamera(@NonNull CameraUpdate update, @Nullable CancelableCallback callback) {
        this.animateCamera(update, 300, callback);
    }

    public final void animateCamera(@NonNull CameraUpdate update, int durationMs) {
        this.animateCamera(update, durationMs, null);
    }

    public final void animateCamera(@NonNull CameraUpdate update, int durationMs, @Nullable CancelableCallback callback) {
        if (durationMs <= 0) {
            throw new IllegalArgumentException("Null duration passed into animateCamera");
        }
        this.transform.animateCamera(this, update, durationMs, callback);
    }

    private void invalidateCameraPosition() {
        CameraPosition cameraPosition = this.transform.invalidateCameraPosition();
        if (cameraPosition != null) {
            this.transform.updateCameraPosition(cameraPosition);
        }
    }

    public void resetNorth() {
        this.transform.resetNorth();
    }

    public void setFocalBearing(double bearing, float focalX, float focalY, long duration) {
        this.transform.setBearing(bearing, focalX, focalY, duration);
    }

    public float getHeight() {
        return this.nativeMapView.getHeight();
    }

    public float getWidth() {
        return this.nativeMapView.getWidth();
    }

    public boolean isDebugActive() {
        return this.nativeMapView.getDebug();
    }

    public void setDebugActive(boolean debugActive) {
        this.nativeMapView.setDebug(debugActive);
    }

    public void cycleDebugOptions() {
        this.nativeMapView.cycleDebugOptions();
    }

    private void setApiBaseUrl(@NonNull MapboxMapOptions options) {
        String apiBaseUrl = options.getApiBaseUrl();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            this.nativeMapView.setApiBaseUrl(apiBaseUrl);
        }
    }

    public void setStyleUrl(@NonNull String url) {
        this.setStyleUrl(url, null);
    }

    public void setStyleUrl(final @NonNull String url, final @Nullable OnStyleLoadedListener callback) {
        if (callback != null) {
            this.nativeMapView.addOnMapChangedListener(new MapView.OnMapChangedListener(){

                @Override
                public void onMapChanged(int change) {
                    if (change == 14) {
                        callback.onStyleLoaded(url);
                        MapboxMap.this.nativeMapView.removeOnMapChangedListener(this);
                    }
                }
            });
        }
        this.nativeMapView.setStyleUrl(url);
    }

    public void setStyle(String style2) {
        this.setStyleUrl(style2);
    }

    public void setStyle(String style2, @Nullable OnStyleLoadedListener callback) {
        this.setStyleUrl(style2, callback);
    }

    private void setStyleUrl(@NonNull MapboxMapOptions options) {
        String style2 = options.getStyleUrl();
        if (!TextUtils.isEmpty((CharSequence)style2)) {
            this.setStyleUrl(style2, null);
        }
    }

    @Nullable
    public String getStyleUrl() {
        return this.nativeMapView.getStyleUrl();
    }

    public void setStyleJson(@NonNull String styleJson) {
        this.nativeMapView.setStyleJson(styleJson);
    }

    private void setStyleJson(@NonNull MapboxMapOptions options) {
        String styleJson = options.getStyleJson();
        if (!TextUtils.isEmpty((CharSequence)styleJson)) {
            this.setStyleJson(styleJson);
        }
    }

    @NonNull
    public String getStyleJson() {
        return this.nativeMapView.getStyleJson();
    }

    @NonNull
    public Marker addMarker(@NonNull MarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @NonNull
    public Marker addMarker(@NonNull BaseMarkerOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this);
    }

    @Deprecated
    @NonNull
    public MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions) {
        return this.annotationManager.addMarker(markerOptions, this, null);
    }

    @Deprecated
    @NonNull
    public MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        return this.annotationManager.addMarker(markerOptions, this, onMarkerViewAddedListener);
    }

    @Deprecated
    @NonNull
    public List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions) {
        return this.annotationManager.addMarkerViews(markerViewOptions, this);
    }

    @Deprecated
    @NonNull
    public List<MarkerView> getMarkerViewsInRect(@NonNull RectF rect) {
        return this.annotationManager.getMarkerViewsInRect(rect);
    }

    @NonNull
    public List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList) {
        return this.annotationManager.addMarkers(markerOptionsList, this);
    }

    public void updateMarker(@NonNull Marker updatedMarker) {
        this.annotationManager.updateMarker(updatedMarker, this);
    }

    @NonNull
    public Polyline addPolyline(@NonNull PolylineOptions polylineOptions) {
        return this.annotationManager.addPolyline(polylineOptions, this);
    }

    @NonNull
    public List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList) {
        return this.annotationManager.addPolylines(polylineOptionsList, this);
    }

    public void updatePolyline(@NonNull Polyline polyline) {
        this.annotationManager.updatePolyline(polyline);
    }

    @NonNull
    public Polygon addPolygon(@NonNull PolygonOptions polygonOptions) {
        return this.annotationManager.addPolygon(polygonOptions, this);
    }

    @NonNull
    public List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList) {
        return this.annotationManager.addPolygons(polygonOptionsList, this);
    }

    public void updatePolygon(@NonNull Polygon polygon) {
        this.annotationManager.updatePolygon(polygon);
    }

    public void removeMarker(@NonNull Marker marker) {
        this.annotationManager.removeAnnotation(marker);
    }

    public void removePolyline(@NonNull Polyline polyline) {
        this.annotationManager.removeAnnotation(polyline);
    }

    public void removePolygon(@NonNull Polygon polygon) {
        this.annotationManager.removeAnnotation(polygon);
    }

    public void removeAnnotation(@NonNull Annotation annotation) {
        this.annotationManager.removeAnnotation(annotation);
    }

    public void removeAnnotation(long id2) {
        this.annotationManager.removeAnnotation(id2);
    }

    public void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        this.annotationManager.removeAnnotations(annotationList);
    }

    public void removeAnnotations() {
        this.annotationManager.removeAnnotations();
    }

    public void clear() {
        this.annotationManager.removeAnnotations();
    }

    @Nullable
    public Annotation getAnnotation(long id2) {
        return this.annotationManager.getAnnotation(id2);
    }

    @NonNull
    public List<Annotation> getAnnotations() {
        return this.annotationManager.getAnnotations();
    }

    @NonNull
    public List<Marker> getMarkers() {
        return this.annotationManager.getMarkers();
    }

    @NonNull
    public List<Polygon> getPolygons() {
        return this.annotationManager.getPolygons();
    }

    @NonNull
    public List<Polyline> getPolylines() {
        return this.annotationManager.getPolylines();
    }

    public void setOnMarkerClickListener(@Nullable OnMarkerClickListener listener) {
        this.annotationManager.setOnMarkerClickListener(listener);
    }

    public void setOnPolygonClickListener(@Nullable OnPolygonClickListener listener) {
        this.annotationManager.setOnPolygonClickListener(listener);
    }

    public void setOnPolylineClickListener(@Nullable OnPolylineClickListener listener) {
        this.annotationManager.setOnPolylineClickListener(listener);
    }

    public void selectMarker(@NonNull Marker marker) {
        if (marker == null) {
            Logger.w(TAG, "marker was null, so just returning");
            return;
        }
        this.annotationManager.selectMarker(marker);
    }

    public void deselectMarkers() {
        this.annotationManager.deselectMarkers();
    }

    public void deselectMarker(@NonNull Marker marker) {
        this.annotationManager.deselectMarker(marker);
    }

    @NonNull
    public List<Marker> getSelectedMarkers() {
        return this.annotationManager.getSelectedMarkers();
    }

    @NonNull
    public MarkerViewManager getMarkerViewManager() {
        return this.annotationManager.getMarkerViewManager();
    }

    public void setInfoWindowAdapter(@Nullable InfoWindowAdapter infoWindowAdapter) {
        this.annotationManager.getInfoWindowManager().setInfoWindowAdapter(infoWindowAdapter);
    }

    @Nullable
    public InfoWindowAdapter getInfoWindowAdapter() {
        return this.annotationManager.getInfoWindowManager().getInfoWindowAdapter();
    }

    public void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.annotationManager.getInfoWindowManager().setAllowConcurrentMultipleOpenInfoWindows(allow);
    }

    public boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.annotationManager.getInfoWindowManager().isAllowConcurrentMultipleOpenInfoWindows();
    }

    public void setLatLngBoundsForCameraTarget(@Nullable LatLngBounds latLngBounds) {
        this.nativeMapView.setLatLngBounds(latLngBounds);
    }

    @NonNull
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0});
    }

    @NonNull
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @NonNull @Size(value=4L) int[] padding) {
        return this.getCameraForLatLngBounds(latLngBounds, padding, this.transform.getRawBearing(), this.transform.getTilt());
    }

    @NonNull
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.getCameraForLatLngBounds(latLngBounds, new int[]{0, 0, 0, 0}, bearing, tilt);
    }

    @NonNull
    public CameraPosition getCameraForLatLngBounds(@NonNull LatLngBounds latLngBounds, @NonNull @Size(value=4L) int[] padding, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.nativeMapView.getCameraForLatLngBounds(latLngBounds, padding, bearing, tilt);
    }

    @NonNull
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0});
    }

    @NonNull
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @NonNull @Size(value=4L) int[] padding) {
        return this.getCameraForGeometry(geometry, padding, this.transform.getBearing(), this.transform.getTilt());
    }

    @NonNull
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.getCameraForGeometry(geometry, new int[]{0, 0, 0, 0}, bearing, tilt);
    }

    @NonNull
    public CameraPosition getCameraForGeometry(@NonNull Geometry geometry, @NonNull @Size(value=4L) int[] padding, @FloatRange(from=0.0, to=360.0) double bearing, @FloatRange(from=0.0, to=60.0) double tilt) {
        return this.nativeMapView.getCameraForGeometry(geometry, padding, bearing, tilt);
    }

    @Deprecated
    @NonNull
    public CameraPosition getCameraForGeometry(Geometry geometry, double bearing, int[] padding) {
        return this.getCameraForGeometry(geometry, padding, bearing, this.transform.getTilt());
    }

    public void setPadding(int left, int top, int right, int bottom) {
        this.projection.setContentPadding(new int[]{left, top, right, bottom});
        this.uiSettings.invalidate();
    }

    @NonNull
    public int[] getPadding() {
        return this.projection.getContentPadding();
    }

    @Deprecated
    public void setOnCameraChangeListener(@Nullable OnCameraChangeListener listener) {
        this.transform.setOnCameraChangeListener(listener);
    }

    @Deprecated
    public void setOnCameraIdleListener(@Nullable OnCameraIdleListener listener) {
        this.cameraChangeDispatcher.setOnCameraIdleListener(listener);
    }

    public void addOnCameraIdleListener(@NonNull OnCameraIdleListener listener) {
        this.cameraChangeDispatcher.addOnCameraIdleListener(listener);
    }

    public void removeOnCameraIdleListener(@NonNull OnCameraIdleListener listener) {
        this.cameraChangeDispatcher.removeOnCameraIdleListener(listener);
    }

    @Deprecated
    public void setOnCameraMoveCancelListener(@Nullable OnCameraMoveCanceledListener listener) {
        this.cameraChangeDispatcher.setOnCameraMoveCanceledListener(listener);
    }

    public void addOnCameraMoveCancelListener(@NonNull OnCameraMoveCanceledListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveCancelListener(listener);
    }

    public void removeOnCameraMoveCancelListener(@NonNull OnCameraMoveCanceledListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveCancelListener(listener);
    }

    @Deprecated
    public void setOnCameraMoveStartedListener(@Nullable OnCameraMoveStartedListener listener) {
        this.cameraChangeDispatcher.setOnCameraMoveStartedListener(listener);
    }

    public void addOnCameraMoveStartedListener(@NonNull OnCameraMoveStartedListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveStartedListener(listener);
    }

    public void removeOnCameraMoveStartedListener(@NonNull OnCameraMoveStartedListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveStartedListener(listener);
    }

    @Deprecated
    public void setOnCameraMoveListener(@Nullable OnCameraMoveListener listener) {
        this.cameraChangeDispatcher.setOnCameraMoveListener(listener);
    }

    public void addOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.cameraChangeDispatcher.addOnCameraMoveListener(listener);
    }

    public void removeOnCameraMoveListener(@NonNull OnCameraMoveListener listener) {
        this.cameraChangeDispatcher.removeOnCameraMoveListener(listener);
    }

    public void setOnFpsChangedListener(@Nullable OnFpsChangedListener listener) {
        this.onFpsChangedListener = listener;
        this.nativeMapView.setOnFpsChangedListener(listener);
    }

    @Nullable
    OnFpsChangedListener getOnFpsChangedListener() {
        return this.onFpsChangedListener;
    }

    @Deprecated
    public void setOnScrollListener(@Nullable OnScrollListener listener) {
        this.onGesturesManagerInteractionListener.onSetScrollListener(listener);
    }

    public void addOnScrollListener(@NonNull OnScrollListener listener) {
        this.onGesturesManagerInteractionListener.onAddScrollListener(listener);
    }

    public void removeOnScrollListener(@NonNull OnScrollListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveScrollListener(listener);
    }

    @Deprecated
    public void setOnFlingListener(@Nullable OnFlingListener listener) {
        this.onGesturesManagerInteractionListener.onSetFlingListener(listener);
    }

    public void addOnFlingListener(@NonNull OnFlingListener listener) {
        this.onGesturesManagerInteractionListener.onAddFlingListener(listener);
    }

    public void removeOnFlingListener(@NonNull OnFlingListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveFlingListener(listener);
    }

    public void addOnMoveListener(@NonNull OnMoveListener listener) {
        this.onGesturesManagerInteractionListener.onAddMoveListener(listener);
    }

    public void removeOnMoveListener(@NonNull OnMoveListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMoveListener(listener);
    }

    public void addOnRotateListener(@NonNull OnRotateListener listener) {
        this.onGesturesManagerInteractionListener.onAddRotateListener(listener);
    }

    public void removeOnRotateListener(@NonNull OnRotateListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveRotateListener(listener);
    }

    public void addOnScaleListener(@NonNull OnScaleListener listener) {
        this.onGesturesManagerInteractionListener.onAddScaleListener(listener);
    }

    public void removeOnScaleListener(@NonNull OnScaleListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveScaleListener(listener);
    }

    public void addOnShoveListener(@NonNull OnShoveListener listener) {
        this.onGesturesManagerInteractionListener.onAddShoveListener(listener);
    }

    public void removeOnShoveListener(@NonNull OnShoveListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveShoveListener(listener);
    }

    public void setGesturesManager(@NonNull AndroidGesturesManager androidGesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
        this.onGesturesManagerInteractionListener.setGesturesManager(androidGesturesManager, attachDefaultListeners, setDefaultMutuallyExclusives);
    }

    @NonNull
    public AndroidGesturesManager getGesturesManager() {
        return this.onGesturesManagerInteractionListener.getGesturesManager();
    }

    public void cancelAllVelocityAnimations() {
        this.onGesturesManagerInteractionListener.cancelAllVelocityAnimations();
    }

    @Deprecated
    public void setOnMapClickListener(@Nullable OnMapClickListener listener) {
        this.onGesturesManagerInteractionListener.onSetMapClickListener(listener);
    }

    public void addOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.onGesturesManagerInteractionListener.onAddMapClickListener(listener);
    }

    public void removeOnMapClickListener(@NonNull OnMapClickListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMapClickListener(listener);
    }

    @Deprecated
    public void setOnMapLongClickListener(@Nullable OnMapLongClickListener listener) {
        this.onGesturesManagerInteractionListener.onSetMapLongClickListener(listener);
    }

    public void addOnMapLongClickListener(@NonNull OnMapLongClickListener listener) {
        this.onGesturesManagerInteractionListener.onAddMapLongClickListener(listener);
    }

    public void removeOnMapLongClickListener(@NonNull OnMapLongClickListener listener) {
        this.onGesturesManagerInteractionListener.onRemoveMapLongClickListener(listener);
    }

    public void setOnInfoWindowClickListener(@Nullable OnInfoWindowClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowClickListener(listener);
    }

    @Nullable
    public OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowClickListener();
    }

    public void setOnInfoWindowLongClickListener(@Nullable OnInfoWindowLongClickListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowLongClickListener(listener);
    }

    @Nullable
    public OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowLongClickListener();
    }

    public void setOnInfoWindowCloseListener(@Nullable OnInfoWindowCloseListener listener) {
        this.annotationManager.getInfoWindowManager().setOnInfoWindowCloseListener(listener);
    }

    @Nullable
    public OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.annotationManager.getInfoWindowManager().getOnInfoWindowCloseListener();
    }

    public void snapshot(@NonNull SnapshotReadyCallback callback) {
        this.nativeMapView.addSnapshotCallback(callback);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable Expression filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, null);
    }

    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable Expression filter, String ... layerIds) {
        return this.nativeMapView.queryRenderedFeatures(coordinates, layerIds, filter);
    }

    void injectLocationComponent(LocationComponent locationComponent) {
        this.locationComponent = locationComponent;
    }

    @NonNull
    public LocationComponent getLocationComponent() {
        return this.locationComponent;
    }

    @NonNull
    Transform getTransform() {
        return this.transform;
    }

    public static interface OnStyleLoadedListener {
        public void onStyleLoaded(@NonNull String var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(@NonNull Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onCancel();

        public void onFinish();
    }

    public static interface OnMarkerViewClickListener {
        public boolean onMarkerClick(@NonNull Marker var1, @NonNull View var2, @NonNull MarkerViewAdapter var3);
    }

    @Deprecated
    public static abstract class MarkerViewAdapter<U extends MarkerView> {
        private Context context;
        private final Class<U> persistentClass;
        private final Pools.SimplePool<View> viewReusePool;

        public MarkerViewAdapter(Context context, Class<U> persistentClass) {
            this.context = context;
            this.persistentClass = persistentClass;
            this.viewReusePool = new Pools.SimplePool(10000);
        }

        @Nullable
        public abstract View getView(@NonNull U var1, @Nullable View var2, @NonNull ViewGroup var3);

        public boolean prepareViewForReuse(@NonNull MarkerView marker, @NonNull View convertView) {
            return true;
        }

        public boolean onSelect(@NonNull U marker, @NonNull View convertView, boolean reselectionFromRecycling) {
            return true;
        }

        public void onDeselect(@NonNull U marker, @NonNull View convertView) {
        }

        public final Class<U> getMarkerClass() {
            return this.persistentClass;
        }

        public final Pools.SimplePool<View> getViewReusePool() {
            return this.viewReusePool;
        }

        public final Context getContext() {
            return this.context;
        }

        public final void releaseView(View view) {
            view.setVisibility(8);
            this.viewReusePool.release((Object)view);
        }
    }

    public static interface InfoWindowAdapter {
        @Nullable
        public View getInfoWindow(@NonNull Marker var1);
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(@NonNull Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(@NonNull Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public boolean onInfoWindowClick(@NonNull Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(@NonNull Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(@NonNull Polygon var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(@NonNull Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(@NonNull LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(@NonNull LatLng var1);
    }

    static interface OnGesturesManagerInteractionListener {
        public void onSetMapClickListener(OnMapClickListener var1);

        public void onAddMapClickListener(OnMapClickListener var1);

        public void onRemoveMapClickListener(OnMapClickListener var1);

        public void onSetMapLongClickListener(OnMapLongClickListener var1);

        public void onAddMapLongClickListener(OnMapLongClickListener var1);

        public void onRemoveMapLongClickListener(OnMapLongClickListener var1);

        public void onSetScrollListener(OnScrollListener var1);

        public void onAddScrollListener(OnScrollListener var1);

        public void onRemoveScrollListener(OnScrollListener var1);

        public void onSetFlingListener(OnFlingListener var1);

        public void onAddFlingListener(OnFlingListener var1);

        public void onRemoveFlingListener(OnFlingListener var1);

        public void onAddMoveListener(OnMoveListener var1);

        public void onRemoveMoveListener(OnMoveListener var1);

        public void onAddRotateListener(OnRotateListener var1);

        public void onRemoveRotateListener(OnRotateListener var1);

        public void onAddScaleListener(OnScaleListener var1);

        public void onRemoveScaleListener(OnScaleListener var1);

        public void onAddShoveListener(OnShoveListener var1);

        public void onRemoveShoveListener(OnShoveListener var1);

        public AndroidGesturesManager getGesturesManager();

        public void setGesturesManager(AndroidGesturesManager var1, boolean var2, boolean var3);

        public void cancelAllVelocityAnimations();
    }

    public static interface OnFpsChangedListener {
        public void onFpsChanged(double var1);
    }

    public static interface OnCompassAnimationListener {
        public void onCompassAnimation();

        public void onCompassAnimationFinished();
    }

    public static interface OnCameraIdleListener {
        public void onCameraIdle();
    }

    public static interface OnCameraMoveCanceledListener {
        public void onCameraMoveCanceled();
    }

    public static interface OnCameraMoveListener {
        public void onCameraMove();
    }

    public static interface OnCameraMoveStartedListener {
        public static final int REASON_API_GESTURE = 1;
        public static final int REASON_DEVELOPER_ANIMATION = 2;
        public static final int REASON_API_ANIMATION = 3;

        public void onCameraMoveStarted(int var1);
    }

    @Deprecated
    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnShoveListener {
        public void onShoveBegin(@NonNull ShoveGestureDetector var1);

        public void onShove(@NonNull ShoveGestureDetector var1);

        public void onShoveEnd(@NonNull ShoveGestureDetector var1);
    }

    public static interface OnScaleListener {
        public void onScaleBegin(@NonNull StandardScaleGestureDetector var1);

        public void onScale(@NonNull StandardScaleGestureDetector var1);

        public void onScaleEnd(@NonNull StandardScaleGestureDetector var1);
    }

    public static interface OnRotateListener {
        public void onRotateBegin(@NonNull RotateGestureDetector var1);

        public void onRotate(@NonNull RotateGestureDetector var1);

        public void onRotateEnd(@NonNull RotateGestureDetector var1);
    }

    public static interface OnMoveListener {
        public void onMoveBegin(@NonNull MoveGestureDetector var1);

        public void onMove(@NonNull MoveGestureDetector var1);

        public void onMoveEnd(@NonNull MoveGestureDetector var1);
    }

    @Deprecated
    public static interface OnScrollListener {
        public void onScroll();
    }

    public static interface OnFlingListener {
        public void onFling();
    }
}

