/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.view.View;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.BaseMarkerOptions;
import com.mapbox.mapboxsdk.annotations.BaseMarkerViewOptions;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.MarkerView;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.PolygonOptions;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.annotations.PolylineOptions;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Annotations;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.InfoWindowManager;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.Markers;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.Polygons;
import com.mapbox.mapboxsdk.maps.Polylines;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotations;
import java.util.ArrayList;
import java.util.List;

class AnnotationManager {
    private static final String TAG = "Mbgl-AnnotationManager";
    private static final long NO_ANNOTATION_ID = -1L;
    private final MapView mapView;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    @NonNull
    private final MarkerViewManager markerViewManager;
    private final LongSparseArray<Annotation> annotationsArray;
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private MapboxMap mapboxMap;
    @Nullable
    private MapboxMap.OnMarkerClickListener onMarkerClickListener;
    @Nullable
    private MapboxMap.OnPolygonClickListener onPolygonClickListener;
    @Nullable
    private MapboxMap.OnPolylineClickListener onPolylineClickListener;
    private Annotations annotations;
    private ShapeAnnotations shapeAnnotations;
    private Markers markers;
    private Polygons polygons;
    private Polylines polylines;

    AnnotationManager(@Nullable NativeMapView view, MapView mapView, LongSparseArray<Annotation> annotationsArray, @NonNull MarkerViewManager markerViewManager, IconManager iconManager, Annotations annotations, Markers markers, Polygons polygons, Polylines polylines, ShapeAnnotations shapeAnnotations) {
        this.mapView = mapView;
        this.annotationsArray = annotationsArray;
        this.markerViewManager = markerViewManager;
        this.iconManager = iconManager;
        this.annotations = annotations;
        this.markers = markers;
        this.polygons = polygons;
        this.polylines = polylines;
        this.shapeAnnotations = shapeAnnotations;
        if (view != null) {
            view.addOnMapChangedListener(markerViewManager);
        }
    }

    @NonNull
    AnnotationManager bind(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
        this.markerViewManager.bind(mapboxMap);
        return this;
    }

    void update() {
        this.markerViewManager.update();
        this.infoWindowManager.update();
    }

    Annotation getAnnotation(long id2) {
        return this.annotations.obtainBy(id2);
    }

    List<Annotation> getAnnotations() {
        return this.annotations.obtainAll();
    }

    void removeAnnotation(long id2) {
        this.annotations.removeBy(id2);
    }

    void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
            } else {
                this.iconManager.iconCleanup(marker.getIcon());
            }
        }
        this.annotations.removeBy(annotation);
    }

    void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        for (Annotation annotation : annotationList) {
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
                continue;
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(annotationList);
    }

    void removeAnnotations() {
        int count = this.annotationsArray.size();
        long[] ids = new long[count];
        this.selectedMarkers.clear();
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotationsArray.keyAt(i);
            Annotation annotation = (Annotation)this.annotationsArray.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (marker instanceof MarkerView) {
                this.markerViewManager.removeMarkerView((MarkerView)marker);
                continue;
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeAll();
    }

    Marker addMarker(@NonNull BaseMarkerOptions markerOptions, @NonNull MapboxMap mapboxMap) {
        return this.markers.addBy(markerOptions, mapboxMap);
    }

    List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapboxMap mapboxMap) {
        return this.markers.addBy(markerOptionsList, mapboxMap);
    }

    void updateMarker(@NonNull Marker updatedMarker, @NonNull MapboxMap mapboxMap) {
        if (!this.isAddedToMap(updatedMarker)) {
            this.logNonAdded(updatedMarker);
            return;
        }
        this.markers.update(updatedMarker, mapboxMap);
    }

    List<Marker> getMarkers() {
        return this.markers.obtainAll();
    }

    @NonNull
    List<Marker> getMarkersInRect(@NonNull RectF rectangle) {
        return this.markers.obtainAllIn(rectangle);
    }

    MarkerView addMarker(@NonNull BaseMarkerViewOptions markerOptions, @NonNull MapboxMap mapboxMap, @Nullable MarkerViewManager.OnMarkerViewAddedListener onMarkerViewAddedListener) {
        return this.markers.addViewBy(markerOptions, mapboxMap, onMarkerViewAddedListener);
    }

    List<MarkerView> addMarkerViews(@NonNull List<? extends BaseMarkerViewOptions> markerViewOptions, @NonNull MapboxMap mapboxMap) {
        return this.markers.addViewsBy(markerViewOptions, mapboxMap);
    }

    List<MarkerView> getMarkerViewsInRect(@NonNull RectF rectangle) {
        return this.markers.obtainViewsIn(rectangle);
    }

    void reloadMarkers() {
        this.markers.reload();
    }

    Polygon addPolygon(@NonNull PolygonOptions polygonOptions, @NonNull MapboxMap mapboxMap) {
        return this.polygons.addBy(polygonOptions, mapboxMap);
    }

    List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapboxMap mapboxMap) {
        return this.polygons.addBy(polygonOptionsList, mapboxMap);
    }

    void updatePolygon(@NonNull Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            this.logNonAdded(polygon);
            return;
        }
        this.polygons.update(polygon);
    }

    List<Polygon> getPolygons() {
        return this.polygons.obtainAll();
    }

    Polyline addPolyline(@NonNull PolylineOptions polylineOptions, @NonNull MapboxMap mapboxMap) {
        return this.polylines.addBy(polylineOptions, mapboxMap);
    }

    List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapboxMap mapboxMap) {
        return this.polylines.addBy(polylineOptionsList, mapboxMap);
    }

    void updatePolyline(@NonNull Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            this.logNonAdded(polyline);
            return;
        }
        this.polylines.update(polyline);
    }

    List<Polyline> getPolylines() {
        return this.polylines.obtainAll();
    }

    void setOnMarkerClickListener(@Nullable MapboxMap.OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    void setOnPolygonClickListener(@Nullable MapboxMap.OnPolygonClickListener listener) {
        this.onPolygonClickListener = listener;
    }

    void setOnPolylineClickListener(@Nullable MapboxMap.OnPolylineClickListener listener) {
        this.onPolylineClickListener = listener;
    }

    void selectMarker(@NonNull Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.select((MarkerView)marker, false);
            this.markerViewManager.ensureInfoWindowOffset((MarkerView)marker);
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapboxMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker == null) continue;
            if (marker.isInfoWindowShown()) {
                marker.hideInfoWindow();
            }
            if (!(marker instanceof MarkerView)) continue;
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.clear();
    }

    void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        if (marker instanceof MarkerView) {
            this.markerViewManager.deselect((MarkerView)marker, false);
        }
        this.selectedMarkers.remove(marker);
    }

    @NonNull
    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    @NonNull
    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    @NonNull
    MarkerViewManager getMarkerViewManager() {
        return this.markerViewManager;
    }

    void adjustTopOffsetPixels(@NonNull MapboxMap mapboxMap) {
        int count = this.annotationsArray.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotationsArray.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapboxMap, this.mapView);
        }
    }

    private boolean isAddedToMap(@Nullable Annotation annotation) {
        return annotation != null && annotation.getId() != -1L && this.annotationsArray.indexOfKey(annotation.getId()) > -1;
    }

    private void logNonAdded(@NonNull Annotation annotation) {
        Logger.w(TAG, String.format("Attempting to update non-added %s with value %s", annotation.getClass().getCanonicalName(), annotation));
    }

    boolean onTap(@NonNull PointF tapPoint) {
        MarkerHit markerHit = this.getMarkerHitFromTouchArea(tapPoint);
        long markerId = new MarkerHitResolver(this.mapboxMap).execute(markerHit);
        if (markerId != -1L && this.isClickHandledForMarker(markerId)) {
            return true;
        }
        ShapeAnnotationHit shapeAnnotationHit = this.getShapeAnnotationHitFromTap(tapPoint);
        Annotation annotation = new ShapeAnnotationHitResolver(this.shapeAnnotations).execute(shapeAnnotationHit);
        return annotation != null && this.handleClickForShapeAnnotation(annotation);
    }

    private ShapeAnnotationHit getShapeAnnotationHitFromTap(PointF tapPoint) {
        float touchTargetSide = Mapbox.getApplicationContext().getResources().getDimension(R.dimen.mapbox_eight_dp);
        RectF tapRect = new RectF(tapPoint.x - touchTargetSide, tapPoint.y - touchTargetSide, tapPoint.x + touchTargetSide, tapPoint.y + touchTargetSide);
        return new ShapeAnnotationHit(tapRect);
    }

    private boolean handleClickForShapeAnnotation(Annotation annotation) {
        if (annotation instanceof Polygon && this.onPolygonClickListener != null) {
            this.onPolygonClickListener.onPolygonClick((Polygon)annotation);
            return true;
        }
        if (annotation instanceof Polyline && this.onPolylineClickListener != null) {
            this.onPolylineClickListener.onPolylineClick((Polyline)annotation);
            return true;
        }
        return false;
    }

    private MarkerHit getMarkerHitFromTouchArea(PointF tapPoint) {
        int touchSurfaceWidth = (int)((double)this.iconManager.getHighestIconHeight() * 1.5);
        int touchSurfaceHeight = (int)((double)this.iconManager.getHighestIconWidth() * 1.5);
        RectF tapRect = new RectF(tapPoint.x - (float)touchSurfaceWidth, tapPoint.y - (float)touchSurfaceHeight, tapPoint.x + (float)touchSurfaceWidth, tapPoint.y + (float)touchSurfaceHeight);
        return new MarkerHit(tapRect, this.getMarkersInRect(tapRect));
    }

    private boolean isClickHandledForMarker(long markerId) {
        Marker marker = (Marker)this.getAnnotation(markerId);
        boolean handledDefaultClick = marker instanceof MarkerView ? this.markerViewManager.onClickMarkerView((MarkerView)marker) : this.onClickMarker(marker);
        if (!handledDefaultClick) {
            this.toggleMarkerSelectionState(marker);
        }
        return true;
    }

    private boolean onClickMarker(@NonNull Marker marker) {
        return this.onMarkerClickListener != null && this.onMarkerClickListener.onMarkerClick(marker);
    }

    private void toggleMarkerSelectionState(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            this.selectMarker(marker);
        } else {
            this.deselectMarker(marker);
        }
    }

    private static class MarkerHit {
        private final RectF tapRect;
        private final List<Marker> markers;

        MarkerHit(RectF tapRect, List<Marker> markers) {
            this.tapRect = tapRect;
            this.markers = markers;
        }

        float getTapPointX() {
            return this.tapRect.centerX();
        }

        float getTapPointY() {
            return this.tapRect.centerY();
        }
    }

    private static class ShapeAnnotationHit {
        private final RectF tapPoint;

        ShapeAnnotationHit(RectF tapPoint) {
            this.tapPoint = tapPoint;
        }
    }

    private static class MarkerHitResolver {
        @NonNull
        private final MarkerViewManager markerViewManager;
        @NonNull
        private final Projection projection;
        private final int minimalTouchSize;
        @Nullable
        private View view;
        private Bitmap bitmap;
        private int bitmapWidth;
        private int bitmapHeight;
        private PointF markerLocation;
        @NonNull
        private Rect hitRectView = new Rect();
        @NonNull
        private RectF hitRectMarker = new RectF();
        @NonNull
        private RectF highestSurfaceIntersection = new RectF();
        private long closestMarkerId = -1L;

        MarkerHitResolver(@NonNull MapboxMap mapboxMap) {
            this.markerViewManager = mapboxMap.getMarkerViewManager();
            this.projection = mapboxMap.getProjection();
            this.minimalTouchSize = (int)(32.0f * Mapbox.getApplicationContext().getResources().getDisplayMetrics().density);
        }

        public long execute(@NonNull MarkerHit markerHit) {
            this.resolveForMarkers(markerHit);
            return this.closestMarkerId;
        }

        private void resolveForMarkers(MarkerHit markerHit) {
            for (Marker marker : markerHit.markers) {
                if (marker instanceof MarkerView) {
                    this.resolveForMarkerView(markerHit, (MarkerView)marker);
                    continue;
                }
                this.resolveForMarker(markerHit, marker);
            }
        }

        private void resolveForMarkerView(@NonNull MarkerHit markerHit, @NonNull MarkerView markerView) {
            this.view = this.markerViewManager.getView(markerView);
            if (this.view != null) {
                this.view.getHitRect(this.hitRectView);
                this.hitRectMarker = new RectF(this.hitRectView);
                this.hitTestMarker(markerHit, markerView, this.hitRectMarker);
            }
        }

        private void resolveForMarker(@NonNull MarkerHit markerHit, Marker marker) {
            this.markerLocation = this.projection.toScreenLocation(marker.getPosition());
            this.bitmap = marker.getIcon().getBitmap();
            this.bitmapHeight = this.bitmap.getHeight();
            if (this.bitmapHeight < this.minimalTouchSize) {
                this.bitmapHeight = this.minimalTouchSize;
            }
            this.bitmapWidth = this.bitmap.getWidth();
            if (this.bitmapWidth < this.minimalTouchSize) {
                this.bitmapWidth = this.minimalTouchSize;
            }
            this.hitRectMarker.set(0.0f, 0.0f, (float)this.bitmapWidth, (float)this.bitmapHeight);
            this.hitRectMarker.offsetTo(this.markerLocation.x - (float)(this.bitmapWidth / 2), this.markerLocation.y - (float)(this.bitmapHeight / 2));
            this.hitTestMarker(markerHit, marker, this.hitRectMarker);
        }

        private void hitTestMarker(@NonNull MarkerHit markerHit, @NonNull Marker marker, @NonNull RectF hitRectMarker) {
            if (hitRectMarker.contains(markerHit.getTapPointX(), markerHit.getTapPointY())) {
                hitRectMarker.intersect(markerHit.tapRect);
                if (this.isRectangleHighestSurfaceIntersection(hitRectMarker)) {
                    this.highestSurfaceIntersection = new RectF(hitRectMarker);
                    this.closestMarkerId = marker.getId();
                }
            }
        }

        private boolean isRectangleHighestSurfaceIntersection(RectF rectF) {
            return rectF.width() * rectF.height() > this.highestSurfaceIntersection.width() * this.highestSurfaceIntersection.height();
        }
    }

    private static class ShapeAnnotationHitResolver {
        private ShapeAnnotations shapeAnnotations;

        ShapeAnnotationHitResolver(ShapeAnnotations shapeAnnotations) {
            this.shapeAnnotations = shapeAnnotations;
        }

        @Nullable
        public Annotation execute(@NonNull ShapeAnnotationHit shapeHit) {
            Annotation foundAnnotation = null;
            List<Annotation> annotations = this.shapeAnnotations.obtainAllIn(shapeHit.tapPoint);
            if (annotations.size() > 0) {
                foundAnnotation = annotations.get(0);
            }
            return foundAnnotation;
        }
    }
}

