/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.sources;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.WorkerThread;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.sources.CustomGeometrySourceOptions;
import com.mapbox.mapboxsdk.style.sources.GeometryTileProvider;
import com.mapbox.mapboxsdk.style.sources.Source;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CustomGeometrySource
extends Source {
    public static final String THREAD_PREFIX = "CustomGeom";
    public static final int THREAD_POOL_LIMIT = 4;
    private static final AtomicInteger poolCount = new AtomicInteger();
    private final Lock executorLock = new ReentrantLock();
    private ThreadPoolExecutor executor;
    private GeometryTileProvider provider;
    private final Map<TileID, GeometryTileRequest> awaitingTasksMap = new HashMap<TileID, GeometryTileRequest>();
    private final Map<TileID, AtomicBoolean> inProgressTasksMap = new HashMap<TileID, AtomicBoolean>();

    @UiThread
    public CustomGeometrySource(String id2, GeometryTileProvider provider) {
        this(id2, provider, new CustomGeometrySourceOptions());
    }

    @UiThread
    public CustomGeometrySource(String id2, GeometryTileProvider provider, CustomGeometrySourceOptions options) {
        this.provider = provider;
        this.initialize(id2, options);
    }

    public void invalidateRegion(LatLngBounds bounds) {
        this.nativeInvalidateBounds(bounds);
    }

    public void invalidateTile(int zoomLevel, int x, int y) {
        this.nativeInvalidateTile(zoomLevel, x, y);
    }

    public void setTileData(int zoomLevel, int x, int y, FeatureCollection data) {
        this.nativeSetTileData(zoomLevel, x, y, data);
    }

    @NonNull
    public List<Feature> querySourceFeatures(@Nullable Expression filter) {
        this.checkThread();
        Feature[] features = this.querySourceFeatures(filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @Keep
    protected native void initialize(String var1, Object var2);

    @NonNull
    @Keep
    private native Feature[] querySourceFeatures(Object[] var1);

    @Keep
    private native void nativeSetTileData(int var1, int var2, int var3, FeatureCollection var4);

    @Keep
    private native void nativeInvalidateTile(int var1, int var2, int var3);

    @Keep
    private native void nativeInvalidateBounds(LatLngBounds var1);

    @Keep
    protected native void finalize() throws Throwable;

    private void setTileData(TileID tileId, FeatureCollection data) {
        this.nativeSetTileData(tileId.z, tileId.x, tileId.y, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Keep
    private void fetchTile(int z, int x, int y) {
        AtomicBoolean cancelFlag = new AtomicBoolean(false);
        TileID tileID = new TileID(z, x, y);
        GeometryTileRequest request = new GeometryTileRequest(tileID, this.provider, this.awaitingTasksMap, this.inProgressTasksMap, this, cancelFlag);
        Map<TileID, GeometryTileRequest> map = this.awaitingTasksMap;
        synchronized (map) {
            Map<TileID, AtomicBoolean> map2 = this.inProgressTasksMap;
            synchronized (map2) {
                if (this.executor.getQueue().contains(request)) {
                    this.executor.remove(request);
                    this.executeRequest(request);
                } else if (this.inProgressTasksMap.containsKey(tileID)) {
                    this.awaitingTasksMap.put(tileID, request);
                } else {
                    this.executeRequest(request);
                }
            }
        }
    }

    private void executeRequest(@NonNull GeometryTileRequest request) {
        this.executorLock.lock();
        try {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.execute(request);
            }
        }
        finally {
            this.executorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Keep
    private void cancelTile(int z, int x, int y) {
        TileID tileID = new TileID(z, x, y);
        Map<TileID, GeometryTileRequest> map = this.awaitingTasksMap;
        synchronized (map) {
            Map<TileID, AtomicBoolean> map2 = this.inProgressTasksMap;
            synchronized (map2) {
                AtomicBoolean cancelFlag = this.inProgressTasksMap.get(tileID);
                if (cancelFlag == null || !cancelFlag.compareAndSet(false, true)) {
                    GeometryTileRequest emptyRequest = new GeometryTileRequest(tileID, null, null, null, null, null);
                    if (!this.executor.getQueue().remove(emptyRequest)) {
                        this.awaitingTasksMap.remove(tileID);
                    }
                }
            }
        }
    }

    @Keep
    private void startThreads() {
        this.executorLock.lock();
        try {
            if (this.executor != null && !this.executor.isShutdown()) {
                this.executor.shutdownNow();
            }
            this.executor = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                final AtomicInteger threadCount = new AtomicInteger();
                final int poolId = CustomGeometrySource.access$000().getAndIncrement();

                @Override
                @NonNull
                public Thread newThread(@NonNull Runnable runnable) {
                    return new Thread(runnable, String.format(Locale.US, "%s-%d-%d", CustomGeometrySource.THREAD_PREFIX, this.poolId, this.threadCount.getAndIncrement()));
                }
            });
        }
        finally {
            this.executorLock.unlock();
        }
    }

    @Keep
    private void releaseThreads() {
        this.executorLock.lock();
        try {
            this.executor.shutdownNow();
        }
        finally {
            this.executorLock.unlock();
        }
    }

    @Keep
    private boolean isCancelled(int z, int x, int y) {
        return this.inProgressTasksMap.get(new TileID(z, x, y)).get();
    }

    static /* synthetic */ AtomicInteger access$000() {
        return poolCount;
    }

    static class GeometryTileRequest
    implements Runnable {
        private final TileID id;
        private final GeometryTileProvider provider;
        private final Map<TileID, GeometryTileRequest> awaiting;
        private final Map<TileID, AtomicBoolean> inProgress;
        @NonNull
        private final WeakReference<CustomGeometrySource> sourceRef;
        private final AtomicBoolean cancelled;

        GeometryTileRequest(TileID _id, GeometryTileProvider p, Map<TileID, GeometryTileRequest> awaiting, Map<TileID, AtomicBoolean> m, CustomGeometrySource _source, AtomicBoolean _cancelled) {
            this.id = _id;
            this.provider = p;
            this.awaiting = awaiting;
            this.inProgress = m;
            this.sourceRef = new WeakReference<CustomGeometrySource>(_source);
            this.cancelled = _cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<TileID, AtomicBoolean> map;
            Map<TileID, GeometryTileRequest> map2 = this.awaiting;
            synchronized (map2) {
                map = this.inProgress;
                synchronized (map) {
                    if (this.inProgress.containsKey(this.id)) {
                        if (!this.awaiting.containsKey(this.id)) {
                            this.awaiting.put(this.id, this);
                        }
                        return;
                    }
                    this.inProgress.put(this.id, this.cancelled);
                }
            }
            if (!this.isCancelled().booleanValue()) {
                FeatureCollection data = this.provider.getFeaturesForBounds(LatLngBounds.from(this.id.z, this.id.x, this.id.y), this.id.z);
                CustomGeometrySource source = (CustomGeometrySource)this.sourceRef.get();
                if (!this.isCancelled().booleanValue() && source != null && data != null) {
                    source.setTileData(this.id, data);
                }
            }
            map2 = this.awaiting;
            synchronized (map2) {
                map = this.inProgress;
                synchronized (map) {
                    this.inProgress.remove(this.id);
                    if (this.awaiting.containsKey(this.id)) {
                        GeometryTileRequest queuedRequest = this.awaiting.get(this.id);
                        CustomGeometrySource source = (CustomGeometrySource)this.sourceRef.get();
                        if (source != null && queuedRequest != null) {
                            source.executor.execute(queuedRequest);
                        }
                        this.awaiting.remove(this.id);
                    }
                }
            }
        }

        private Boolean isCancelled() {
            return this.cancelled.get();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeometryTileRequest request = (GeometryTileRequest)o;
            return this.id.equals(request.id);
        }
    }

    static class TileID {
        public int z;
        public int x;
        public int y;

        TileID(int _z, int _x, int _y) {
            this.z = _z;
            this.x = _x;
            this.y = _y;
        }

        public int hashCode() {
            return Arrays.hashCode(new int[]{this.z, this.x, this.y});
        }

        public boolean equals(@Nullable Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (object instanceof TileID) {
                TileID other = (TileID)object;
                return this.z == other.z && this.x == other.x && this.y == other.y;
            }
            return false;
        }
    }
}

