/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ZoomButtonsController;
import com.mapbox.android.gestures.AndroidGesturesManager;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.Mapbox;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.annotations.Annotation;
import com.mapbox.mapboxsdk.annotations.MarkerViewManager;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.maps.AnnotationContainer;
import com.mapbox.mapboxsdk.maps.AnnotationManager;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.CameraChangeDispatcher;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.IconManager;
import com.mapbox.mapboxsdk.maps.MapChangeReceiver;
import com.mapbox.mapboxsdk.maps.MapGestureDetector;
import com.mapbox.mapboxsdk.maps.MapKeyListener;
import com.mapbox.mapboxsdk.maps.MapZoomButtonController;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.MarkerContainer;
import com.mapbox.mapboxsdk.maps.NativeMapView;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.PolygonContainer;
import com.mapbox.mapboxsdk.maps.PolylineContainer;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.ShapeAnnotationContainer;
import com.mapbox.mapboxsdk.maps.TelemetryDefinition;
import com.mapbox.mapboxsdk.maps.Transform;
import com.mapbox.mapboxsdk.maps.UiSettings;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.glsurfaceview.GLSurfaceViewMapRenderer;
import com.mapbox.mapboxsdk.maps.renderer.textureview.TextureViewMapRenderer;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.net.ConnectivityReceiver;
import com.mapbox.mapboxsdk.offline.OfflineGeometryRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineRegionDefinition;
import com.mapbox.mapboxsdk.offline.OfflineTilePyramidRegionDefinition;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class MapView
extends FrameLayout
implements NativeMapView.ViewCallback {
    private final CopyOnWriteArrayList<OnMapChangedListener> onMapChangedListeners = new CopyOnWriteArrayList();
    private final MapChangeReceiver mapChangeReceiver = new MapChangeReceiver();
    private final MapCallback mapCallback = new MapCallback();
    private final InitialRenderCallback initialRenderCallback = new InitialRenderCallback();
    private NativeMapView nativeMapView;
    private MapboxMap mapboxMap;
    private MapboxMapOptions mapboxMapOptions;
    private MapRenderer mapRenderer;
    private boolean destroyed;
    private boolean hasSurface;
    private CompassView compassView;
    private PointF focalPoint;
    private ImageView attrView;
    private ImageView logoView;
    private MapGestureDetector mapGestureDetector;
    private MapKeyListener mapKeyListener;
    private MapZoomButtonController mapZoomButtonController;
    private Bundle savedInstanceState;
    public static final int REGION_WILL_CHANGE = 0;
    public static final int REGION_WILL_CHANGE_ANIMATED = 1;
    public static final int REGION_IS_CHANGING = 2;
    public static final int REGION_DID_CHANGE = 3;
    public static final int REGION_DID_CHANGE_ANIMATED = 4;
    public static final int WILL_START_LOADING_MAP = 5;
    public static final int DID_FINISH_LOADING_MAP = 6;
    public static final int DID_FAIL_LOADING_MAP = 7;
    public static final int WILL_START_RENDERING_FRAME = 8;
    public static final int DID_FINISH_RENDERING_FRAME = 9;
    public static final int DID_FINISH_RENDERING_FRAME_FULLY_RENDERED = 10;
    public static final int WILL_START_RENDERING_MAP = 11;
    public static final int DID_FINISH_RENDERING_MAP = 12;
    public static final int DID_FINISH_RENDERING_MAP_FULLY_RENDERED = 13;
    public static final int DID_FINISH_LOADING_STYLE = 14;
    public static final int SOURCE_DID_CHANGE = 15;

    @UiThread
    public MapView(@NonNull Context context) {
        super(context);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, null));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, MapboxMapOptions.createFromAttributes(context, attrs));
    }

    @UiThread
    public MapView(@NonNull Context context, @Nullable MapboxMapOptions options) {
        super(context);
        this.initialize(context, options == null ? MapboxMapOptions.createFromAttributes(context, null) : options);
    }

    @CallSuper
    @UiThread
    protected void initialize(@NonNull Context context, @NonNull MapboxMapOptions options) {
        if (this.isInEditMode()) {
            return;
        }
        this.setForeground((Drawable)new ColorDrawable(options.getForegroundLoadColor()));
        this.mapboxMapOptions = options;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.mapbox_mapview_internal, (ViewGroup)this);
        this.compassView = (CompassView)view.findViewById(R.id.compassView);
        this.attrView = (ImageView)view.findViewById(R.id.attributionView);
        this.logoView = (ImageView)view.findViewById(R.id.logoView);
        this.setContentDescription(context.getString(R.string.mapbox_mapActionDescription));
        this.setWillNotDraw(false);
        this.initialiseDrawingSurface(options);
    }

    private void initialiseMap() {
        Context context = this.getContext();
        FocalPointInvalidator focalInvalidator = new FocalPointInvalidator();
        focalInvalidator.addListener(this.createFocalPointChangeListener());
        GesturesManagerInteractionListener registerTouchListener = new GesturesManagerInteractionListener();
        CameraChangeDispatcher cameraChangeDispatcher = new CameraChangeDispatcher();
        Projection proj = new Projection(this.nativeMapView);
        UiSettings uiSettings = new UiSettings(proj, focalInvalidator, this.compassView, this.attrView, (View)this.logoView, this.getPixelRatio());
        LongSparseArray annotationsArray = new LongSparseArray();
        MarkerViewManager markerViewManager = new MarkerViewManager((ViewGroup)this.findViewById(R.id.markerViewContainer));
        IconManager iconManager = new IconManager(this.nativeMapView);
        AnnotationContainer annotations = new AnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        MarkerContainer markers = new MarkerContainer(this.nativeMapView, this, (LongSparseArray<Annotation>)annotationsArray, iconManager, markerViewManager);
        PolygonContainer polygons = new PolygonContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        PolylineContainer polylines = new PolylineContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        ShapeAnnotationContainer shapeAnnotations = new ShapeAnnotationContainer(this.nativeMapView, (LongSparseArray<Annotation>)annotationsArray);
        AnnotationManager annotationManager = new AnnotationManager(this.nativeMapView, this, (LongSparseArray<Annotation>)annotationsArray, markerViewManager, iconManager, annotations, markers, polygons, polylines, shapeAnnotations);
        Transform transform = new Transform(this.nativeMapView, annotationManager.getMarkerViewManager(), cameraChangeDispatcher);
        this.mapboxMap = new MapboxMap(this.nativeMapView, transform, uiSettings, proj, registerTouchListener, annotationManager, cameraChangeDispatcher);
        this.mapGestureDetector = new MapGestureDetector(context, transform, proj, uiSettings, annotationManager, cameraChangeDispatcher);
        this.mapKeyListener = new MapKeyListener(transform, uiSettings, this.mapGestureDetector);
        this.mapZoomButtonController = new MapZoomButtonController(new ZoomButtonsController((View)this));
        MapZoomControllerListener zoomListener = new MapZoomControllerListener(this.mapGestureDetector, cameraChangeDispatcher, this.getWidth(), this.getHeight());
        this.mapZoomButtonController.bind(uiSettings, zoomListener);
        this.compassView.injectCompassAnimationListener(this.createCompassAnimationListener(cameraChangeDispatcher));
        this.compassView.setOnClickListener(this.createCompassClickListener(cameraChangeDispatcher));
        this.mapboxMap.injectLocationComponent(new LocationComponent(this.mapboxMap));
        this.attrView.setOnClickListener((View.OnClickListener)new AttributionClickListener(context, this.mapboxMap));
        this.setClickable(true);
        this.setLongClickable(true);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.requestDisallowInterceptTouchEvent(true);
        this.nativeMapView.setReachability(ConnectivityReceiver.instance(context).isConnected(context));
        if (this.savedInstanceState == null) {
            this.mapboxMap.initialise(context, this.mapboxMapOptions);
        } else {
            this.mapboxMap.onRestoreInstanceState(this.savedInstanceState);
        }
        this.mapCallback.initialised();
    }

    private FocalPointChangeListener createFocalPointChangeListener() {
        return new FocalPointChangeListener(){

            @Override
            public void onFocalPointChanged(PointF pointF) {
                MapView.this.focalPoint = pointF;
            }
        };
    }

    private MapboxMap.OnCompassAnimationListener createCompassAnimationListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new MapboxMap.OnCompassAnimationListener(){

            @Override
            public void onCompassAnimation() {
                cameraChangeDispatcher.onCameraMove();
            }

            @Override
            public void onCompassAnimationFinished() {
                MapView.this.compassView.isAnimating(false);
                cameraChangeDispatcher.onCameraIdle();
            }
        };
    }

    private View.OnClickListener createCompassClickListener(final CameraChangeDispatcher cameraChangeDispatcher) {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (MapView.this.mapboxMap != null && MapView.this.compassView != null) {
                    if (MapView.this.focalPoint != null) {
                        MapView.this.mapboxMap.setFocalBearing(0.0, ((MapView)MapView.this).focalPoint.x, ((MapView)MapView.this).focalPoint.y, 150L);
                    } else {
                        MapView.this.mapboxMap.setFocalBearing(0.0, MapView.this.mapboxMap.getWidth() / 2.0f, MapView.this.mapboxMap.getHeight() / 2.0f, 150L);
                    }
                    cameraChangeDispatcher.onCameraMoveStarted(3);
                    MapView.this.compassView.isAnimating(true);
                    MapView.this.compassView.postDelayed(MapView.this.compassView, 650L);
                }
            }
        };
    }

    @UiThread
    public void onCreate(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            TelemetryDefinition telemetry = Mapbox.getTelemetry();
            if (telemetry != null) {
                telemetry.onAppUserTurnstileEvent();
            }
        } else if (savedInstanceState.getBoolean("mapbox_savedState")) {
            this.savedInstanceState = savedInstanceState;
        }
    }

    private void initialiseDrawingSurface(MapboxMapOptions options) {
        String localFontFamily = options.getLocalIdeographFontFamily();
        if (options.getTextureMode()) {
            TextureView textureView = new TextureView(this.getContext());
            boolean translucentSurface = options.getTranslucentTextureSurface();
            this.mapRenderer = new TextureViewMapRenderer(this.getContext(), textureView, localFontFamily, translucentSurface){

                @Override
                protected void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gl, config);
                }
            };
            this.addView((View)textureView, 0);
        } else {
            GLSurfaceView glSurfaceView = new GLSurfaceView(this.getContext());
            glSurfaceView.setZOrderMediaOverlay(this.mapboxMapOptions.getRenderSurfaceOnTop());
            this.mapRenderer = new GLSurfaceViewMapRenderer(this.getContext(), glSurfaceView, localFontFamily){

                @Override
                public void onSurfaceCreated(GL10 gl, EGLConfig config) {
                    MapView.this.onSurfaceCreated();
                    super.onSurfaceCreated(gl, config);
                }
            };
            this.addView((View)glSurfaceView, 0);
        }
        boolean crossSourceCollisions = this.mapboxMapOptions.getCrossSourceCollisions();
        this.nativeMapView = new NativeMapView(this.getContext(), this.getPixelRatio(), crossSourceCollisions, this, this.mapChangeReceiver, this.mapRenderer);
    }

    private void onSurfaceCreated() {
        this.hasSurface = true;
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!MapView.this.destroyed && MapView.this.mapboxMap == null) {
                    MapView.this.initialiseMap();
                    MapView.this.mapboxMap.onStart();
                }
            }
        });
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.mapboxMap != null) {
            outState.putBoolean("mapbox_savedState", true);
            this.mapboxMap.onSaveInstanceState(outState);
        }
    }

    @UiThread
    public void onStart() {
        ConnectivityReceiver.instance(this.getContext()).activate();
        FileSource.getInstance(this.getContext()).activate();
        if (this.mapboxMap != null) {
            this.mapboxMap.onStart();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStart();
        }
    }

    @UiThread
    public void onResume() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onResume();
        }
    }

    @UiThread
    public void onPause() {
        if (this.mapRenderer != null) {
            this.mapRenderer.onPause();
        }
    }

    @UiThread
    public void onStop() {
        if (this.mapboxMap != null) {
            this.mapGestureDetector.cancelAnimators();
            this.mapboxMap.onStop();
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onStop();
        }
        ConnectivityReceiver.instance(this.getContext()).deactivate();
        FileSource.getInstance(this.getContext()).deactivate();
    }

    @UiThread
    public void onDestroy() {
        this.destroyed = true;
        this.mapChangeReceiver.clear();
        this.onMapChangedListeners.clear();
        this.mapCallback.onDestroy();
        this.initialRenderCallback.onDestroy();
        if (this.mapboxMap != null) {
            this.mapboxMap.onDestroy();
        }
        if (this.nativeMapView != null && this.hasSurface) {
            this.nativeMapView.destroy();
            this.nativeMapView = null;
        }
        if (this.mapRenderer != null) {
            this.mapRenderer.onDestroy();
        }
    }

    @UiThread
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isZoomButtonControllerInitialized() || !this.isGestureDetectorInitialized()) {
            return super.onTouchEvent(event);
        }
        if (event.getAction() == 0) {
            this.mapZoomButtonController.setVisible(true);
        }
        return this.mapGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyDown(keyCode, event) || super.onKeyDown(keyCode, event);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyLongPress(keyCode, event) || super.onKeyLongPress(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mapKeyListener.onKeyUp(keyCode, event) || super.onKeyUp(keyCode, event);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return this.mapKeyListener.onTrackballEvent(event) || super.onTrackballEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if (!this.isGestureDetectorInitialized()) {
            return super.onGenericMotionEvent(event);
        }
        return this.mapGestureDetector.onGenericMotionEvent(event) || super.onGenericMotionEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (!this.isZoomButtonControllerInitialized()) {
            return super.onHoverEvent(event);
        }
        switch (event.getActionMasked()) {
            case 7: 
            case 9: {
                this.mapZoomButtonController.setVisible(true);
                return true;
            }
            case 10: {
                this.mapZoomButtonController.setVisible(false);
                return true;
            }
        }
        return false;
    }

    @UiThread
    public void onLowMemory() {
        if (this.nativeMapView != null) {
            this.nativeMapView.onLowMemory();
        }
    }

    public void setStyleUrl(@NonNull String url) {
        this.nativeMapView.setStyleUrl(url);
    }

    public void setOfflineRegionDefinition(OfflineRegionDefinition definition) {
        if (definition instanceof OfflineTilePyramidRegionDefinition) {
            this.setOfflineTilePyramidRegionDefinition((OfflineTilePyramidRegionDefinition)definition);
        } else if (definition instanceof OfflineGeometryRegionDefinition) {
            this.setOfflineGeometryRegionDefinition((OfflineGeometryRegionDefinition)definition);
        } else {
            throw new UnsupportedOperationException("OfflineRegionDefintion instance not supported");
        }
    }

    private void setOfflineRegionDefinition(String styleUrl, LatLng cameraTarget, double minZoom, double maxZoom) {
        CameraPosition cameraPosition = new CameraPosition.Builder().target(cameraTarget).zoom(minZoom).build();
        this.setStyleUrl(styleUrl);
        if (this.mapboxMap != null) {
            this.mapboxMap.moveCamera(CameraUpdateFactory.newCameraPosition(cameraPosition));
            this.mapboxMap.setMinZoomPreference(minZoom);
            this.mapboxMap.setMaxZoomPreference(maxZoom);
        } else {
            this.mapboxMapOptions.camera(cameraPosition);
            this.mapboxMapOptions.minZoomPreference(minZoom);
            this.mapboxMapOptions.maxZoomPreference(maxZoom);
        }
    }

    private void setOfflineTilePyramidRegionDefinition(OfflineTilePyramidRegionDefinition regionDefinition) {
        this.setOfflineRegionDefinition(regionDefinition.getStyleURL(), regionDefinition.getBounds().getCenter(), regionDefinition.getMinZoom(), regionDefinition.getMaxZoom());
    }

    private void setOfflineGeometryRegionDefinition(OfflineGeometryRegionDefinition regionDefinition) {
        this.setOfflineRegionDefinition(regionDefinition.getStyleURL(), regionDefinition.getBounds().getCenter(), regionDefinition.getMinZoom(), regionDefinition.getMaxZoom());
    }

    protected void onSizeChanged(int width, int height, int oldw, int oldh) {
        if (!this.isInEditMode()) {
            this.nativeMapView.resizeView(width, height);
        }
    }

    private float getPixelRatio() {
        float pixelRatio = this.mapboxMapOptions.getPixelRatio();
        if (pixelRatio == 0.0f) {
            pixelRatio = this.getResources().getDisplayMetrics().density;
        }
        return pixelRatio;
    }

    @CallSuper
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.isZoomButtonControllerInitialized()) {
            this.mapZoomButtonController.setVisible(false);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        if (this.isInEditMode()) {
            return;
        }
        if (this.isZoomButtonControllerInitialized()) {
            this.mapZoomButtonController.setVisible(visibility == 0);
        }
    }

    @Override
    public Bitmap getViewContent() {
        return BitmapUtils.createBitmapFromView((View)this);
    }

    public void addOnCameraWillChangeListener(OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.addOnCameraWillChangeListener(listener);
    }

    public void removeOnCameraWillChangeListener(OnCameraWillChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraWillChangeListener(listener);
    }

    public void addOnCameraIsChangingListener(OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.addOnCameraIsChangingListener(listener);
    }

    public void removeOnCameraIsChangingListener(OnCameraIsChangingListener listener) {
        this.mapChangeReceiver.removeOnCameraIsChangingListener(listener);
    }

    public void addOnCameraDidChangeListener(OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.addOnCameraDidChangeListener(listener);
    }

    public void removeOnCameraDidChangeListener(OnCameraDidChangeListener listener) {
        this.mapChangeReceiver.removeOnCameraDidChangeListener(listener);
    }

    public void addOnWillStartLoadingMapListener(OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartLoadingMapListener(listener);
    }

    public void removeOnWillStartLoadingMapListener(OnWillStartLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartLoadingMapListener(listener);
    }

    public void addOnDidFinishLoadingMapListener(OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingMapListener(listener);
    }

    public void removeOnDidFinishLoadingMapListener(OnDidFinishLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingMapListener(listener);
    }

    public void addOnDidFailLoadingMapListener(OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.addOnDidFailLoadingMapListener(listener);
    }

    public void removeOnDidFailLoadingMapListener(OnDidFailLoadingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFailLoadingMapListener(listener);
    }

    public void addOnWillStartRenderingFrameListener(OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingFrameListener(listener);
    }

    public void removeOnWillStartRenderingFrameListener(OnWillStartRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingFrameListener(listener);
    }

    public void addOnDidFinishRenderingFrameListener(OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingFrameListener(listener);
    }

    public void removeOnDidFinishRenderingFrameListener(OnDidFinishRenderingFrameListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingFrameListener(listener);
    }

    public void addOnWillStartRenderingMapListener(OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.addOnWillStartRenderingMapListener(listener);
    }

    public void removeOnWillStartRenderingMapListener(OnWillStartRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnWillStartRenderingMapListener(listener);
    }

    public void addOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.addOnDidFinishRenderingMapListener(listener);
    }

    public void removeOnDidFinishRenderingMapListener(OnDidFinishRenderingMapListener listener) {
        this.mapChangeReceiver.removeOnDidFinishRenderingMapListener(listener);
    }

    public void addOnDidFinishLoadingStyleListener(OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.addOnDidFinishLoadingStyleListener(listener);
    }

    public void removeOnDidFinishLoadingStyleListener(OnDidFinishLoadingStyleListener listener) {
        this.mapChangeReceiver.removeOnDidFinishLoadingStyleListener(listener);
    }

    public void addOnSourceChangedListener(OnSourceChangedListener listener) {
        this.mapChangeReceiver.addOnSourceChangedListener(listener);
    }

    public void removeOnSourceChangedListener(OnSourceChangedListener listener) {
        this.mapChangeReceiver.removeOnSourceChangedListener(listener);
    }

    @Deprecated
    public void addOnMapChangedListener(@NonNull OnMapChangedListener listener) {
        this.onMapChangedListeners.add(listener);
    }

    @Deprecated
    public void removeOnMapChangedListener(@NonNull OnMapChangedListener listener) {
        if (this.onMapChangedListeners.contains(listener)) {
            this.onMapChangedListeners.remove(listener);
        }
    }

    @UiThread
    public void getMapAsync(@NonNull OnMapReadyCallback callback) {
        if (this.mapCallback.isInitialLoad()) {
            this.mapCallback.addOnMapReadyCallback(callback);
        } else {
            callback.onMapReady(this.mapboxMap);
        }
    }

    private boolean isZoomButtonControllerInitialized() {
        return this.mapZoomButtonController != null;
    }

    private boolean isGestureDetectorInitialized() {
        return this.mapGestureDetector != null;
    }

    MapboxMap getMapboxMap() {
        return this.mapboxMap;
    }

    void setMapboxMap(MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    public static void setMapStrictModeEnabled(boolean strictModeEnabled) {
        MapStrictMode.setStrictModeEnabled(strictModeEnabled);
    }

    private static class AttributionClickListener
    implements View.OnClickListener {
        private final AttributionDialogManager defaultDialogManager;
        private UiSettings uiSettings;

        private AttributionClickListener(Context context, MapboxMap mapboxMap) {
            this.defaultDialogManager = new AttributionDialogManager(context, mapboxMap);
            this.uiSettings = mapboxMap.getUiSettings();
        }

        public void onClick(View v) {
            AttributionDialogManager customDialogManager = this.uiSettings.getAttributionDialogManager();
            if (customDialogManager != null) {
                this.uiSettings.getAttributionDialogManager().onClick(v);
            } else {
                this.defaultDialogManager.onClick(v);
            }
        }
    }

    private class MapCallback
    implements OnWillStartLoadingMapListener,
    OnDidFinishLoadingStyleListener,
    OnDidFinishRenderingFrameListener,
    OnDidFinishLoadingMapListener,
    OnCameraIsChangingListener,
    OnCameraDidChangeListener {
        private final List<OnMapReadyCallback> onMapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
        private boolean initialLoad = true;

        MapCallback() {
            MapView.this.addOnWillStartLoadingMapListener(this);
            MapView.this.addOnDidFinishLoadingStyleListener(this);
            MapView.this.addOnDidFinishRenderingFrameListener(this);
            MapView.this.addOnDidFinishLoadingMapListener(this);
            MapView.this.addOnCameraIsChangingListener(this);
            MapView.this.addOnCameraDidChangeListener(this);
        }

        void initialised() {
            if (!this.initialLoad) {
                MapView.this.mapboxMap.onPreMapReady();
                this.onMapReady();
                MapView.this.mapboxMap.onPostMapReady();
            }
        }

        private void onMapReady() {
            if (this.onMapReadyCallbackList.size() > 0) {
                Iterator<OnMapReadyCallback> iterator = this.onMapReadyCallbackList.iterator();
                while (iterator.hasNext()) {
                    OnMapReadyCallback callback = iterator.next();
                    callback.onMapReady(MapView.this.mapboxMap);
                    iterator.remove();
                }
            }
        }

        boolean isInitialLoad() {
            return this.initialLoad;
        }

        void addOnMapReadyCallback(OnMapReadyCallback callback) {
            this.onMapReadyCallbackList.add(callback);
        }

        void onDestroy() {
            this.onMapReadyCallbackList.clear();
            MapView.this.removeOnWillStartLoadingMapListener(this);
            MapView.this.removeOnDidFinishLoadingStyleListener(this);
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
            MapView.this.removeOnDidFinishLoadingMapListener(this);
            MapView.this.removeOnCameraIsChangingListener(this);
            MapView.this.removeOnCameraDidChangeListener(this);
        }

        @Override
        public void onWillStartLoadingMap() {
            if (MapView.this.mapboxMap != null && !this.initialLoad) {
                MapView.this.mapboxMap.onStartLoadingMap();
            }
        }

        @Override
        public void onDidFinishLoadingStyle() {
            if (MapView.this.mapboxMap != null) {
                if (this.initialLoad) {
                    MapView.this.mapboxMap.onPreMapReady();
                    this.onMapReady();
                    MapView.this.mapboxMap.onPostMapReady();
                } else {
                    MapView.this.mapboxMap.onFinishLoadingStyle();
                }
            }
            this.initialLoad = false;
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateFullyRendered();
            }
        }

        @Override
        public void onDidFinishLoadingMap() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraIsChanging() {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }

        @Override
        public void onCameraDidChange(boolean animated) {
            if (MapView.this.mapboxMap != null) {
                MapView.this.mapboxMap.onUpdateRegionChange();
            }
        }
    }

    private static class MapZoomControllerListener
    implements ZoomButtonsController.OnZoomListener {
        private final MapGestureDetector mapGestureDetector;
        private final CameraChangeDispatcher cameraChangeDispatcher;
        private final float mapWidth;
        private final float mapHeight;

        MapZoomControllerListener(MapGestureDetector detector, CameraChangeDispatcher dispatcher, float mapWidth, float mapHeight) {
            this.mapGestureDetector = detector;
            this.cameraChangeDispatcher = dispatcher;
            this.mapWidth = mapWidth;
            this.mapHeight = mapHeight;
        }

        public void onVisibilityChanged(boolean visible) {
        }

        public void onZoom(boolean zoomIn) {
            this.cameraChangeDispatcher.onCameraMoveStarted(3);
            this.onZoom(zoomIn, this.mapGestureDetector.getFocalPoint());
        }

        private void onZoom(boolean zoomIn, @Nullable PointF focalPoint) {
            if (focalPoint == null) {
                focalPoint = new PointF(this.mapWidth / 2.0f, this.mapHeight / 2.0f);
            }
            if (zoomIn) {
                this.mapGestureDetector.zoomInAnimated(focalPoint, true);
            } else {
                this.mapGestureDetector.zoomOutAnimated(focalPoint, true);
            }
        }
    }

    private class GesturesManagerInteractionListener
    implements MapboxMap.OnGesturesManagerInteractionListener {
        private GesturesManagerInteractionListener() {
        }

        @Override
        public void onSetMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapClickListener(listener);
        }

        @Override
        public void onAddMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapClickListener(listener);
        }

        @Override
        public void onRemoveMapClickListener(MapboxMap.OnMapClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapClickListener(listener);
        }

        @Override
        public void onSetMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.setOnMapLongClickListener(listener);
        }

        @Override
        public void onAddMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.addOnMapLongClickListener(listener);
        }

        @Override
        public void onRemoveMapLongClickListener(MapboxMap.OnMapLongClickListener listener) {
            MapView.this.mapGestureDetector.removeOnMapLongClickListener(listener);
        }

        @Override
        public void onSetScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.setOnScrollListener(listener);
        }

        @Override
        public void onAddScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.addOnScrollListener(listener);
        }

        @Override
        public void onRemoveScrollListener(MapboxMap.OnScrollListener listener) {
            MapView.this.mapGestureDetector.removeOnScrollListener(listener);
        }

        @Override
        public void onSetFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.setOnFlingListener(listener);
        }

        @Override
        public void onAddFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.addOnFlingListener(listener);
        }

        @Override
        public void onRemoveFlingListener(MapboxMap.OnFlingListener listener) {
            MapView.this.mapGestureDetector.removeOnFlingListener(listener);
        }

        @Override
        public void onAddMoveListener(MapboxMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.addOnMoveListener(listener);
        }

        @Override
        public void onRemoveMoveListener(MapboxMap.OnMoveListener listener) {
            MapView.this.mapGestureDetector.removeOnMoveListener(listener);
        }

        @Override
        public void onAddRotateListener(MapboxMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.addOnRotateListener(listener);
        }

        @Override
        public void onRemoveRotateListener(MapboxMap.OnRotateListener listener) {
            MapView.this.mapGestureDetector.removeOnRotateListener(listener);
        }

        @Override
        public void onAddScaleListener(MapboxMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.addOnScaleListener(listener);
        }

        @Override
        public void onRemoveScaleListener(MapboxMap.OnScaleListener listener) {
            MapView.this.mapGestureDetector.removeOnScaleListener(listener);
        }

        @Override
        public void onAddShoveListener(MapboxMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.addShoveListener(listener);
        }

        @Override
        public void onRemoveShoveListener(MapboxMap.OnShoveListener listener) {
            MapView.this.mapGestureDetector.removeShoveListener(listener);
        }

        @Override
        public AndroidGesturesManager getGesturesManager() {
            return MapView.this.mapGestureDetector.getGesturesManager();
        }

        @Override
        public void setGesturesManager(AndroidGesturesManager gesturesManager, boolean attachDefaultListeners, boolean setDefaultMutuallyExclusives) {
            MapView.this.mapGestureDetector.setGesturesManager(MapView.this.getContext(), gesturesManager, attachDefaultListeners, setDefaultMutuallyExclusives);
        }

        @Override
        public void cancelAllVelocityAnimations() {
            MapView.this.mapGestureDetector.cancelAnimators();
        }
    }

    private class InitialRenderCallback
    implements OnDidFinishLoadingStyleListener,
    OnDidFinishRenderingFrameListener {
        private int renderCount;
        private boolean styleLoaded;

        InitialRenderCallback() {
            MapView.this.addOnDidFinishLoadingStyleListener(this);
            MapView.this.addOnDidFinishRenderingFrameListener(this);
        }

        @Override
        public void onDidFinishLoadingStyle() {
            this.styleLoaded = true;
        }

        @Override
        public void onDidFinishRenderingFrame(boolean fully) {
            if (this.styleLoaded) {
                ++this.renderCount;
                if (this.renderCount == 2) {
                    MapView.this.setForeground(null);
                    MapView.this.removeOnDidFinishRenderingFrameListener(this);
                }
            }
        }

        private void onDestroy() {
            MapView.this.removeOnDidFinishLoadingStyleListener(this);
            MapView.this.removeOnDidFinishRenderingFrameListener(this);
        }
    }

    private class FocalPointInvalidator
    implements FocalPointChangeListener {
        private final List<FocalPointChangeListener> focalPointChangeListeners = new ArrayList<FocalPointChangeListener>();

        private FocalPointInvalidator() {
        }

        void addListener(FocalPointChangeListener focalPointChangeListener) {
            this.focalPointChangeListeners.add(focalPointChangeListener);
        }

        @Override
        public void onFocalPointChanged(PointF pointF) {
            MapView.this.mapGestureDetector.setFocalPoint(pointF);
            for (FocalPointChangeListener focalPointChangeListener : this.focalPointChangeListeners) {
                focalPointChangeListener.onFocalPointChanged(pointF);
            }
        }
    }

    @Deprecated
    public static interface OnMapChangedListener {
        public void onMapChanged(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MapChange {
    }

    public static interface OnSourceChangedListener {
        public void onSourceChangedListener(String var1);
    }

    public static interface OnDidFinishLoadingStyleListener {
        public void onDidFinishLoadingStyle();
    }

    public static interface OnDidFinishRenderingMapListener {
        public void onDidFinishRenderingMap(boolean var1);
    }

    public static interface OnWillStartRenderingMapListener {
        public void onWillStartRenderingMap();
    }

    public static interface OnDidFinishRenderingFrameListener {
        public void onDidFinishRenderingFrame(boolean var1);
    }

    public static interface OnWillStartRenderingFrameListener {
        public void onWillStartRenderingFrame();
    }

    public static interface OnDidFailLoadingMapListener {
        public void onDidFailLoadingMap(String var1);
    }

    public static interface OnDidFinishLoadingMapListener {
        public void onDidFinishLoadingMap();
    }

    public static interface OnWillStartLoadingMapListener {
        public void onWillStartLoadingMap();
    }

    public static interface OnCameraDidChangeListener {
        public void onCameraDidChange(boolean var1);
    }

    public static interface OnCameraIsChangingListener {
        public void onCameraIsChanging();
    }

    public static interface OnCameraWillChangeListener {
        public void onCameraWillChange(boolean var1);
    }
}

