/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.SensorManager;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.StyleRes;
import android.view.WindowManager;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineListener;
import com.mapbox.android.core.location.LocationEnginePriority;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.CompassEngine;
import com.mapbox.mapboxsdk.location.CompassListener;
import com.mapbox.mapboxsdk.location.LayerBitmapProvider;
import com.mapbox.mapboxsdk.location.LayerFeatureProvider;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationAnimatorCoordinator;
import com.mapbox.mapboxsdk.location.LocationCameraController;
import com.mapbox.mapboxsdk.location.LocationComponentCompassEngine;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.LocationLayerController;
import com.mapbox.mapboxsdk.location.OnCameraMoveInvalidateListener;
import com.mapbox.mapboxsdk.location.OnCameraTrackingChangedListener;
import com.mapbox.mapboxsdk.location.OnLocationClickListener;
import com.mapbox.mapboxsdk.location.OnLocationLongClickListener;
import com.mapbox.mapboxsdk.location.OnLocationStaleListener;
import com.mapbox.mapboxsdk.location.StaleStateManager;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class LocationComponent {
    private static final String TAG = "Mbgl-LocationComponent";
    @NonNull
    private final MapboxMap mapboxMap;
    private LocationComponentOptions options;
    @Nullable
    private LocationEngine locationEngine;
    @Nullable
    private CompassEngine compassEngine;
    private boolean usingInternalLocationEngine;
    private LocationLayerController locationLayerController;
    private LocationCameraController locationCameraController;
    private LocationAnimatorCoordinator locationAnimatorCoordinator;
    @Nullable
    private Location lastLocation;
    private CameraPosition lastCameraPosition;
    private boolean isInitialized;
    private boolean isEnabled;
    private boolean isComponentStarted;
    private boolean isLayerReady;
    private StaleStateManager staleStateManager;
    private final CopyOnWriteArrayList<OnLocationStaleListener> onLocationStaleListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationClickListener> onLocationClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationLongClickListener> onLocationLongClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnCameraTrackingChangedListener> onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
    @NonNull
    private MapboxMap.OnCameraMoveListener onCameraMoveListener = new MapboxMap.OnCameraMoveListener(){

        @Override
        public void onCameraMove() {
            LocationComponent.this.updateLayerOffsets(false);
        }
    };
    @NonNull
    private MapboxMap.OnCameraIdleListener onCameraIdleListener = new MapboxMap.OnCameraIdleListener(){

        @Override
        public void onCameraIdle() {
            LocationComponent.this.updateLayerOffsets(false);
        }
    };
    @NonNull
    private MapboxMap.OnMapClickListener onMapClickListener = new MapboxMap.OnMapClickListener(){

        @Override
        public boolean onMapClick(@NonNull LatLng point) {
            if (!LocationComponent.this.onLocationClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick(point)) {
                for (OnLocationClickListener listener : LocationComponent.this.onLocationClickListeners) {
                    listener.onLocationComponentClick();
                }
                return true;
            }
            return false;
        }
    };
    @NonNull
    private MapboxMap.OnMapLongClickListener onMapLongClickListener = new MapboxMap.OnMapLongClickListener(){

        @Override
        public boolean onMapLongClick(@NonNull LatLng point) {
            if (!LocationComponent.this.onLocationLongClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick(point)) {
                for (OnLocationLongClickListener listener : LocationComponent.this.onLocationLongClickListeners) {
                    listener.onLocationComponentLongClick();
                }
                return true;
            }
            return false;
        }
    };
    @NonNull
    private OnLocationStaleListener onLocationStaleListener = new OnLocationStaleListener(){

        @Override
        public void onStaleStateChange(boolean isStale) {
            LocationComponent.this.locationLayerController.setLocationsStale(isStale);
            for (OnLocationStaleListener listener : LocationComponent.this.onLocationStaleListeners) {
                listener.onStaleStateChange(isStale);
            }
        }
    };
    @NonNull
    private OnCameraMoveInvalidateListener onCameraMoveInvalidateListener = new OnCameraMoveInvalidateListener(){

        @Override
        public void onInvalidateCameraMove() {
            LocationComponent.this.onCameraMoveListener.onCameraMove();
        }
    };
    @NonNull
    private CompassListener compassListener = new CompassListener(){

        @Override
        public void onCompassChanged(float userHeading) {
            LocationComponent.this.updateCompassHeading(userHeading);
        }

        @Override
        public void onCompassAccuracyChange(int compassStatus) {
        }
    };
    @NonNull
    private LocationEngineListener locationEngineListener = new LocationEngineListener(){

        public void onConnected() {
            if (LocationComponent.this.usingInternalLocationEngine && LocationComponent.this.isLayerReady && LocationComponent.this.isEnabled) {
                LocationComponent.this.locationEngine.requestLocationUpdates();
            }
        }

        public void onLocationChanged(Location location) {
            LocationComponent.this.updateLocation(location, false);
        }
    };
    @NonNull
    private OnCameraTrackingChangedListener cameraTrackingChangedListener = new OnCameraTrackingChangedListener(){

        @Override
        public void onCameraTrackingDismissed() {
            for (OnCameraTrackingChangedListener listener : LocationComponent.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingDismissed();
            }
        }

        @Override
        public void onCameraTrackingChanged(int currentMode) {
            LocationComponent.this.locationAnimatorCoordinator.cancelZoomAnimation();
            LocationComponent.this.locationAnimatorCoordinator.cancelTiltAnimation();
            for (OnCameraTrackingChangedListener listener : LocationComponent.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingChanged(currentMode);
            }
        }
    };

    public LocationComponent(@NonNull MapboxMap mapboxMap) {
        this.mapboxMap = mapboxMap;
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void activateLocationComponent(@NonNull Context context) {
        this.activateLocationComponent(context, LocationComponentOptions.createFromAttributes(context, R.style.mapbox_LocationComponent));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void activateLocationComponent(@NonNull Context context, boolean useDefaultLocationEngine) {
        if (useDefaultLocationEngine) {
            this.activateLocationComponent(context, R.style.mapbox_LocationComponent);
        } else {
            this.activateLocationComponent(context, null, R.style.mapbox_LocationComponent);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void activateLocationComponent(@NonNull Context context, @StyleRes int styleRes) {
        this.activateLocationComponent(context, LocationComponentOptions.createFromAttributes(context, styleRes));
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void activateLocationComponent(@NonNull Context context, @NonNull LocationComponentOptions options) {
        this.initialize(context, options);
        this.initializeLocationEngine(context);
        this.applyStyle(options);
    }

    public void activateLocationComponent(@NonNull Context context, @Nullable LocationEngine locationEngine, @StyleRes int styleRes) {
        this.activateLocationComponent(context, locationEngine, LocationComponentOptions.createFromAttributes(context, styleRes));
    }

    public void activateLocationComponent(@NonNull Context context, @NonNull LocationEngine locationEngine) {
        this.activateLocationComponent(context, locationEngine, R.style.mapbox_LocationComponent);
    }

    public void activateLocationComponent(@NonNull Context context, @Nullable LocationEngine locationEngine, @NonNull LocationComponentOptions options) {
        this.initialize(context, options);
        this.setLocationEngine(locationEngine);
        this.applyStyle(options);
    }

    public void setLocationComponentEnabled(boolean isEnabled) {
        if (isEnabled) {
            this.enableLocationComponent();
        } else {
            this.disableLocationComponent();
        }
    }

    public boolean isLocationComponentEnabled() {
        return this.isEnabled;
    }

    public void setCameraMode(int cameraMode) {
        this.locationCameraController.setCameraMode(cameraMode);
        boolean isGpsNorth = cameraMode == 36;
        this.locationAnimatorCoordinator.resetAllCameraAnimations(this.mapboxMap.getCameraPosition(), isGpsNorth);
    }

    public int getCameraMode() {
        return this.locationCameraController.getCameraMode();
    }

    public void setRenderMode(int renderMode) {
        this.locationLayerController.setRenderMode(renderMode);
        this.updateLayerOffsets(true);
    }

    public int getRenderMode() {
        return this.locationLayerController.getRenderMode();
    }

    public LocationComponentOptions getLocationComponentOptions() {
        return this.options;
    }

    public void applyStyle(@NonNull Context context, @StyleRes int styleRes) {
        this.applyStyle(LocationComponentOptions.createFromAttributes(context, styleRes));
    }

    public void applyStyle(@NonNull LocationComponentOptions options) {
        this.options = options;
        this.locationLayerController.applyStyle(options);
        this.locationCameraController.initializeOptions(options);
        this.staleStateManager.setEnabled(options.enableStaleState());
        this.staleStateManager.setDelayTime(options.staleStateTimeout());
        this.locationAnimatorCoordinator.setTrackingAnimationDurationMultiplier(options.trackingAnimationDurationMultiplier());
        this.updateMapWithOptions(options);
    }

    public void zoomWhileTracking(double zoomLevel, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        if (!this.isLayerReady) {
            return;
        }
        if (this.getCameraMode() == 8) {
            Logger.e(TAG, String.format("%s%s", "LocationComponent#zoomWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        this.locationAnimatorCoordinator.feedNewZoomLevel(zoomLevel, this.mapboxMap.getCameraPosition(), animationDuration, callback);
    }

    public void zoomWhileTracking(double zoomLevel, long animationDuration) {
        this.zoomWhileTracking(zoomLevel, animationDuration, null);
    }

    public void zoomWhileTracking(double zoomLevel) {
        this.zoomWhileTracking(zoomLevel, 750L, null);
    }

    public void cancelZoomWhileTrackingAnimation() {
        this.locationAnimatorCoordinator.cancelZoomAnimation();
    }

    public void tiltWhileTracking(double tilt, long animationDuration, @Nullable MapboxMap.CancelableCallback callback) {
        if (!this.isLayerReady) {
            return;
        }
        if (this.getCameraMode() == 8) {
            Logger.e(TAG, String.format("%s%s", "LocationComponent#tiltWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        this.locationAnimatorCoordinator.feedNewTilt(tilt, this.mapboxMap.getCameraPosition(), animationDuration, callback);
    }

    public void tiltWhileTracking(double tilt, long animationDuration) {
        this.tiltWhileTracking(tilt, animationDuration, null);
    }

    public void tiltWhileTracking(double tilt) {
        this.tiltWhileTracking(tilt, 1250L, null);
    }

    public void cancelTiltWhileTrackingAnimation() {
        this.locationAnimatorCoordinator.cancelTiltAnimation();
    }

    public void forceLocationUpdate(@Nullable Location location) {
        this.updateLocation(location, false);
    }

    public void setLocationEngine(@Nullable LocationEngine locationEngine) {
        if (this.locationEngine != null) {
            if (this.usingInternalLocationEngine) {
                this.locationEngine.removeLocationUpdates();
                this.locationEngine.deactivate();
                this.usingInternalLocationEngine = false;
            }
            this.locationEngine.removeLocationEngineListener(this.locationEngineListener);
            this.locationEngine = null;
        }
        if (locationEngine != null) {
            this.locationEngine = locationEngine;
            if (this.isEnabled) {
                this.locationEngine.addLocationEngineListener(this.locationEngineListener);
            }
        }
    }

    @Nullable
    public LocationEngine getLocationEngine() {
        return this.locationEngine;
    }

    public void setCompassEngine(@NonNull CompassEngine compassEngine) {
        this.compassEngine.removeCompassListener(this.compassListener);
        this.compassEngine = compassEngine;
        compassEngine.addCompassListener(this.compassListener);
    }

    @NonNull
    public CompassEngine getCompassEngine() {
        return this.compassEngine;
    }

    @Nullable
    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public Location getLastKnownLocation() {
        Location location;
        Location location2 = location = this.locationEngine != null ? this.locationEngine.getLastLocation() : null;
        if (location == null) {
            location = this.lastLocation;
        }
        return location;
    }

    public float getLastKnownCompassAccuracyStatus() {
        return this.compassEngine.getLastAccuracySensorStatus();
    }

    public void addCompassListener(@NonNull CompassListener compassListener) {
        this.compassEngine.addCompassListener(compassListener);
    }

    public void removeCompassListener(@NonNull CompassListener compassListener) {
        this.compassEngine.removeCompassListener(compassListener);
    }

    public void addOnLocationClickListener(@NonNull OnLocationClickListener listener) {
        this.onLocationClickListeners.add(listener);
    }

    public void removeOnLocationClickListener(@NonNull OnLocationClickListener listener) {
        this.onLocationClickListeners.remove(listener);
    }

    public void addOnLocationLongClickListener(@NonNull OnLocationLongClickListener listener) {
        this.onLocationLongClickListeners.add(listener);
    }

    public void removeOnLocationLongClickListener(@NonNull OnLocationLongClickListener listener) {
        this.onLocationLongClickListeners.remove(listener);
    }

    public void addOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.add(listener);
    }

    public void removeOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.remove(listener);
    }

    public void addOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.add(listener);
    }

    public void removeOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.remove(listener);
    }

    public void onStart() {
        this.isComponentStarted = true;
        this.onLocationLayerStart();
    }

    public void onStop() {
        this.onLocationLayerStop();
        this.isComponentStarted = false;
    }

    public void onDestroy() {
        if (this.locationEngine != null && this.usingInternalLocationEngine) {
            this.locationEngine.deactivate();
        }
    }

    public void onStartLoadingMap() {
        this.onLocationLayerStop();
    }

    public void onFinishLoadingStyle() {
        if (this.isInitialized) {
            this.locationLayerController.initializeComponents(this.options);
            this.locationCameraController.initializeOptions(this.options);
        }
        this.onLocationLayerStart();
    }

    @SuppressLint(value={"MissingPermission"})
    private void onLocationLayerStart() {
        if (!this.isInitialized || !this.isComponentStarted) {
            return;
        }
        if (!this.isLayerReady) {
            this.isLayerReady = true;
            this.mapboxMap.addOnCameraMoveListener(this.onCameraMoveListener);
            this.mapboxMap.addOnCameraIdleListener(this.onCameraIdleListener);
            if (this.options.enableStaleState()) {
                this.staleStateManager.onStart();
            }
            this.compassEngine.onStart();
        }
        if (this.isEnabled) {
            if (this.locationEngine != null) {
                this.locationEngine.addLocationEngineListener(this.locationEngineListener);
                if (this.locationEngine.isConnected() && this.usingInternalLocationEngine) {
                    this.locationEngine.requestLocationUpdates();
                }
            }
            this.setCameraMode(this.locationCameraController.getCameraMode());
            this.setLastLocation();
            this.setLastCompassHeading();
        }
    }

    private void onLocationLayerStop() {
        if (!(this.isInitialized && this.isLayerReady && this.isComponentStarted)) {
            return;
        }
        this.isLayerReady = false;
        this.locationLayerController.hide();
        this.staleStateManager.onStop();
        this.compassEngine.onStop();
        this.locationAnimatorCoordinator.cancelAllAnimations();
        if (this.locationEngine != null) {
            if (this.usingInternalLocationEngine) {
                this.locationEngine.removeLocationUpdates();
            }
            this.locationEngine.removeLocationEngineListener(this.locationEngineListener);
        }
        this.mapboxMap.removeOnCameraMoveListener(this.onCameraMoveListener);
        this.mapboxMap.removeOnCameraIdleListener(this.onCameraIdleListener);
    }

    private void initialize(@NonNull Context context, @NonNull LocationComponentOptions options) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.options = options;
        this.mapboxMap.addOnMapClickListener(this.onMapClickListener);
        this.mapboxMap.addOnMapLongClickListener(this.onMapLongClickListener);
        LayerSourceProvider sourceProvider = new LayerSourceProvider();
        LayerFeatureProvider featureProvider = new LayerFeatureProvider();
        LayerBitmapProvider bitmapProvider = new LayerBitmapProvider(context);
        this.locationLayerController = new LocationLayerController(this.mapboxMap, sourceProvider, featureProvider, bitmapProvider, options);
        this.locationCameraController = new LocationCameraController(context, this.mapboxMap, this.cameraTrackingChangedListener, options, this.onCameraMoveInvalidateListener);
        this.locationAnimatorCoordinator = new LocationAnimatorCoordinator();
        this.locationAnimatorCoordinator.addLayerListener(this.locationLayerController);
        this.locationAnimatorCoordinator.addCameraListener(this.locationCameraController);
        this.locationAnimatorCoordinator.setTrackingAnimationDurationMultiplier(options.trackingAnimationDurationMultiplier());
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        this.compassEngine = new LocationComponentCompassEngine(windowManager, sensorManager);
        this.compassEngine.addCompassListener(this.compassListener);
        this.staleStateManager = new StaleStateManager(this.onLocationStaleListener, options);
        this.updateMapWithOptions(options);
        this.setRenderMode(18);
        this.setCameraMode(8);
        this.onLocationLayerStart();
    }

    private void initializeLocationEngine(@NonNull Context context) {
        if (this.locationEngine != null) {
            if (this.usingInternalLocationEngine) {
                this.locationEngine.removeLocationUpdates();
                this.locationEngine.deactivate();
            }
            this.locationEngine.removeLocationEngineListener(this.locationEngineListener);
        }
        this.usingInternalLocationEngine = true;
        this.locationEngine = new LocationEngineProvider(context).obtainBestLocationEngineAvailable();
        this.locationEngine.setPriority(LocationEnginePriority.HIGH_ACCURACY);
        this.locationEngine.setFastestInterval(1000);
        this.locationEngine.addLocationEngineListener(this.locationEngineListener);
        this.locationEngine.activate();
    }

    private void enableLocationComponent() {
        this.isEnabled = true;
        this.onLocationLayerStart();
    }

    private void disableLocationComponent() {
        this.isEnabled = false;
        this.onLocationLayerStop();
    }

    private void updateMapWithOptions(LocationComponentOptions options) {
        this.mapboxMap.setPadding(options.padding()[0], options.padding()[1], options.padding()[2], options.padding()[3]);
        this.mapboxMap.setMaxZoomPreference(options.maxZoom());
        this.mapboxMap.setMinZoomPreference(options.minZoom());
    }

    private void updateLocation(@Nullable Location location, boolean fromLastLocation) {
        if (location == null) {
            return;
        }
        if (!this.isLayerReady) {
            this.lastLocation = location;
            return;
        }
        this.showLocationLayerIfHidden();
        if (!fromLastLocation) {
            this.staleStateManager.updateLatestLocationTime();
        }
        CameraPosition currentCameraPosition = this.mapboxMap.getCameraPosition();
        boolean isGpsNorth = this.getCameraMode() == 36;
        this.locationAnimatorCoordinator.feedNewLocation(location, currentCameraPosition, isGpsNorth);
        this.updateAccuracyRadius(location, false);
        this.lastLocation = location;
    }

    private void showLocationLayerIfHidden() {
        boolean isLocationLayerHidden = this.locationLayerController.isHidden();
        if (this.isEnabled && this.isComponentStarted && isLocationLayerHidden) {
            this.locationLayerController.show();
        }
    }

    private void updateCompassHeading(float heading) {
        this.locationAnimatorCoordinator.feedNewCompassBearing(heading, this.mapboxMap.getCameraPosition());
    }

    @SuppressLint(value={"MissingPermission"})
    private void setLastLocation() {
        this.updateLocation(this.getLastKnownLocation(), true);
    }

    private void setLastCompassHeading() {
        this.updateCompassHeading(this.compassEngine.getLastHeading());
    }

    @SuppressLint(value={"MissingPermission"})
    private void updateLayerOffsets(boolean forceUpdate) {
        CameraPosition position = this.mapboxMap.getCameraPosition();
        if (this.lastCameraPosition == null || forceUpdate) {
            this.lastCameraPosition = position;
            this.locationLayerController.updateForegroundBearing((float)position.bearing);
            this.locationLayerController.updateForegroundOffset(position.tilt);
            this.updateAccuracyRadius(this.getLastKnownLocation(), true);
            return;
        }
        if (position.bearing != this.lastCameraPosition.bearing) {
            this.locationLayerController.updateForegroundBearing((float)position.bearing);
        }
        if (position.tilt != this.lastCameraPosition.tilt) {
            this.locationLayerController.updateForegroundOffset(position.tilt);
        }
        if (position.zoom != this.lastCameraPosition.zoom) {
            this.updateAccuracyRadius(this.getLastKnownLocation(), true);
        }
        this.lastCameraPosition = position;
    }

    private void updateAccuracyRadius(Location location, boolean noAnimation) {
        this.locationAnimatorCoordinator.feedNewAccuracyRadius(Utils.calculateZoomLevelRadius(this.mapboxMap, location), noAnimation);
    }
}

