/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Px;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.maps.AttributionDialogManager;
import com.mapbox.mapboxsdk.maps.FocalPointChangeListener;
import com.mapbox.mapboxsdk.maps.MapboxMapOptions;
import com.mapbox.mapboxsdk.maps.Projection;
import com.mapbox.mapboxsdk.maps.widgets.CompassView;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.ColorUtils;

public final class UiSettings {
    @NonNull
    private final FocalPointChangeListener focalPointChangeListener;
    @NonNull
    private final Projection projection;
    @NonNull
    private final CompassView compassView;
    private final int[] compassMargins = new int[4];
    @NonNull
    private final ImageView attributionsView;
    private final int[] attributionsMargins = new int[4];
    private AttributionDialogManager attributionDialogManager;
    @NonNull
    private final View logoView;
    private final int[] logoMargins = new int[4];
    private final float pixelRatio;
    private boolean rotateGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean doubleTapGesturesEnabled = true;
    private boolean quickZoomGesturesEnabled = true;
    private boolean scaleVelocityAnimationEnabled = true;
    private boolean rotateVelocityAnimationEnabled = true;
    private boolean flingVelocityAnimationEnabled = true;
    private boolean increaseRotateThresholdWhenScaling = true;
    private boolean increaseScaleThresholdWhenRotating = true;
    private float zoomRate = 1.0f;
    private boolean deselectMarkersOnTap = true;
    @Nullable
    private PointF userProvidedFocalPoint;

    UiSettings(@NonNull Projection projection, @NonNull FocalPointChangeListener listener, @NonNull CompassView compassView, @NonNull ImageView attributionsView, @NonNull View logoView, float pixelRatio) {
        this.projection = projection;
        this.focalPointChangeListener = listener;
        this.compassView = compassView;
        this.attributionsView = attributionsView;
        this.logoView = logoView;
        this.pixelRatio = pixelRatio;
    }

    void initialise(@NonNull Context context, @NonNull MapboxMapOptions options) {
        Resources resources = context.getResources();
        this.initialiseGestures(options);
        this.initialiseCompass(options, resources);
        this.initialiseLogo(options, resources);
        this.initialiseAttribution(context, options);
    }

    void onSaveInstanceState(@NonNull Bundle outState) {
        this.saveGestures(outState);
        this.saveCompass(outState);
        this.saveLogo(outState);
        this.saveAttribution(outState);
        this.saveDeselectMarkersOnTap(outState);
        this.saveFocalPoint(outState);
    }

    void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        this.restoreGestures(savedInstanceState);
        this.restoreCompass(savedInstanceState);
        this.restoreLogo(savedInstanceState);
        this.restoreAttribution(savedInstanceState);
        this.restoreDeselectMarkersOnTap(savedInstanceState);
        this.restoreFocalPoint(savedInstanceState);
    }

    private void initialiseGestures(MapboxMapOptions options) {
        this.setZoomGesturesEnabled(options.getZoomGesturesEnabled());
        this.setScrollGesturesEnabled(options.getScrollGesturesEnabled());
        this.setRotateGesturesEnabled(options.getRotateGesturesEnabled());
        this.setTiltGesturesEnabled(options.getTiltGesturesEnabled());
        this.setDoubleTapGesturesEnabled(options.getDoubleTapGesturesEnabled());
        this.setQuickZoomGesturesEnabled(options.getQuickZoomGesturesEnabled());
    }

    private void saveGestures(Bundle outState) {
        outState.putBoolean("mapbox_zoomEnabled", this.isZoomGesturesEnabled());
        outState.putBoolean("mapbox_scrollEnabled", this.isScrollGesturesEnabled());
        outState.putBoolean("mapbox_rotateEnabled", this.isRotateGesturesEnabled());
        outState.putBoolean("mapbox_tiltEnabled", this.isTiltGesturesEnabled());
        outState.putBoolean("mapbox_doubleTapEnabled", this.isDoubleTapGesturesEnabled());
        outState.putBoolean("mapbox_scaleAnimationEnabled", this.isScaleVelocityAnimationEnabled());
        outState.putBoolean("mapbox_rotateAnimationEnabled", this.isRotateVelocityAnimationEnabled());
        outState.putBoolean("mapbox_flingAnimationEnabled", this.isFlingVelocityAnimationEnabled());
        outState.putBoolean("mapbox_increaseRotateThreshold", this.isIncreaseRotateThresholdWhenScaling());
        outState.putBoolean("mapbox_increaseScaleThreshold", this.isIncreaseScaleThresholdWhenRotating());
        outState.putBoolean("mapbox_quickZoom", this.isQuickZoomGesturesEnabled());
        outState.putFloat("mapbox_zoomRate", this.getZoomRate());
    }

    private void restoreGestures(Bundle savedInstanceState) {
        this.setZoomGesturesEnabled(savedInstanceState.getBoolean("mapbox_zoomEnabled"));
        this.setScrollGesturesEnabled(savedInstanceState.getBoolean("mapbox_scrollEnabled"));
        this.setRotateGesturesEnabled(savedInstanceState.getBoolean("mapbox_rotateEnabled"));
        this.setTiltGesturesEnabled(savedInstanceState.getBoolean("mapbox_tiltEnabled"));
        this.setDoubleTapGesturesEnabled(savedInstanceState.getBoolean("mapbox_doubleTapEnabled"));
        this.setScaleVelocityAnimationEnabled(savedInstanceState.getBoolean("mapbox_scaleAnimationEnabled"));
        this.setRotateVelocityAnimationEnabled(savedInstanceState.getBoolean("mapbox_rotateAnimationEnabled"));
        this.setFlingVelocityAnimationEnabled(savedInstanceState.getBoolean("mapbox_flingAnimationEnabled"));
        this.setIncreaseRotateThresholdWhenScaling(savedInstanceState.getBoolean("mapbox_increaseRotateThreshold"));
        this.setIncreaseScaleThresholdWhenRotating(savedInstanceState.getBoolean("mapbox_increaseScaleThreshold"));
        this.setQuickZoomGesturesEnabled(savedInstanceState.getBoolean("mapbox_quickZoom"));
        this.setZoomRate(savedInstanceState.getFloat("mapbox_zoomRate", 1.0f));
    }

    private void initialiseCompass(MapboxMapOptions options, @NonNull Resources resources) {
        this.setCompassEnabled(options.getCompassEnabled());
        this.setCompassGravity(options.getCompassGravity());
        int[] compassMargins = options.getCompassMargins();
        if (compassMargins != null) {
            this.setCompassMargins(compassMargins[0], compassMargins[1], compassMargins[2], compassMargins[3]);
        } else {
            int tenDp = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setCompassMargins(tenDp, tenDp, tenDp, tenDp);
        }
        this.setCompassFadeFacingNorth(options.getCompassFadeFacingNorth());
        if (options.getCompassImage() == null) {
            options.compassImage(ResourcesCompat.getDrawable((Resources)resources, (int)R.drawable.mapbox_compass_icon, null));
        }
        this.setCompassImage(options.getCompassImage());
    }

    private void saveCompass(Bundle outState) {
        outState.putBoolean("mapbox_compassEnabled", this.isCompassEnabled());
        outState.putInt("mapbox_compassGravity", this.getCompassGravity());
        outState.putInt("mapbox_compassMarginLeft", this.getCompassMarginLeft());
        outState.putInt("mapbox_compassMarginTop", this.getCompassMarginTop());
        outState.putInt("mapbox_compassMarginBottom", this.getCompassMarginBottom());
        outState.putInt("mapbox_compassMarginRight", this.getCompassMarginRight());
        outState.putBoolean("mapbox_compassFade", this.isCompassFadeWhenFacingNorth());
        outState.putByteArray("mapbox_compassImage", BitmapUtils.getByteArrayFromDrawable(this.getCompassImage()));
    }

    private void restoreCompass(Bundle savedInstanceState) {
        this.setCompassEnabled(savedInstanceState.getBoolean("mapbox_compassEnabled"));
        this.setCompassGravity(savedInstanceState.getInt("mapbox_compassGravity"));
        this.setCompassMargins(savedInstanceState.getInt("mapbox_compassMarginLeft"), savedInstanceState.getInt("mapbox_compassMarginTop"), savedInstanceState.getInt("mapbox_compassMarginRight"), savedInstanceState.getInt("mapbox_compassMarginBottom"));
        this.setCompassFadeFacingNorth(savedInstanceState.getBoolean("mapbox_compassFade"));
        this.setCompassImage(BitmapUtils.getDrawableFromByteArray(this.compassView.getContext(), savedInstanceState.getByteArray("mapbox_compassImage")));
    }

    private void initialiseLogo(MapboxMapOptions options, @NonNull Resources resources) {
        this.setLogoEnabled(options.getLogoEnabled());
        this.setLogoGravity(options.getLogoGravity());
        this.setLogoMargins(resources, options.getLogoMargins());
    }

    private void setLogoMargins(@NonNull Resources resources, @Nullable int[] logoMargins) {
        if (logoMargins != null) {
            this.setLogoMargins(logoMargins[0], logoMargins[1], logoMargins[2], logoMargins[3]);
        } else {
            int fourDp = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            this.setLogoMargins(fourDp, fourDp, fourDp, fourDp);
        }
    }

    private void saveLogo(Bundle outState) {
        outState.putInt("mapbox_logoGravity", this.getLogoGravity());
        outState.putInt("mapbox_logoMarginLeft", this.getLogoMarginLeft());
        outState.putInt("mapbox_logoMarginTop", this.getLogoMarginTop());
        outState.putInt("mapbox_logoMarginRight", this.getLogoMarginRight());
        outState.putInt("mapbox_logoMarginBottom", this.getLogoMarginBottom());
        outState.putBoolean("mapbox_logoEnabled", this.isLogoEnabled());
    }

    private void restoreLogo(Bundle savedInstanceState) {
        this.setLogoEnabled(savedInstanceState.getBoolean("mapbox_logoEnabled"));
        this.setLogoGravity(savedInstanceState.getInt("mapbox_logoGravity"));
        this.setLogoMargins(savedInstanceState.getInt("mapbox_logoMarginLeft"), savedInstanceState.getInt("mapbox_logoMarginTop"), savedInstanceState.getInt("mapbox_logoMarginRight"), savedInstanceState.getInt("mapbox_logoMarginBottom"));
    }

    private void initialiseAttribution(@NonNull Context context, MapboxMapOptions options) {
        this.setAttributionEnabled(options.getAttributionEnabled());
        this.setAttributionGravity(options.getAttributionGravity());
        this.setAttributionMargins(context, options.getAttributionMargins());
        int attributionTintColor = options.getAttributionTintColor();
        this.setAttributionTintColor(attributionTintColor != -1 ? attributionTintColor : ColorUtils.getPrimaryColor(context));
    }

    private void setAttributionMargins(@NonNull Context context, @Nullable int[] attributionMargins) {
        if (attributionMargins != null) {
            this.setAttributionMargins(attributionMargins[0], attributionMargins[1], attributionMargins[2], attributionMargins[3]);
        } else {
            Resources resources = context.getResources();
            int margin = (int)resources.getDimension(R.dimen.mapbox_four_dp);
            int leftMargin = (int)resources.getDimension(R.dimen.mapbox_ninety_two_dp);
            this.setAttributionMargins(leftMargin, margin, margin, margin);
        }
    }

    private void saveAttribution(Bundle outState) {
        outState.putInt("mapbox_attrGravity", this.getAttributionGravity());
        outState.putInt("mapbox_attrMarginLeft", this.getAttributionMarginLeft());
        outState.putInt("mapbox_attrMarginTop", this.getAttributionMarginTop());
        outState.putInt("mapbox_attrMarginRight", this.getAttributionMarginRight());
        outState.putInt("mapbox_atrrMarginBottom", this.getAttributionMarginBottom());
        outState.putBoolean("mapbox_atrrEnabled", this.isAttributionEnabled());
    }

    private void restoreAttribution(Bundle savedInstanceState) {
        this.setAttributionEnabled(savedInstanceState.getBoolean("mapbox_atrrEnabled"));
        this.setAttributionGravity(savedInstanceState.getInt("mapbox_attrGravity"));
        this.setAttributionMargins(savedInstanceState.getInt("mapbox_attrMarginLeft"), savedInstanceState.getInt("mapbox_attrMarginTop"), savedInstanceState.getInt("mapbox_attrMarginRight"), savedInstanceState.getInt("mapbox_atrrMarginBottom"));
    }

    public void setCompassEnabled(boolean compassEnabled) {
        this.compassView.setEnabled(compassEnabled);
    }

    public boolean isCompassEnabled() {
        return this.compassView.isEnabled();
    }

    @UiThread
    public void setCompassGravity(int gravity) {
        this.setWidgetGravity((View)this.compassView, gravity);
    }

    public void setCompassFadeFacingNorth(boolean compassFadeFacingNorth) {
        this.compassView.fadeCompassViewFacingNorth(compassFadeFacingNorth);
    }

    public void setCompassImage(@NonNull Drawable compass) {
        this.compassView.setCompassImage(compass);
    }

    public boolean isCompassFadeWhenFacingNorth() {
        return this.compassView.isFadeCompassViewFacingNorth();
    }

    public int getCompassGravity() {
        return ((FrameLayout.LayoutParams)this.compassView.getLayoutParams()).gravity;
    }

    @UiThread
    public void setCompassMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        this.setWidgetMargins((View)this.compassView, this.compassMargins, left, top, right, bottom);
    }

    @Px
    public int getCompassMarginLeft() {
        return this.compassMargins[0];
    }

    @Px
    public int getCompassMarginTop() {
        return this.compassMargins[1];
    }

    @Px
    public int getCompassMarginRight() {
        return this.compassMargins[2];
    }

    @Px
    public int getCompassMarginBottom() {
        return this.compassMargins[3];
    }

    @NonNull
    public Drawable getCompassImage() {
        return this.compassView.getCompassImage();
    }

    void update(@NonNull CameraPosition cameraPosition) {
        if (!this.isCompassEnabled()) {
            return;
        }
        double clockwiseBearing = -cameraPosition.bearing;
        this.compassView.update(clockwiseBearing);
    }

    public void setLogoEnabled(boolean enabled) {
        this.logoView.setVisibility(enabled ? 0 : 8);
    }

    public boolean isLogoEnabled() {
        return this.logoView.getVisibility() == 0;
    }

    public void setLogoGravity(int gravity) {
        this.setWidgetGravity(this.logoView, gravity);
    }

    public int getLogoGravity() {
        return ((FrameLayout.LayoutParams)this.logoView.getLayoutParams()).gravity;
    }

    public void setLogoMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        this.setWidgetMargins(this.logoView, this.logoMargins, left, top, right, bottom);
    }

    @Px
    public int getLogoMarginLeft() {
        return this.logoMargins[0];
    }

    @Px
    public int getLogoMarginTop() {
        return this.logoMargins[1];
    }

    @Px
    public int getLogoMarginRight() {
        return this.logoMargins[2];
    }

    @Px
    public int getLogoMarginBottom() {
        return this.logoMargins[3];
    }

    public void setAttributionEnabled(boolean enabled) {
        this.attributionsView.setVisibility(enabled ? 0 : 8);
    }

    public boolean isAttributionEnabled() {
        return this.attributionsView.getVisibility() == 0;
    }

    public void setAttributionDialogManager(@NonNull AttributionDialogManager attributionDialogManager) {
        this.attributionDialogManager = attributionDialogManager;
    }

    @Nullable
    public AttributionDialogManager getAttributionDialogManager() {
        return this.attributionDialogManager;
    }

    public void setAttributionGravity(int gravity) {
        this.setWidgetGravity((View)this.attributionsView, gravity);
    }

    public int getAttributionGravity() {
        return ((FrameLayout.LayoutParams)this.attributionsView.getLayoutParams()).gravity;
    }

    public void setAttributionMargins(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        this.setWidgetMargins((View)this.attributionsView, this.attributionsMargins, left, top, right, bottom);
    }

    public void setAttributionTintColor(@ColorInt int tintColor) {
        if (Color.alpha((int)tintColor) == 0) {
            ColorUtils.setTintList(this.attributionsView, ContextCompat.getColor((Context)this.attributionsView.getContext(), (int)R.color.mapbox_blue));
        } else {
            ColorUtils.setTintList(this.attributionsView, tintColor);
        }
    }

    @Px
    public int getAttributionMarginLeft() {
        return this.attributionsMargins[0];
    }

    @Px
    public int getAttributionMarginTop() {
        return this.attributionsMargins[1];
    }

    @Px
    public int getAttributionMarginRight() {
        return this.attributionsMargins[2];
    }

    @Px
    public int getAttributionMarginBottom() {
        return this.attributionsMargins[3];
    }

    public void setRotateGesturesEnabled(boolean rotateGesturesEnabled) {
        this.rotateGesturesEnabled = rotateGesturesEnabled;
    }

    public boolean isRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public void setTiltGesturesEnabled(boolean tiltGesturesEnabled) {
        this.tiltGesturesEnabled = tiltGesturesEnabled;
    }

    public boolean isTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public void setZoomGesturesEnabled(boolean zoomGesturesEnabled) {
        this.zoomGesturesEnabled = zoomGesturesEnabled;
    }

    public boolean isZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public void setDoubleTapGesturesEnabled(boolean doubleTapGesturesEnabled) {
        this.doubleTapGesturesEnabled = doubleTapGesturesEnabled;
    }

    public boolean isDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean isQuickZoomGesturesEnabled() {
        return this.quickZoomGesturesEnabled;
    }

    public void setQuickZoomGesturesEnabled(boolean quickZoomGesturesEnabled) {
        this.quickZoomGesturesEnabled = quickZoomGesturesEnabled;
    }

    public float getZoomRate() {
        return this.zoomRate;
    }

    public void setZoomRate(@FloatRange(from=0.0) float zoomRate) {
        this.zoomRate = zoomRate;
    }

    private void restoreDeselectMarkersOnTap(Bundle savedInstanceState) {
        this.setDeselectMarkersOnTap(savedInstanceState.getBoolean("mapbox_deselectMarkerOnTap"));
    }

    private void saveDeselectMarkersOnTap(Bundle outState) {
        outState.putBoolean("mapbox_deselectMarkerOnTap", this.isDeselectMarkersOnTap());
    }

    public boolean isDeselectMarkersOnTap() {
        return this.deselectMarkersOnTap;
    }

    public void setDeselectMarkersOnTap(boolean deselectMarkersOnTap) {
        this.deselectMarkersOnTap = deselectMarkersOnTap;
    }

    public void setScrollGesturesEnabled(boolean scrollGesturesEnabled) {
        this.scrollGesturesEnabled = scrollGesturesEnabled;
    }

    public boolean isScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean isScaleVelocityAnimationEnabled() {
        return this.scaleVelocityAnimationEnabled;
    }

    public void setScaleVelocityAnimationEnabled(boolean scaleVelocityAnimationEnabled) {
        this.scaleVelocityAnimationEnabled = scaleVelocityAnimationEnabled;
    }

    public boolean isRotateVelocityAnimationEnabled() {
        return this.rotateVelocityAnimationEnabled;
    }

    public void setRotateVelocityAnimationEnabled(boolean rotateVelocityAnimationEnabled) {
        this.rotateVelocityAnimationEnabled = rotateVelocityAnimationEnabled;
    }

    public boolean isFlingVelocityAnimationEnabled() {
        return this.flingVelocityAnimationEnabled;
    }

    public void setFlingVelocityAnimationEnabled(boolean flingVelocityAnimationEnabled) {
        this.flingVelocityAnimationEnabled = flingVelocityAnimationEnabled;
    }

    public void setAllVelocityAnimationsEnabled(boolean allVelocityAnimationsEnabled) {
        this.setScaleVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setRotateVelocityAnimationEnabled(allVelocityAnimationsEnabled);
        this.setFlingVelocityAnimationEnabled(allVelocityAnimationsEnabled);
    }

    public boolean isIncreaseRotateThresholdWhenScaling() {
        return this.increaseRotateThresholdWhenScaling;
    }

    public void setIncreaseRotateThresholdWhenScaling(boolean increaseRotateThresholdWhenScaling) {
        this.increaseRotateThresholdWhenScaling = increaseRotateThresholdWhenScaling;
    }

    public boolean isIncreaseScaleThresholdWhenRotating() {
        return this.increaseScaleThresholdWhenRotating;
    }

    public void setIncreaseScaleThresholdWhenRotating(boolean increaseScaleThresholdWhenRotating) {
        this.increaseScaleThresholdWhenRotating = increaseScaleThresholdWhenRotating;
    }

    public void setAllGesturesEnabled(boolean enabled) {
        this.setScrollGesturesEnabled(enabled);
        this.setRotateGesturesEnabled(enabled);
        this.setTiltGesturesEnabled(enabled);
        this.setZoomGesturesEnabled(enabled);
        this.setDoubleTapGesturesEnabled(enabled);
        this.setQuickZoomGesturesEnabled(enabled);
    }

    public boolean areAllGesturesEnabled() {
        return this.rotateGesturesEnabled && this.tiltGesturesEnabled && this.zoomGesturesEnabled && this.scrollGesturesEnabled && this.doubleTapGesturesEnabled && this.quickZoomGesturesEnabled;
    }

    private void saveFocalPoint(Bundle outState) {
        outState.putParcelable("mapbox_userFocalPoint", (Parcelable)this.getFocalPoint());
    }

    private void restoreFocalPoint(Bundle savedInstanceState) {
        PointF pointF = (PointF)savedInstanceState.getParcelable("mapbox_userFocalPoint");
        if (pointF != null) {
            this.setFocalPoint(pointF);
        }
    }

    public void setFocalPoint(@Nullable PointF focalPoint) {
        this.userProvidedFocalPoint = focalPoint;
        this.focalPointChangeListener.onFocalPointChanged(focalPoint);
    }

    @Nullable
    public PointF getFocalPoint() {
        return this.userProvidedFocalPoint;
    }

    public float getHeight() {
        return this.projection.getHeight();
    }

    public float getWidth() {
        return this.projection.getWidth();
    }

    float getPixelRatio() {
        return this.pixelRatio;
    }

    public void invalidate() {
        this.setLogoMargins(this.getLogoMarginLeft(), this.getLogoMarginTop(), this.getLogoMarginRight(), this.getLogoMarginBottom());
        this.setCompassMargins(this.getCompassMarginLeft(), this.getCompassMarginTop(), this.getCompassMarginRight(), this.getCompassMarginBottom());
        this.setAttributionMargins(this.getAttributionMarginLeft(), this.getAttributionMarginTop(), this.getAttributionMarginRight(), this.getAttributionMarginBottom());
    }

    private void setWidgetGravity(@NonNull View view, int gravity) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.gravity = gravity;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWidgetMargins(@NonNull View view, int[] initMargins, int left, int top, int right, int bottom) {
        initMargins[0] = left;
        initMargins[1] = top;
        initMargins[2] = right;
        initMargins[3] = bottom;
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        layoutParams.setMargins(left, top, right, bottom);
        if (Build.VERSION.SDK_INT >= 17) {
            layoutParams.setMarginStart(left);
            layoutParams.setMarginEnd(right);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }
}

