/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.log;

import android.support.annotation.Keep;
import android.util.Log;
import com.mapbox.mapboxsdk.log.LoggerDefinition;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Keep
public final class Logger {
    private static final LoggerDefinition DEFAULT;
    private static volatile LoggerDefinition logger;
    private static int logLevel;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = 99;

    public static void setVerbosity(int logLevel) {
        Logger.logLevel = logLevel;
    }

    public static void setLoggerDefinition(LoggerDefinition loggerDefinition) {
        logger = loggerDefinition;
    }

    public static void v(String tag, String msg) {
        if (logLevel <= 2) {
            logger.v(tag, msg);
        }
    }

    public static void v(String tag, String msg, Throwable tr) {
        if (logLevel <= 2) {
            logger.v(tag, msg, tr);
        }
    }

    public static void d(String tag, String msg) {
        if (logLevel <= 3) {
            logger.d(tag, msg);
        }
    }

    public static void d(String tag, String msg, Throwable tr) {
        if (logLevel <= 3) {
            logger.d(tag, msg, tr);
        }
    }

    public static void i(String tag, String msg) {
        if (logLevel <= 4) {
            logger.i(tag, msg);
        }
    }

    public static void i(String tag, String msg, Throwable tr) {
        if (logLevel <= 4) {
            logger.i(tag, msg, tr);
        }
    }

    public static void w(String tag, String msg) {
        if (logLevel <= 5) {
            logger.w(tag, msg);
        }
    }

    public static void w(String tag, String msg, Throwable tr) {
        if (logLevel <= 5) {
            logger.w(tag, msg, tr);
        }
    }

    public static void e(String tag, String msg) {
        if (logLevel <= 6) {
            logger.e(tag, msg);
        }
    }

    public static void e(String tag, String msg, Throwable tr) {
        if (logLevel <= 6) {
            logger.e(tag, msg, tr);
        }
    }

    public static void log(int severity, String tag, String message) {
        switch (severity) {
            case 2: {
                Logger.v(tag, message);
                break;
            }
            case 3: {
                Logger.d(tag, message);
                break;
            }
            case 4: {
                Logger.i(tag, message);
                break;
            }
            case 5: {
                Logger.w(tag, message);
                break;
            }
            case 6: {
                Logger.e(tag, message);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static {
        logger = DEFAULT = new LoggerDefinition(){

            @Override
            public void v(String tag, String msg) {
                Log.v((String)tag, (String)msg);
            }

            @Override
            public void v(String tag, String msg, Throwable tr) {
                Log.v((String)tag, (String)msg, (Throwable)tr);
            }

            @Override
            public void d(String tag, String msg) {
                Log.d((String)tag, (String)msg);
            }

            @Override
            public void d(String tag, String msg, Throwable tr) {
                Log.d((String)tag, (String)msg, (Throwable)tr);
            }

            @Override
            public void i(String tag, String msg) {
                Log.i((String)tag, (String)msg);
            }

            @Override
            public void i(String tag, String msg, Throwable tr) {
                Log.i((String)tag, (String)msg, (Throwable)tr);
            }

            @Override
            public void w(String tag, String msg) {
                Log.w((String)tag, (String)msg);
            }

            @Override
            public void w(String tag, String msg, Throwable tr) {
                Log.w((String)tag, (String)msg, (Throwable)tr);
            }

            @Override
            public void e(String tag, String msg) {
                Log.e((String)tag, (String)msg);
            }

            @Override
            public void e(String tag, String msg, Throwable tr) {
                Log.e((String)tag, (String)msg, (Throwable)tr);
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LogLevel {
    }
}

