/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.ResourcesCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.FontUtils;
import java.util.Arrays;

public class MapboxMapOptions
implements Parcelable {
    private static final int LIGHT_GRAY = -988703;
    private static final float FOUR_DP = 4.0f;
    private static final float NINETY_TWO_DP = 92.0f;
    private static final int UNDEFINED_COLOR = -1;
    private CameraPosition cameraPosition;
    private boolean debugActive;
    private boolean compassEnabled = true;
    private boolean fadeCompassFacingNorth = true;
    private int compassGravity = 8388661;
    private int[] compassMargins;
    private Drawable compassImage;
    private boolean logoEnabled = true;
    private int logoGravity = 8388691;
    private int[] logoMargins;
    @ColorInt
    private int attributionTintColor = -1;
    private boolean attributionEnabled = true;
    private int attributionGravity = 8388691;
    private int[] attributionMargins;
    private double minZoom = 0.0;
    private double maxZoom = 25.5;
    private boolean rotateGesturesEnabled = true;
    private boolean scrollGesturesEnabled = true;
    private boolean tiltGesturesEnabled = true;
    private boolean zoomGesturesEnabled = true;
    private boolean doubleTapGesturesEnabled = true;
    private boolean quickZoomGesturesEnabled = true;
    private boolean prefetchesTiles = true;
    private int prefetchZoomDelta = 4;
    private boolean zMediaOverlay = false;
    private boolean localIdeographFontFamilyEnabled = true;
    private String localIdeographFontFamily;
    private String[] localIdeographFontFamilies;
    private String apiBaseUri;
    private boolean textureMode;
    private boolean translucentTextureSurface;
    @ColorInt
    private int foregroundLoadColor;
    private float pixelRatio;
    private boolean crossSourceCollisions = true;
    public static final Parcelable.Creator<MapboxMapOptions> CREATOR = new Parcelable.Creator<MapboxMapOptions>(){

        public MapboxMapOptions createFromParcel(@NonNull Parcel in) {
            return new MapboxMapOptions(in);
        }

        public MapboxMapOptions[] newArray(int size) {
            return new MapboxMapOptions[size];
        }
    };

    @Deprecated
    public MapboxMapOptions() {
    }

    private MapboxMapOptions(Parcel in) {
        this.cameraPosition = (CameraPosition)in.readParcelable(CameraPosition.class.getClassLoader());
        this.debugActive = in.readByte() != 0;
        this.compassEnabled = in.readByte() != 0;
        this.compassGravity = in.readInt();
        this.compassMargins = in.createIntArray();
        this.fadeCompassFacingNorth = in.readByte() != 0;
        Bitmap compassBitmap = (Bitmap)in.readParcelable(this.getClass().getClassLoader());
        if (compassBitmap != null) {
            this.compassImage = new BitmapDrawable(compassBitmap);
        }
        this.logoEnabled = in.readByte() != 0;
        this.logoGravity = in.readInt();
        this.logoMargins = in.createIntArray();
        this.attributionEnabled = in.readByte() != 0;
        this.attributionGravity = in.readInt();
        this.attributionMargins = in.createIntArray();
        this.attributionTintColor = in.readInt();
        this.minZoom = in.readDouble();
        this.maxZoom = in.readDouble();
        this.rotateGesturesEnabled = in.readByte() != 0;
        this.scrollGesturesEnabled = in.readByte() != 0;
        this.tiltGesturesEnabled = in.readByte() != 0;
        this.zoomGesturesEnabled = in.readByte() != 0;
        this.doubleTapGesturesEnabled = in.readByte() != 0;
        this.quickZoomGesturesEnabled = in.readByte() != 0;
        this.apiBaseUri = in.readString();
        this.textureMode = in.readByte() != 0;
        this.translucentTextureSurface = in.readByte() != 0;
        this.prefetchesTiles = in.readByte() != 0;
        this.prefetchZoomDelta = in.readInt();
        this.zMediaOverlay = in.readByte() != 0;
        this.localIdeographFontFamilyEnabled = in.readByte() != 0;
        this.localIdeographFontFamily = in.readString();
        this.localIdeographFontFamilies = in.createStringArray();
        this.pixelRatio = in.readFloat();
        this.foregroundLoadColor = in.readInt();
        this.crossSourceCollisions = in.readByte() != 0;
    }

    @NonNull
    public static MapboxMapOptions createFromAttributes(@NonNull Context context) {
        return MapboxMapOptions.createFromAttributes(context, null);
    }

    @NonNull
    public static MapboxMapOptions createFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.mapbox_MapView, 0, 0);
        return MapboxMapOptions.createFromAttributes(new MapboxMapOptions(), context, typedArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static MapboxMapOptions createFromAttributes(@NonNull MapboxMapOptions mapboxMapOptions, @NonNull Context context, @Nullable TypedArray typedArray) {
        float pxlRatio = context.getResources().getDisplayMetrics().density;
        try {
            mapboxMapOptions.camera(new CameraPosition.Builder(typedArray).build());
            mapboxMapOptions.apiBaseUrl(typedArray.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUrl));
            String baseUri = typedArray.getString(R.styleable.mapbox_MapView_mapbox_apiBaseUri);
            if (!TextUtils.isEmpty((CharSequence)baseUri)) {
                mapboxMapOptions.apiBaseUri(baseUri);
            }
            mapboxMapOptions.zoomGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiZoomGestures, true));
            mapboxMapOptions.scrollGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiScrollGestures, true));
            mapboxMapOptions.rotateGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiRotateGestures, true));
            mapboxMapOptions.tiltGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiTiltGestures, true));
            mapboxMapOptions.doubleTapGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiDoubleTapGestures, true));
            mapboxMapOptions.quickZoomGesturesEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiQuickZoomGestures, true));
            mapboxMapOptions.maxZoomPreference(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMax, 25.5f));
            mapboxMapOptions.minZoomPreference(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_cameraZoomMin, 0.0f));
            mapboxMapOptions.compassEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompass, true));
            mapboxMapOptions.compassGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiCompassGravity, 8388661));
            mapboxMapOptions.compassMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiCompassMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.compassFadesWhenFacingNorth(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiCompassFadeFacingNorth, true));
            Drawable compassDrawable = typedArray.getDrawable(R.styleable.mapbox_MapView_mapbox_uiCompassDrawable);
            if (compassDrawable == null) {
                compassDrawable = ResourcesCompat.getDrawable((Resources)context.getResources(), (int)R.drawable.mapbox_compass_icon, null);
            }
            mapboxMapOptions.compassImage(compassDrawable);
            mapboxMapOptions.logoEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiLogo, true));
            mapboxMapOptions.logoGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiLogoGravity, 8388691));
            mapboxMapOptions.logoMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginLeft, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiLogoMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.attributionTintColor(typedArray.getColor(R.styleable.mapbox_MapView_mapbox_uiAttributionTintColor, -1));
            mapboxMapOptions.attributionEnabled(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_uiAttribution, true));
            mapboxMapOptions.attributionGravity(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_uiAttributionGravity, 8388691));
            mapboxMapOptions.attributionMargins(new int[]{(int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginLeft, 92.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginTop, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginRight, 4.0f * pxlRatio), (int)typedArray.getDimension(R.styleable.mapbox_MapView_mapbox_uiAttributionMarginBottom, 4.0f * pxlRatio)});
            mapboxMapOptions.textureMode(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_renderTextureMode, false));
            mapboxMapOptions.translucentTextureSurface(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_renderTextureTranslucentSurface, false));
            mapboxMapOptions.setPrefetchesTiles(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_enableTilePrefetch, true));
            mapboxMapOptions.setPrefetchZoomDelta(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_prefetchZoomDelta, 4));
            mapboxMapOptions.renderSurfaceOnTop(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_enableZMediaOverlay, false));
            mapboxMapOptions.localIdeographFontFamilyEnabled = typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_localIdeographEnabled, true);
            int localIdeographFontFamiliesResId = typedArray.getResourceId(R.styleable.mapbox_MapView_mapbox_localIdeographFontFamilies, 0);
            if (localIdeographFontFamiliesResId != 0) {
                String[] localIdeographFontFamilies = context.getResources().getStringArray(localIdeographFontFamiliesResId);
                mapboxMapOptions.localIdeographFontFamily(localIdeographFontFamilies);
            } else {
                String localIdeographFontFamily = typedArray.getString(R.styleable.mapbox_MapView_mapbox_localIdeographFontFamily);
                if (localIdeographFontFamily == null) {
                    localIdeographFontFamily = "sans-serif";
                }
                mapboxMapOptions.localIdeographFontFamily(localIdeographFontFamily);
            }
            mapboxMapOptions.pixelRatio(typedArray.getFloat(R.styleable.mapbox_MapView_mapbox_pixelRatio, 0.0f));
            mapboxMapOptions.foregroundLoadColor(typedArray.getInt(R.styleable.mapbox_MapView_mapbox_foregroundLoadColor, -988703));
            mapboxMapOptions.crossSourceCollisions(typedArray.getBoolean(R.styleable.mapbox_MapView_mapbox_cross_source_collisions, true));
        }
        finally {
            typedArray.recycle();
        }
        return mapboxMapOptions;
    }

    @Deprecated
    @NonNull
    public MapboxMapOptions apiBaseUrl(String apiBaseUrl) {
        this.apiBaseUri = apiBaseUrl;
        return this;
    }

    @NonNull
    public MapboxMapOptions apiBaseUri(String apiBaseUri) {
        this.apiBaseUri = apiBaseUri;
        return this;
    }

    @NonNull
    public MapboxMapOptions camera(CameraPosition cameraPosition) {
        this.cameraPosition = cameraPosition;
        return this;
    }

    @NonNull
    public MapboxMapOptions debugActive(boolean enabled) {
        this.debugActive = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions minZoomPreference(double minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    @NonNull
    public MapboxMapOptions maxZoomPreference(double maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    @NonNull
    public MapboxMapOptions compassEnabled(boolean enabled) {
        this.compassEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions compassGravity(int gravity) {
        this.compassGravity = gravity;
        return this;
    }

    @NonNull
    public MapboxMapOptions compassMargins(int[] margins) {
        this.compassMargins = margins;
        return this;
    }

    @NonNull
    public MapboxMapOptions compassFadesWhenFacingNorth(boolean compassFadeWhenFacingNorth) {
        this.fadeCompassFacingNorth = compassFadeWhenFacingNorth;
        return this;
    }

    @NonNull
    public MapboxMapOptions compassImage(Drawable compass) {
        this.compassImage = compass;
        return this;
    }

    @NonNull
    public MapboxMapOptions logoEnabled(boolean enabled) {
        this.logoEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions logoGravity(int gravity) {
        this.logoGravity = gravity;
        return this;
    }

    @NonNull
    public MapboxMapOptions logoMargins(int[] margins) {
        this.logoMargins = margins;
        return this;
    }

    @NonNull
    public MapboxMapOptions attributionEnabled(boolean enabled) {
        this.attributionEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions attributionGravity(int gravity) {
        this.attributionGravity = gravity;
        return this;
    }

    @NonNull
    public MapboxMapOptions attributionMargins(int[] margins) {
        this.attributionMargins = margins;
        return this;
    }

    @NonNull
    public MapboxMapOptions attributionTintColor(@ColorInt int color2) {
        this.attributionTintColor = color2;
        return this;
    }

    @NonNull
    public MapboxMapOptions rotateGesturesEnabled(boolean enabled) {
        this.rotateGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions scrollGesturesEnabled(boolean enabled) {
        this.scrollGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions tiltGesturesEnabled(boolean enabled) {
        this.tiltGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions zoomGesturesEnabled(boolean enabled) {
        this.zoomGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions doubleTapGesturesEnabled(boolean enabled) {
        this.doubleTapGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions quickZoomGesturesEnabled(boolean enabled) {
        this.quickZoomGesturesEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions textureMode(boolean textureMode) {
        this.textureMode = textureMode;
        return this;
    }

    @NonNull
    public MapboxMapOptions translucentTextureSurface(boolean translucentTextureSurface) {
        this.translucentTextureSurface = translucentTextureSurface;
        return this;
    }

    @NonNull
    public MapboxMapOptions foregroundLoadColor(@ColorInt int loadColor) {
        this.foregroundLoadColor = loadColor;
        return this;
    }

    @Deprecated
    @NonNull
    public MapboxMapOptions setPrefetchesTiles(boolean enable) {
        this.prefetchesTiles = enable;
        return this;
    }

    @NonNull
    public MapboxMapOptions setPrefetchZoomDelta(@IntRange(from=0L) int delta) {
        this.prefetchZoomDelta = delta;
        return this;
    }

    @NonNull
    public MapboxMapOptions crossSourceCollisions(boolean crossSourceCollisions) {
        this.crossSourceCollisions = crossSourceCollisions;
        return this;
    }

    @NonNull
    public MapboxMapOptions localIdeographFontFamilyEnabled(boolean enabled) {
        this.localIdeographFontFamilyEnabled = enabled;
        return this;
    }

    @NonNull
    public MapboxMapOptions localIdeographFontFamily(String fontFamily) {
        this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamily);
        return this;
    }

    @NonNull
    public MapboxMapOptions localIdeographFontFamily(String ... fontFamilies) {
        this.localIdeographFontFamily = FontUtils.extractValidFont(fontFamilies);
        return this;
    }

    @NonNull
    public MapboxMapOptions pixelRatio(float pixelRatio) {
        this.pixelRatio = pixelRatio;
        return this;
    }

    @Deprecated
    public boolean getPrefetchesTiles() {
        return this.prefetchesTiles;
    }

    @IntRange(from=0L)
    public int getPrefetchZoomDelta() {
        return this.prefetchZoomDelta;
    }

    public boolean getCrossSourceCollisions() {
        return this.crossSourceCollisions;
    }

    public void renderSurfaceOnTop(boolean renderOnTop) {
        this.zMediaOverlay = renderOnTop;
    }

    public boolean getRenderSurfaceOnTop() {
        return this.zMediaOverlay;
    }

    @Deprecated
    public String getApiBaseUrl() {
        return this.apiBaseUri;
    }

    public String getApiBaseUri() {
        return this.apiBaseUri;
    }

    public CameraPosition getCamera() {
        return this.cameraPosition;
    }

    public double getMinZoomPreference() {
        return this.minZoom;
    }

    public double getMaxZoomPreference() {
        return this.maxZoom;
    }

    public boolean getCompassEnabled() {
        return this.compassEnabled;
    }

    public int getCompassGravity() {
        return this.compassGravity;
    }

    public int[] getCompassMargins() {
        return this.compassMargins;
    }

    public boolean getCompassFadeFacingNorth() {
        return this.fadeCompassFacingNorth;
    }

    public Drawable getCompassImage() {
        return this.compassImage;
    }

    public boolean getLogoEnabled() {
        return this.logoEnabled;
    }

    public int getLogoGravity() {
        return this.logoGravity;
    }

    public int[] getLogoMargins() {
        return this.logoMargins;
    }

    public boolean getRotateGesturesEnabled() {
        return this.rotateGesturesEnabled;
    }

    public boolean getScrollGesturesEnabled() {
        return this.scrollGesturesEnabled;
    }

    public boolean getTiltGesturesEnabled() {
        return this.tiltGesturesEnabled;
    }

    public boolean getZoomGesturesEnabled() {
        return this.zoomGesturesEnabled;
    }

    public boolean getDoubleTapGesturesEnabled() {
        return this.doubleTapGesturesEnabled;
    }

    public boolean getQuickZoomGesturesEnabled() {
        return this.quickZoomGesturesEnabled;
    }

    public boolean getAttributionEnabled() {
        return this.attributionEnabled;
    }

    public int getAttributionGravity() {
        return this.attributionGravity;
    }

    public int[] getAttributionMargins() {
        return this.attributionMargins;
    }

    @ColorInt
    public int getAttributionTintColor() {
        return this.attributionTintColor;
    }

    public boolean getDebugActive() {
        return this.debugActive;
    }

    public boolean getTextureMode() {
        return this.textureMode;
    }

    public boolean getTranslucentTextureSurface() {
        return this.translucentTextureSurface;
    }

    @ColorInt
    public int getForegroundLoadColor() {
        return this.foregroundLoadColor;
    }

    @Nullable
    public String getLocalIdeographFontFamily() {
        return this.localIdeographFontFamilyEnabled ? this.localIdeographFontFamily : null;
    }

    public boolean isLocalIdeographFontFamilyEnabled() {
        return this.localIdeographFontFamilyEnabled;
    }

    public float getPixelRatio() {
        return this.pixelRatio;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.cameraPosition, flags);
        dest.writeByte((byte)(this.debugActive ? 1 : 0));
        dest.writeByte((byte)(this.compassEnabled ? 1 : 0));
        dest.writeInt(this.compassGravity);
        dest.writeIntArray(this.compassMargins);
        dest.writeByte((byte)(this.fadeCompassFacingNorth ? 1 : 0));
        dest.writeParcelable((Parcelable)(this.compassImage != null ? BitmapUtils.getBitmapFromDrawable(this.compassImage) : null), flags);
        dest.writeByte((byte)(this.logoEnabled ? 1 : 0));
        dest.writeInt(this.logoGravity);
        dest.writeIntArray(this.logoMargins);
        dest.writeByte((byte)(this.attributionEnabled ? 1 : 0));
        dest.writeInt(this.attributionGravity);
        dest.writeIntArray(this.attributionMargins);
        dest.writeInt(this.attributionTintColor);
        dest.writeDouble(this.minZoom);
        dest.writeDouble(this.maxZoom);
        dest.writeByte((byte)(this.rotateGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.scrollGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.tiltGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.zoomGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.doubleTapGesturesEnabled ? 1 : 0));
        dest.writeByte((byte)(this.quickZoomGesturesEnabled ? 1 : 0));
        dest.writeString(this.apiBaseUri);
        dest.writeByte((byte)(this.textureMode ? 1 : 0));
        dest.writeByte((byte)(this.translucentTextureSurface ? 1 : 0));
        dest.writeByte((byte)(this.prefetchesTiles ? 1 : 0));
        dest.writeInt(this.prefetchZoomDelta);
        dest.writeByte((byte)(this.zMediaOverlay ? 1 : 0));
        dest.writeByte((byte)(this.localIdeographFontFamilyEnabled ? 1 : 0));
        dest.writeString(this.localIdeographFontFamily);
        dest.writeStringArray(this.localIdeographFontFamilies);
        dest.writeFloat(this.pixelRatio);
        dest.writeInt(this.foregroundLoadColor);
        dest.writeByte((byte)(this.crossSourceCollisions ? 1 : 0));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapboxMapOptions options = (MapboxMapOptions)o;
        if (this.debugActive != options.debugActive) {
            return false;
        }
        if (this.compassEnabled != options.compassEnabled) {
            return false;
        }
        if (this.fadeCompassFacingNorth != options.fadeCompassFacingNorth) {
            return false;
        }
        if (this.compassImage != null ? !this.compassImage.equals(options.compassImage) : options.compassImage != null) {
            return false;
        }
        if (this.compassGravity != options.compassGravity) {
            return false;
        }
        if (this.logoEnabled != options.logoEnabled) {
            return false;
        }
        if (this.logoGravity != options.logoGravity) {
            return false;
        }
        if (this.attributionTintColor != options.attributionTintColor) {
            return false;
        }
        if (this.attributionEnabled != options.attributionEnabled) {
            return false;
        }
        if (this.attributionGravity != options.attributionGravity) {
            return false;
        }
        if (Double.compare(options.minZoom, this.minZoom) != 0) {
            return false;
        }
        if (Double.compare(options.maxZoom, this.maxZoom) != 0) {
            return false;
        }
        if (this.rotateGesturesEnabled != options.rotateGesturesEnabled) {
            return false;
        }
        if (this.scrollGesturesEnabled != options.scrollGesturesEnabled) {
            return false;
        }
        if (this.tiltGesturesEnabled != options.tiltGesturesEnabled) {
            return false;
        }
        if (this.zoomGesturesEnabled != options.zoomGesturesEnabled) {
            return false;
        }
        if (this.doubleTapGesturesEnabled != options.doubleTapGesturesEnabled) {
            return false;
        }
        if (this.quickZoomGesturesEnabled != options.quickZoomGesturesEnabled) {
            return false;
        }
        if (this.cameraPosition != null ? !this.cameraPosition.equals(options.cameraPosition) : options.cameraPosition != null) {
            return false;
        }
        if (!Arrays.equals(this.compassMargins, options.compassMargins)) {
            return false;
        }
        if (!Arrays.equals(this.logoMargins, options.logoMargins)) {
            return false;
        }
        if (!Arrays.equals(this.attributionMargins, options.attributionMargins)) {
            return false;
        }
        if (this.apiBaseUri != null ? !this.apiBaseUri.equals(options.apiBaseUri) : options.apiBaseUri != null) {
            return false;
        }
        if (this.prefetchesTiles != options.prefetchesTiles) {
            return false;
        }
        if (this.prefetchZoomDelta != options.prefetchZoomDelta) {
            return false;
        }
        if (this.zMediaOverlay != options.zMediaOverlay) {
            return false;
        }
        if (this.localIdeographFontFamilyEnabled != options.localIdeographFontFamilyEnabled) {
            return false;
        }
        if (!this.localIdeographFontFamily.equals(options.localIdeographFontFamily)) {
            return false;
        }
        if (!Arrays.equals(this.localIdeographFontFamilies, options.localIdeographFontFamilies)) {
            return false;
        }
        if (this.pixelRatio != options.pixelRatio) {
            return false;
        }
        if (this.crossSourceCollisions != options.crossSourceCollisions) {
            return false;
        }
        return false;
    }

    public int hashCode() {
        int result = this.cameraPosition != null ? this.cameraPosition.hashCode() : 0;
        result = 31 * result + (this.debugActive ? 1 : 0);
        result = 31 * result + (this.compassEnabled ? 1 : 0);
        result = 31 * result + (this.fadeCompassFacingNorth ? 1 : 0);
        result = 31 * result + this.compassGravity;
        result = 31 * result + (this.compassImage != null ? this.compassImage.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.compassMargins);
        result = 31 * result + (this.logoEnabled ? 1 : 0);
        result = 31 * result + this.logoGravity;
        result = 31 * result + Arrays.hashCode(this.logoMargins);
        result = 31 * result + this.attributionTintColor;
        result = 31 * result + (this.attributionEnabled ? 1 : 0);
        result = 31 * result + this.attributionGravity;
        result = 31 * result + Arrays.hashCode(this.attributionMargins);
        long temp = Double.doubleToLongBits(this.minZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rotateGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.scrollGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.tiltGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.zoomGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.doubleTapGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.quickZoomGesturesEnabled ? 1 : 0);
        result = 31 * result + (this.apiBaseUri != null ? this.apiBaseUri.hashCode() : 0);
        result = 31 * result + (this.textureMode ? 1 : 0);
        result = 31 * result + (this.translucentTextureSurface ? 1 : 0);
        result = 31 * result + (this.prefetchesTiles ? 1 : 0);
        result = 31 * result + this.prefetchZoomDelta;
        result = 31 * result + (this.zMediaOverlay ? 1 : 0);
        result = 31 * result + (this.localIdeographFontFamilyEnabled ? 1 : 0);
        result = 31 * result + (this.localIdeographFontFamily != null ? this.localIdeographFontFamily.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.localIdeographFontFamilies);
        result = 31 * result + (int)this.pixelRatio;
        result = 31 * result + (this.crossSourceCollisions ? 1 : 0);
        return result;
    }
}

