/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.google.gson.JsonElement;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.utils.ColorUtils;

@UiThread
public class LineLayer
extends Layer {
    @Keep
    LineLayer(long nativePtr) {
        super(nativePtr);
    }

    public LineLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public LineLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public LineLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    @NonNull
    public LineLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<String> getLineCap() {
        this.checkThread();
        return new PropertyValue<Object>("line-cap", this.nativeGetLineCap());
    }

    @NonNull
    public PropertyValue<String> getLineJoin() {
        this.checkThread();
        return new PropertyValue<Object>("line-join", this.nativeGetLineJoin());
    }

    @NonNull
    public PropertyValue<Float> getLineMiterLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-miter-limit", this.nativeGetLineMiterLimit());
    }

    @NonNull
    public PropertyValue<Float> getLineRoundLimit() {
        this.checkThread();
        return new PropertyValue<Object>("line-round-limit", this.nativeGetLineRoundLimit());
    }

    @NonNull
    public PropertyValue<Float> getLineSortKey() {
        this.checkThread();
        return new PropertyValue<Object>("line-sort-key", this.nativeGetLineSortKey());
    }

    @NonNull
    public PropertyValue<Float> getLineOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("line-opacity", this.nativeGetLineOpacity());
    }

    @NonNull
    public TransitionOptions getLineOpacityTransition() {
        this.checkThread();
        return this.nativeGetLineOpacityTransition();
    }

    public void setLineOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getLineColor() {
        this.checkThread();
        return new PropertyValue<Object>("line-color", this.nativeGetLineColor());
    }

    @ColorInt
    public int getLineColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getLineColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getLineColorTransition() {
        this.checkThread();
        return this.nativeGetLineColorTransition();
    }

    public void setLineColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getLineTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate", this.nativeGetLineTranslate());
    }

    @NonNull
    public TransitionOptions getLineTranslateTransition() {
        this.checkThread();
        return this.nativeGetLineTranslateTransition();
    }

    public void setLineTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getLineTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("line-translate-anchor", this.nativeGetLineTranslateAnchor());
    }

    @NonNull
    public PropertyValue<Float> getLineWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-width", this.nativeGetLineWidth());
    }

    @NonNull
    public TransitionOptions getLineWidthTransition() {
        this.checkThread();
        return this.nativeGetLineWidthTransition();
    }

    public void setLineWidthTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineWidthTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getLineGapWidth() {
        this.checkThread();
        return new PropertyValue<Object>("line-gap-width", this.nativeGetLineGapWidth());
    }

    @NonNull
    public TransitionOptions getLineGapWidthTransition() {
        this.checkThread();
        return this.nativeGetLineGapWidthTransition();
    }

    public void setLineGapWidthTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineGapWidthTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getLineOffset() {
        this.checkThread();
        return new PropertyValue<Object>("line-offset", this.nativeGetLineOffset());
    }

    @NonNull
    public TransitionOptions getLineOffsetTransition() {
        this.checkThread();
        return this.nativeGetLineOffsetTransition();
    }

    public void setLineOffsetTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineOffsetTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getLineBlur() {
        this.checkThread();
        return new PropertyValue<Object>("line-blur", this.nativeGetLineBlur());
    }

    @NonNull
    public TransitionOptions getLineBlurTransition() {
        this.checkThread();
        return this.nativeGetLineBlurTransition();
    }

    public void setLineBlurTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineBlurTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getLineDasharray() {
        this.checkThread();
        return new PropertyValue<Object>("line-dasharray", this.nativeGetLineDasharray());
    }

    @NonNull
    public TransitionOptions getLineDasharrayTransition() {
        this.checkThread();
        return this.nativeGetLineDasharrayTransition();
    }

    public void setLineDasharrayTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLineDasharrayTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getLinePattern() {
        this.checkThread();
        return new PropertyValue<Object>("line-pattern", this.nativeGetLinePattern());
    }

    @NonNull
    public TransitionOptions getLinePatternTransition() {
        this.checkThread();
        return this.nativeGetLinePatternTransition();
    }

    public void setLinePatternTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetLinePatternTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getLineGradient() {
        this.checkThread();
        return new PropertyValue<Object>("line-gradient", this.nativeGetLineGradient());
    }

    @ColorInt
    public int getLineGradientAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getLineGradient();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("line-gradient was set as a Function");
    }

    @NonNull
    @Keep
    private native Object nativeGetLineCap();

    @NonNull
    @Keep
    private native Object nativeGetLineJoin();

    @NonNull
    @Keep
    private native Object nativeGetLineMiterLimit();

    @NonNull
    @Keep
    private native Object nativeGetLineRoundLimit();

    @NonNull
    @Keep
    private native Object nativeGetLineSortKey();

    @NonNull
    @Keep
    private native Object nativeGetLineOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineOpacityTransition();

    @Keep
    private native void nativeSetLineOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineColorTransition();

    @Keep
    private native void nativeSetLineColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineTranslateTransition();

    @Keep
    private native void nativeSetLineTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineTranslateAnchor();

    @NonNull
    @Keep
    private native Object nativeGetLineWidth();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineWidthTransition();

    @Keep
    private native void nativeSetLineWidthTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineGapWidth();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineGapWidthTransition();

    @Keep
    private native void nativeSetLineGapWidthTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineOffset();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineOffsetTransition();

    @Keep
    private native void nativeSetLineOffsetTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineBlur();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineBlurTransition();

    @Keep
    private native void nativeSetLineBlurTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineDasharray();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLineDasharrayTransition();

    @Keep
    private native void nativeSetLineDasharrayTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLinePattern();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetLinePatternTransition();

    @Keep
    private native void nativeSetLinePatternTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetLineGradient();

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

