/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.graphics.Bitmap;
import androidx.annotation.Nullable;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.location.LayerSourceProvider;
import com.mapbox.mapboxsdk.location.LocationComponentPositionManager;
import com.mapbox.mapboxsdk.location.LocationLayerRenderer;
import com.mapbox.mapboxsdk.location.LocationPropertyFactory;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.mapboxsdk.utils.ColorUtils;

class IndicatorLocationLayerRenderer
implements LocationLayerRenderer {
    private Style style;
    private final LayerSourceProvider layerSourceProvider;
    private Layer layer;
    @Nullable
    private LatLng lastLatLng;
    private double lastBearing = 0.0;
    private float lastAccuracy = 0.0f;

    IndicatorLocationLayerRenderer(LayerSourceProvider layerSourceProvider) {
        this.layerSourceProvider = layerSourceProvider;
    }

    @Override
    public void initializeComponents(Style style2) {
        this.style = style2;
        this.layer = this.layerSourceProvider.generateLocationComponentLayer();
        if (this.lastLatLng != null) {
            this.setLatLng(this.lastLatLng);
        }
        this.setLayerBearing(this.lastBearing);
        this.setAccuracyRadius(Float.valueOf(this.lastAccuracy));
    }

    @Override
    public void addLayers(LocationComponentPositionManager positionManager) {
        positionManager.addLayerToMap(this.layer);
    }

    @Override
    public void removeLayers() {
        this.style.removeLayer(this.layer);
    }

    @Override
    public void hide() {
        this.setLayerVisibility(false);
    }

    @Override
    public void cameraTiltUpdated(double tilt) {
    }

    @Override
    public void cameraBearingUpdated(double bearing) {
    }

    @Override
    public void show(int renderMode, boolean isStale) {
        this.setImages(renderMode, isStale);
        this.setLayerVisibility(true);
    }

    @Override
    public void styleAccuracy(float accuracyAlpha, int accuracyColor) {
        float[] colorArray = ColorUtils.colorToRgbaArray(accuracyColor);
        colorArray[3] = accuracyAlpha;
        Expression rgbaExpression = Expression.rgba(Float.valueOf(colorArray[0]), Float.valueOf(colorArray[1]), Float.valueOf(colorArray[2]), Float.valueOf(colorArray[3]));
        this.layer.setProperties(LocationPropertyFactory.accuracyRadiusColor(rgbaExpression), LocationPropertyFactory.accuracyRadiusBorderColor(rgbaExpression));
    }

    @Override
    public void setLatLng(LatLng latLng) {
        this.setLayerLocation(latLng);
    }

    @Override
    public void setGpsBearing(Float gpsBearing) {
        this.setLayerBearing(gpsBearing.floatValue());
    }

    @Override
    public void setCompassBearing(Float compassBearing) {
        this.setLayerBearing(compassBearing.floatValue());
    }

    @Override
    public void setAccuracyRadius(Float accuracy) {
        this.layer.setProperties(LocationPropertyFactory.accuracyRadius(accuracy));
        this.lastAccuracy = accuracy.floatValue();
    }

    @Override
    public void styleScaling(Expression scaleExpression) {
        this.layer.setProperties(LocationPropertyFactory.shadowImageSize(scaleExpression), LocationPropertyFactory.bearingImageSize(scaleExpression), LocationPropertyFactory.topImageSize(scaleExpression));
    }

    @Override
    public void setLocationStale(boolean isStale, int renderMode) {
        this.setImages(renderMode, isStale);
    }

    @Override
    public void updateIconIds(String foregroundIconString, String foregroundStaleIconString, String backgroundIconString, String backgroundStaleIconString, String bearingIconString) {
    }

    @Override
    public void addBitmaps(int renderMode, @Nullable Bitmap shadowBitmap, Bitmap backgroundBitmap, Bitmap backgroundStaleBitmap, Bitmap bearingBitmap, Bitmap foregroundBitmap, Bitmap foregroundStaleBitmap) {
        if (shadowBitmap != null) {
            this.style.addImage("mapbox-location-shadow-icon", shadowBitmap);
        } else {
            this.style.removeImage("mapbox-location-shadow-icon");
        }
        this.style.addImage("mapbox-location-icon", foregroundBitmap);
        this.style.addImage("mapbox-location-stale-icon", foregroundStaleBitmap);
        if (renderMode == 4) {
            float leftOffset = (float)(bearingBitmap.getWidth() - backgroundBitmap.getWidth()) / 2.0f;
            float topOffset = (float)(bearingBitmap.getHeight() - backgroundBitmap.getHeight()) / 2.0f;
            this.style.addImage("mapbox-location-bearing-icon", BitmapUtils.mergeBitmap(bearingBitmap, backgroundBitmap, leftOffset, topOffset));
            float staleLeftOffset = (float)(bearingBitmap.getWidth() - backgroundStaleBitmap.getWidth()) / 2.0f;
            float staleTopOffset = (float)(bearingBitmap.getHeight() - backgroundStaleBitmap.getHeight()) / 2.0f;
            this.style.addImage("mapbox-location-bearing-stale-icon", BitmapUtils.mergeBitmap(bearingBitmap, backgroundStaleBitmap, staleLeftOffset, staleTopOffset));
        } else {
            this.style.addImage("mapbox-location-stroke-icon", backgroundBitmap);
            this.style.addImage("mapbox-location-background-stale-icon", backgroundStaleBitmap);
            this.style.addImage("mapbox-location-bearing-icon", bearingBitmap);
        }
    }

    private void setLayerVisibility(boolean visible) {
        this.layer.setProperties(LocationPropertyFactory.visibility(visible ? "visible" : "none"));
    }

    private void setLayerLocation(LatLng latLng) {
        Double[] values = new Double[]{latLng.getLatitude(), latLng.getLongitude(), 0.0};
        this.layer.setProperties(LocationPropertyFactory.location(values));
        this.lastLatLng = latLng;
    }

    private void setLayerBearing(double bearing) {
        this.layer.setProperties(LocationPropertyFactory.bearing(bearing));
        this.lastBearing = bearing;
    }

    private void setImages(int renderMode, boolean isStale) {
        String topImage = "";
        String bearingImage = "";
        String shadowImage = "";
        switch (renderMode) {
            case 4: {
                topImage = isStale ? "mapbox-location-stale-icon" : "mapbox-location-icon";
                bearingImage = isStale ? "mapbox-location-bearing-stale-icon" : "mapbox-location-bearing-icon";
                shadowImage = "mapbox-location-shadow-icon";
                break;
            }
            case 8: {
                topImage = "";
                bearingImage = isStale ? "mapbox-location-stale-icon" : "mapbox-location-icon";
                shadowImage = "";
                this.setAccuracyRadius(Float.valueOf(0.0f));
                break;
            }
            case 18: {
                topImage = isStale ? "mapbox-location-stale-icon" : "mapbox-location-icon";
                bearingImage = isStale ? "mapbox-location-background-stale-icon" : "mapbox-location-stroke-icon";
                shadowImage = "mapbox-location-shadow-icon";
            }
        }
        this.layer.setProperties(LocationPropertyFactory.topImage(topImage), LocationPropertyFactory.bearingImage(bearingImage), LocationPropertyFactory.shadowImage(shadowImage));
    }
}

