/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.location;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.mapbox.mapboxsdk.R;
import com.mapbox.mapboxsdk.location.LocationComponentOptions;
import com.mapbox.mapboxsdk.location.Utils;
import com.mapbox.mapboxsdk.utils.BitmapUtils;

class LayerBitmapProvider {
    private final Context context;

    LayerBitmapProvider(Context context) {
        this.context = context;
    }

    Bitmap generateBitmap(@DrawableRes int drawableRes, @ColorInt Integer tintColor) {
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(this.context, drawableRes, tintColor);
        return BitmapUtils.getBitmapFromDrawable(drawable2);
    }

    Bitmap generateShadowBitmap(@NonNull LocationComponentOptions options) {
        Drawable shadowDrawable = BitmapUtils.getDrawableFromRes(this.context, R.drawable.mapbox_user_icon_shadow);
        return Utils.generateShadow(shadowDrawable, options.elevation());
    }
}

