/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.maps;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Handler;
import android.text.TextUtils;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.Geometry;
import com.mapbox.mapboxsdk.LibraryLoader;
import com.mapbox.mapboxsdk.MapStrictMode;
import com.mapbox.mapboxsdk.annotations.Icon;
import com.mapbox.mapboxsdk.annotations.Marker;
import com.mapbox.mapboxsdk.annotations.Polygon;
import com.mapbox.mapboxsdk.annotations.Polyline;
import com.mapbox.mapboxsdk.camera.CameraPosition;
import com.mapbox.mapboxsdk.exceptions.CalledFromWorkerThreadException;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.geometry.ProjectedMeters;
import com.mapbox.mapboxsdk.log.Logger;
import com.mapbox.mapboxsdk.maps.Image;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.NativeMap;
import com.mapbox.mapboxsdk.maps.renderer.MapRenderer;
import com.mapbox.mapboxsdk.storage.FileSource;
import com.mapbox.mapboxsdk.style.expressions.Expression;
import com.mapbox.mapboxsdk.style.layers.CannotAddLayerException;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.TransitionOptions;
import com.mapbox.mapboxsdk.style.light.Light;
import com.mapbox.mapboxsdk.style.sources.CannotAddSourceException;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class NativeMapView
implements NativeMap {
    private static final String TAG = "Mbgl-NativeMapView";
    private final FileSource fileSource;
    private final MapRenderer mapRenderer;
    @NonNull
    private final Thread thread;
    @Nullable
    private ViewCallback viewCallback;
    @Nullable
    private StateCallback stateCallback;
    private final float pixelRatio;
    private boolean destroyed = false;
    private double[] edgeInsets;
    @Keep
    private long nativePtr = 0L;
    private MapboxMap.SnapshotReadyCallback snapshotReadyCallback;

    public NativeMapView(@NonNull Context context, boolean crossSourceCollisions, ViewCallback viewCallback, StateCallback stateCallback, MapRenderer mapRenderer) {
        this(context, context.getResources().getDisplayMetrics().density, crossSourceCollisions, viewCallback, stateCallback, mapRenderer);
    }

    public NativeMapView(Context context, float pixelRatio, boolean crossSourceCollisions, ViewCallback viewCallback, StateCallback stateCallback, MapRenderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        this.viewCallback = viewCallback;
        this.fileSource = FileSource.getInstance(context);
        this.pixelRatio = pixelRatio;
        this.thread = Thread.currentThread();
        this.stateCallback = stateCallback;
        this.nativeInitialize(this, this.fileSource, mapRenderer, pixelRatio, crossSourceCollisions);
    }

    private boolean checkState(String callingMethod) {
        if (this.thread != Thread.currentThread()) {
            throw new CalledFromWorkerThreadException(String.format("Map interactions should happen on the UI thread. Method invoked from wrong thread is %s.", callingMethod));
        }
        if (this.destroyed && !TextUtils.isEmpty((CharSequence)callingMethod)) {
            String message = String.format("You're calling `%s` after the `MapView` was destroyed, were you invoking it after `onDestroy()`?", callingMethod);
            Logger.e(TAG, message);
            MapStrictMode.strictModeViolation(message);
        }
        return this.destroyed;
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        this.viewCallback = null;
        this.nativeDestroy();
    }

    @Override
    public void resizeView(int width, int height) {
        if (this.checkState("resizeView")) {
            return;
        }
        width = (int)Math.ceil((float)width / this.pixelRatio);
        height = (int)Math.ceil((float)height / this.pixelRatio);
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be negative.");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be negative.");
        }
        if (width > 65535) {
            Logger.e(TAG, String.format("Device returned an out of range width size, capping value at 65535 instead of %s", width));
            width = 65535;
        }
        if (height > 65535) {
            Logger.e(TAG, String.format("Device returned an out of range height size, capping value at 65535 instead of %s", height));
            height = 65535;
        }
        this.nativeResizeView(width, height);
    }

    @Override
    public void setStyleUri(String url) {
        if (this.checkState("setStyleUri")) {
            return;
        }
        this.nativeSetStyleUrl(url);
    }

    @Override
    @NonNull
    public String getStyleUri() {
        if (this.checkState("getStyleUri")) {
            return "";
        }
        return this.nativeGetStyleUrl();
    }

    @Override
    public void setStyleJson(String newStyleJson) {
        if (this.checkState("setStyleJson")) {
            return;
        }
        this.nativeSetStyleJson(newStyleJson);
    }

    @Override
    @NonNull
    public String getStyleJson() {
        if (this.checkState("getStyleJson")) {
            return "";
        }
        return this.nativeGetStyleJson();
    }

    @Override
    public void setLatLngBounds(LatLngBounds latLngBounds) {
        if (this.checkState("setLatLngBounds")) {
            return;
        }
        this.nativeSetLatLngBounds(latLngBounds);
    }

    @Override
    public void cancelTransitions() {
        if (this.checkState("cancelTransitions")) {
            return;
        }
        this.nativeCancelTransitions();
    }

    @Override
    public void setGestureInProgress(boolean inProgress) {
        if (this.checkState("setGestureInProgress")) {
            return;
        }
        this.nativeSetGestureInProgress(inProgress);
    }

    @Override
    public void moveBy(double dx, double dy, long duration) {
        if (this.checkState("moveBy")) {
            return;
        }
        this.nativeMoveBy(dx / (double)this.pixelRatio, dy / (double)this.pixelRatio, duration);
    }

    @Override
    public void setLatLng(@NonNull LatLng latLng, long duration) {
        if (this.checkState("setLatLng")) {
            return;
        }
        this.nativeSetLatLng(latLng.getLatitude(), latLng.getLongitude(), this.getAnimationPaddingAndClearCachedInsets(null), duration);
    }

    @Override
    public LatLng getLatLng() {
        if (this.checkState("")) {
            return new LatLng();
        }
        return this.nativeGetLatLng();
    }

    @Override
    public CameraPosition getCameraForLatLngBounds(LatLngBounds bounds, int[] padding, double bearing, double tilt) {
        if (this.checkState("getCameraForLatLngBounds")) {
            return null;
        }
        return this.nativeGetCameraForLatLngBounds(bounds, (float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio, bearing, tilt);
    }

    @Override
    public CameraPosition getCameraForGeometry(Geometry geometry, int[] padding, double bearing, double tilt) {
        if (this.checkState("getCameraForGeometry")) {
            return null;
        }
        return this.nativeGetCameraForGeometry(geometry, (float)padding[1] / this.pixelRatio, (float)padding[0] / this.pixelRatio, (float)padding[3] / this.pixelRatio, (float)padding[2] / this.pixelRatio, bearing, tilt);
    }

    @Override
    public void resetPosition() {
        if (this.checkState("resetPosition")) {
            return;
        }
        this.nativeResetPosition();
    }

    @Override
    public double getPitch() {
        if (this.checkState("getPitch")) {
            return 0.0;
        }
        return this.nativeGetPitch();
    }

    @Override
    public void setPitch(double pitch, long duration) {
        if (this.checkState("setPitch")) {
            return;
        }
        this.nativeSetPitch(pitch, duration);
    }

    @Override
    public void setZoom(double zoom, @NonNull PointF focalPoint, long duration) {
        if (this.checkState("setZoom")) {
            return;
        }
        this.nativeSetZoom(zoom, focalPoint.x / this.pixelRatio, focalPoint.y / this.pixelRatio, duration);
    }

    @Override
    public double getZoom() {
        if (this.checkState("getZoom")) {
            return 0.0;
        }
        return this.nativeGetZoom();
    }

    @Override
    public void resetZoom() {
        if (this.checkState("resetZoom")) {
            return;
        }
        this.nativeResetZoom();
    }

    @Override
    public void setMinZoom(double zoom) {
        if (this.checkState("setMinZoom")) {
            return;
        }
        this.nativeSetMinZoom(zoom);
    }

    @Override
    public double getMinZoom() {
        if (this.checkState("getMinZoom")) {
            return 0.0;
        }
        return this.nativeGetMinZoom();
    }

    @Override
    public void setMaxZoom(double zoom) {
        if (this.checkState("setMaxZoom")) {
            return;
        }
        this.nativeSetMaxZoom(zoom);
    }

    @Override
    public double getMaxZoom() {
        if (this.checkState("getMaxZoom")) {
            return 0.0;
        }
        return this.nativeGetMaxZoom();
    }

    @Override
    public void setMinPitch(double pitch) {
        if (this.checkState("setMinPitch")) {
            return;
        }
        this.nativeSetMinPitch(pitch);
    }

    @Override
    public double getMinPitch() {
        if (this.checkState("getMinPitch")) {
            return 0.0;
        }
        return this.nativeGetMinPitch();
    }

    @Override
    public void setMaxPitch(double pitch) {
        if (this.checkState("setMaxPitch")) {
            return;
        }
        this.nativeSetMaxPitch(pitch);
    }

    @Override
    public double getMaxPitch() {
        if (this.checkState("getMaxPitch")) {
            return 0.0;
        }
        return this.nativeGetMaxPitch();
    }

    @Override
    public void rotateBy(double sx, double sy, double ex, double ey, long duration) {
        if (this.checkState("rotateBy")) {
            return;
        }
        this.nativeRotateBy(sx / (double)this.pixelRatio, sy / (double)this.pixelRatio, ex, ey, duration);
    }

    @Override
    public void setContentPadding(double[] padding) {
        if (this.checkState("setContentPadding")) {
            return;
        }
        this.edgeInsets = padding;
    }

    @Override
    public double[] getContentPadding() {
        if (this.checkState("getContentPadding")) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        return this.edgeInsets != null ? this.edgeInsets : this.getCameraPosition().padding;
    }

    @Override
    public void setBearing(double degrees, long duration) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.nativeSetBearing(degrees, duration);
    }

    @Override
    public void setBearing(double degrees, double fx, double fy, long duration) {
        if (this.checkState("setBearing")) {
            return;
        }
        this.nativeSetBearingXY(degrees, fx / (double)this.pixelRatio, fy / (double)this.pixelRatio, duration);
    }

    @Override
    public double getBearing() {
        if (this.checkState("getBearing")) {
            return 0.0;
        }
        return this.nativeGetBearing();
    }

    @Override
    public void resetNorth() {
        if (this.checkState("resetNorth")) {
            return;
        }
        this.nativeResetNorth();
    }

    @Override
    public long addMarker(Marker marker) {
        if (this.checkState("addMarker")) {
            return 0L;
        }
        Marker[] markers = new Marker[]{marker};
        return this.nativeAddMarkers(markers)[0];
    }

    @Override
    @NonNull
    public long[] addMarkers(@NonNull List<Marker> markers) {
        if (this.checkState("addMarkers")) {
            return new long[0];
        }
        return this.nativeAddMarkers(markers.toArray(new Marker[markers.size()]));
    }

    @Override
    public long addPolyline(Polyline polyline) {
        if (this.checkState("addPolyline")) {
            return 0L;
        }
        Polyline[] polylines = new Polyline[]{polyline};
        return this.nativeAddPolylines(polylines)[0];
    }

    @Override
    @NonNull
    public long[] addPolylines(@NonNull List<Polyline> polylines) {
        if (this.checkState("addPolylines")) {
            return new long[0];
        }
        return this.nativeAddPolylines(polylines.toArray(new Polyline[polylines.size()]));
    }

    @Override
    public long addPolygon(Polygon polygon) {
        if (this.checkState("addPolygon")) {
            return 0L;
        }
        Polygon[] polygons = new Polygon[]{polygon};
        return this.nativeAddPolygons(polygons)[0];
    }

    @Override
    @NonNull
    public long[] addPolygons(@NonNull List<Polygon> polygons) {
        if (this.checkState("addPolygons")) {
            return new long[0];
        }
        return this.nativeAddPolygons(polygons.toArray(new Polygon[polygons.size()]));
    }

    @Override
    public void updateMarker(@NonNull Marker marker) {
        if (this.checkState("updateMarker")) {
            return;
        }
        LatLng position = marker.getPosition();
        Icon icon = marker.getIcon();
        this.nativeUpdateMarker(marker.getId(), position.getLatitude(), position.getLongitude(), icon.getId());
    }

    @Override
    public void updatePolygon(@NonNull Polygon polygon) {
        if (this.checkState("updatePolygon")) {
            return;
        }
        this.nativeUpdatePolygon(polygon.getId(), polygon);
    }

    @Override
    public void updatePolyline(@NonNull Polyline polyline) {
        if (this.checkState("updatePolyline")) {
            return;
        }
        this.nativeUpdatePolyline(polyline.getId(), polyline);
    }

    @Override
    public void removeAnnotation(long id2) {
        if (this.checkState("removeAnnotation")) {
            return;
        }
        long[] ids = new long[]{id2};
        this.removeAnnotations(ids);
    }

    @Override
    public void removeAnnotations(long[] ids) {
        if (this.checkState("removeAnnotations")) {
            return;
        }
        this.nativeRemoveAnnotations(ids);
    }

    @Override
    @NonNull
    public long[] queryPointAnnotations(RectF rect) {
        if (this.checkState("queryPointAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryPointAnnotations(rect);
    }

    @Override
    @NonNull
    public long[] queryShapeAnnotations(RectF rectF) {
        if (this.checkState("queryShapeAnnotations")) {
            return new long[0];
        }
        return this.nativeQueryShapeAnnotations(rectF);
    }

    @Override
    public void addAnnotationIcon(String symbol, int width, int height, float scale, byte[] pixels) {
        if (this.checkState("addAnnotationIcon")) {
            return;
        }
        this.nativeAddAnnotationIcon(symbol, width, height, scale, pixels);
    }

    @Override
    public void removeAnnotationIcon(String symbol) {
        if (this.checkState("removeAnnotationIcon")) {
            return;
        }
        this.nativeRemoveAnnotationIcon(symbol);
    }

    @Override
    public void setVisibleCoordinateBounds(LatLng[] coordinates, RectF padding, double direction, long duration) {
        if (this.checkState("setVisibleCoordinateBounds")) {
            return;
        }
        this.nativeSetVisibleCoordinateBounds(coordinates, padding, direction, duration);
    }

    @Override
    public void onLowMemory() {
        if (this.checkState("onLowMemory")) {
            return;
        }
        this.nativeOnLowMemory();
    }

    @Override
    public void setDebug(boolean debug) {
        if (this.checkState("setDebug")) {
            return;
        }
        this.nativeSetDebug(debug);
    }

    @Override
    public boolean getDebug() {
        if (this.checkState("getDebug")) {
            return false;
        }
        return this.nativeGetDebug();
    }

    @Override
    public boolean isFullyLoaded() {
        if (this.checkState("isFullyLoaded")) {
            return false;
        }
        return this.nativeIsFullyLoaded();
    }

    @Override
    public void setReachability(boolean status) {
        if (this.checkState("setReachability")) {
            return;
        }
        this.nativeSetReachability(status);
    }

    @Override
    public double getMetersPerPixelAtLatitude(double lat) {
        if (this.checkState("getMetersPerPixelAtLatitude")) {
            return 0.0;
        }
        return this.nativeGetMetersPerPixelAtLatitude(lat, this.getZoom());
    }

    @Override
    public ProjectedMeters projectedMetersForLatLng(@NonNull LatLng latLng) {
        if (this.checkState("projectedMetersForLatLng")) {
            return null;
        }
        return this.nativeProjectedMetersForLatLng(latLng.getLatitude(), latLng.getLongitude());
    }

    @Override
    public LatLng latLngForProjectedMeters(@NonNull ProjectedMeters projectedMeters) {
        if (this.checkState("latLngForProjectedMeters")) {
            return new LatLng();
        }
        return this.nativeLatLngForProjectedMeters(projectedMeters.getNorthing(), projectedMeters.getEasting());
    }

    @Override
    @NonNull
    public PointF pixelForLatLng(@NonNull LatLng latLng) {
        if (this.checkState("pixelForLatLng")) {
            return new PointF();
        }
        PointF pointF = this.nativePixelForLatLng(latLng.getLatitude(), latLng.getLongitude());
        pointF.set(pointF.x * this.pixelRatio, pointF.y * this.pixelRatio);
        return pointF;
    }

    @Override
    public void pixelsForLatLngs(@NonNull double[] input, @NonNull double[] output) {
        if (!this.checkState("pixelsForLatLngs")) {
            this.nativePixelsForLatLngs(input, output, this.pixelRatio);
        }
    }

    @Override
    public void getVisibleCoordinateBounds(@NonNull double[] output) {
        if (!this.checkState("getVisibleCoordinateBounds")) {
            this.nativeGetVisibleCoordinateBounds(output);
        }
    }

    @Override
    public LatLng latLngForPixel(@NonNull PointF pixel) {
        if (this.checkState("latLngForPixel")) {
            return new LatLng();
        }
        return this.nativeLatLngForPixel(pixel.x / this.pixelRatio, pixel.y / this.pixelRatio);
    }

    @Override
    public void latLngsForPixels(@NonNull double[] input, @NonNull double[] output) {
        if (!this.checkState("latLngsForPixels")) {
            this.nativeLatLngsForPixels(input, output, this.pixelRatio);
        }
    }

    @Override
    public double getTopOffsetPixelsForAnnotationSymbol(String symbolName) {
        if (this.checkState("getTopOffsetPixelsForAnnotationSymbol")) {
            return 0.0;
        }
        return this.nativeGetTopOffsetPixelsForAnnotationSymbol(symbolName);
    }

    @Override
    public void jumpTo(@NonNull LatLng center, double zoom, double pitch, double angle, double[] padding) {
        if (this.checkState("jumpTo")) {
            return;
        }
        this.nativeJumpTo(angle, center.getLatitude(), center.getLongitude(), pitch, zoom, this.getAnimationPaddingAndClearCachedInsets(padding));
    }

    @Override
    public void easeTo(@NonNull LatLng center, double zoom, double angle, double pitch, double[] padding, long duration, boolean easingInterpolator) {
        if (this.checkState("easeTo")) {
            return;
        }
        this.nativeEaseTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, this.getAnimationPaddingAndClearCachedInsets(padding), easingInterpolator);
    }

    @Override
    public void flyTo(@NonNull LatLng center, double zoom, double angle, double pitch, double[] padding, long duration) {
        if (this.checkState("flyTo")) {
            return;
        }
        this.nativeFlyTo(angle, center.getLatitude(), center.getLongitude(), duration, pitch, zoom, this.getAnimationPaddingAndClearCachedInsets(padding));
    }

    @Override
    @NonNull
    public CameraPosition getCameraPosition() {
        if (this.checkState("getCameraValues")) {
            return new CameraPosition.Builder().build();
        }
        if (this.edgeInsets != null) {
            return new CameraPosition.Builder(this.nativeGetCameraPosition()).padding(this.edgeInsets).build();
        }
        return this.nativeGetCameraPosition();
    }

    @Override
    public void setPrefetchTiles(boolean enable) {
        if (this.checkState("setPrefetchTiles")) {
            return;
        }
        this.nativeSetPrefetchTiles(enable);
    }

    @Override
    public boolean getPrefetchTiles() {
        if (this.checkState("getPrefetchTiles")) {
            return false;
        }
        return this.nativeGetPrefetchTiles();
    }

    @Override
    public void setPrefetchZoomDelta(@IntRange(from=0L) int delta) {
        if (this.checkState("nativeSetPrefetchZoomDelta")) {
            return;
        }
        this.nativeSetPrefetchZoomDelta(delta);
    }

    @Override
    @IntRange(from=0L)
    public int getPrefetchZoomDelta() {
        if (this.checkState("nativeGetPrefetchZoomDelta")) {
            return 0;
        }
        return this.nativeGetPrefetchZoomDelta();
    }

    @Override
    public void setTransitionOptions(@NonNull TransitionOptions transitionOptions) {
        this.nativeSetTransitionOptions(transitionOptions);
    }

    @Override
    @NonNull
    public TransitionOptions getTransitionOptions() {
        return this.nativeGetTransitionOptions();
    }

    @Override
    @NonNull
    public List<Layer> getLayers() {
        if (this.checkState("getLayers")) {
            return new ArrayList<Layer>();
        }
        return Arrays.asList(this.nativeGetLayers());
    }

    @Override
    public Layer getLayer(String layerId) {
        if (this.checkState("getLayer")) {
            return null;
        }
        return this.nativeGetLayer(layerId);
    }

    @Override
    public void addLayer(@NonNull Layer layer) {
        if (this.checkState("addLayer")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), null);
    }

    @Override
    public void addLayerBelow(@NonNull Layer layer, @NonNull String below) {
        if (this.checkState("addLayerBelow")) {
            return;
        }
        this.nativeAddLayer(layer.getNativePtr(), below);
    }

    @Override
    public void addLayerAbove(@NonNull Layer layer, @NonNull String above) {
        if (this.checkState("addLayerAbove")) {
            return;
        }
        this.nativeAddLayerAbove(layer.getNativePtr(), above);
    }

    @Override
    public void addLayerAt(@NonNull Layer layer, @IntRange(from=0L) int index) {
        if (this.checkState("addLayerAt")) {
            return;
        }
        this.nativeAddLayerAt(layer.getNativePtr(), index);
    }

    @Override
    public boolean removeLayer(@NonNull String layerId) {
        if (this.checkState("removeLayer")) {
            return false;
        }
        Layer layer = this.getLayer(layerId);
        if (layer != null) {
            return this.removeLayer(layer);
        }
        return false;
    }

    @Override
    public boolean removeLayer(@NonNull Layer layer) {
        if (this.checkState("removeLayer")) {
            return false;
        }
        return this.nativeRemoveLayer(layer.getNativePtr());
    }

    @Override
    public boolean removeLayerAt(@IntRange(from=0L) int index) {
        if (this.checkState("removeLayerAt")) {
            return false;
        }
        return this.nativeRemoveLayerAt(index);
    }

    @Override
    @NonNull
    public List<Source> getSources() {
        if (this.checkState("getSources")) {
            return new ArrayList<Source>();
        }
        return Arrays.asList(this.nativeGetSources());
    }

    @Override
    public Source getSource(@NonNull String sourceId) {
        if (this.checkState("getSource")) {
            return null;
        }
        return this.nativeGetSource(sourceId);
    }

    @Override
    public void addSource(@NonNull Source source) {
        if (this.checkState("addSource")) {
            return;
        }
        this.nativeAddSource(source, source.getNativePtr());
    }

    @Override
    public boolean removeSource(@NonNull String sourceId) {
        if (this.checkState("removeSource")) {
            return false;
        }
        Source source = this.getSource(sourceId);
        if (source != null) {
            return this.removeSource(source);
        }
        return false;
    }

    @Override
    public boolean removeSource(@NonNull Source source) {
        if (this.checkState("removeSource")) {
            return false;
        }
        return this.nativeRemoveSource(source, source.getNativePtr());
    }

    @Override
    public void addImages(@NonNull Image[] images) {
        if (this.checkState("addImages")) {
            return;
        }
        this.nativeAddImages(images);
    }

    @Override
    public void removeImage(String name) {
        if (this.checkState("removeImage")) {
            return;
        }
        this.nativeRemoveImage(name);
    }

    @Override
    public Bitmap getImage(String name) {
        if (this.checkState("getImage")) {
            return null;
        }
        return this.nativeGetImage(name);
    }

    @Override
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull PointF coordinates, @Nullable String[] layerIds, @Nullable Expression filter) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForPoint(coordinates.x / this.pixelRatio, coordinates.y / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @Override
    @NonNull
    public List<Feature> queryRenderedFeatures(@NonNull RectF coordinates, @Nullable String[] layerIds, @Nullable Expression filter) {
        if (this.checkState("queryRenderedFeatures")) {
            return new ArrayList<Feature>();
        }
        Feature[] features = this.nativeQueryRenderedFeaturesForBox(coordinates.left / this.pixelRatio, coordinates.top / this.pixelRatio, coordinates.right / this.pixelRatio, coordinates.bottom / this.pixelRatio, layerIds, filter != null ? filter.toArray() : null);
        return features != null ? Arrays.asList(features) : new ArrayList<Feature>();
    }

    @Override
    public void setApiBaseUrl(String baseUrl) {
        if (this.checkState("setApiBaseUrl")) {
            return;
        }
        this.fileSource.setApiBaseUrl(baseUrl);
    }

    @Override
    public Light getLight() {
        if (this.checkState("getLight")) {
            return null;
        }
        return this.nativeGetLight();
    }

    @Override
    public float getPixelRatio() {
        return this.pixelRatio;
    }

    @Override
    public void triggerRepaint() {
        this.nativeTriggerRepaint();
    }

    @Override
    @NonNull
    public RectF getDensityDependantRectangle(RectF rectangle) {
        return new RectF(rectangle.left / this.pixelRatio, rectangle.top / this.pixelRatio, rectangle.right / this.pixelRatio, rectangle.bottom / this.pixelRatio);
    }

    @Keep
    private void onCameraWillChange(boolean animated) {
        if (this.stateCallback != null) {
            this.stateCallback.onCameraWillChange(animated);
        }
    }

    @Keep
    private void onCameraIsChanging() {
        if (this.stateCallback != null) {
            this.stateCallback.onCameraIsChanging();
        }
    }

    @Keep
    private void onCameraDidChange(boolean animated) {
        if (this.stateCallback != null) {
            this.stateCallback.onCameraDidChange(animated);
        }
    }

    @Keep
    private void onWillStartLoadingMap() {
        if (this.stateCallback != null) {
            this.stateCallback.onWillStartLoadingMap();
        }
    }

    @Keep
    private void onDidFinishLoadingMap() {
        if (this.stateCallback != null) {
            this.stateCallback.onDidFinishLoadingMap();
        }
    }

    @Keep
    private void onDidFailLoadingMap(String error) {
        if (this.stateCallback != null) {
            this.stateCallback.onDidFailLoadingMap(error);
        }
    }

    @Keep
    private void onWillStartRenderingFrame() {
        if (this.stateCallback != null) {
            this.stateCallback.onWillStartRenderingFrame();
        }
    }

    @Keep
    private void onDidFinishRenderingFrame(boolean fully) {
        if (this.stateCallback != null) {
            this.stateCallback.onDidFinishRenderingFrame(fully);
        }
    }

    @Keep
    private void onWillStartRenderingMap() {
        if (this.stateCallback != null) {
            this.stateCallback.onWillStartRenderingMap();
        }
    }

    @Keep
    private void onDidFinishRenderingMap(boolean fully) {
        if (this.stateCallback != null) {
            this.stateCallback.onDidFinishRenderingMap(fully);
        }
    }

    @Keep
    private void onDidBecomeIdle() {
        if (this.stateCallback != null) {
            this.stateCallback.onDidBecomeIdle();
        }
    }

    @Keep
    private void onDidFinishLoadingStyle() {
        if (this.stateCallback != null) {
            this.stateCallback.onDidFinishLoadingStyle();
        }
    }

    @Keep
    private void onSourceChanged(String sourceId) {
        if (this.stateCallback != null) {
            this.stateCallback.onSourceChanged(sourceId);
        }
    }

    @Keep
    private void onStyleImageMissing(String imageId) {
        if (this.stateCallback != null) {
            this.stateCallback.onStyleImageMissing(imageId);
        }
    }

    @Keep
    private boolean onCanRemoveUnusedStyleImage(String imageId) {
        if (this.stateCallback != null) {
            return this.stateCallback.onCanRemoveUnusedStyleImage(imageId);
        }
        return true;
    }

    @Keep
    protected void onSnapshotReady(@Nullable Bitmap mapContent) {
        if (this.checkState("OnSnapshotReady")) {
            return;
        }
        try {
            if (this.snapshotReadyCallback != null && mapContent != null) {
                if (this.viewCallback == null) {
                    this.snapshotReadyCallback.onSnapshotReady(mapContent);
                } else {
                    Bitmap viewContent = this.viewCallback.getViewContent();
                    if (viewContent != null) {
                        this.snapshotReadyCallback.onSnapshotReady(BitmapUtils.mergeBitmap(mapContent, viewContent));
                    }
                }
            }
        }
        catch (Throwable err) {
            Logger.e(TAG, "Exception in onSnapshotReady", err);
            throw err;
        }
    }

    @Keep
    private native void nativeInitialize(NativeMapView var1, FileSource var2, MapRenderer var3, float var4, boolean var5);

    @Keep
    private native void nativeDestroy();

    @Keep
    private native void nativeResizeView(int var1, int var2);

    @Keep
    private native void nativeSetStyleUrl(String var1);

    @NonNull
    @Keep
    private native String nativeGetStyleUrl();

    @Keep
    private native void nativeSetStyleJson(String var1);

    @NonNull
    @Keep
    private native String nativeGetStyleJson();

    @Keep
    private native void nativeSetLatLngBounds(LatLngBounds var1);

    @Keep
    private native void nativeCancelTransitions();

    @Keep
    private native void nativeSetGestureInProgress(boolean var1);

    @Keep
    private native void nativeMoveBy(double var1, double var3, long var5);

    @Keep
    private native void nativeSetLatLng(double var1, double var3, double[] var5, long var6);

    @NonNull
    @Keep
    private native LatLng nativeGetLatLng();

    @NonNull
    @Keep
    private native CameraPosition nativeGetCameraForLatLngBounds(LatLngBounds var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @NonNull
    @Keep
    private native CameraPosition nativeGetCameraForGeometry(Geometry var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @Keep
    private native void nativeResetPosition();

    @Keep
    private native double nativeGetPitch();

    @Keep
    private native void nativeSetPitch(double var1, long var3);

    @Keep
    private native void nativeSetZoom(double var1, double var3, double var5, long var7);

    @Keep
    private native double nativeGetZoom();

    @Keep
    private native void nativeResetZoom();

    @Keep
    private native void nativeSetMinZoom(double var1);

    @Keep
    private native double nativeGetMinZoom();

    @Keep
    private native void nativeSetMaxZoom(double var1);

    @Keep
    private native double nativeGetMaxZoom();

    @Keep
    private native void nativeSetMinPitch(double var1);

    @Keep
    private native double nativeGetMinPitch();

    @Keep
    private native void nativeSetMaxPitch(double var1);

    @Keep
    private native double nativeGetMaxPitch();

    @Keep
    private native void nativeRotateBy(double var1, double var3, double var5, double var7, long var9);

    @Keep
    private native void nativeSetBearing(double var1, long var3);

    @Keep
    private native void nativeSetBearingXY(double var1, double var3, double var5, long var7);

    @Keep
    private native double nativeGetBearing();

    @Keep
    private native void nativeResetNorth();

    @Keep
    private native void nativeUpdateMarker(long var1, double var3, double var5, String var7);

    @NonNull
    @Keep
    private native long[] nativeAddMarkers(Marker[] var1);

    @NonNull
    @Keep
    private native long[] nativeAddPolylines(Polyline[] var1);

    @NonNull
    @Keep
    private native long[] nativeAddPolygons(Polygon[] var1);

    @Keep
    private native void nativeRemoveAnnotations(long[] var1);

    @NonNull
    @Keep
    private native long[] nativeQueryPointAnnotations(RectF var1);

    @NonNull
    @Keep
    private native long[] nativeQueryShapeAnnotations(RectF var1);

    @Keep
    private native void nativeAddAnnotationIcon(String var1, int var2, int var3, float var4, byte[] var5);

    @Keep
    private native void nativeRemoveAnnotationIcon(String var1);

    @Keep
    private native void nativeSetVisibleCoordinateBounds(LatLng[] var1, RectF var2, double var3, long var5);

    @Keep
    private native void nativeOnLowMemory();

    @Keep
    private native void nativeSetDebug(boolean var1);

    @Keep
    private native boolean nativeGetDebug();

    @Keep
    private native boolean nativeIsFullyLoaded();

    @Keep
    private native void nativeSetReachability(boolean var1);

    @Keep
    private native double nativeGetMetersPerPixelAtLatitude(double var1, double var3);

    @NonNull
    @Keep
    private native ProjectedMeters nativeProjectedMetersForLatLng(double var1, double var3);

    @NonNull
    @Keep
    private native LatLng nativeLatLngForProjectedMeters(double var1, double var3);

    @NonNull
    @Keep
    private native PointF nativePixelForLatLng(double var1, double var3);

    @Keep
    private native void nativePixelsForLatLngs(double[] var1, double[] var2, float var3);

    @Keep
    private native void nativeGetVisibleCoordinateBounds(double[] var1);

    @NonNull
    @Keep
    private native LatLng nativeLatLngForPixel(float var1, float var2);

    @Keep
    private native void nativeLatLngsForPixels(double[] var1, double[] var2, float var3);

    @Keep
    private native double nativeGetTopOffsetPixelsForAnnotationSymbol(String var1);

    @Keep
    private native void nativeJumpTo(double var1, double var3, double var5, double var7, double var9, double[] var11);

    @Keep
    private native void nativeEaseTo(double var1, double var3, double var5, long var7, double var9, double var11, double[] var13, boolean var14);

    @Keep
    private native void nativeFlyTo(double var1, double var3, double var5, long var7, double var9, double var11, double[] var13);

    @NonNull
    @Keep
    private native CameraPosition nativeGetCameraPosition();

    @Keep
    private native void nativeSetTransitionOptions(TransitionOptions var1);

    @NonNull
    @Keep
    private native TransitionOptions nativeGetTransitionOptions();

    @Keep
    private native long nativeGetTransitionDuration();

    @Keep
    private native void nativeSetTransitionDuration(long var1);

    @Keep
    private native long nativeGetTransitionDelay();

    @Keep
    private native void nativeSetTransitionDelay(long var1);

    @NonNull
    @Keep
    private native Layer[] nativeGetLayers();

    @NonNull
    @Keep
    private native Layer nativeGetLayer(String var1);

    @Keep
    private native void nativeAddLayer(long var1, String var3) throws CannotAddLayerException;

    @Keep
    private native void nativeAddLayerAbove(long var1, String var3) throws CannotAddLayerException;

    @Keep
    private native void nativeAddLayerAt(long var1, int var3) throws CannotAddLayerException;

    @Keep
    private native boolean nativeRemoveLayer(long var1);

    @Keep
    private native boolean nativeRemoveLayerAt(int var1);

    @NonNull
    @Keep
    private native Source[] nativeGetSources();

    @NonNull
    @Keep
    private native Source nativeGetSource(String var1);

    @Keep
    private native void nativeAddSource(Source var1, long var2) throws CannotAddSourceException;

    @Keep
    private native boolean nativeRemoveSource(Source var1, long var2);

    @Keep
    private native void nativeAddImage(String var1, Bitmap var2, float var3, boolean var4);

    @Keep
    private native void nativeAddImages(Image[] var1);

    @Keep
    private native void nativeRemoveImage(String var1);

    @NonNull
    @Keep
    private native Bitmap nativeGetImage(String var1);

    @Keep
    private native void nativeUpdatePolygon(long var1, Polygon var3);

    @Keep
    private native void nativeUpdatePolyline(long var1, Polyline var3);

    @Keep
    private native void nativeTakeSnapshot();

    @NonNull
    @Keep
    private native Feature[] nativeQueryRenderedFeaturesForPoint(float var1, float var2, String[] var3, Object[] var4);

    @NonNull
    @Keep
    private native Feature[] nativeQueryRenderedFeaturesForBox(float var1, float var2, float var3, float var4, String[] var5, Object[] var6);

    @NonNull
    @Keep
    private native Light nativeGetLight();

    @Keep
    private native void nativeSetPrefetchTiles(boolean var1);

    @Keep
    private native boolean nativeGetPrefetchTiles();

    @Keep
    private native void nativeSetPrefetchZoomDelta(int var1);

    @Keep
    private native int nativeGetPrefetchZoomDelta();

    @Override
    public long getNativePtr() {
        return this.nativePtr;
    }

    @Keep
    private native void nativeTriggerRepaint();

    @Override
    public void addSnapshotCallback(@NonNull MapboxMap.SnapshotReadyCallback callback) {
        if (this.checkState("addSnapshotCallback")) {
            return;
        }
        this.snapshotReadyCallback = callback;
        this.nativeTakeSnapshot();
    }

    @Override
    public void setOnFpsChangedListener(final @Nullable MapboxMap.OnFpsChangedListener listener) {
        final Handler handler = new Handler();
        this.mapRenderer.queueEvent(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    NativeMapView.this.mapRenderer.setOnFpsChangedListener(new MapboxMap.OnFpsChangedListener(){

                        @Override
                        public void onFpsChanged(final double fps) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onFpsChanged(fps);
                                }
                            });
                        }
                    });
                } else {
                    NativeMapView.this.mapRenderer.setOnFpsChangedListener(null);
                }
            }
        });
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private double[] getAnimationPaddingAndClearCachedInsets(double[] providedPadding) {
        double[] dArray;
        if (providedPadding == null) {
            providedPadding = this.edgeInsets;
        }
        this.edgeInsets = null;
        if (providedPadding == null) {
            dArray = null;
        } else {
            double[] dArray2 = new double[4];
            dArray2[0] = providedPadding[1] / (double)this.pixelRatio;
            dArray2[1] = providedPadding[0] / (double)this.pixelRatio;
            dArray2[2] = providedPadding[3] / (double)this.pixelRatio;
            dArray = dArray2;
            dArray2[3] = providedPadding[2] / (double)this.pixelRatio;
        }
        return dArray;
    }

    static {
        LibraryLoader.load();
    }

    static interface StateCallback
    extends StyleCallback {
        public void onCameraWillChange(boolean var1);

        public void onCameraIsChanging();

        public void onCameraDidChange(boolean var1);

        public void onDidFinishLoadingMap();

        public void onDidFailLoadingMap(String var1);

        public void onWillStartRenderingFrame();

        public void onDidFinishRenderingFrame(boolean var1);

        public void onWillStartRenderingMap();

        public void onDidFinishRenderingMap(boolean var1);

        public void onDidBecomeIdle();

        public void onSourceChanged(String var1);

        public void onStyleImageMissing(String var1);

        public boolean onCanRemoveUnusedStyleImage(String var1);
    }

    static interface StyleCallback {
        public void onWillStartLoadingMap();

        public void onDidFinishLoadingStyle();
    }

    public static interface ViewCallback {
        @Nullable
        public Bitmap getViewContent();
    }
}

