/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.style.layers;

import androidx.annotation.Keep;

public class TransitionOptions {
    @Keep
    private long duration;
    @Keep
    private long delay;
    @Keep
    private boolean enablePlacementTransitions;

    public TransitionOptions(long duration, long delay) {
        this(duration, delay, true);
    }

    public TransitionOptions(long duration, long delay, boolean enablePlacementTransitions) {
        this.duration = duration;
        this.delay = delay;
        this.enablePlacementTransitions = enablePlacementTransitions;
    }

    @Deprecated
    @Keep
    public static TransitionOptions fromTransitionOptions(long duration, long delay) {
        return new TransitionOptions(duration, delay);
    }

    @Keep
    static TransitionOptions fromTransitionOptions(long duration, long delay, boolean enablePlacementTransitions) {
        return new TransitionOptions(duration, delay, enablePlacementTransitions);
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean isEnablePlacementTransitions() {
        return this.enablePlacementTransitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransitionOptions that = (TransitionOptions)o;
        if (this.duration != that.duration) {
            return false;
        }
        if (this.delay != that.delay) {
            return false;
        }
        return this.enablePlacementTransitions == that.enablePlacementTransitions;
    }

    public int hashCode() {
        int result = (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.delay ^ this.delay >>> 32);
        result = 31 * result + (this.enablePlacementTransitions ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TransitionOptions{duration=" + this.duration + ", delay=" + this.delay + ", enablePlacementTransitions=" + this.enablePlacementTransitions + '}';
    }
}

