/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.annotation.SuppressLint;
import android.os.Bundle;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ParcelCreator"})
class PerformanceEvent
extends MapBaseEvent {
    private static final String PERFORMANCE_TRACE = "mobile.performance_trace";
    private final String sessionId;
    private final List<PerformanceAttribute<String>> attributes;
    private final List<PerformanceAttribute<Double>> counters;
    private final JsonObject metadata;

    PerformanceEvent(PhoneState phoneState, String sessionId, Bundle bundle) {
        super(phoneState);
        this.sessionId = sessionId;
        this.attributes = this.initList(bundle.getString("attributes"), (TypeToken)new TypeToken<ArrayList<PerformanceAttribute<String>>>(){});
        this.counters = this.initList(bundle.getString("counters"), (TypeToken)new TypeToken<ArrayList<PerformanceAttribute<Double>>>(){});
        this.metadata = this.initMetaData(bundle.getString("metadata"));
    }

    private <T> ArrayList<PerformanceAttribute<T>> initList(String fromString, TypeToken typeToken) {
        if (fromString == null || fromString.isEmpty()) {
            return new ArrayList<PerformanceAttribute<T>>();
        }
        return (ArrayList)new Gson().fromJson(fromString, typeToken.getType());
    }

    private JsonObject initMetaData(String fromString) {
        if (fromString == null) {
            return new JsonObject();
        }
        return (JsonObject)new Gson().fromJson(fromString, JsonObject.class);
    }

    @Override
    String getEventName() {
        return PERFORMANCE_TRACE;
    }

    String getSessionId() {
        return this.sessionId;
    }

    List<PerformanceAttribute<String>> getAttributes() {
        return this.attributes;
    }

    List<PerformanceAttribute<Double>> getCounters() {
        return this.counters;
    }

    JsonObject getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PerformanceEvent that = (PerformanceEvent)((Object)o);
        if (this.sessionId != null ? !this.sessionId.equals(that.sessionId) : that.sessionId != null) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.counters != null ? !this.counters.equals(that.counters) : that.counters != null) {
            return false;
        }
        return this.metadata != null ? this.metadata.equals((Object)that.metadata) : that.metadata == null;
    }

    public int hashCode() {
        int result = this.sessionId != null ? this.sessionId.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        result = 31 * result + (this.counters != null ? this.counters.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PerformanceEvent{sessionId='" + this.sessionId + '\'' + ", attributes=" + this.attributes + ", counters=" + this.counters + ", metadata=" + this.metadata + '}';
    }

    static class PerformanceAttribute<T> {
        private final String name;
        private final T value;

        PerformanceAttribute(String name, T value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerformanceAttribute that = (PerformanceAttribute)o;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

