/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.Keep;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.exception.GeoJsonException;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import java.io.IOException;

@Keep
abstract class BaseGeometryTypeAdapter<G, T>
extends TypeAdapter<G> {
    private volatile TypeAdapter<String> stringAdapter;
    private volatile TypeAdapter<BoundingBox> boundingBoxAdapter;
    private volatile TypeAdapter<T> coordinatesAdapter;
    private final Gson gson;

    BaseGeometryTypeAdapter(Gson gson, TypeAdapter<T> coordinatesAdapter) {
        this.gson = gson;
        this.coordinatesAdapter = coordinatesAdapter;
        this.boundingBoxAdapter = new BoundingBoxTypeAdapter();
    }

    public void writeCoordinateContainer(JsonWriter jsonWriter, CoordinateContainer<T> object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        jsonWriter.beginObject();
        jsonWriter.name("type");
        if (object.type() == null) {
            jsonWriter.nullValue();
        } else {
            TypeAdapter stringAdapter = this.stringAdapter;
            if (stringAdapter == null) {
                this.stringAdapter = stringAdapter = this.gson.getAdapter(String.class);
            }
            stringAdapter.write(jsonWriter, (Object)object.type());
        }
        jsonWriter.name("bbox");
        if (object.bbox() == null) {
            jsonWriter.nullValue();
        } else {
            TypeAdapter boundingBoxAdapter = this.boundingBoxAdapter;
            if (boundingBoxAdapter == null) {
                this.boundingBoxAdapter = boundingBoxAdapter = this.gson.getAdapter(BoundingBox.class);
            }
            boundingBoxAdapter.write(jsonWriter, (Object)object.bbox());
        }
        jsonWriter.name("coordinates");
        if (object.coordinates() == null) {
            jsonWriter.nullValue();
        } else {
            TypeAdapter<T> coordinatesAdapter = this.coordinatesAdapter;
            if (coordinatesAdapter == null) {
                throw new GeoJsonException("Coordinates type adapter is null");
            }
            coordinatesAdapter.write(jsonWriter, object.coordinates());
        }
        jsonWriter.endObject();
    }

    public CoordinateContainer<T> readCoordinateContainer(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        jsonReader.beginObject();
        String type = null;
        BoundingBox bbox = null;
        Object coordinates = null;
        block10: while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                continue;
            }
            switch (name) {
                case "type": {
                    TypeAdapter stringAdapter = this.stringAdapter;
                    if (stringAdapter == null) {
                        this.stringAdapter = stringAdapter = this.gson.getAdapter(String.class);
                    }
                    type = (String)stringAdapter.read(jsonReader);
                    continue block10;
                }
                case "bbox": {
                    TypeAdapter boundingBoxAdapter = this.boundingBoxAdapter;
                    if (boundingBoxAdapter == null) {
                        this.boundingBoxAdapter = boundingBoxAdapter = this.gson.getAdapter(BoundingBox.class);
                    }
                    bbox = (BoundingBox)boundingBoxAdapter.read(jsonReader);
                    continue block10;
                }
                case "coordinates": {
                    TypeAdapter<T> coordinatesAdapter = this.coordinatesAdapter;
                    if (coordinatesAdapter == null) {
                        throw new GeoJsonException("Coordinates type adapter is null");
                    }
                    coordinates = coordinatesAdapter.read(jsonReader);
                    continue block10;
                }
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return this.createCoordinateContainer(type, bbox, coordinates);
    }

    abstract CoordinateContainer<T> createCoordinateContainer(String var1, BoundingBox var2, T var3);
}

