/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.GeoJson;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.GeometryAdapterFactory;
import com.mapbox.geojson.gson.BoundingBoxTypeAdapter;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;

@Keep
public final class Feature
implements GeoJson {
    private static final String TYPE = "Feature";
    private final String type;
    @JsonAdapter(value=BoundingBoxTypeAdapter.class)
    private final BoundingBox bbox;
    private final String id;
    private final Geometry geometry;
    private final JsonObject properties;

    public static Feature fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gson.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        Feature feature = (Feature)gson.create().fromJson(json, Feature.class);
        if (feature.properties() != null) {
            return feature;
        }
        return new Feature(TYPE, feature.bbox(), feature.id(), feature.geometry(), new JsonObject());
    }

    public static Feature fromGeometry(@Nullable Geometry geometry) {
        return new Feature(TYPE, null, null, geometry, new JsonObject());
    }

    public static Feature fromGeometry(@Nullable Geometry geometry, @Nullable BoundingBox bbox) {
        return new Feature(TYPE, bbox, null, geometry, new JsonObject());
    }

    public static Feature fromGeometry(@Nullable Geometry geometry, @Nullable JsonObject properties) {
        return new Feature(TYPE, null, null, geometry, properties == null ? new JsonObject() : properties);
    }

    public static Feature fromGeometry(@Nullable Geometry geometry, @Nullable JsonObject properties, @Nullable BoundingBox bbox) {
        return new Feature(TYPE, bbox, null, geometry, properties == null ? new JsonObject() : properties);
    }

    public static Feature fromGeometry(@Nullable Geometry geometry, @Nullable JsonObject properties, @Nullable String id) {
        return new Feature(TYPE, null, id, geometry, properties == null ? new JsonObject() : properties);
    }

    public static Feature fromGeometry(@Nullable Geometry geometry, @NonNull JsonObject properties, @Nullable String id, @Nullable BoundingBox bbox) {
        return new Feature(TYPE, bbox, id, geometry, properties == null ? new JsonObject() : properties);
    }

    Feature(String type, @Nullable BoundingBox bbox, @Nullable String id, @Nullable Geometry geometry, @Nullable JsonObject properties) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        this.id = id;
        this.geometry = geometry;
        this.properties = properties;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public Geometry geometry() {
        return this.geometry;
    }

    @Nullable
    public JsonObject properties() {
        return this.properties;
    }

    @Override
    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create()).create();
        Feature feature = this;
        if (this.properties().size() == 0) {
            feature = new Feature(TYPE, this.bbox(), this.id(), this.geometry(), null);
        }
        return gson.toJson((Object)feature);
    }

    public static TypeAdapter<Feature> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public void addStringProperty(String key, String value) {
        this.properties().addProperty(key, value);
    }

    public void addNumberProperty(String key, Number value) {
        this.properties().addProperty(key, value);
    }

    public void addBooleanProperty(String key, Boolean value) {
        this.properties().addProperty(key, value);
    }

    public void addCharacterProperty(String key, Character value) {
        this.properties().addProperty(key, value);
    }

    public void addProperty(String key, JsonElement value) {
        this.properties().add(key, value);
    }

    public String getStringProperty(String key) {
        JsonElement propertyKey = this.properties().get(key);
        return propertyKey == null ? null : propertyKey.getAsString();
    }

    public Number getNumberProperty(String key) {
        JsonElement propertyKey = this.properties().get(key);
        return propertyKey == null ? (Number)null : (Number)propertyKey.getAsNumber();
    }

    public Boolean getBooleanProperty(String key) {
        JsonElement propertyKey = this.properties().get(key);
        return propertyKey == null ? null : Boolean.valueOf(propertyKey.getAsBoolean());
    }

    public Character getCharacterProperty(String key) {
        JsonElement propertyKey = this.properties().get(key);
        return propertyKey == null ? null : Character.valueOf(propertyKey.getAsCharacter());
    }

    public JsonElement getProperty(String key) {
        return this.properties().get(key);
    }

    public JsonElement removeProperty(String key) {
        return this.properties().remove(key);
    }

    public boolean hasProperty(String key) {
        return this.properties().has(key);
    }

    public boolean hasNonNullValueForProperty(String key) {
        return this.hasProperty(key) && !this.getProperty(key).isJsonNull();
    }

    public String toString() {
        return "Feature{type=" + this.type + ", bbox=" + this.bbox + ", id=" + this.id + ", geometry=" + this.geometry + ", properties=" + this.properties + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Feature) {
            Feature that = (Feature)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.geometry == null ? that.geometry() == null : this.geometry.equals(that.geometry())) && (this.properties == null ? that.properties() == null : this.properties.equals((Object)that.properties()));
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.id == null ? 0 : this.id.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.geometry == null ? 0 : this.geometry.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.properties == null ? 0 : this.properties.hashCode();
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<Feature> {
        private volatile TypeAdapter<String> stringTypeAdapter;
        private volatile TypeAdapter<BoundingBox> boundingBoxTypeAdapter;
        private volatile TypeAdapter<Geometry> geometryTypeAdapter;
        private volatile TypeAdapter<JsonObject> jsonObjectTypeAdapter;
        private final Gson gson;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, Feature object) throws IOException {
            TypeAdapter stringTypeAdapter;
            if (object == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (object.type() == null) {
                jsonWriter.nullValue();
            } else {
                stringTypeAdapter = this.stringTypeAdapter;
                if (stringTypeAdapter == null) {
                    this.stringTypeAdapter = stringTypeAdapter = this.gson.getAdapter(String.class);
                }
                stringTypeAdapter.write(jsonWriter, (Object)object.type());
            }
            jsonWriter.name("bbox");
            if (object.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter boundingBoxTypeAdapter = this.boundingBoxTypeAdapter;
                if (boundingBoxTypeAdapter == null) {
                    this.boundingBoxTypeAdapter = boundingBoxTypeAdapter = this.gson.getAdapter(BoundingBox.class);
                }
                boundingBoxTypeAdapter.write(jsonWriter, (Object)object.bbox());
            }
            jsonWriter.name("id");
            if (object.id() == null) {
                jsonWriter.nullValue();
            } else {
                stringTypeAdapter = this.stringTypeAdapter;
                if (stringTypeAdapter == null) {
                    this.stringTypeAdapter = stringTypeAdapter = this.gson.getAdapter(String.class);
                }
                stringTypeAdapter.write(jsonWriter, (Object)object.id());
            }
            jsonWriter.name("geometry");
            if (object.geometry() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter geometryTypeAdapter = this.geometryTypeAdapter;
                if (geometryTypeAdapter == null) {
                    this.geometryTypeAdapter = geometryTypeAdapter = this.gson.getAdapter(Geometry.class);
                }
                geometryTypeAdapter.write(jsonWriter, (Object)object.geometry());
            }
            jsonWriter.name("properties");
            if (object.properties() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter jsonObjectTypeAdapter = this.jsonObjectTypeAdapter;
                if (jsonObjectTypeAdapter == null) {
                    this.jsonObjectTypeAdapter = jsonObjectTypeAdapter = this.gson.getAdapter(JsonObject.class);
                }
                jsonObjectTypeAdapter.write(jsonWriter, (Object)object.properties());
            }
            jsonWriter.endObject();
        }

        public Feature read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            String type = null;
            BoundingBox bbox = null;
            String id = null;
            Geometry geometry = null;
            JsonObject properties = null;
            block14: while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                switch (name) {
                    case "type": {
                        TypeAdapter strTypeAdapter = this.stringTypeAdapter;
                        if (strTypeAdapter == null) {
                            this.stringTypeAdapter = strTypeAdapter = this.gson.getAdapter(String.class);
                        }
                        type = (String)strTypeAdapter.read(jsonReader);
                        continue block14;
                    }
                    case "bbox": {
                        TypeAdapter boundingBoxTypeAdapter = this.boundingBoxTypeAdapter;
                        if (boundingBoxTypeAdapter == null) {
                            this.boundingBoxTypeAdapter = boundingBoxTypeAdapter = this.gson.getAdapter(BoundingBox.class);
                        }
                        bbox = (BoundingBox)boundingBoxTypeAdapter.read(jsonReader);
                        continue block14;
                    }
                    case "id": {
                        TypeAdapter strTypeAdapter = this.stringTypeAdapter;
                        if (strTypeAdapter == null) {
                            this.stringTypeAdapter = strTypeAdapter = this.gson.getAdapter(String.class);
                        }
                        id = (String)strTypeAdapter.read(jsonReader);
                        continue block14;
                    }
                    case "geometry": {
                        TypeAdapter geometryTypeAdapter = this.geometryTypeAdapter;
                        if (geometryTypeAdapter == null) {
                            this.geometryTypeAdapter = geometryTypeAdapter = this.gson.getAdapter(Geometry.class);
                        }
                        geometry = (Geometry)geometryTypeAdapter.read(jsonReader);
                        continue block14;
                    }
                    case "properties": {
                        TypeAdapter jsonObjectTypeAdapter = this.jsonObjectTypeAdapter;
                        if (jsonObjectTypeAdapter == null) {
                            this.jsonObjectTypeAdapter = jsonObjectTypeAdapter = this.gson.getAdapter(JsonObject.class);
                        }
                        properties = (JsonObject)jsonObjectTypeAdapter.read(jsonReader);
                        continue block14;
                    }
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new Feature(type, bbox, id, geometry, properties);
        }
    }
}

