/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.Keep;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.exception.GeoJsonException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
class ListOfPointCoordinatesTypeAdapter
extends BaseCoordinatesTypeAdapter<List<Point>> {
    ListOfPointCoordinatesTypeAdapter() {
    }

    public void write(JsonWriter out, List<Point> points) throws IOException {
        if (points == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (Point point : points) {
            this.writePoint(out, point);
        }
        out.endArray();
    }

    public List<Point> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            throw new NullPointerException();
        }
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
            ArrayList<Point> points = new ArrayList<Point>();
            in.beginArray();
            while (in.peek() == JsonToken.BEGIN_ARRAY) {
                points.add(this.readPoint(in));
            }
            in.endArray();
            return points;
        }
        throw new GeoJsonException("coordinates should be non-null array of array of double");
    }
}

