/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.ListOfListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

@Keep
public final class MultiLineString
implements CoordinateContainer<List<List<Point>>> {
    private static final String TYPE = "MultiLineString";
    private final String type;
    private final BoundingBox bbox;
    private final List<List<Point>> coordinates;

    public static MultiLineString fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (MultiLineString)gson.create().fromJson(json, MultiLineString.class);
    }

    public static MultiLineString fromLineStrings(@NonNull List<LineString> lineStrings) {
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>(lineStrings.size());
        for (LineString lineString : lineStrings) {
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new MultiLineString(TYPE, null, coordinates);
    }

    public static MultiLineString fromLineStrings(@NonNull List<LineString> lineStrings, @Nullable BoundingBox bbox) {
        ArrayList<List<Point>> coordinates = new ArrayList<List<Point>>(lineStrings.size());
        for (LineString lineString : lineStrings) {
            coordinates.add((List<Point>)lineString.coordinates());
        }
        return new MultiLineString(TYPE, bbox, coordinates);
    }

    public static MultiLineString fromLineString(@NonNull LineString lineString) {
        List<List<Point>> coordinates = Arrays.asList(lineString.coordinates());
        return new MultiLineString(TYPE, null, coordinates);
    }

    public static MultiLineString fromLineString(@NonNull LineString lineString, @Nullable BoundingBox bbox) {
        List<List<Point>> coordinates = Arrays.asList(lineString.coordinates());
        return new MultiLineString(TYPE, bbox, coordinates);
    }

    public static MultiLineString fromLngLats(@NonNull List<List<Point>> points) {
        return new MultiLineString(TYPE, null, points);
    }

    public static MultiLineString fromLngLats(@NonNull List<List<Point>> points, @Nullable BoundingBox bbox) {
        return new MultiLineString(TYPE, bbox, points);
    }

    static MultiLineString fromLngLats(double[][][] coordinates) {
        ArrayList<List<Point>> multiLine = new ArrayList<List<Point>>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            ArrayList<Point> lineString = new ArrayList<Point>(coordinates[i].length);
            for (int j = 0; j < coordinates[i].length; ++j) {
                lineString.add(Point.fromLngLat(coordinates[i][j]));
            }
            multiLine.add(lineString);
        }
        return new MultiLineString(TYPE, null, multiLine);
    }

    MultiLineString(String type, @Nullable BoundingBox bbox, List<List<Point>> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<List<Point>> coordinates() {
        return this.coordinates;
    }

    public List<LineString> lineStrings() {
        Object coordinates = this.coordinates();
        ArrayList<LineString> lineStrings = new ArrayList<LineString>(coordinates.size());
        Iterator iterator = coordinates.iterator();
        while (iterator.hasNext()) {
            List points = (List)iterator.next();
            lineStrings.add(LineString.fromLngLats(points));
        }
        return lineStrings;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<MultiLineString> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "MultiLineString{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiLineString) {
            MultiLineString that = (MultiLineString)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiLineString, List<List<Point>>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfListOfPointCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, MultiLineString object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public MultiLineString read(JsonReader jsonReader) throws IOException {
            return (MultiLineString)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<List<Point>>> createCoordinateContainer(String type, BoundingBox bbox, List<List<Point>> coords) {
            return new MultiLineString(type == null ? MultiLineString.TYPE : type, bbox, coords);
        }
    }
}

