/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.geojson;

import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mapbox.geojson.BaseGeometryTypeAdapter;
import com.mapbox.geojson.BoundingBox;
import com.mapbox.geojson.CoordinateContainer;
import com.mapbox.geojson.ListOfPointCoordinatesTypeAdapter;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
public final class MultiPoint
implements CoordinateContainer<List<Point>> {
    private static final String TYPE = "MultiPoint";
    private final String type;
    private final BoundingBox bbox;
    private final List<Point> coordinates;

    public static MultiPoint fromJson(@NonNull String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (MultiPoint)gson.create().fromJson(json, MultiPoint.class);
    }

    public static MultiPoint fromLngLats(@NonNull List<Point> points) {
        return new MultiPoint(TYPE, null, points);
    }

    public static MultiPoint fromLngLats(@NonNull List<Point> points, @Nullable BoundingBox bbox) {
        return new MultiPoint(TYPE, bbox, points);
    }

    static MultiPoint fromLngLats(@NonNull double[][] coordinates) {
        ArrayList<Point> converted = new ArrayList<Point>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            converted.add(Point.fromLngLat(coordinates[i]));
        }
        return new MultiPoint(TYPE, null, converted);
    }

    MultiPoint(String type, @Nullable BoundingBox bbox, List<Point> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<Point> coordinates() {
        return this.coordinates;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<MultiPoint> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "MultiPoint{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiPoint) {
            MultiPoint that = (MultiPoint)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<MultiPoint, List<Point>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfPointCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, MultiPoint object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public MultiPoint read(JsonReader jsonReader) throws IOException {
            return (MultiPoint)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<Point>> createCoordinateContainer(String type, BoundingBox bbox, List<Point> coordinates) {
            return new MultiPoint(type == null ? MultiPoint.TYPE : type, bbox, coordinates);
        }
    }
}

